/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.stroke;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;

public class TimedPolygon2D
extends Polygon2D
implements Serializable,
Cloneable {
    static final long serialVersionUID = -4348203203982309698L;
    private static final int DEFAULT_ARRAY_LEN = 20;
    public long[] times = new long[20];

    public TimedPolygon2D() {
    }

    public TimedPolygon2D(int[] x, int[] y, int numPoints) {
        this(x, y, System.currentTimeMillis(), numPoints);
    }

    public TimedPolygon2D(int[] x, int[] y, long time, int numPoints) {
        super(x, y, numPoints);
        this.times = new long[numPoints];
        int i = 0;
        while (i < numPoints) {
            this.times[i] = time;
            ++i;
        }
    }

    public TimedPolygon2D(int[] x, int[] y, long[] t, int numPoints) {
        super(x, y, numPoints);
        this.times = new long[t.length];
        System.arraycopy(t, 0, this.times, 0, this.npoints);
    }

    public TimedPolygon2D(Polygon p) {
        this(p.xpoints, p.ypoints, p.npoints);
    }

    public TimedPolygon2D(Polygon p, long[] t) {
        this(p.xpoints, p.ypoints, t, p.npoints);
    }

    public TimedPolygon2D(float[] x, float[] y, int numPoints) {
        this(x, y, System.currentTimeMillis(), numPoints);
    }

    public TimedPolygon2D(float[] x, float[] y, long time, int numPoints) {
        super(x, y, numPoints);
        this.times = new long[numPoints];
        int i = 0;
        while (i < numPoints) {
            this.times[i] = time;
            ++i;
        }
    }

    public TimedPolygon2D(float[] x, float[] y, long[] t, int numPoints) {
        super(x, y, numPoints);
        this.times = new long[t.length];
        System.arraycopy(t, 0, this.times, 0, this.npoints);
    }

    public TimedPolygon2D(Polygon2D p) {
        this(p.xpoints, p.ypoints, p.npoints);
    }

    public TimedPolygon2D(Polygon2D p, long[] t) {
        this(p.xpoints, p.ypoints, t, p.npoints);
    }

    public TimedPolygon2D(TimedPolygon2D p) {
        this(p.xpoints, p.ypoints, p.times, p.npoints);
    }

    public long getStartTime() {
        return this.times[0];
    }

    public long getEndTime() {
        return this.times[this.npoints - 1];
    }

    public Rectangle getBounds() {
        if (this.npoints > 0) {
            return super.getBounds();
        }
        return new Rectangle();
    }

    public void setToShape(TimedPolygon2D poly) {
        super.setToShape(poly);
        this.times = new long[poly.npoints];
        System.arraycopy(poly.times, 0, this.times, 0, this.npoints);
    }

    public void addPoint(double x, double y) {
        this.addPoint(x, y, System.currentTimeMillis());
    }

    public void addPoint(double x, double y, long t) {
        super.addPoint(x, y);
        if (this.times != null) {
            if (this.npoints >= this.times.length) {
                long[] temp = new long[this.times.length * 2];
                System.arraycopy(this.times, 0, temp, 0, this.times.length);
                this.times = temp;
            }
            this.times[this.npoints - 1] = t;
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        int i = 0;
        while (i < this.npoints) {
            strbuf.append("(" + this.xpoints[i] + "," + this.ypoints[i] + "," + this.times[i] + ")");
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public Object clone() {
        TimedPolygon2D ret = new TimedPolygon2D();
        this.clone(ret);
        return ret;
    }

    public Object clone(TimedPolygon2D p) {
        super.clone(p);
        p.times = new long[this.times.length];
        System.arraycopy(this.times, 0, p.times, 0, this.times.length);
        return p;
    }
}

