/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.stroke;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.ViewHandler;
import edu.berkeley.guir.lib.satin.stroke.TimedPolygon2D;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TimedCurvyStroke
extends TimedStroke
implements SatinConstants {
    private static final Color SELECTED_COLOR;
    private static final int SELECTED_WIDTH = 6;
    private GeneralPath thePath = new GeneralPath(0);
    private boolean thisIsALink = false;
    private boolean doNotRender = false;
    private static int MAX_MOUSE_POINTS;
    private boolean drawingLine;
    private float[] directAngle = new float[MAX_MOUSE_POINTS];
    private int directAngleSize;
    private float[] triangleFilteredAngle = new float[MAX_MOUSE_POINTS];
    private int triangleArraySize;
    private int triangleFilterSize = 5;
    private int[] curveDraw = new int[MAX_MOUSE_POINTS];
    private int curveDrawSize;
    private int recentAngleNum;
    private boolean isSelectionRenderEnabled = true;
    private float degrees = 70.0f;
    private float THRESHHOLD = this.degrees * ((float)Math.PI / 180);
    private boolean endTangentExist = false;
    private float endTangent;
    private boolean noKinks = true;
    private GeneralPath theEndLine = new GeneralPath(0);
    private boolean lineDone = false;
    private Point2D ptA = new Point2D.Float();
    private Point2D ptB = new Point2D.Float();
    private float cornerDegree = 70.0f;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.satin.stroke.TimedCurvyStroke");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        SELECTED_COLOR = new Color(210, 0, 0);
        MAX_MOUSE_POINTS = 210;
    }

    public TimedCurvyStroke() {
        this.initializations();
    }

    public TimedCurvyStroke(Polygon2D p) {
        this.initializations();
        TimedPolygon2D tempPoly = p instanceof TimedPolygon2D ? new TimedPolygon2D((TimedPolygon2D)p) : new TimedPolygon2D(p);
        int index = 0;
        while (index < tempPoly.npoints) {
            this.addPoint((int)tempPoly.xpoints[index], (int)tempPoly.ypoints[index]);
            ++index;
        }
        this.setLocalBoundingPoints2DRef(this.poly);
        this.setHasClosedBoundingPoints(false);
        this.doneAddingPoints();
    }

    public TimedCurvyStroke(TimedStroke tstk) {
        this.initializations();
        TimedPolygon2D tempPoly = tstk.getPolygon2D(10);
        int index = 0;
        while (index < tempPoly.npoints) {
            this.addPoint((int)tempPoly.xpoints[index], (int)tempPoly.ypoints[index]);
            ++index;
        }
        this.poly = tempPoly;
        this.setTransform(tstk.getTransform(11));
        this.setHasClosedBoundingPoints(false);
        this.length = tstk.length;
        this.doneAddingPoints();
        this.setLocalBoundingPoints2DRef(this.poly);
    }

    public TimedCurvyStroke(TimedStroke tstk, boolean isLink) {
        this(tstk);
        this.thisIsALink = isLink;
        if (isLink) {
            this.cornerDegree = 140.0f;
        }
    }

    public TimedCurvyStroke(TimedCurvyStroke tcstk) {
        this.initializations();
        TimedPolygon2D tempPoly = tcstk.getPolygon2D(10);
        this.thePath = tcstk.thePath;
        this.poly = tempPoly;
        this.setTransform(tcstk.getTransform(11));
        this.setHasClosedBoundingPoints(false);
        this.length = tcstk.length;
        this.doneAddingPoints();
        this.setLocalBoundingPoints2DRef(this.poly);
    }

    private void initializations() {
        TimedPolygon2D timedPolygon2D = this.poly;
        synchronized (timedPolygon2D) {
            super.clearPoints();
        }
        this.thePath.reset();
        if (this.lineDone) {
            this.directAngle = new float[MAX_MOUSE_POINTS];
            this.triangleFilteredAngle = new float[MAX_MOUSE_POINTS];
            this.curveDraw = new int[MAX_MOUSE_POINTS];
        }
        this.drawingLine = false;
        this.directAngleSize = 0;
        this.triangleArraySize = 0;
        this.curveDrawSize = 0;
        this.recentAngleNum = -1;
        this.theEndLine.reset();
        this.lineDone = false;
        this.endTangentExist = false;
    }

    public void setFilterSize(int mySize) {
        if (!this.drawingLine) {
            this.triangleFilterSize = mySize;
        }
    }

    public void setThreshhold(float myDegree) {
        if (!this.drawingLine) {
            this.degrees = myDegree;
            this.THRESHHOLD = this.degrees * ((float)Math.PI / 180);
        }
    }

    public void setRenderCurvy(boolean var) {
        this.doNotRender = !var;
    }

    public void setCornerThreshhold(float myCornerThresh) {
        this.cornerDegree = myCornerThresh;
    }

    public void setNoKinks() {
        this.noKinks = true;
    }

    public void setWithKinks() {
        this.noKinks = false;
    }

    public TimedStroke doneAddingPoints() {
        if (this.noKinks) {
            this.findKinklessControlPoints(this.triangleFilterSize, 1);
        } else {
            this.findControlPoints(this.triangleFilterSize, 1);
        }
        if (Sheet.isIdleRenderingMode()) {
            this.damage(22, this);
        } else {
            this.damage(21, this);
        }
        this.drawingLine = false;
        ViewHandler k = this.getViewHandler();
        Point2D yay = k.normalizeBoundingPoints();
        if (yay != null) {
            this.thePath.transform(AffineTransform.getTranslateInstance(yay.getX(), yay.getY()));
        }
        this.lineDone = true;
        this.directAngle = null;
        this.triangleFilteredAngle = null;
        this.curveDraw = null;
        return super.doneAddingPoints();
    }

    public void clearPoints() {
        this.initializations();
    }

    public void enableSelectionRender(boolean b) {
        this.isSelectionRenderEnabled = b;
    }

    public void addPoint(float myX, float myY, long time) {
        if (this.pointFilter(myX, myY)) {
            Shape shape = this.poly;
            synchronized (shape) {
                this.poly.addPoint(myX, myY, time);
            }
            if (this.curveDrawSize >= this.curveDraw.length - 5 || this.directAngleSize >= this.directAngle.length - 5) {
                this.expandArrays();
            }
            shape = this;
            synchronized (shape) {
                if (this.poly.npoints > 1 && this.addDirectAngle()) {
                    this.triangleFilter(this.triangleFilterSize);
                }
            }
            this.updateLength();
            this.damageEnd();
        }
    }

    protected void defaultRender(SatinGraphics g) {
        if (this.isRightButton() || this.doNotRender) {
            super.defaultRender(g);
            return;
        }
        if (SatinConstants.cmdsubsys.isSelected(this) && this.isSelectionRenderEnabled) {
            g.setColor(SELECTED_COLOR);
            g.setStroke(new BasicStroke(6.0f));
            g.draw(this.thePath);
            g.setStroke(this.getStyleRef().getDrawStroke());
            g.setColor(Color.white);
        }
        g.draw(this.thePath);
        if (!this.lineDone) {
            int lastDrawn = this.curveDrawSize == 0 ? 0 : this.curveDraw[this.curveDrawSize - 1];
            if (lastDrawn < this.poly.npoints - this.triangleFilterSize) {
                lastDrawn = this.poly.npoints - this.triangleFilterSize;
            }
            this.theEndLine.reset();
            int currentPointIndex = this.curveDrawSize != 0 ? this.curveDraw[this.curveDrawSize - 1] : 0;
            this.theEndLine.moveTo(this.poly.xpoints[currentPointIndex], this.poly.ypoints[currentPointIndex]);
            lastDrawn = this.poly.npoints - 1;
            float xpoint = this.poly.xpoints[lastDrawn];
            float ypoint = this.poly.ypoints[lastDrawn];
            this.theEndLine.curveTo(this.poly.xpoints[currentPointIndex + (lastDrawn - currentPointIndex) / 3], this.poly.ypoints[currentPointIndex + (lastDrawn - currentPointIndex) / 3], this.poly.xpoints[currentPointIndex + 2 * (lastDrawn - currentPointIndex) / 3], this.poly.ypoints[currentPointIndex + 2 * (lastDrawn - currentPointIndex) / 3], xpoint, ypoint);
            g.draw(this.theEndLine);
        }
    }

    protected void renderSelected(SatinGraphics g, Rectangle2D rect) {
    }

    private void damageEnd() {
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        if (!this.lineDone) {
            int lastDrawn = this.curveDrawSize == 0 ? 0 : this.curveDraw[this.curveDrawSize - 1];
            if (lastDrawn < this.poly.npoints - this.triangleFilterSize) {
                lastDrawn = this.poly.npoints - this.triangleFilterSize;
            }
            int currentPointIndex = this.curveDrawSize != 0 && this.noKinks ? (this.curveDrawSize > 4 ? this.curveDraw[this.curveDrawSize - 4] : this.curveDraw[this.curveDrawSize - 1]) : 0;
            minX = this.poly.xpoints[currentPointIndex];
            minY = this.poly.ypoints[currentPointIndex];
            maxX = this.poly.xpoints[currentPointIndex];
            maxY = this.poly.ypoints[currentPointIndex];
            int currPoint = currentPointIndex + 1;
            while (currPoint < this.poly.npoints) {
                float xpoint = this.poly.xpoints[currPoint];
                float ypoint = this.poly.ypoints[currPoint];
                minX = Math.min(xpoint, minX);
                maxX = Math.max(xpoint, maxX);
                minY = Math.min(ypoint, minY);
                maxY = Math.max(ypoint, maxY);
                if (currPoint < lastDrawn) {
                    currPoint += 5;
                    continue;
                }
                ++currPoint;
            }
        }
        if (maxX != 0.0f || maxY != 0.0f || minX != 0.0f || minY != 0.0f) {
            this.ptA.setLocation(minX, minY);
            this.ptB.setLocation(maxX, maxY);
            TimedStroke.txBuffer = this.getTransform(12, TimedStroke.txBuffer);
            TimedStroke.txBuffer.transform(this.ptA, this.ptA);
            TimedStroke.txBuffer.transform(this.ptB, this.ptB);
            int width = (int)this.getStyleRef().getLineWidth() + 1;
            TimedStroke.damageRect.setRect(this.ptA.getX(), this.ptA.getY(), Math.abs(this.ptB.getX() - this.ptA.getX()) + (double)width + 2.0, Math.abs(this.ptB.getY() - this.ptA.getY()) + (double)width + 2.0);
            if (Sheet.isIdleRenderingMode()) {
                this.damage(22, TimedStroke.damageRect);
            } else {
                this.damage(21, TimedStroke.damageRect);
            }
        }
    }

    public Object clone() {
        TimedCurvyStroke stk = new TimedCurvyStroke(this, this.thisIsALink);
        this.clone(stk);
        return stk;
    }

    protected TimedCurvyStroke clone(TimedCurvyStroke stk) {
        super.clone(stk);
        return stk;
    }

    public Object deepClone() {
        return this.clone();
    }

    protected Object deepClone(TimedCurvyStroke gobClone) {
        return this.clone(gobClone);
    }

    private boolean addDirectAngle() {
        float initialGuessAngle;
        if (this.poly.npoints < 2) {
            return false;
        }
        float diffX = this.poly.xpoints[this.poly.npoints - 1] - this.poly.xpoints[this.poly.npoints - 2];
        float diffY = this.poly.ypoints[this.poly.npoints - 1] - this.poly.ypoints[this.poly.npoints - 2];
        if (diffX == 0.0f) {
            if ((double)diffY > 0.0) {
                initialGuessAngle = 4.712389f;
            } else {
                if ((double)diffY == 0.0) {
                    TimedPolygon2D timedPolygon2D = this.poly;
                    synchronized (timedPolygon2D) {
                        --this.poly.npoints;
                    }
                    return false;
                }
                initialGuessAngle = 1.5707964f;
            }
        } else {
            initialGuessAngle = this.convertMouse2PI((float)Math.atan(diffY / diffX), diffX, diffY);
        }
        if (this.directAngleSize == 0) {
            this.directAngle[0] = initialGuessAngle;
            ++this.directAngleSize;
            return true;
        }
        float previousAngle = this.within2PI(this.directAngle[this.poly.npoints - 3]);
        float angleDiff = initialGuessAngle - previousAngle;
        if ((double)Math.abs(angleDiff) > Math.abs((double)initialGuessAngle - ((double)previousAngle + Math.PI * 2))) {
            angleDiff = initialGuessAngle - (previousAngle + (float)Math.PI * 2);
        }
        if ((double)Math.abs(angleDiff) > Math.abs((double)initialGuessAngle + Math.PI * 2 - (double)previousAngle)) {
            angleDiff = initialGuessAngle + (float)Math.PI * 2 - previousAngle;
        }
        this.directAngle[this.poly.npoints - 2] = this.directAngle[this.poly.npoints - 3] + angleDiff;
        ++this.directAngleSize;
        return true;
    }

    private float convert2PI(float radAngle, float diffX, float diffY) {
        if (diffY >= 0.0f && diffX >= 0.0f) {
            return this.within2PI(radAngle);
        }
        if (diffY >= 0.0f && diffX < 0.0f) {
            return this.within2PI((float)Math.PI + radAngle);
        }
        if (diffY < 0.0f && diffX < 0.0f) {
            return this.within2PI((float)Math.PI + radAngle);
        }
        return this.within2PI(radAngle);
    }

    private float convertMouse2PI(float radAngle, float diffX, float diffY) {
        if (diffY >= 0.0f && diffX >= 0.0f) {
            return this.within2PI((float)Math.PI * 2 - radAngle);
        }
        if (diffY >= 0.0f && diffX < 0.0f) {
            return this.within2PI((float)Math.PI - radAngle);
        }
        if (diffY < 0.0f && diffX < 0.0f) {
            return this.within2PI((float)Math.PI - radAngle);
        }
        return this.within2PI(0.0f - radAngle);
    }

    private float within2PI(float radAngle) {
        while ((double)radAngle >= Math.PI * 2) {
            radAngle = (float)((double)radAngle - Math.PI * 2);
        }
        while (radAngle < 0.0f) {
            radAngle = (float)((double)radAngle + Math.PI * 2);
        }
        return radAngle;
    }

    private void triangleFilter(int filterSize) {
        int offset;
        if (this.directAngleSize < filterSize) {
            return;
        }
        int halfFilterSize = (int)Math.ceil(filterSize / 2);
        float convolutionSum = 0.0f;
        float averageMaker = 0.0f;
        boolean even = halfFilterSize == filterSize / 2;
        int counter = halfFilterSize;
        convolutionSum = this.directAngle[this.directAngleSize - halfFilterSize];
        averageMaker += 1.0f;
        if (even) {
            offset = 1;
        } else {
            offset = 0;
            --counter;
        }
        while (counter > 0) {
            convolutionSum += (float)(counter / (halfFilterSize + offset)) * this.directAngle[this.directAngleSize - 2 * halfFilterSize + counter - offset];
            averageMaker += (float)(counter / (halfFilterSize + offset));
            --counter;
        }
        counter = halfFilterSize - 1;
        while (counter > 0) {
            convolutionSum += (float)(counter / halfFilterSize) * this.directAngle[this.directAngleSize - counter];
            averageMaker += (float)(counter / halfFilterSize);
            --counter;
        }
        convolutionSum /= averageMaker;
        float[] fArray = this.triangleFilteredAngle;
        synchronized (this.triangleFilteredAngle) {
            this.triangleFilteredAngle[this.triangleArraySize] = convolutionSum;
            // ** MonitorExit[var8_8] (shouldn't be in output)
            ++this.triangleArraySize;
            if (this.noKinks) {
                this.findKinklessControlPoints(filterSize, 0);
            } else {
                this.findControlPoints(filterSize, 0);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findControlPoints(int filterSize, int choice) {
        if (this.recentAngleNum == -1) {
            this.recentAngleNum = 0;
            int[] nArray = this.curveDraw;
            synchronized (this.curveDraw) {
                this.curveDraw[0] = 0;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                ++this.curveDrawSize;
                this.thePath.moveTo(this.poly.xpoints[0], this.poly.ypoints[0]);
                if (choice != 1) return;
                this.thePath.lineTo(this.poly.xpoints[this.poly.npoints - 1], this.poly.ypoints[this.poly.npoints - 1]);
                this.curveDraw[1] = this.poly.npoints - 1;
                ++this.curveDrawSize;
                return;
            }
        }
        if (choice == 1) {
            int currentPointIndex = this.curveDraw[this.curveDrawSize - 1];
            if (currentPointIndex < this.poly.npoints - 1 - filterSize) {
                this.thePath.curveTo(this.poly.xpoints[this.recentAngleNum + (this.poly.npoints - 1 - filterSize - this.recentAngleNum) / 3], this.poly.ypoints[this.recentAngleNum + (this.poly.npoints - 1 - filterSize - this.recentAngleNum) / 3], this.poly.xpoints[this.recentAngleNum + (this.poly.npoints - 1 - filterSize - this.recentAngleNum) * 2 / 3], this.poly.ypoints[this.recentAngleNum + (this.poly.npoints - 1 - filterSize - this.recentAngleNum) * 2 / 3], this.poly.xpoints[this.poly.npoints - 1 - filterSize], this.poly.ypoints[this.poly.npoints - 1 - filterSize]);
                this.recentAngleNum = this.triangleArraySize - 1;
                currentPointIndex = this.poly.npoints - 1 - filterSize;
            }
            while (currentPointIndex < this.poly.npoints) {
                this.thePath.lineTo(this.poly.xpoints[currentPointIndex], this.poly.ypoints[currentPointIndex]);
                ++currentPointIndex;
            }
            return;
        }
        if (choice == 0) {
            if (!this.aboveThresh(this.triangleFilteredAngle[this.recentAngleNum], this.triangleFilteredAngle[this.triangleArraySize - 1]) && !this.cornerDetectedSharp(this.triangleArraySize - 1)) return;
            int[] nArray = this.curveDraw;
            synchronized (this.curveDraw) {
                this.curveDraw[this.curveDrawSize] = this.recentAngleNum + (this.triangleArraySize - 1 - this.recentAngleNum) / 3;
                ++this.curveDrawSize;
                this.curveDraw[this.curveDrawSize] = this.recentAngleNum + (this.triangleArraySize - 1 - this.recentAngleNum) * 2 / 3;
                ++this.curveDrawSize;
                this.curveDraw[this.curveDrawSize] = this.triangleArraySize - 1;
                ++this.curveDrawSize;
                // ** MonitorExit[var3_5] (shouldn't be in output)
                this.thePath.curveTo(this.poly.xpoints[this.curveDraw[this.curveDrawSize - 3]], this.poly.ypoints[this.curveDraw[this.curveDrawSize - 3]], this.poly.xpoints[this.curveDraw[this.curveDrawSize - 2]], this.poly.ypoints[this.curveDraw[this.curveDrawSize - 2]], this.poly.xpoints[this.curveDraw[this.curveDrawSize - 1]], this.poly.ypoints[this.curveDraw[this.curveDrawSize - 1]]);
                this.recentAngleNum = this.triangleArraySize - 1;
                return;
            }
        }
        if ($assertionsDisabled) return;
        throw new AssertionError();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findKinklessControlPoints(int filterSize, int choice) {
        if (this.recentAngleNum == -1) {
            this.recentAngleNum = 0;
            int[] nArray = this.curveDraw;
            synchronized (this.curveDraw) {
                this.curveDraw[0] = 0;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                ++this.curveDrawSize;
                this.thePath.moveTo(this.poly.xpoints[0], this.poly.ypoints[0]);
                if (choice != 1) return;
                this.thePath.lineTo(this.poly.xpoints[this.poly.npoints - 1], this.poly.ypoints[this.poly.npoints - 1]);
                this.curveDraw[1] = this.poly.npoints - 1;
                ++this.curveDrawSize;
                return;
            }
        }
        if (choice == 1) {
            int currentPointIndex = this.curveDraw[this.curveDrawSize - 1];
            if (currentPointIndex < this.poly.npoints - 1) {
                float thirdLastXPoint = this.poly.xpoints[this.recentAngleNum + (this.poly.npoints - 1 - this.recentAngleNum) / 3];
                float thirdLastYPoint = this.poly.ypoints[this.recentAngleNum + (this.poly.npoints - 1 - this.recentAngleNum) / 3];
                float secondLastXPoint = this.poly.xpoints[this.recentAngleNum + (this.poly.npoints - 1 - this.recentAngleNum) * 2 / 3];
                float secondLastYPoint = this.poly.ypoints[this.recentAngleNum + (this.poly.npoints - 1 - this.recentAngleNum) * 2 / 3];
                float lastXPoint = this.poly.xpoints[this.poly.npoints - 1];
                float lastYPoint = this.poly.ypoints[this.poly.npoints - 1];
                float fourthLastXPoint = this.poly.xpoints[this.curveDraw[this.curveDrawSize - 1]];
                float fourthLastYPoint = this.poly.ypoints[this.curveDraw[this.curveDrawSize - 1]];
                if (this.endTangentExist && !this.cornerDetectedSharp(this.recentAngleNum)) {
                    AffineTransform matrix = new AffineTransform();
                    float oldDiffX = thirdLastXPoint - fourthLastXPoint;
                    float oldDiffY = thirdLastYPoint - fourthLastYPoint;
                    float beginTangent = this.findAngle(oldDiffX, oldDiffY);
                    float angleDiff = this.endTangent - beginTangent;
                    angleDiff = -angleDiff;
                    matrix.setToTranslation(fourthLastXPoint, fourthLastYPoint);
                    matrix.rotate(angleDiff);
                    matrix.translate(-fourthLastXPoint, -fourthLastYPoint);
                    Point2D.Float transformPoint = new Point2D.Float();
                    ((Point2D)transformPoint).setLocation(thirdLastXPoint, thirdLastYPoint);
                    matrix.transform(transformPoint, transformPoint);
                    thirdLastXPoint = (float)((Point2D)transformPoint).getX();
                    thirdLastYPoint = (float)((Point2D)transformPoint).getY();
                }
                float oldDiffX = lastXPoint - secondLastXPoint;
                float oldDiffY = lastYPoint - secondLastYPoint;
                this.endTangent = this.findAngle(oldDiffX, oldDiffY);
                this.endTangentExist = true;
                this.thePath.curveTo(thirdLastXPoint, thirdLastYPoint, secondLastXPoint, secondLastYPoint, lastXPoint, lastYPoint);
                this.recentAngleNum = this.triangleArraySize - 1;
                currentPointIndex = this.poly.npoints - 1;
            }
            while (currentPointIndex < this.poly.npoints) {
                this.thePath.lineTo(this.poly.xpoints[currentPointIndex], this.poly.ypoints[currentPointIndex]);
                ++currentPointIndex;
            }
            return;
        }
        if (choice == 0) {
            if (!this.aboveThresh(this.triangleFilteredAngle[this.recentAngleNum], this.triangleFilteredAngle[this.triangleArraySize - 1]) && !this.cornerDetectedSharp(this.triangleArraySize - 1)) return;
            int[] currentPointIndex = this.curveDraw;
            synchronized (this.curveDraw) {
                this.curveDraw[this.curveDrawSize] = this.recentAngleNum + (this.triangleArraySize - 1 - this.recentAngleNum) / 3;
                ++this.curveDrawSize;
                this.curveDraw[this.curveDrawSize] = this.recentAngleNum + (this.triangleArraySize - 1 - this.recentAngleNum) * 2 / 3;
                ++this.curveDrawSize;
                this.curveDraw[this.curveDrawSize] = this.triangleArraySize - 1;
                ++this.curveDrawSize;
                // ** MonitorExit[currentPointIndex] (shouldn't be in output)
                float lastXPoint = this.poly.xpoints[this.curveDraw[this.curveDrawSize - 1]];
                float lastYPoint = this.poly.ypoints[this.curveDraw[this.curveDrawSize - 1]];
                float secondLastXPoint = this.poly.xpoints[this.curveDraw[this.curveDrawSize - 2]];
                float secondLastYPoint = this.poly.ypoints[this.curveDraw[this.curveDrawSize - 2]];
                float thirdLastXPoint = this.poly.xpoints[this.curveDraw[this.curveDrawSize - 3]];
                float thirdLastYPoint = this.poly.ypoints[this.curveDraw[this.curveDrawSize - 3]];
                float fourthLastXPoint = this.poly.xpoints[this.curveDraw[this.curveDrawSize - 4]];
                float fourthLastYPoint = this.poly.ypoints[this.curveDraw[this.curveDrawSize - 4]];
                if (this.endTangentExist && !this.cornerDetectedSharp(this.recentAngleNum)) {
                    AffineTransform matrix = new AffineTransform();
                    float oldDiffX = thirdLastXPoint - fourthLastXPoint;
                    float oldDiffY = thirdLastYPoint - fourthLastYPoint;
                    float beginTangent = this.findAngle(oldDiffX, oldDiffY);
                    float angleDiff = this.endTangent - beginTangent;
                    angleDiff = -angleDiff;
                    matrix.setToTranslation(fourthLastXPoint, fourthLastYPoint);
                    matrix.rotate(angleDiff);
                    matrix.translate(-fourthLastXPoint, -fourthLastYPoint);
                    Point2D.Float transformPoint = new Point2D.Float();
                    ((Point2D)transformPoint).setLocation(thirdLastXPoint, thirdLastYPoint);
                    matrix.transform(transformPoint, transformPoint);
                    thirdLastXPoint = (float)((Point2D)transformPoint).getX();
                    thirdLastYPoint = (float)((Point2D)transformPoint).getY();
                }
                float oldDiffX = lastXPoint - secondLastXPoint;
                float oldDiffY = lastYPoint - secondLastYPoint;
                this.endTangent = this.findAngle(oldDiffX, oldDiffY);
                this.endTangentExist = true;
                this.thePath.curveTo(thirdLastXPoint, thirdLastYPoint, secondLastXPoint, secondLastYPoint, lastXPoint, lastYPoint);
                this.recentAngleNum = this.triangleArraySize - 1;
                return;
            }
        }
        if ($assertionsDisabled) return;
        throw new AssertionError();
    }

    private boolean cornerDetectedSharp(int triangleFilterIndex) {
        int previous = 5;
        if (triangleFilterIndex < previous) {
            return false;
        }
        float cornerThresh = this.cornerDegree * (float)Math.PI / 180.0f;
        float difference = Math.abs(this.triangleFilteredAngle[triangleFilterIndex] - this.triangleFilteredAngle[triangleFilterIndex - previous]);
        return difference > cornerThresh;
    }

    private boolean aboveThresh(float angle1, float angle2) {
        float angleDifference = Math.abs(angle2 - angle1);
        return angleDifference >= this.THRESHHOLD;
    }

    private void expandArrays() {
        Object[] objectArray = this.directAngle;
        synchronized (this.directAngle) {
            float[] temp = new float[this.directAngle.length * 2];
            System.arraycopy(this.directAngle, 0, temp, 0, this.directAngle.length);
            this.directAngle = temp;
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            objectArray = this.triangleFilteredAngle;
            synchronized (this.triangleFilteredAngle) {
                temp = new float[this.triangleFilteredAngle.length * 2];
                System.arraycopy(this.triangleFilteredAngle, 0, temp, 0, this.triangleFilteredAngle.length);
                this.triangleFilteredAngle = temp;
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                objectArray = this.curveDraw;
                synchronized (this.curveDraw) {
                    int[] tempint = new int[this.curveDraw.length * 2];
                    System.arraycopy(this.curveDraw, 0, tempint, 0, this.curveDraw.length);
                    this.curveDraw = tempint;
                    // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    private float findAngle(float vectX, float vectY) {
        float angle = vectX == 0.0f ? ((double)vectY > 0.0 ? 4.712389f : ((double)vectY == 0.0 ? 0.0f : 1.5707964f)) : this.convertMouse2PI((float)Math.atan(vectY / vectX), vectX, vectY);
        return angle;
    }

    public void changeDest(float x, float y) {
        Point2D.Float newDestPt = new Point2D.Float();
        Point2D destPt = this.thePath.getCurrentPoint();
        Point2D.Float sourcePt = new Point2D.Float();
        ((Point2D)newDestPt).setLocation(x, y);
        PathIterator pIt = this.thePath.getPathIterator(new AffineTransform());
        float[] temppoints = new float[6];
        pIt.currentSegment(temppoints);
        ((Point2D)sourcePt).setLocation(temppoints[0], temppoints[1]);
        if (((Point2D)newDestPt).getX() == destPt.getX() && ((Point2D)newDestPt).getY() == destPt.getY()) {
            return;
        }
        this.scaleRotate(sourcePt, destPt, newDestPt);
        this.setLocalBoundingPoints2DRef(this.poly);
    }

    public void changeSource(float x, float y) {
        Point2D.Float newSourcePt = new Point2D.Float();
        Point2D destPt = this.thePath.getCurrentPoint();
        Point2D.Float sourcePt = new Point2D.Float();
        ((Point2D)newSourcePt).setLocation(x, y);
        PathIterator pIt = this.thePath.getPathIterator(new AffineTransform());
        float[] temppoints = new float[6];
        pIt.currentSegment(temppoints);
        ((Point2D)sourcePt).setLocation(temppoints[0], temppoints[1]);
        if (((Point2D)newSourcePt).getX() == ((Point2D)sourcePt).getX() && ((Point2D)newSourcePt).getY() == ((Point2D)sourcePt).getY()) {
            return;
        }
        this.scaleRotate(destPt, sourcePt, newSourcePt);
        this.setLocalBoundingPoints2DRef(this.poly);
    }

    private void scaleRotate(Point2D anchor, Point2D originalEnd, Point2D newEnd) {
        AffineTransform matrix = new AffineTransform();
        float oldDiffX = (float)originalEnd.getX() - (float)anchor.getX();
        float oldDiffY = (float)originalEnd.getY() - (float)anchor.getY();
        float angleOrig = this.findAngle(oldDiffX, oldDiffY);
        float newDiffX = (float)newEnd.getX() - (float)anchor.getX();
        float newDiffY = (float)newEnd.getY() - (float)anchor.getY();
        float angleNew = this.findAngle(newDiffX, newDiffY);
        float angleDiff = angleOrig - angleNew;
        float oldMagnitude = oldDiffX * oldDiffX + oldDiffY * oldDiffY;
        float newMagnitude = newDiffX * newDiffX + newDiffY * newDiffY;
        float scale = (float)Math.sqrt(newMagnitude / oldMagnitude);
        float tempX = (float)anchor.getX();
        float tempY = (float)anchor.getY();
        matrix.setToTranslation(tempX, tempY);
        matrix.rotate(angleDiff);
        matrix.scale(scale, scale);
        matrix.translate(-tempX, -tempY);
        this.thePath.transform(matrix);
        this.poly.transform(matrix);
    }

    public void deepClear() {
        super.deepClear();
        this.thePath = null;
        this.directAngle = null;
        this.triangleFilteredAngle = null;
        this.curveDraw = null;
        this.theEndLine = null;
        this.ptA = null;
        this.ptB = null;
    }
}

