/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.stroke;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.graph.StrokeGraph;
import edu.berkeley.guir.lib.satin.stroke.TimedPolygon2D;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class StrokeSegmentLib {
    public static final int DEFAULT_DIST_THRESHOLD = 15;
    public static final int SEGMENT_THRESHOLD = 6;
    public static final int ENDPOINT_ANGLE = 6;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.satin.stroke.StrokeSegmentLib");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private StrokeSegmentLib() {
    }

    private static double minValue(double[] arr) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] < min) {
                min = arr[i];
            }
            ++i;
        }
        return min;
    }

    private static double avg(double[] arr) {
        double sum = 0.0;
        int i = 0;
        while (i < arr.length) {
            sum += arr[i];
            ++i;
        }
        return sum / (double)arr.length;
    }

    private static double stdev(double[] arr) {
        double avg = StrokeSegmentLib.avg(arr);
        double sum = 0.0;
        int i = 0;
        while (i < arr.length) {
            sum += (arr[i] - avg) * (arr[i] - avg);
            ++i;
        }
        return Math.sqrt(sum / (double)arr.length);
    }

    private static boolean isLocalMaxima1(double[] arr, int i) {
        if (arr.length <= 1) {
            return true;
        }
        if (i == 0) {
            return arr[0] >= arr[1];
        }
        if (i == arr.length - 1) {
            return arr[arr.length - 1] >= arr[arr.length - 2];
        }
        return arr[i] >= arr[i + 1] && arr[i] > arr[i - 1];
    }

    private static boolean isLocalMaxima2(double[] arr, int i) {
        int g = i - 2;
        int h = i - 1;
        int j = i + 1;
        int k = i + 2;
        if (arr.length <= 2) {
            return true;
        }
        double vg = g < 0 ? Double.MIN_VALUE : arr[g];
        double vh = h < 0 ? Double.MIN_VALUE : arr[h];
        double vi = arr[i];
        double vj = j >= arr.length ? Double.MIN_VALUE : arr[j];
        double vk = k >= arr.length ? Double.MIN_VALUE : arr[k];
        return vi >= vh && vi >= vg && vi > vj && vi > vk;
    }

    private static double distance(Rectangle2D rAA, Rectangle2D rBB) {
        if (rAA.intersects(rBB.getX(), rBB.getY(), rBB.getWidth(), rBB.getHeight())) {
            return 0.0;
        }
        double x1 = rBB.getX();
        double y1 = rBB.getY();
        double x2 = rBB.getX() + rBB.getWidth();
        double y2 = rBB.getY() + rBB.getHeight();
        Line2D.Double lAA = new Line2D.Double(x1, y1, x2, y1);
        Line2D.Double lBB = new Line2D.Double(x2, y1, x2, y2);
        Line2D.Double lCC = new Line2D.Double(x2, y2, x1, y2);
        Line2D.Double lDD = new Line2D.Double(x1, y2, x1, y1);
        x1 = rAA.getX();
        y1 = rAA.getY();
        x2 = rAA.getX() + rAA.getWidth();
        y2 = rAA.getY() + rAA.getHeight();
        double[] dists = new double[]{lAA.ptSegDist(x1, y1), lAA.ptSegDist(x2, y1), lAA.ptSegDist(x2, y2), lAA.ptSegDist(x1, y2), lBB.ptSegDist(x1, y1), lBB.ptSegDist(x2, y1), lBB.ptSegDist(x2, y2), lBB.ptSegDist(x1, y2), lCC.ptSegDist(x1, y1), lCC.ptSegDist(x2, y1), lCC.ptSegDist(x2, y2), lCC.ptSegDist(x1, y2), lDD.ptSegDist(x1, y1), lDD.ptSegDist(x2, y1), lDD.ptSegDist(x2, y2), lDD.ptSegDist(x1, y2)};
        return StrokeSegmentLib.minValue(dists);
    }

    private static boolean fullOrNearIntersect(TimedStroke stkAA, TimedStroke stkBB, double thresh) {
        if (!$assertionsDisabled && !(thresh >= 0.0)) {
            throw new AssertionError();
        }
        Rectangle2D.Float bdsXX = new Rectangle2D.Float();
        Rectangle2D.Float bdsYY = new Rectangle2D.Float();
        stkAA.getBounds2D(11, null, bdsXX);
        stkBB.getBounds2D(11, null, bdsYY);
        double dist = StrokeSegmentLib.distance(bdsXX, bdsYY);
        return dist <= thresh;
    }

    private static double calculateAngle(double x1, double y1, double x2, double y2, double x3, double y3) {
        double dx = x3 - x2;
        double dy = y3 - y2;
        double dx2 = x2 - x1;
        double dy2 = y2 - y1;
        return Math.atan2(dx * dy2 - dx2 * dy, dx * dx2 + dy * dy2);
    }

    private static double[] calculateVelocity(TimedStroke stk) {
        TimedPolygon2D poly = stk.getPolygon2D(12);
        long[] times = poly.times;
        float[] xpts = poly.xpoints;
        float[] ypts = poly.ypoints;
        int len = poly.npoints;
        double[] velocity = new double[len];
        int i = 0;
        while (i < len - 1) {
            double dist = Point2D.distance(xpts[i], ypts[i], xpts[i + 1], ypts[i + 1]);
            long time = Math.max(times[i + 1] - times[i], 10L);
            velocity[i] = dist / (double)time;
            ++i;
        }
        if (len >= 2) {
            velocity[len - 1] = velocity[len - 2];
        }
        return velocity;
    }

    /*
     * Unable to fully structure code
     */
    private static double[] calculateAngleDeltas(Polygon2D poly) {
        dThetaArr = new double[poly.npoints];
        xpts = poly.xpoints;
        ypts = poly.ypoints;
        j = 0;
        while (j < poly.npoints) {
            block5: {
                block3: {
                    block4: {
                        k = j + 1;
                        if (k < poly.npoints) break block3;
                        if (poly.isClosed()) break block4;
                        dThetaArr[j] = 6.0;
                        break block5;
                    }
                    k %= poly.npoints;
                }
                if ((i = j - 1) >= 0) ** GOTO lbl19
                if (!poly.isClosed()) {
                    dThetaArr[j] = 6.0;
                } else {
                    i += poly.npoints - 1;
lbl19:
                    // 2 sources

                    dist = Point2D.distance(xpts[j], ypts[j], xpts[k], ypts[k]);
                    dThetaArr[j] = dTheta = StrokeSegmentLib.calculateAngle(xpts[i], ypts[i], xpts[j], ypts[j], xpts[k], ypts[k]);
                }
            }
            ++j;
        }
        return dThetaArr;
    }

    public static StrokeGraph segment(TimedStroke[] stks) {
        return StrokeSegmentLib.segment(stks, 15.0);
    }

    public static StrokeGraph segment(TimedStroke[] stks, double thresh) {
        LinkedList<IntersectingPair> listPairs = new LinkedList<IntersectingPair>();
        int i = 0;
        while (i < stks.length) {
            int j = i + 1;
            while (j < stks.length) {
                if (StrokeSegmentLib.fullOrNearIntersect(stks[i], stks[j], thresh)) {
                    listPairs.add(new IntersectingPair(i, j));
                }
                ++j;
            }
            ++i;
        }
        throw new RuntimeException("not implemented yet");
    }

    public static StrokeGraph segment(TimedStroke[] stks, Rectangle2D rect) {
        throw new RuntimeException("not implemented yet");
    }

    public static StrokeGraph segment(TimedStroke stk) {
        Polygon2D bds = stk.getBoundingPoints2D(11);
        float[] xpts = bds.xpoints;
        float[] ypts = bds.ypoints;
        int len = bds.npoints;
        StrokeGraph g = new StrokeGraph();
        double[] dThetaArr = StrokeSegmentLib.calculateAngleDeltas(bds);
        double[] dVelocityArr = StrokeSegmentLib.calculateVelocity(stk);
        double[] dAngleVelocityArr = new double[len];
        LinkedList<Integer> listPts = new LinkedList<Integer>();
        int i = 0;
        while (i < dVelocityArr.length) {
            dAngleVelocityArr[i] = Math.abs(dThetaArr[i] / dVelocityArr[i]);
            ++i;
        }
        double thresh = StrokeSegmentLib.avg(dAngleVelocityArr);
        int i2 = 0;
        while (i2 < dAngleVelocityArr.length) {
            if (Math.abs(dAngleVelocityArr[i2]) >= thresh && StrokeSegmentLib.isLocalMaxima2(dAngleVelocityArr, i2)) {
                listPts.add(new Integer(i2));
            }
            ++i2;
        }
        List listStks = StrokeSegmentLib.cutStroke(listPts, xpts, ypts, len, bds.isClosed());
        Iterator it = listStks.iterator();
        TimedStroke currStk = null;
        TimedStroke lastStk = null;
        TimedStroke firstStk = null;
        while (it.hasNext()) {
            currStk = (TimedStroke)it.next();
            g.addStroke(currStk);
            if (firstStk == null) {
                firstStk = currStk;
            }
            if (lastStk == null) continue;
            g.addConnection(lastStk, currStk);
        }
        if (bds.isClosed() && lastStk != null && firstStk != null) {
            g.addConnection(lastStk, firstStk);
        }
        return g;
    }

    /*
     * Unable to fully structure code
     */
    public static List cutStroke(List listPts, float[] xpts, float[] ypts, int len, boolean flagWraparound) {
        block3: {
            Collections.sort(listPts);
            it = listPts.iterator();
            first = 0;
            start = 0;
            end = 0;
            listStks = new LinkedList<TimedStroke>();
            flagFirst = true;
            if (listPts.size() > 1) ** GOTO lbl24
            poly = new Polygon2D(xpts, ypts, xpts.length);
            listStks.add(new TimedStroke(poly));
            break block3;
lbl-1000:
            // 1 sources

            {
                end = (Integer)it.next();
                if (flagFirst) {
                    flagFirst = false;
                    first = start = end;
                    continue;
                }
                if (end == start) continue;
                poly = new Polygon2D(xpts, ypts, start, end - start + 1);
                poly.setClosed(false);
                listStks.add(new TimedStroke(poly));
                start = end;
lbl24:
                // 4 sources

                ** while (it.hasNext())
            }
lbl25:
            // 1 sources

            if (flagWraparound) {
                xpoints = new float[len - end + first + 1];
                ypoints = new float[len - end + first + 1];
                copylen = len - end;
                System.arraycopy(xpts, end, xpoints, 0, copylen);
                System.arraycopy(ypts, end, ypoints, 0, copylen);
                System.arraycopy(xpts, 0, xpoints, copylen, first);
                System.arraycopy(ypts, 0, ypoints, copylen, first);
                poly = new Polygon2D(xpoints, ypoints, xpoints.length);
                poly.setClosed(false);
                listStks.add(new TimedStroke(poly));
            }
        }
        return listStks;
    }

    public static void main(String[] argv) {
    }

    private static void testCalculateAngle() {
        System.out.println(Math.toDegrees(StrokeSegmentLib.calculateAngle(0.0, 0.0, 10.0, 0.0, 10.0, 10.0)));
        System.out.println(Math.toDegrees(StrokeSegmentLib.calculateAngle(0.0, 0.0, 10.0, 0.0, 17.07, 7.07)));
        System.out.println(Math.toDegrees(StrokeSegmentLib.calculateAngle(0.0, 0.0, 10.0, 0.0, 2.928, 7.07)));
        System.out.println(Math.toDegrees(StrokeSegmentLib.calculateAngle(0.0, 0.0, 10.0, 0.0, 18.66, 5.0)));
        System.out.println(Math.toDegrees(StrokeSegmentLib.calculateAngle(0.0, 0.0, 10.0, 0.0, 1.34, 5.0)));
    }

    private static void testRectDistance(String[] argv) {
        Rectangle2D.Float rAA = new Rectangle2D.Float();
        Rectangle2D.Float rBB = new Rectangle2D.Float();
        ((Rectangle2D)rAA).setRect(0.0, 0.0, 10.0, 10.0);
        ((Rectangle2D)rBB).setRect(0.0, 0.0, 10.0, 10.0);
        System.out.println(StrokeSegmentLib.distance(rAA, rBB));
        System.out.println();
        ((Rectangle2D)rAA).setRect(0.0, 0.0, 10.0, 10.0);
        ((Rectangle2D)rBB).setRect(5.0, 5.0, 10.0, 10.0);
        System.out.println(StrokeSegmentLib.distance(rAA, rBB));
        System.out.println();
        ((Rectangle2D)rAA).setRect(0.0, 0.0, 10.0, 10.0);
        ((Rectangle2D)rBB).setRect(10.0, 10.0, 10.0, 10.0);
        System.out.println(StrokeSegmentLib.distance(rAA, rBB));
        System.out.println();
        ((Rectangle2D)rAA).setRect(0.0, 0.0, 10.0, 10.0);
        ((Rectangle2D)rBB).setRect(11.0, 11.0, 10.0, 10.0);
        System.out.println(StrokeSegmentLib.distance(rAA, rBB));
        System.out.println();
        ((Rectangle2D)rAA).setRect(0.0, 0.0, 10.0, 10.0);
        ((Rectangle2D)rBB).setRect(0.0, 12.0, 10.0, 10.0);
        System.out.println(StrokeSegmentLib.distance(rAA, rBB));
        System.out.println();
        ((Rectangle2D)rAA).setRect(0.0, 0.0, 10.0, 10.0);
        ((Rectangle2D)rBB).setRect(1.0, 12.0, 10.0, 10.0);
        System.out.println(StrokeSegmentLib.distance(rAA, rBB));
        System.out.println();
        ((Rectangle2D)rAA).setRect(0.0, 0.0, 10.0, 10.0);
        ((Rectangle2D)rBB).setRect(100.0, 100.0, 10.0, 10.0);
        System.out.println(StrokeSegmentLib.distance(rAA, rBB));
        System.out.println();
    }

    static class IntersectingPair {
        int xx;
        int yy;

        public IntersectingPair(int newXX, int newYY) {
            this.xx = newXX;
            this.yy = newYY;
        }
    }
}

