/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.stroke;

import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GesturePackage;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import edu.berkeley.guir.lib.noise.NoiseLib;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.stroke.TimedPolygon2D;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class StrokeLib
implements SatinConstants {
    private static final short DOWN = 0;
    private static final short UP = 1;
    private static final short LEFT = 2;
    private static final short RIGHT = 3;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.satin.stroke.StrokeLib");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static double calculateAnglePerDistance(TimedStroke stk) {
        double totalAngle = StrokeLib.calculateTotalAngle(stk);
        double totalLength = StrokeLib.calculateTotalLength(stk);
        return totalAngle / totalLength;
    }

    public static double calculateAspect(TimedStroke stk) {
        Rectangle2D bds = stk.getBounds2D(11);
        double bdsTheta = Math.atan2(bds.getHeight(), bds.getWidth());
        return Math.abs(bdsTheta - 0.7853981633974483);
    }

    public static double calculateBoundsAngle(TimedStroke stk) {
        Rectangle2D bds = stk.getBounds2D(11);
        return Math.atan2(bds.getHeight(), bds.getWidth());
    }

    public static double calculateBoundsSize(TimedStroke stk) {
        Rectangle2D bds = stk.getBounds2D(11);
        return Math.sqrt(bds.getHeight() * bds.getHeight() + bds.getWidth() * bds.getWidth());
    }

    public static double calculateCurviness1(TimedStroke stk) {
        TimedPolygon2D points = stk.getPolygon2D(11);
        double value = 0.0;
        double lowerThreshold = 5.0;
        double upperThreshold = 20.0;
        double lowerThresholdRadians = lowerThreshold / 180.0 * Math.PI;
        double upperThresholdRadians = upperThreshold / 180.0 * Math.PI;
        int i = 2;
        while (i < points.npoints) {
            double dx = points.xpoints[i] - points.xpoints[i - 1];
            double dy2 = points.ypoints[i - 1] - points.ypoints[i - 2];
            double dx2 = points.xpoints[i - 1] - points.xpoints[i - 2];
            double dy = points.ypoints[i] - points.ypoints[i - 1];
            double theta = Math.atan2(dx * dy2 - dx2 * dy, dx * dx2 + dy * dy2);
            double absTheta = Math.abs(theta);
            if (absTheta > lowerThresholdRadians && absTheta < upperThresholdRadians) {
                value += theta;
            }
            ++i;
        }
        return Math.abs(value);
    }

    public static double calculateCurviness2(TimedStroke stk) {
        TimedPolygon2D points = stk.getPolygon2D(11);
        double threshold = 19.0;
        double value = 0.0;
        double thresholdRadians = threshold / 180.0 * Math.PI;
        int i = 2;
        while (i < points.npoints) {
            double dx = points.xpoints[i] - points.xpoints[i - 1];
            double dy2 = points.ypoints[i - 1] - points.ypoints[i - 2];
            double dx2 = points.xpoints[i - 1] - points.xpoints[i - 2];
            double dy = points.ypoints[i] - points.ypoints[i - 1];
            double theta = Math.atan2(dx * dy2 - dx2 * dy, dx * dx2 + dy * dy2);
            if (Math.abs(theta) < thresholdRadians) {
                value += theta;
            }
            ++i;
        }
        return Math.abs(value);
    }

    public static double calculateDensity1(TimedStroke stk) {
        double totalLength = StrokeLib.calculateTotalLength(stk);
        double endsDist = StrokeLib.calculateEndsDistance(stk);
        if (endsDist != 0.0) {
            return totalLength / endsDist;
        }
        return 0.0;
    }

    public static double calculateDensity2(TimedStroke stk) {
        double totalLength = StrokeLib.calculateTotalLength(stk);
        double boundsSize = StrokeLib.calculateBoundsSize(stk);
        return totalLength / boundsSize;
    }

    public static double calculateEndsAngleCosine(TimedStroke stk) {
        TimedPolygon2D p = stk.getPolygon2D(11);
        double value = 0.0;
        double rolloff = 16.0;
        double EPSILON = 1.0E-4;
        if (p.npoints < 3) {
            value = 0.0;
        } else {
            double xn = p.xpoints[p.npoints - 1];
            double x0 = p.xpoints[0];
            double yn = p.ypoints[p.npoints - 1];
            double y0 = p.ypoints[0];
            double hypot = Math.sqrt((xn - x0) * (xn - x0) + (yn - y0) * (yn - y0));
            double factor = hypot * hypot / rolloff;
            if (factor > 1.0) {
                factor = 1.0;
            }
            factor = hypot > EPSILON ? factor / hypot : 0.0;
            value = (xn - x0) * factor;
        }
        return value;
    }

    public static double calculateEndsAngleSine(TimedStroke stk) {
        TimedPolygon2D p = stk.getPolygon2D(11);
        double value = 0.0;
        double rolloff = 16.0;
        double EPSILON = 1.0E-4;
        if (p.npoints < 3) {
            value = 0.0;
        } else {
            double xn = p.xpoints[p.npoints - 1];
            double x0 = p.xpoints[0];
            double yn = p.ypoints[p.npoints - 1];
            double y0 = p.ypoints[0];
            double hypot = Math.sqrt((xn - x0) * (xn - x0) + (yn - y0) * (yn - y0));
            double factor = hypot * hypot / rolloff;
            if (factor > 1.0) {
                factor = 1.0;
            }
            factor = hypot > EPSILON ? factor / hypot : 0.0;
            value = (yn - y0) * factor;
        }
        return value;
    }

    public static double calculateEndsDistance(TimedStroke stk) {
        TimedPolygon2D points = stk.getPolygon2D(11);
        if (points.npoints > 0) {
            double dx = points.xpoints[points.npoints - 1] - points.xpoints[0];
            double dy = points.ypoints[points.npoints - 1] - points.ypoints[0];
            return Math.sqrt(dx * dx + dy * dy);
        }
        return 0.0;
    }

    public static double calculateInitAngleCosine(TimedStroke stk) {
        double y0;
        double y2;
        double x0;
        double x2;
        double hypot;
        TimedPolygon2D p = stk.getPolygon2D(11);
        double value = 0.0;
        value = p.npoints < 3 ? 0.0 : ((hypot = Math.sqrt(((x2 = (double)p.xpoints[2]) - (x0 = (double)p.xpoints[0])) * (x2 - x0) + ((y2 = (double)p.ypoints[2]) - (y0 = (double)p.ypoints[0])) * (y2 - y0))) == 0.0 ? 0.0 : (x2 - x0) / hypot);
        return value;
    }

    public static double calculateInitAngleSine(TimedStroke stk) {
        double y0;
        double y2;
        double x0;
        double x2;
        double hypot;
        TimedPolygon2D p = stk.getPolygon2D(11);
        double value = 0.0;
        value = p.npoints < 3 ? 0.0 : ((hypot = Math.sqrt(((x2 = (double)p.xpoints[2]) - (x0 = (double)p.xpoints[0])) * (x2 - x0) + ((y2 = (double)p.ypoints[2]) - (y0 = (double)p.ypoints[0])) * (y2 - y0))) == 0.0 ? 0.0 : (y2 - y0) / hypot);
        return value;
    }

    public static double calculateLogArea(TimedStroke stk) {
        Rectangle2D bds = stk.getBounds2D(11);
        double boundsLength = Math.sqrt(bds.getWidth() * bds.getWidth() + bds.getHeight() * bds.getHeight());
        return 2.0 * Math.log(boundsLength);
    }

    public static double calculateLogAspect(TimedStroke stk) {
        double RADIANS45 = 0.7853981633974483;
        double ONE_DEGREE = Math.PI / 180;
        Rectangle2D bds = stk.getBounds2D(11);
        double boundsAngle = Math.atan2(bds.getHeight(), bds.getWidth());
        double aspect = Math.abs(boundsAngle - RADIANS45);
        double value = Math.log(aspect != 0.0 ? aspect : ONE_DEGREE);
        return value;
    }

    public static double calculateSharpness(TimedStroke stk) {
        TimedPolygon2D points = stk.getPolygon2D(11);
        double value = 0.0;
        int i = 2;
        while (i < points.npoints) {
            double dx = points.xpoints[i] - points.xpoints[i - 1];
            double dy = points.ypoints[i] - points.ypoints[i - 1];
            double dx2 = points.xpoints[i - 1] - points.xpoints[i - 2];
            double dy2 = points.ypoints[i - 1] - points.ypoints[i - 2];
            double theta = Math.atan2(dx * dy2 - dx2 * dy, dx * dx2 + dy * dy2);
            value += theta * theta;
            ++i;
        }
        return value;
    }

    public static double calculateTotalAbsAngle(TimedStroke stk) {
        TimedPolygon2D points = stk.getPolygon2D(11);
        double value = 0.0;
        int i = 2;
        while (i < points.npoints) {
            double dx = points.xpoints[i] - points.xpoints[i - 1];
            double dy = points.ypoints[i] - points.ypoints[i - 1];
            double dx2 = points.xpoints[i - 1] - points.xpoints[i - 2];
            double dy2 = points.ypoints[i - 1] - points.ypoints[i - 2];
            double theta = Math.atan2(dx * dy2 - dx2 * dy, dx * dx2 + dy * dy2);
            value += Math.abs(theta);
            ++i;
        }
        return value;
    }

    public static double calculateTotalAngle(TimedStroke stk) {
        TimedPolygon2D points = stk.getPolygon2D(11);
        double value = 0.0;
        int i = 2;
        while (i < points.npoints) {
            double dx = points.xpoints[i] - points.xpoints[i - 1];
            double dy = points.ypoints[i] - points.ypoints[i - 1];
            double dx2 = points.xpoints[i - 1] - points.xpoints[i - 2];
            double dy2 = points.ypoints[i - 1] - points.ypoints[i - 2];
            double theta = Math.atan2(dx * dy2 - dx2 * dy, dx * dx2 + dy * dy2);
            value += theta;
            ++i;
        }
        return value;
    }

    public static double calculateTotalLength(TimedStroke stk) {
        TimedPolygon2D points = stk.getPolygon2D(11);
        double value = 0.0;
        int i = 1;
        while (i < points.npoints) {
            double dx = points.xpoints[i] - points.xpoints[i - 1];
            double dy = points.ypoints[i] - points.ypoints[i - 1];
            double magsq = dx * dx + dy * dy;
            value += Math.sqrt(magsq);
            ++i;
        }
        return value;
    }

    public static float[] getCumulativeLengths(Polygon2D poly) {
        float[] lengths = new float[poly.npoints];
        if (poly.npoints == 0) {
            return lengths;
        }
        lengths[0] = 0.0f;
        int i = 1;
        while (i < poly.npoints) {
            lengths[i] = lengths[i - 1] + GeomLib.distance(poly.xpoints[i], poly.ypoints[i], poly.xpoints[i - 1], poly.ypoints[i - 1]);
            ++i;
        }
        return lengths;
    }

    public static float[] getCumulativeXValues(Polygon2D poly) {
        float[] xvals = new float[poly.npoints];
        xvals[0] = poly.xpoints[0];
        int i = 1;
        while (i < poly.npoints) {
            xvals[i] = xvals[i - 1] + poly.xpoints[i];
            ++i;
        }
        return xvals;
    }

    public static float[] getCumulativeYValues(Polygon2D poly) {
        float[] yvals = new float[poly.npoints];
        yvals[0] = poly.ypoints[0];
        int i = 1;
        while (i < poly.npoints) {
            yvals[i] = yvals[i - 1] + poly.ypoints[i];
            ++i;
        }
        return yvals;
    }

    public static Point2D computeApproxDirection(int cdsys, TimedStroke stk) {
        int len = stk.getNumPoints();
        int startpt = Math.max(0, len - 15);
        TimedPolygon2D points = stk.getPolygon2D(cdsys);
        Point2D.Float ptA = new Point2D.Float();
        Point2D.Float ptB = new Point2D.Float();
        Point2D.Float ptDel = new Point2D.Float();
        int i = startpt;
        while (i < len) {
            ((Point2D)ptA).setLocation(points.xpoints[i], points.ypoints[i]);
            int j = i + 1;
            while (j < len) {
                ((Point2D)ptB).setLocation(points.xpoints[j], points.ypoints[j]);
                ((Point2D)ptDel).setLocation(((Point2D)ptDel).getX() + (((Point2D)ptB).getX() - ((Point2D)ptA).getX()), ((Point2D)ptDel).getY() + (((Point2D)ptB).getY() - ((Point2D)ptA).getY()));
                ++j;
            }
            ++i;
        }
        double dist = Math.sqrt(((Point2D)ptDel).getX() * ((Point2D)ptDel).getX() + ((Point2D)ptDel).getY() * ((Point2D)ptDel).getY());
        ((Point2D)ptDel).setLocation(((Point2D)ptDel).getX() / dist, ((Point2D)ptDel).getY() / dist);
        return ptDel;
    }

    public static double computeEndpointDistance(int cdsys, TimedStroke stk) {
        Point2D startPt = stk.getStartPoint2D(cdsys);
        Point2D endPt = stk.getEndPoint2D(cdsys);
        return GeomLib.distance(startPt, endPt);
    }

    public static double computeSpatialDistance(TimedStroke stk1, TimedStroke stk2) {
        return StrokeLib.computeSpatialDistance(1.0, 1.0, stk1, stk2);
    }

    public static double computeSpatialDistance(double relImportanceX, double relImportanceY, TimedStroke stk1, TimedStroke stk2) {
        double spatialDistance;
        Rectangle2D boundsStk1 = stk1.getBounds2D(12);
        Rectangle2D boundsStk2 = stk2.getBounds2D(12);
        if (stk1.shapeIntersects(stk2)) {
            spatialDistance = 0.0;
        } else {
            double dy;
            double dx = boundsStk2.getX() > boundsStk1.getX() ? boundsStk2.getX() - (boundsStk1.getX() + boundsStk1.getWidth()) : boundsStk1.getX() - (boundsStk2.getX() + boundsStk2.getWidth());
            if (dx < 0.0) {
                dx = 0.0;
            }
            if ((dy = boundsStk2.getY() > boundsStk1.getY() ? boundsStk2.getY() - (boundsStk1.getY() + boundsStk1.getHeight()) : boundsStk1.getY() - (boundsStk2.getY() + boundsStk2.getHeight())) < 0.0) {
                dy = 0.0;
            }
            spatialDistance = relImportanceX * dx + relImportanceY * dy;
        }
        return spatialDistance;
    }

    public static double computeTemporalDistance(TimedStroke stk1, TimedStroke stk2) {
        return StrokeLib.computeTemporalDistance(stk1, stk2, 100000.0);
    }

    public static double computeTemporalDistance(TimedStroke stk1, TimedStroke stk2, double maxTimeDistance) {
        double temporalDistance = 0.0;
        temporalDistance = stk1.getEndTime() < stk2.getStartTime() ? (double)(stk2.getStartTime() - stk1.getEndTime()) : (double)(stk1.getStartTime() - stk2.getEndTime());
        if (temporalDistance > maxTimeDistance) {
            temporalDistance = maxTimeDistance;
        }
        return temporalDistance;
    }

    public static double computeDistance(TimedStroke stk1, TimedStroke stk2) {
        return StrokeLib.computeDistance(1.0, 1.0, stk1, stk2);
    }

    public static double computeHandwritingDistance(TimedStroke stk1, TimedStroke stk2) {
        return 5.0 * StrokeLib.computeSpatialDistance(1.0, 4.0, stk1, stk2);
    }

    public static double computeDistance(double relImportanceSpace, double relImportanceTime, TimedStroke stk1, TimedStroke stk2) {
        return relImportanceTime * StrokeLib.computeTemporalDistance(stk1, stk2) + relImportanceSpace * StrokeLib.computeSpatialDistance(stk1, stk2);
    }

    public static TimedStroke getNoisyStroke(float x1, float y1, float x2, float y2, float t, float freq, float amp, int steps) {
        TimedStroke stk = new TimedStroke();
        float step = 1.0f / (float)steps;
        float xmag = amp;
        float ymag = amp;
        stk.addPoint(x1, y1);
        float a = step;
        while (a < 1.0f) {
            float n = (float)NoiseLib.noise1(t);
            t += freq;
            float xx = x1 + a * (x2 - x1) + n * xmag;
            float yy = y1 + a * (y2 - y1) + n * ymag;
            stk.addPoint(xx, yy);
            a += step;
        }
        stk.addPoint(x2, y2);
        return stk;
    }

    private static int interpolate(float[] srcxpts, float[] srcypts, int srci, int srcj, float[] dstxpts, float[] dstypts, int dsti, float maxlen) {
        double dist = Point2D.distance(srcxpts[srci], srcypts[srci], srcxpts[srci + 1], srcypts[srci + 1]);
        if (dist >= (double)maxlen) {
            int split = (int)(dist / (double)maxlen);
            int j = 0;
            while (j < split) {
                float newx = srcxpts[srci] + (float)j / (float)split * (srcxpts[srcj] - srcxpts[srci]);
                float newy = srcypts[srci] + (float)j / (float)split * (srcypts[srcj] - srcypts[srci]);
                dstxpts[dsti] = newx;
                dstypts[dsti] = newy;
                ++dsti;
                ++j;
            }
            return split;
        }
        dstxpts[dsti] = srcxpts[srci];
        dstypts[dsti] = srcypts[srci];
        ++dsti;
        return 1;
    }

    public static TimedStroke noisify(TimedStroke stk, float t, float freq, float amp, float maxlen) {
        double dist;
        Polygon2D poly = stk.getBoundingPoints2D(10);
        float[] xpts = poly.xpoints;
        float[] ypts = poly.ypoints;
        int len = poly.npoints;
        int numsplits = 0;
        if (stk.getNumPoints() <= 1) {
            return new TimedStroke(stk);
        }
        int i = 0;
        while (i < len - 1) {
            dist = Point2D.distance(xpts[i], ypts[i], xpts[i + 1], ypts[i + 1]);
            if (dist >= (double)maxlen) {
                numsplits += (int)(dist / (double)maxlen) - 1;
            }
            ++i;
        }
        if (poly.isClosed() && (dist = Point2D.distance(xpts[len - 1], ypts[len - 1], xpts[0], ypts[0])) >= (double)maxlen) {
            numsplits += (int)(dist / (double)maxlen);
        }
        if (numsplits > 0) {
            float[] newxpts = new float[len + numsplits];
            float[] newypts = new float[len + numsplits];
            int newi = 0;
            int i2 = 0;
            while (i2 < len - 1) {
                newi += StrokeLib.interpolate(xpts, ypts, i2, i2 + 1, newxpts, newypts, newi, maxlen);
                ++i2;
            }
            if (poly.isClosed() && len >= 2) {
                newi += StrokeLib.interpolate(xpts, ypts, len - 1, 0, newxpts, newypts, newi, maxlen);
            }
            xpts = newxpts;
            ypts = newypts;
            len = xpts.length;
        }
        int i3 = 0;
        while (i3 < len) {
            float n = (float)NoiseLib.noise1(t);
            t += freq;
            int n2 = i3;
            xpts[n2] = xpts[n2] + n * amp;
            int n3 = i3++;
            ypts[n3] = ypts[n3] + n * amp;
        }
        poly = new Polygon2D(xpts, ypts, len);
        TimedStroke newstk = new TimedStroke(poly);
        newstk.setHasClosedBoundingPoints(stk.hasClosedBoundingPoints());
        return newstk;
    }

    public static Gesture convertStrokeToQuillGesture(TimedStroke stk) {
        TimedPolygon2D polyOrig = stk.getPolygon2D(10);
        int len = polyOrig.npoints;
        int[] newXpoints = new int[len];
        int[] newYpoints = new int[len];
        long[] newTimes = new long[len];
        int i = 0;
        while (i < len) {
            newXpoints[i] = (int)polyOrig.xpoints[i];
            newYpoints[i] = (int)polyOrig.ypoints[i];
            newTimes[i] = polyOrig.times[i];
            ++i;
        }
        TimedPolygon polyNew = new TimedPolygon(newXpoints, newYpoints, newTimes, len);
        Gesture gNew = new Gesture();
        gNew.setPoints(polyNew);
        return gNew;
    }

    private static short calcGeneralDirection(float x1, float y1, float x2, float y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        if (Math.abs(dx) >= Math.abs(dy)) {
            if (dx >= 0.0f) {
                return 3;
            }
            return 2;
        }
        if (dy >= 0.0f) {
            return 0;
        }
        return 1;
    }

    private static Line2D linearize(Polygon2D poly, int start, int end, short direction) {
        float minY = poly.ypoints[start];
        float maxY = poly.ypoints[start];
        float sumY = 0.0f;
        float avgY = 0.0f;
        float minX = poly.xpoints[start];
        float maxX = poly.xpoints[start];
        float sumX = 0.0f;
        float avgX = 0.0f;
        int i = start;
        while (i < end) {
            sumX += poly.xpoints[i];
            sumY += poly.ypoints[i];
            if (poly.ypoints[i] < minY) {
                minY = poly.ypoints[i];
            } else if (poly.ypoints[i] > maxY) {
                maxY = poly.ypoints[i];
            }
            if (poly.xpoints[i] < minX) {
                minX = poly.xpoints[i];
            } else if (poly.xpoints[i] > maxX) {
                maxX = poly.xpoints[i];
            }
            ++i;
        }
        avgX = sumX / (float)(end - start);
        avgY = sumY / (float)(end - start);
        Line2D.Float line = new Line2D.Float();
        switch (direction) {
            case 1: {
                ((Line2D)line).setLine(avgX, maxY, avgX, minY);
                break;
            }
            case 0: {
                ((Line2D)line).setLine(avgX, minY, avgX, maxY);
                break;
            }
            case 2: {
                ((Line2D)line).setLine(maxX, avgY, minX, avgY);
                break;
            }
            case 3: {
                ((Line2D)line).setLine(minX, avgY, maxX, avgY);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return line;
    }

    private static TimedStroke linesToStroke_1(LinkedList listLines) {
        TimedStroke linearStk = new TimedStroke();
        Iterator it = listLines.iterator();
        float lastx = 0.0f;
        float lasty = 0.0f;
        while (it.hasNext()) {
            Line2D line = (Line2D)it.next();
            float x1 = (float)line.getX1();
            float y1 = (float)line.getY1();
            float x2 = (float)line.getX2();
            float y2 = (float)line.getY2();
            if (linearStk.getNumPoints() <= 0) {
                linearStk.addPoint(x1, y1);
                linearStk.addPoint(x2, y2);
            } else if ((double)Math.abs(x1 - x2) < 0.001) {
                x2 = lastx;
                linearStk.addPoint(x2, y2);
            } else {
                y2 = lasty;
                linearStk.addPoint(x2, y2);
            }
            lastx = x2;
            lasty = y2;
        }
        return linearStk;
    }

    private static short calcGeneralDirection(short[] directions, int start, int end) {
        int[] dircounts = new int[4];
        int i = start;
        while (i < end) {
            short s = directions[i];
            dircounts[s] = dircounts[s] + 1;
            ++i;
        }
        int index = 0;
        int max = 0;
        int i2 = 0;
        while (i2 < dircounts.length) {
            if (dircounts[i2] >= max) {
                index = i2;
                max = dircounts[i2];
            }
            i2 = (short)(i2 + 1);
        }
        return (short)index;
    }

    private static void filterDirections(short[] directions) {
        int len = directions.length;
        if (len > 4) {
            directions[0] = StrokeLib.calcGeneralDirection(directions, 0, 4);
            directions[len - 1] = StrokeLib.calcGeneralDirection(directions, len - 4, len);
        }
    }

    public static TimedStroke linearize(TimedStroke stk) {
        TimedStroke linearStk = null;
        Polygon2D poly = stk.getBoundingPoints2D(10);
        short[] directions = new short[poly.npoints - 1];
        int i = 0;
        while (i < poly.npoints - 1) {
            directions[i] = StrokeLib.calcGeneralDirection(poly.xpoints[i], poly.ypoints[i], poly.xpoints[i + 1], poly.ypoints[i + 1]);
            ++i;
        }
        StrokeLib.filterDirections(directions);
        LinkedList<Line2D> listLines = new LinkedList<Line2D>();
        short curdir = directions[0];
        int start = 0;
        int i2 = 1;
        while (i2 < directions.length) {
            if (curdir != directions[i2]) {
                Line2D line = StrokeLib.linearize(poly, start, i2, curdir);
                listLines.add(line);
                curdir = directions[i2];
                start = i2;
            }
            ++i2;
        }
        if (start < poly.npoints) {
            Line2D line = StrokeLib.linearize(poly, start, poly.npoints, curdir);
            listLines.add(line);
        }
        linearStk = StrokeLib.linesToStroke_1(listLines);
        linearStk.setTransform(stk.getTransform(11));
        linearStk.setStyle(stk.getStyle());
        return linearStk;
    }

    public static void straighten(TimedStroke stk) {
        int numPoints = stk.getNumPoints();
        if (numPoints > 2) {
            float firstX = stk.poly.xpoints[0];
            float firstY = stk.poly.ypoints[0];
            long firstTime = stk.poly.times[0];
            float lastX = stk.poly.xpoints[numPoints - 1];
            float lastY = stk.poly.ypoints[numPoints - 1];
            long lastTime = stk.poly.times[numPoints - 1];
            stk.clearPoints();
            stk.addPoint(firstX, firstY, firstTime);
            stk.addPoint(lastX, lastY, lastTime);
        }
    }

    private static void hideCenterLengths(float[] cumlengths, float perc) {
        if (cumlengths.length <= 0) {
            return;
        }
        float len = cumlengths[cumlengths.length - 1];
        float startThresh = perc * len;
        float endThresh = len - startThresh;
        int i = 0;
        while (i < cumlengths.length) {
            if (!(cumlengths[i] < startThresh) && !(cumlengths[i] > endThresh)) {
                cumlengths[i] = -1.0f;
            }
            ++i;
        }
    }

    public static TimedStroke mergeStrokes(TimedStroke stkAA, TimedStroke stkBB) {
        Polygon2D pAA = stkAA.getBoundingPoints2D(12);
        Polygon2D pBB = stkBB.getBoundingPoints2D(12);
        float[] lenAA = StrokeLib.getCumulativeLengths(pAA);
        float[] lenBB = StrokeLib.getCumulativeLengths(pBB);
        StrokeLib.hideCenterLengths(lenAA, 0.333f);
        StrokeLib.hideCenterLengths(lenBB, 0.333f);
        float[] mindists = new float[pAA.npoints];
        int[] indices = new int[pAA.npoints];
        int i = 0;
        while (i < pAA.npoints) {
            if (!(lenAA[i] < 0.0f)) {
                double mindist = Double.MAX_VALUE;
                int index = -1;
                int j = 0;
                while (j < pBB.npoints) {
                    double dist;
                    if (!(lenBB[j] < 0.0f) && (dist = (double)GeomLib.distance(pAA.xpoints[i], pAA.ypoints[i], pBB.xpoints[j], pBB.ypoints[j])) < mindist) {
                        mindist = (float)dist;
                        index = j;
                    }
                    ++j;
                }
                if (index >= 0) {
                    mindists[i] = (float)mindist;
                    indices[i] = index;
                }
            }
            ++i;
        }
        int indexAAFront = 0;
        int indexBBFront = 0;
        float mindistFront = Float.MAX_VALUE;
        int i2 = 0;
        while (i2 < pAA.npoints) {
            if (lenAA[i2] < 0.0f) break;
            if (mindists[i2] < mindistFront) {
                mindistFront = mindists[i2];
                indexAAFront = i2;
                indexBBFront = indices[i2];
            }
            ++i2;
        }
        int indexAABack = pAA.npoints - 1;
        int indexBBBack = pBB.npoints - 1;
        float mindistBack = Float.MAX_VALUE;
        int i3 = pAA.npoints - 1;
        while (i3 >= 0) {
            if (lenAA[i3] < 0.0f) break;
            if (mindists[i3] < mindistBack) {
                mindistBack = mindists[i3];
                indexAABack = i3;
                indexBBBack = indices[i3];
            }
            --i3;
        }
        if (mindistFront > 10.0f && mindistBack > 10.0f) {
            return null;
        }
        boolean flagFrontConnected = true;
        if (mindistFront > 10.0f) {
            flagFrontConnected = false;
            indexAAFront = 0;
        }
        boolean flagBackConnected = true;
        if (mindistBack > 10.0f) {
            flagBackConnected = false;
            indexAABack = pAA.npoints - 1;
        }
        TimedStroke stk = new TimedStroke();
        if (flagFrontConnected && flagBackConnected) {
            int i4 = indexAAFront;
            while (i4 < indexAABack) {
                stk.addPoint(pAA.xpoints[i4], pAA.ypoints[i4]);
                ++i4;
            }
            if (indexBBFront < indexBBBack) {
                i4 = indexBBBack;
                while (i4 >= indexBBFront) {
                    stk.addPoint(pBB.xpoints[i4], pBB.ypoints[i4]);
                    --i4;
                }
            } else {
                i4 = indexBBBack;
                while (i4 < indexBBFront) {
                    stk.addPoint(pBB.xpoints[i4], pBB.ypoints[i4]);
                    ++i4;
                }
            }
        } else if (flagFrontConnected) {
            int i5 = indexAABack;
            while (i5 >= indexAAFront) {
                stk.addPoint(pAA.xpoints[i5], pAA.ypoints[i5]);
                --i5;
            }
            if (lenBB[indexBBFront] < lenBB[pBB.npoints - 1] - lenBB[indexBBFront]) {
                i5 = indexBBFront;
                while (i5 < pBB.npoints) {
                    stk.addPoint(pBB.xpoints[i5], pBB.ypoints[i5]);
                    ++i5;
                }
            } else {
                i5 = indexBBFront;
                while (i5 >= 0) {
                    stk.addPoint(pBB.xpoints[i5], pBB.ypoints[i5]);
                    --i5;
                }
            }
        } else if (flagBackConnected) {
            int i6 = indexAAFront;
            while (i6 < indexAABack) {
                stk.addPoint(pAA.xpoints[i6], pAA.ypoints[i6]);
                ++i6;
            }
            if (lenBB[indexBBBack] < lenBB[pBB.npoints - 1] - lenBB[indexBBBack]) {
                i6 = indexBBBack;
                while (i6 < pBB.npoints) {
                    stk.addPoint(pBB.xpoints[i6], pBB.ypoints[i6]);
                    ++i6;
                }
            } else {
                i6 = indexBBBack;
                while (i6 >= 0) {
                    stk.addPoint(pBB.xpoints[i6], pBB.ypoints[i6]);
                    --i6;
                }
            }
        } else {
            return null;
        }
        return stk;
    }

    public static List splitStroke(TimedStroke stk, Rectangle2D rect) {
        Polygon2D p = stk.getBoundingPoints2D(12);
        Line2D.Double pSeg = new Line2D.Double();
        LinkedList<TimedStroke> list = new LinkedList<TimedStroke>();
        TimedStroke newstk = null;
        int i = 0;
        while (i < p.npoints - 1) {
            double x1 = p.xpoints[i];
            double y1 = p.ypoints[i];
            double x2 = p.xpoints[i + 1];
            double y2 = p.ypoints[i + 1];
            ((Line2D)pSeg).setLine(x1, y1, x2, y2);
            if (pSeg.intersects(rect)) {
                List ptlist = GeomLib.calcIntersectPoints(pSeg, rect);
                Iterator it = ptlist.iterator();
                Point2D p1 = null;
                Point2D p2 = null;
                if (it.hasNext()) {
                    p1 = (Point2D)it.next();
                }
                if (it.hasNext()) {
                    p2 = (Point2D)it.next();
                }
                if (!rect.contains(x1, y1) && rect.contains(x2, y2)) {
                    if (newstk == null) {
                        newstk = new TimedStroke();
                        list.add(newstk);
                    }
                    newstk.addPoint(x1, y1);
                    newstk.addPoint(p1);
                    newstk = null;
                } else if (rect.contains(x1, y1) && !rect.contains(x2, y2)) {
                    if (newstk == null) {
                        newstk = new TimedStroke();
                        list.add(newstk);
                    }
                    newstk.addPoint(p1);
                    newstk.addPoint(x2, y2);
                } else if (!rect.contains(x1, y1) && !rect.contains(x2, y2)) {
                    if (newstk == null) {
                        newstk = new TimedStroke();
                        list.add(newstk);
                    }
                    newstk.addPoint(x1, y1);
                    if (p2 != null && GeomLib.distance(x1, y1, p1.getX(), p1.getY()) > GeomLib.distance(x1, y1, p2.getX(), p2.getY())) {
                        Point2D ptmp = p1;
                        p1 = p2;
                        p2 = ptmp;
                    }
                    newstk.addPoint(p1);
                    newstk = new TimedStroke();
                    list.add(newstk);
                    if (p2 != null) {
                        newstk.addPoint(p2);
                    }
                    newstk.addPoint(x2, y2);
                }
            } else {
                if (newstk == null) {
                    newstk = new TimedStroke();
                    list.add(newstk);
                }
                newstk.addPoint(x1, y1);
            }
            ++i;
        }
        if (newstk != null) {
            newstk.addPoint(p.xpoints[p.npoints - 1], p.ypoints[p.npoints - 1]);
        }
        return list;
    }

    public static boolean isTap(TimedStroke stk) {
        Rectangle2D absBds = stk.getParentGroup() == null ? stk.getBounds2D(10) : stk.getBounds2D(12);
        return absBds.getWidth() <= 6.0 && absBds.getHeight() <= 6.0;
    }

    public static TimedStroke getTestInstanceStrokeAA() {
        TimedStroke stk = new TimedStroke();
        stk.addPoint(0, 55);
        stk.addPoint(11, 40);
        stk.addPoint(20, 25);
        stk.addPoint(24, 18);
        stk.addPoint(28, 9);
        stk.addPoint(29, 4);
        stk.addPoint(29, 7);
        stk.addPoint(30, 12);
        stk.addPoint(32, 19);
        stk.addPoint(34, 31);
        stk.addPoint(38, 44);
        stk.addPoint(43, 57);
        stk.addPoint(48, 65);
        stk.addPoint(51, 68);
        stk.addPoint(53, 69);
        stk.addPoint(54, 68);
        stk.addPoint(56, 64);
        stk.addPoint(58, 58);
        stk.addPoint(60, 47);
        stk.addPoint(63, 14);
        stk.addPoint(64, 11);
        stk.addPoint(65, 15);
        stk.addPoint(66, 22);
        stk.addPoint(68, 32);
        stk.addPoint(71, 43);
        stk.addPoint(73, 53);
        stk.addPoint(76, 59);
        stk.addPoint(78, 62);
        stk.addPoint(79, 61);
        stk.addPoint(80, 58);
        stk.addPoint(82, 54);
        stk.addPoint(83, 46);
        stk.addPoint(88, 17);
        stk.addPoint(89, 5);
        stk.addPoint(90, 0);
        stk.addPoint(92, 3);
        stk.addPoint(93, 8);
        stk.addPoint(96, 16);
        stk.addPoint(98, 26);
        stk.addPoint(103, 36);
        stk.addPoint(107, 45);
        stk.addPoint(113, 53);
        stk.addPoint(115, 54);
        return stk;
    }

    public static TimedStroke getTestInstanceStrokeBB() {
        TimedStroke stk = new TimedStroke();
        stk.addPoint(4, 12);
        stk.addPoint(5, 40);
        stk.addPoint(3, 68);
        stk.addPoint(1, 88);
        stk.addPoint(1, 104);
        stk.addPoint(2, 115);
        stk.addPoint(6, 117);
        stk.addPoint(25, 114);
        stk.addPoint(56, 106);
        stk.addPoint(77, 101);
        stk.addPoint(96, 99);
        stk.addPoint(109, 99);
        stk.addPoint(111, 89);
        stk.addPoint(109, 67);
        stk.addPoint(114, 43);
        stk.addPoint(117, 26);
        stk.addPoint(118, 16);
        stk.addPoint(115, 6);
        stk.addPoint(108, 1);
        stk.addPoint(99, 0);
        stk.addPoint(67, 4);
        stk.addPoint(34, 11);
        stk.addPoint(13, 17);
        stk.addPoint(3, 20);
        stk.addPoint(0, 23);
        return stk;
    }

    public static TimedStroke getTestInstanceStrokeCC() {
        TimedStroke stk = new TimedStroke();
        stk.addPoint(0, 0);
        stk.addPoint(4, 13);
        stk.addPoint(6, 26);
        stk.addPoint(9, 39);
        stk.addPoint(14, 48);
        stk.addPoint(18, 50);
        stk.addPoint(24, 45);
        stk.addPoint(34, 34);
        stk.addPoint(40, 22);
        stk.addPoint(44, 14);
        stk.addPoint(46, 10);
        stk.addPoint(46, 13);
        stk.addPoint(47, 18);
        stk.addPoint(48, 26);
        stk.addPoint(49, 33);
        stk.addPoint(50, 41);
        stk.addPoint(51, 46);
        stk.addPoint(52, 48);
        stk.addPoint(54, 47);
        stk.addPoint(57, 42);
        stk.addPoint(62, 34);
        stk.addPoint(68, 24);
        stk.addPoint(76, 11);
        stk.addPoint(76, 14);
        stk.addPoint(76, 23);
        stk.addPoint(76, 31);
        stk.addPoint(79, 46);
        stk.addPoint(81, 46);
        stk.addPoint(83, 42);
        stk.addPoint(88, 34);
        stk.addPoint(93, 25);
        stk.addPoint(98, 17);
        stk.addPoint(101, 10);
        stk.addPoint(104, 3);
        stk.addPoint(104, 5);
        stk.addPoint(104, 9);
        stk.addPoint(104, 17);
        stk.addPoint(105, 26);
        stk.addPoint(106, 34);
        stk.addPoint(108, 40);
        stk.addPoint(110, 44);
        stk.addPoint(112, 47);
        stk.addPoint(113, 46);
        return stk;
    }

    public static TimedStroke getTestInstanceStrokeDD() {
        TimedStroke stk = new TimedStroke();
        stk.addPoint(0, 0);
        stk.addPoint(0, 10);
        stk.addPoint(10, 10);
        stk.addPoint(10, 0);
        return stk;
    }

    public static void main(String[] argv) throws Exception {
        TimedStroke stkAA = StrokeLib.getTestInstanceStrokeAA();
        TimedStroke stkBB = StrokeLib.getTestInstanceStrokeBB();
        TimedStroke stkCC = StrokeLib.getTestInstanceStrokeCC();
        TimedStroke stkDD = StrokeLib.getTestInstanceStrokeDD();
        Gesture gAA = StrokeLib.convertStrokeToQuillGesture(stkAA);
        Gesture gBB = StrokeLib.convertStrokeToQuillGesture(stkBB);
        Gesture gCC = StrokeLib.convertStrokeToQuillGesture(stkCC);
        Gesture gDD = StrokeLib.convertStrokeToQuillGesture(stkDD);
        GestureCategory gCatAA = new GestureCategory();
        GestureCategory gCatBB = new GestureCategory();
        GestureCategory gCatCC = new GestureCategory();
        gCatAA.addGesture(gAA);
        gCatBB.addGesture(gBB);
        gCatCC.addGesture(gCC);
        gCatCC.addGesture(gDD);
        LinkedList<GestureCategory> listCategories = new LinkedList<GestureCategory>();
        listCategories.add(gCatAA);
        listCategories.add(gCatBB);
        listCategories.add(gCatCC);
        GestureSet gTrainingSet = new GestureSet(listCategories);
        GesturePackage gPack = new GesturePackage(gTrainingSet);
        FileWriter fwtr = new FileWriter("out.gsa");
        gPack.write(fwtr);
        fwtr.close();
    }
}

