/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.stroke;

import edu.berkeley.guir.lib.awt.EventUtil;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.event.BasicStrokeEventFilter;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.stroke.StrokeLib;
import edu.berkeley.guir.lib.satin.stroke.TimedCurvyStroke;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import edu.berkeley.guir.lib.satin.watch.Watchable;
import edu.berkeley.guir.lib.satin.watch.Watcher;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class StrokeAssembler
implements SatinConstants,
Serializable,
Cloneable,
MouseListener,
MouseMotionListener,
Watcher {
    private static final int TOP = 20;
    private static final int BOTTOM = 21;
    private static final int LEFT = 22;
    private static final int RIGHT = 23;
    private static final int TOP_RIGHT = 24;
    private static final int TOP_LEFT = 25;
    private static final int BOTTOM_RIGHT = 26;
    private static final int BOTTOM_LEFT = 27;
    private static final int RIGHT_TOLERANCE = 3;
    private static final int DEFAULT_SCROLL_THRESH_X = 30;
    private static final int DEFAULT_SCROLL_THRESH_Y = 30;
    private static final int DEFAULT_SCROLL_DELAY = 10;
    private static final int DEFAULT_INITIAL_SCROLL_DELAY_COUNT = 20;
    private static final long DEFAULT_MIN_TIME_BETWEEN_RELEASE = 85L;
    private long startTime = 0L;
    private StringBuffer intervalBuf = new StringBuffer(1000);
    private boolean flagScrolling;
    private boolean flagEnabled;
    private int oldX;
    private int oldY;
    private int oldButtonType;
    private boolean isLocked = false;
    private TimedCurvyStroke currentCurvyStroke;
    private TimedStroke currentStroke;
    private Sheet parent;
    private BasicStrokeEventFilter filter;
    private long lastReleaseTime = 0L;
    private boolean flagRenderCurvy = true;
    private float angleTolerance = 70.0f;
    private int windowSize = 5;
    private float cornerDegree = 70.0f;
    Vector dispatchingPath = new Vector();
    AffineTransform parentTx;
    AffineTransform inverseTx;
    boolean flagAutoScrollingEnabled = true;
    boolean flagUseDefaultScrollThreshX;
    boolean flagUseDefaultScrollThreshY;
    int delayCount = 0;
    Rectangle rect = new Rectangle();
    AffineTransform scrollTx = new AffineTransform();
    int scrollThreshX = 0;
    int scrollThreshY = 0;
    MouseEvent repeatEvent;
    MouseEvent ignoreEvent;
    EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();

    public StrokeAssembler(Sheet parent) {
        this.parent = parent;
        this.flagEnabled = true;
        parent.addMouseListener(this);
        parent.addMouseMotionListener(this);
        parent.addWatcher(this);
        this.parentTx = new AffineTransform();
        this.inverseTx = new AffineTransform();
        this.filter = new BasicStrokeEventFilter();
    }

    public void setEnabled(boolean flag) {
        this.flagEnabled = flag;
    }

    public boolean isEnabled() {
        return this.flagEnabled;
    }

    public boolean isLeftButtonAccepted() {
        return this.filter.isLeftButtonAccepted();
    }

    public boolean isMiddleButtonAccepted() {
        return this.filter.isMiddleButtonAccepted();
    }

    public boolean isRightButtonAccepted() {
        return this.filter.isRightButtonAccepted();
    }

    public void setAcceptLeftButton(boolean flag) {
        this.filter.setAcceptLeftButton(flag);
    }

    public void setAcceptMiddleButton(boolean flag) {
        this.filter.setAcceptMiddleButton(flag);
    }

    public void setAcceptRightButton(boolean flag) {
        this.filter.setAcceptRightButton(flag);
    }

    public void setAutoScroll(boolean flag) {
        this.flagAutoScrollingEnabled = flag;
    }

    public boolean getRenderCurvy() {
        return this.flagRenderCurvy;
    }

    public void setRenderCurvy(boolean flag) {
        this.flagRenderCurvy = flag;
    }

    private AffineTransform getInverseTransform() {
        if (!this.parentTx.equals(this.parent.getTransformRef())) {
            this.parentTx = this.parent.getTransform(11);
            this.inverseTx = this.parent.getInverseTransform(11);
        }
        return this.inverseTx;
    }

    private void initScroll(TimedStroke stk) {
        this.parent.getBounds(this.rect);
        int dTop = this.oldY - this.rect.y;
        int dBottom = this.rect.y + this.rect.height - this.oldY;
        int dLeft = this.oldX - this.rect.x;
        int dRight = this.rect.x + this.rect.width - this.oldX;
        this.flagUseDefaultScrollThreshX = dLeft >= 30 && dRight >= 30;
        this.flagUseDefaultScrollThreshY = dTop >= 30 && dBottom >= 30;
    }

    private boolean shouldScroll(TimedStroke stk) {
        return false;
    }

    private void getScrollDirection(TimedStroke stk) {
    }

    private float distSquared(MouseEvent evtAA, MouseEvent evtBB) {
        if (evtAA == null || evtBB == null) {
            return 0.0f;
        }
        float dx = evtAA.getX() - evtBB.getX();
        float dy = evtAA.getY() - evtBB.getY();
        return dx * dx + dy * dy;
    }

    private final boolean acceptMouseEvent(MouseEvent evt) {
        if (evt.isConsumed()) {
            return false;
        }
        if (this.filter.isLeftButtonAccepted() && SwingUtilities.isLeftMouseButton(evt)) {
            return true;
        }
        if (this.filter.isMiddleButtonAccepted() && SwingUtilities.isMiddleMouseButton(evt)) {
            return true;
        }
        if (this.filter.isRightButtonAccepted() && SwingUtilities.isRightMouseButton(evt)) {
            return true;
        }
        return System.getProperty("os.name").equals("Mac OS X") && this.filter.isRightButtonAccepted() && SwingUtilities.isLeftMouseButton(evt) && evt.isControlDown();
    }

    private void setButtonInStroke(TimedStroke stk, MouseEvent evt) {
        if (System.getProperty("os.name").equals("Mac OS X")) {
            if (this.filter.isRightButtonAccepted() && SwingUtilities.isLeftMouseButton(evt) && evt.isControlDown()) {
                stk.setRightButton(true);
            } else if (this.filter.isLeftButtonAccepted() && SwingUtilities.isLeftMouseButton(evt)) {
                stk.setLeftButton(true);
            }
        } else {
            if (this.filter.isLeftButtonAccepted() && SwingUtilities.isLeftMouseButton(evt)) {
                stk.setLeftButton(true);
            }
            if (this.filter.isMiddleButtonAccepted() && SwingUtilities.isMiddleMouseButton(evt)) {
                stk.setMiddleButton(true);
            }
            if (this.filter.isRightButtonAccepted() && SwingUtilities.isRightMouseButton(evt)) {
                stk.setRightButton(true);
            }
        }
    }

    public final void mouseClicked(MouseEvent evt) {
    }

    public final void mouseEntered(MouseEvent evt) {
    }

    public final void mouseExited(MouseEvent evt) {
    }

    public final void mouseMoved(MouseEvent evt) {
        if (this.isLocked && System.getProperty("os.name").equals("Mac OS X")) {
            this.fickMouseDragged(evt);
        }
    }

    public final void mousePressed(MouseEvent evt) {
        this.parent.setRenderToScreen(true);
        if (this.isLocked) {
            MouseEvent releaseEvt = new MouseEvent((Component)evt.getSource(), 502, evt.getWhen(), evt.getModifiers(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger(), this.oldButtonType);
            this.mouseReleased(releaseEvt);
            this.isLocked = false;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.acceptMouseEvent(evt)) {
            return;
        }
        this.flagScrolling = false;
        if (this.flagRenderCurvy) {
            this.currentCurvyStroke = new TimedCurvyStroke();
            this.currentCurvyStroke.setThreshhold(this.angleTolerance);
            this.currentCurvyStroke.setFilterSize(this.windowSize);
            this.currentCurvyStroke.setCornerThreshhold(this.cornerDegree);
        } else {
            this.currentStroke = new TimedStroke();
        }
        this.oldX = evt.getX();
        this.oldY = evt.getY();
        EventUtil.applyTransform(evt, this.getInverseTransform());
        if (this.flagRenderCurvy) {
            this.currentCurvyStroke.addPoint(evt.getX(), evt.getY());
        } else {
            this.currentStroke.addPoint(evt.getX(), evt.getY());
        }
        if (this.flagRenderCurvy) {
            this.setButtonInStroke(this.currentCurvyStroke, evt);
        } else {
            this.setButtonInStroke(this.currentStroke, evt);
        }
        NewStrokeEvent stkevt = this.flagRenderCurvy ? new NewStrokeEvent(this.parent, this.currentCurvyStroke) : new NewStrokeEvent(this.parent, this.currentStroke);
        this.oldButtonType = stkevt.isLeftButton() ? 1 : (stkevt.isMiddleButton() ? 2 : 3);
        this.isLocked = true;
        stkevt.setMouseEvent(evt);
        this.dispatchingPath.clear();
        stkevt.setDispatchingCache(this.dispatchingPath);
        this.parent.onNewStroke(stkevt);
        EventUtil.setPosition(evt, this.oldX, this.oldY);
        if (this.flagRenderCurvy) {
            this.initScroll(this.currentCurvyStroke);
        } else {
            this.initScroll(this.currentStroke);
        }
    }

    public final void fickMouseDragged(MouseEvent moveEvt) {
        AWTEvent e1;
        MouseEvent evt = new MouseEvent((Component)moveEvt.getSource(), 506, moveEvt.getWhen(), moveEvt.getModifiers(), moveEvt.getX(), moveEvt.getY(), moveEvt.getClickCount(), moveEvt.isPopupTrigger(), this.oldButtonType);
        if (this.repeatEvent != evt) {
            if (!this.flagScrolling) {
                this.ignoreEvent = this.repeatEvent;
                this.delayCount = 0;
            } else if (this.distSquared(evt, this.repeatEvent) > 50.0f) {
                this.flagScrolling = false;
                this.ignoreEvent = this.repeatEvent;
                this.delayCount = 0;
            } else if (this.repeatEvent != null) {
                this.repeatEvent = evt;
                this.delayCount = 20;
            }
        }
        this.oldX = evt.getX();
        this.oldY = evt.getY();
        EventUtil.applyTransform(evt, this.getInverseTransform());
        if (this.flagRenderCurvy) {
            this.currentCurvyStroke.addPoint(evt.getX(), evt.getY());
        } else {
            this.currentStroke.addPoint(evt.getX(), evt.getY());
        }
        boolean flagApply = false;
        if (this.flagAutoScrollingEnabled) {
            this.parent.getBounds(this.rect);
            this.rect.x = 0;
            this.rect.y = 0;
            int dTop = this.oldY - this.rect.y;
            int dBottom = this.rect.y + this.rect.height - this.oldY;
            int dLeft = this.oldX - this.rect.x;
            int dRight = this.rect.x + this.rect.width - this.oldX;
            this.scrollThreshX = this.flagUseDefaultScrollThreshX ? 30 : 0;
            this.scrollThreshY = this.flagUseDefaultScrollThreshY ? 30 : 0;
            this.scrollThreshX = 0;
            this.scrollThreshY = 0;
            if ((this.flagUseDefaultScrollThreshX || this.flagUseDefaultScrollThreshY) && (dLeft <= this.scrollThreshX || dRight <= this.scrollThreshX + 3 || dTop <= this.scrollThreshY || dBottom <= this.scrollThreshY)) {
                flagApply = true;
            }
            if (flagApply && this.delayCount >= 20) {
                Point2D ptDir = this.flagRenderCurvy ? StrokeLib.computeApproxDirection(11, this.currentCurvyStroke) : StrokeLib.computeApproxDirection(11, this.currentStroke);
                this.scrollTx.setToIdentity();
                this.scrollTx.translate(-ptDir.getX() * 30.0, -ptDir.getY() * 30.0);
                this.parent.applyTransform(this.scrollTx);
            }
        }
        if (this.flagRenderCurvy) {
            this.setButtonInStroke(this.currentCurvyStroke, evt);
        } else {
            this.setButtonInStroke(this.currentStroke, evt);
        }
        UpdateStrokeEvent stkevt = this.flagRenderCurvy ? new UpdateStrokeEvent(this.parent, this.currentCurvyStroke) : new UpdateStrokeEvent(this.parent, this.currentStroke);
        stkevt.setMouseEvent(evt);
        stkevt.setDispatchingCache(this.dispatchingPath);
        if (this.isLocked && evt.getButton() != this.oldButtonType) {
            stkevt.getStroke().setLeftButton(false);
            stkevt.getStroke().setMiddleButton(false);
            stkevt.getStroke().setRightButton(false);
            switch (this.oldButtonType) {
                case 1: {
                    stkevt.getStroke().setLeftButton(true);
                    break;
                }
                case 2: {
                    stkevt.getStroke().setMiddleButton(true);
                    break;
                }
                case 3: {
                    stkevt.getStroke().setRightButton(true);
                }
            }
        }
        this.parent.onUpdateStroke(stkevt);
        EventUtil.setPosition(evt, this.oldX, this.oldY);
        if (flagApply && (e1 = this.queue.peekEvent(502)) == null) {
            try {
                Thread.sleep(10L);
                ++this.delayCount;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.repeatEvent = evt;
            this.queue.postEvent(evt);
            this.flagScrolling = true;
        }
    }

    public final void mouseDragged(MouseEvent evt) {
        AWTEvent e1;
        if (!this.isEnabled()) {
            return;
        }
        if (this.flagRenderCurvy ? this.currentCurvyStroke == null : this.currentStroke == null) {
            return;
        }
        if (!this.acceptMouseEvent(evt)) {
            return;
        }
        if (evt == this.ignoreEvent) {
            return;
        }
        if (this.repeatEvent != evt) {
            if (!this.flagScrolling) {
                this.ignoreEvent = this.repeatEvent;
                this.delayCount = 0;
            } else if (this.distSquared(evt, this.repeatEvent) > 50.0f) {
                this.flagScrolling = false;
                this.ignoreEvent = this.repeatEvent;
                this.delayCount = 0;
            } else if (this.repeatEvent != null) {
                this.repeatEvent = evt;
                this.delayCount = 20;
            }
        }
        this.oldX = evt.getX();
        this.oldY = evt.getY();
        EventUtil.applyTransform(evt, this.getInverseTransform());
        if (this.flagRenderCurvy) {
            this.currentCurvyStroke.addPoint(evt.getX(), evt.getY());
        } else {
            this.currentStroke.addPoint(evt.getX(), evt.getY());
        }
        boolean flagApply = false;
        if (this.flagAutoScrollingEnabled) {
            this.parent.getBounds(this.rect);
            this.rect.x = 0;
            this.rect.y = 0;
            int dTop = this.oldY - this.rect.y;
            int dBottom = this.rect.y + this.rect.height - this.oldY;
            int dLeft = this.oldX - this.rect.x;
            int dRight = this.rect.x + this.rect.width - this.oldX;
            this.scrollThreshX = this.flagUseDefaultScrollThreshX ? 30 : 0;
            this.scrollThreshY = this.flagUseDefaultScrollThreshY ? 30 : 0;
            this.scrollThreshX = 0;
            this.scrollThreshY = 0;
            if ((this.flagUseDefaultScrollThreshX || this.flagUseDefaultScrollThreshY) && (dLeft <= this.scrollThreshX || dRight <= this.scrollThreshX + 3 || dTop <= this.scrollThreshY || dBottom <= this.scrollThreshY)) {
                flagApply = true;
            }
            if (flagApply && this.delayCount >= 20) {
                Point2D ptDir = this.flagRenderCurvy ? StrokeLib.computeApproxDirection(11, this.currentCurvyStroke) : StrokeLib.computeApproxDirection(11, this.currentStroke);
                this.scrollTx.setToIdentity();
                this.scrollTx.translate(-ptDir.getX() * 30.0, -ptDir.getY() * 30.0);
                this.parent.applyTransform(this.scrollTx);
            }
        }
        if (this.flagRenderCurvy) {
            this.setButtonInStroke(this.currentCurvyStroke, evt);
        } else {
            this.setButtonInStroke(this.currentStroke, evt);
        }
        UpdateStrokeEvent stkevt = this.flagRenderCurvy ? new UpdateStrokeEvent(this.parent, this.currentCurvyStroke) : new UpdateStrokeEvent(this.parent, this.currentStroke);
        stkevt.setMouseEvent(evt);
        stkevt.setDispatchingCache(this.dispatchingPath);
        if (this.isLocked && evt.getButton() != this.oldButtonType) {
            stkevt.getStroke().setLeftButton(false);
            stkevt.getStroke().setMiddleButton(false);
            stkevt.getStroke().setRightButton(false);
            switch (this.oldButtonType) {
                case 1: {
                    stkevt.getStroke().setLeftButton(true);
                    break;
                }
                case 2: {
                    stkevt.getStroke().setMiddleButton(true);
                    break;
                }
                case 3: {
                    stkevt.getStroke().setRightButton(true);
                }
            }
        }
        this.parent.onUpdateStroke(stkevt);
        EventUtil.setPosition(evt, this.oldX, this.oldY);
        if (flagApply && (e1 = this.queue.peekEvent(502)) == null) {
            try {
                Thread.sleep(10L);
                ++this.delayCount;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.repeatEvent = evt;
            this.queue.postEvent(evt);
            this.flagScrolling = true;
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (!this.isEnabled()) {
            this.parent.setRenderToScreen(true);
            return;
        }
        if (this.flagRenderCurvy) {
            if (this.currentCurvyStroke == null) {
                this.parent.setRenderToScreen(true);
                return;
            }
        } else if (this.currentStroke == null) {
            this.parent.setRenderToScreen(true);
            return;
        }
        if (!this.acceptMouseEvent(evt)) {
            this.parent.setRenderToScreen(true);
            return;
        }
        if (evt.getWhen() < this.lastReleaseTime + 85L) {
            Debug.println("Mouse release ignored: interval = " + (evt.getWhen() - this.lastReleaseTime) + " ms");
            this.parent.setRenderToScreen(true);
            return;
        }
        this.flagScrolling = false;
        this.lastReleaseTime = evt.getWhen();
        this.oldX = evt.getX();
        this.oldY = evt.getY();
        EventUtil.applyTransform(evt, this.getInverseTransform());
        if (this.flagRenderCurvy) {
            this.currentCurvyStroke.addPoint(evt.getX(), evt.getY());
            this.currentCurvyStroke.doneAddingPoints();
        } else {
            this.currentStroke.addPoint(evt.getX(), evt.getY());
            this.currentStroke.doneAddingPoints();
        }
        if (this.flagRenderCurvy) {
            this.setButtonInStroke(this.currentCurvyStroke, evt);
        } else {
            this.setButtonInStroke(this.currentStroke, evt);
        }
        SingleStrokeEvent stkevt = this.flagRenderCurvy ? new SingleStrokeEvent(this.parent, this.currentCurvyStroke) : new SingleStrokeEvent(this.parent, this.currentStroke);
        stkevt.setMouseEvent(evt);
        stkevt.setDispatchingCache(this.dispatchingPath);
        if (this.isLocked) {
            if (evt.getButton() != this.oldButtonType) {
                stkevt.getStroke().setLeftButton(false);
                stkevt.getStroke().setMiddleButton(false);
                stkevt.getStroke().setRightButton(false);
                switch (this.oldButtonType) {
                    case 1: {
                        stkevt.getStroke().setLeftButton(true);
                        break;
                    }
                    case 2: {
                        stkevt.getStroke().setMiddleButton(true);
                        break;
                    }
                    case 3: {
                        stkevt.getStroke().setRightButton(true);
                    }
                }
            }
            this.isLocked = false;
        }
        this.parent.onSingleStroke(stkevt);
        EventUtil.setPosition(evt, this.oldX, this.oldY);
        if (this.flagRenderCurvy) {
            this.currentCurvyStroke = null;
        } else {
            this.currentStroke = null;
        }
        this.parent.removeMouseListener(this);
        this.parent.removeMouseMotionListener(this);
        this.parent.addMouseListener(this);
        this.parent.addMouseMotionListener(this);
        this.dispatchingPath.clear();
        this.parent.setRenderToScreen(true);
    }

    public void setAngleTolerance(float at) {
        this.angleTolerance = at;
    }

    public void setFilterWindowSize(int ws) {
        this.windowSize = ws;
    }

    public void setCornerDegree(float cd) {
        this.cornerDegree = cd;
    }

    public void onNotify(Watchable w, Object arg) {
    }

    public void onUpdate(Watchable w, Object arg) {
    }

    public void onUpdate(Watchable w, String strProperty, Object oldVal, Object newVal) {
    }

    public void onRepaint(GraphicalObject gob) {
    }

    public void onRepaint(Rectangle rect) {
    }

    public void onDelete(Watchable w) {
    }

    public Object clone() {
        throw new RuntimeException("StrokeAssembler should not be cloned...");
    }
}

