/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.remote;

import edu.berkeley.guir.lib.satin.command.RemoteCommandQueue;
import edu.berkeley.guir.lib.satin.remote.IOEvent;
import edu.berkeley.guir.lib.satin.remote.RemoteIncomingSocket;
import edu.berkeley.guir.lib.satin.remote.RemoteOutgoingSocket;
import java.util.Vector;

public class RemoteSocketMgr
extends Thread {
    private Vector m_inSockets = new Vector();
    private Vector m_outSockets = new Vector();
    private Vector m_inEvents = new Vector();
    private Vector m_outEvents = new Vector();
    private RemoteCommandQueue m_listener = null;
    private IOEvent m_latest_awareness = null;
    private int m_portBase;
    private int m_inPort;
    private int m_outPort;

    public RemoteSocketMgr(int port) {
        this.m_portBase = port;
    }

    public void setRemoteHost(String hostName, int localOffset, int remoteOffset) {
        this.m_inPort = this.m_portBase + localOffset;
        this.m_outPort = this.m_portBase + remoteOffset;
        this.m_inSockets.add(new RemoteIncomingSocket(this, this.m_inPort));
        this.m_outSockets.add(new RemoteOutgoingSocket(this, this.m_outPort));
        System.out.println("RemoteSocketManager before start");
        this.start();
        System.out.println("RemoteSocketManager after start");
        ((RemoteOutgoingSocket)this.m_outSockets.get(0)).connectToHost(hostName);
    }

    public void setRemoteListener(RemoteCommandQueue listener) {
        this.m_listener = listener;
    }

    public void run() {
        while (true) {
            if (!this.m_inEvents.isEmpty() && this.m_listener != null) {
                System.out.println("()()()()()()()()()() remove event from m_inEvents in RemoteSocketManager!");
                IOEvent event = (IOEvent)this.m_inEvents.remove(0);
                this.m_listener.handleRemoteEvent(event);
                continue;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void postOutgoingEvent(String xml) {
        System.out.println("postOutgoingEvent");
        this.m_outEvents.add(new IOEvent(xml, this.m_outPort));
    }

    public void postOutgoingAwarenessUpdate(String xml) {
        System.out.println("postOutgoingAwarenessUpdate");
        this.m_latest_awareness = new IOEvent(xml, this.m_outPort);
    }

    public IOEvent getOutgoingEvent(int portNum) {
        if (!this.m_outEvents.isEmpty()) {
            System.out.println("()()()()()()()()()() There are " + this.m_outEvents.size() + " events in the Outgoing queue ");
            int first = -1;
            int len = this.m_outEvents.size();
            int i = len - 1;
            while (i >= 0) {
                if (((IOEvent)this.m_outEvents.get(i)).getPort() == portNum) {
                    first = i;
                    i = -2;
                }
                --i;
            }
            if (first == -1) {
                return null;
            }
            return (IOEvent)this.m_outEvents.remove(first);
        }
        if (this.m_latest_awareness != null) {
            System.out.println("red rover red rover, let awareness come over");
            IOEvent awareness = this.m_latest_awareness;
            this.m_latest_awareness = null;
            return awareness;
        }
        return null;
    }

    public void postIncomingEvent(IOEvent rEvent) {
        this.m_inEvents.add(rEvent);
    }
}

