/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.remote;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.command.RemoteCommandQueue;
import edu.berkeley.guir.lib.satin.remote.IOEvent;
import edu.berkeley.guir.lib.satin.remote.RemoteSocketMgr;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class RemoteOutgoingSocket
extends Thread {
    private RemoteSocketMgr m_manager = null;
    private int m_port = -1;
    private Socket m_outConnection = null;
    private PrintWriter m_out = null;
    private BufferedReader m_outEcho = null;
    private String m_hostName = null;

    public RemoteOutgoingSocket(RemoteSocketMgr manager, int port_num) {
        this.m_manager = manager;
        this.m_port = port_num;
    }

    public void connectToHost(String hostName) {
        System.out.println("RemoteOutSocket connect to host called");
        this.m_hostName = hostName;
        this.start();
    }

    private void establishConnection() {
        System.out.println("RemoteOutSocket establishConnection called");
        try {
            this.m_outConnection = new Socket(this.m_hostName, this.m_port);
            System.out.println("Connection Established: Connected to " + this.m_hostName + " - " + this.m_port);
            SatinConstants.cmdqueue.setRemoteSocketMgr(this.m_manager);
            this.m_manager.setRemoteListener((RemoteCommandQueue)((Object)SatinConstants.cmdqueue.getCommandQueue()));
        }
        catch (UnknownHostException e) {
            System.out.println("RemoteOutgoingSocket: Unknown host - " + this.m_hostName);
        }
        catch (SecurityException se) {
            System.out.println("RemoteOutgoingSocket: Security Exception");
        }
        catch (IOException e) {
            System.out.println("IOException, the problem is:" + e.getMessage());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        try {
            this.m_out = new PrintWriter(this.m_outConnection.getOutputStream(), true);
        }
        catch (IOException e) {
            System.out.println("RemoteOutgoingSocket: Failed to create OutputStream.");
        }
        try {
            this.m_outEcho = new BufferedReader(new InputStreamReader(this.m_outConnection.getInputStream()));
        }
        catch (IOException e) {
            System.out.println("RemoteOutgoingSocket: Failed to create InputStream (Response Echo).");
        }
    }

    public void run() {
        System.out.println("RemoteOutSocket run called");
        while (true) {
            if (this.m_outConnection == null) {
                this.establishConnection();
                continue;
            }
            try {
                IOEvent rEvent = null;
                System.out.println("RemoteOutgoingSocket: Awaiting outgoing event...");
                while (rEvent == null) {
                    rEvent = this.m_manager.getOutgoingEvent(this.m_port);
                    if (rEvent != null) continue;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                System.out.println("RemoteOutgoingSocket: Sending outgoing event...");
                this.m_out.println(rEvent.getXML());
                String echo = this.m_outEcho.readLine();
                continue;
            }
            catch (IOException e) {
                System.out.println("RemoteOutgoingSocket: Connection lost...\n");
                try {
                    this.m_outConnection.close();
                    this.m_outConnection = null;
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            break;
        }
    }
}

