/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.remote;

import edu.berkeley.guir.lib.satin.remote.IOEvent;
import edu.berkeley.guir.lib.satin.remote.RemoteSocketMgr;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class RemoteIncomingSocket
extends Thread {
    private RemoteSocketMgr m_manager = null;
    private int m_port = -1;
    private ServerSocket m_inSocket = null;
    private Socket m_inConnection = null;
    private BufferedReader m_in = null;
    private PrintWriter m_inEcho = null;

    public RemoteIncomingSocket(RemoteSocketMgr manager, int port_num) {
        this.m_manager = manager;
        this.m_port = port_num;
        this.start();
    }

    private void establishConnection() {
        try {
            System.out.println("RemoteIncomingSocket: waiting for connection");
            System.out.println("RemoteINSocket: Waiting on " + this.m_port);
            this.m_inConnection = this.m_inSocket.accept();
            System.out.println("RemoteIncomingSocket: Connection Established.");
        }
        catch (IOException e) {
            System.out.println("GRemoteIncomingSocket: Connection Failed.");
        }
        try {
            this.m_in = new BufferedReader(new InputStreamReader(this.m_inConnection.getInputStream()));
        }
        catch (IOException e) {
            System.out.println("GRemoteIncomingSocket: Failed to create InputStream (Response Echo).");
        }
        try {
            this.m_inEcho = new PrintWriter(this.m_inConnection.getOutputStream(), true);
        }
        catch (UnknownHostException e) {
            System.out.println("RemoteIncomingSocket: Unknown host - localhost");
        }
        catch (IOException e) {
            System.out.println("RemoteIncomingSocket: Failed to create OutputStream.");
        }
    }

    public void run() {
        try {
            this.m_inSocket = new ServerSocket(this.m_port);
        }
        catch (IOException e) {
            System.out.println("Failed to Create IncomingSocket");
            System.exit(-1);
        }
        while (true) {
            if (this.m_inConnection == null) {
                this.establishConnection();
                continue;
            }
            try {
                System.out.println("Incoming: blocking until data...");
                String s = this.m_in.readLine();
                if (s != null) {
                    IOEvent rEvent = new IOEvent(s, this.m_port);
                    System.out.println("RemoteIncomingSocket: Received incoming event " + rEvent.toString() + "...");
                    this.m_manager.postIncomingEvent(rEvent);
                    this.m_inEcho.println("<THANKS>");
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            catch (IOException e) {
                System.out.println("RemoteIncomingSocket: Connection lost...\n");
                try {
                    this.m_inConnection.close();
                    this.m_inConnection = null;
                }
                catch (IOException iOException) {
                }
                continue;
            }
            break;
        }
    }
}

