/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.remote;

import edu.berkeley.guir.lib.satin.remote.IOEvent;
import edu.berkeley.guir.lib.satin.remote.InOutMgr;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class FileOutgoingSave
extends Thread {
    private InOutMgr m_manager = null;
    private String m_pathAndFilename = "";
    private FileOutputStream m_out = null;
    private FileWriter m_writeOut = null;

    public FileOutgoingSave(InOutMgr manager, String pathAndFilename) {
        this.m_manager = manager;
        this.m_pathAndFilename = pathAndFilename;
    }

    public void openFile() {
        boolean append = true;
        try {
            this.m_out = new FileOutputStream(this.m_pathAndFilename, append);
            this.m_writeOut = new FileWriter(this.m_pathAndFilename, append);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void closeFile() {
        try {
            this.m_writeOut.flush();
            this.m_writeOut.close();
            this.m_out.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void addString(String XML) {
        try {
            this.m_writeOut.write(XML);
            this.m_writeOut.write("\n");
            this.m_writeOut.flush();
        }
        catch (IOException e) {
            System.out.println("Error in SaveOutgoingDisk:addString(String XML)");
        }
    }

    public void run() {
        System.out.println("SaveOutgoingDisk run called");
        this.openFile();
        while (true) {
            try {
                IOEvent ioEvent = null;
                System.out.println("SaveOutgoingDisk: Awaiting outgoing event...");
                while (ioEvent == null) {
                    ioEvent = this.m_manager.getOutgoingEvent();
                    if (ioEvent != null) continue;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                System.out.println("SaveOutgoingDisk: Saving outgoing event...");
                this.addString(ioEvent.getXML());
                continue;
            }
            catch (Exception e) {
                System.out.println("SaveOutgoingDisk: Exception ---------------\n");
                this.closeFile();
                continue;
            }
            break;
        }
    }
}

