/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.regression;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.metrics.ActionItem;
import edu.berkeley.guir.lib.metrics.Regression;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectImpl;
import edu.berkeley.guir.lib.satin.objects.PatchImpl;
import edu.berkeley.guir.lib.satin.util.SatinRandomLib;
import edu.berkeley.guir.lib.satin.view.SemanticZoomMultiViewImpl;
import edu.berkeley.guir.lib.satin.view.SemanticZoomViewWrapper;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Random;
import javax.swing.JFrame;

public class TestA
implements SatinConstants {
    Sheet s = new Sheet();
    Rectangle rect;

    public TestA() {
        JFrame f = new JFrame();
        this.s.setVisible(true);
        f.getContentPane().add(this.s);
        f.setSize(800, 800);
        f.show();
    }

    public static AffineTransform scaleAndKeepConstant(double scale, int x, int y) {
        AffineTransform tx = AffineTransform.getTranslateInstance(x, y);
        tx.concatenate(AffineTransform.getScaleInstance(scale, scale));
        tx.concatenate(AffineTransform.getTranslateInstance(-x, -y));
        return tx;
    }

    public void suiteZoom() {
        AffineTransform tx = TestA.scaleAndKeepConstant(1.01, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom In"), 20);
        tx = TestA.scaleAndKeepConstant(0.99, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom Out"), 20);
        tx = TestA.scaleAndKeepConstant(0.99, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom Out"), 20);
        tx = TestA.scaleAndKeepConstant(1.01, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom In"), 20);
    }

    public void suiteAnimate() {
        AffineTransform[] txArray = AffineTransformLib.animateSlowInSlowOut(TestA.scaleAndKeepConstant(3.0, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom In"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Right"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(-1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Left"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(TestA.scaleAndKeepConstant(0.3333333333333333, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom Out"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Right"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(-1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Left"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(TestA.scaleAndKeepConstant(0.3333333333333333, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom Out"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Right"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(-1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Left"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(TestA.scaleAndKeepConstant(3.0, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom In"), 20);
    }

    public void test() {
        int x = (int)(-0.5 * (double)this.s.getWidth());
        int y = (int)(-0.5 * (double)this.s.getHeight());
        int w = 2 * this.s.getWidth();
        int h = 2 * this.s.getHeight();
        this.rect = new Rectangle(x, y, w, h);
        System.out.println("Visible Tests");
        System.out.println("-----------");
        this.s.clear();
        this.s.setTransform(new AffineTransform());
        Random rand = new Random();
        double fIn = rand.nextDouble();
        double start = rand.nextDouble() + 1.0;
        double end = rand.nextDouble() + 2.0;
        double fOut = rand.nextDouble() + 3.0;
        GraphicalObject gob = this.s.addToFront(new PatchImpl(new Rectangle(300, 300, 300, 300)));
        SemanticZoomMultiViewImpl med = new SemanticZoomMultiViewImpl();
        SemanticZoomViewWrapper v = new SemanticZoomViewWrapper(((GraphicalObjectImpl)gob).getClassPropertyView());
        v.setDisplayRange(fIn, start, end, fOut);
        med.add(v);
        gob.setView(med);
        this.suiteZoom();
        this.suiteAnimate();
        System.out.println("Not Visible Tests");
        System.out.println("-----------------");
        gob.moveTo(11, 900000.0, 900000.0);
        this.suiteZoom();
        this.suiteAnimate();
    }

    public static void main(String[] argv) throws Exception {
        new TestA().test();
    }

    public class RegressionAddStroke
    extends ActionItem {
        public void init() {
            TestA.this.s.clear();
        }

        public final void doit() {
            TestA.this.s.addToBack(SatinRandomLib.getRandomStroke(TestA.this.rect, 10));
        }

        public String getName() {
            return "Add Stroke";
        }
    }

    public class RegressionAddPatch
    extends ActionItem {
        public void init() {
            TestA.this.s.clear();
        }

        public final void doit() {
            TestA.this.s.addToFront(SatinRandomLib.getRandomPatch(TestA.this.rect));
        }

        public String getName() {
            return "Add Patch";
        }
    }

    public class RegressionTransform
    extends ActionItem {
        AffineTransform tx;
        String str;

        public RegressionTransform(AffineTransform tx, String str) {
            this.tx = tx;
            this.str = str;
        }

        public final void doit() {
            TestA.this.s.applyTransform(this.tx);
        }

        public String getName() {
            return this.str;
        }
    }

    public class AnimationTransform
    extends ActionItem {
        AffineTransform[] txArray;
        String str;
        int i = 0;

        public AnimationTransform(AffineTransform[] txArray, String str) {
            this.txArray = txArray;
            this.str = str;
        }

        public final void doit() {
            TestA.this.s.applyTransform(this.txArray[this.i++]);
        }

        public String getName() {
            return this.str;
        }
    }
}

