/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.regression;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.metrics.ActionItem;
import edu.berkeley.guir.lib.metrics.Regression;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.objects.PatchImpl;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JFrame;

public class RegressionTest2
implements SatinConstants {
    Sheet s = new Sheet();
    Rectangle rect;

    public RegressionTest2() {
        JFrame f = new JFrame();
        this.s.setVisible(true);
        f.getContentPane().add(this.s);
        f.setSize(800, 800);
        f.show();
    }

    public static AffineTransform scaleAndKeepConstant(double scale, int x, int y) {
        AffineTransform tx = AffineTransform.getTranslateInstance(x, y);
        tx.concatenate(AffineTransform.getScaleInstance(scale, scale));
        tx.concatenate(AffineTransform.getTranslateInstance(-x, -y));
        return tx;
    }

    public void suiteZoom() {
        AffineTransform tx = RegressionTest2.scaleAndKeepConstant(1.01, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom In"), 20);
        tx = RegressionTest2.scaleAndKeepConstant(0.99, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom Out"), 20);
        tx = RegressionTest2.scaleAndKeepConstant(0.99, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom Out"), 20);
        tx = RegressionTest2.scaleAndKeepConstant(1.01, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom In"), 20);
    }

    public void suiteAnimate() {
        AffineTransform[] txArray = AffineTransformLib.animateSlowInSlowOut(RegressionTest2.scaleAndKeepConstant(3.0, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom In"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Right"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(-1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Left"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(RegressionTest2.scaleAndKeepConstant(0.3333333333333333, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom Out"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Right"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(-1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Left"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(RegressionTest2.scaleAndKeepConstant(0.3333333333333333, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom Out"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Right"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(-1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Left"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(RegressionTest2.scaleAndKeepConstant(3.0, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom In"), 20);
    }

    public void test() {
        System.out.println("Animation test");
        this.s.clear();
        TimedStroke stk = new TimedStroke();
        stk.addPoint(0, 55);
        stk.addPoint(11, 40);
        stk.addPoint(20, 25);
        stk.addPoint(24, 18);
        stk.addPoint(28, 9);
        stk.addPoint(29, 4);
        stk.addPoint(29, 7);
        stk.addPoint(30, 12);
        stk.addPoint(32, 19);
        stk.addPoint(34, 31);
        stk.addPoint(38, 44);
        stk.addPoint(43, 57);
        stk.addPoint(48, 65);
        stk.addPoint(51, 68);
        stk.addPoint(53, 69);
        stk.addPoint(54, 68);
        stk.addPoint(56, 64);
        stk.addPoint(58, 58);
        stk.addPoint(60, 47);
        stk.addPoint(63, 14);
        stk.addPoint(64, 11);
        stk.addPoint(65, 15);
        stk.addPoint(66, 22);
        stk.addPoint(68, 32);
        stk.addPoint(71, 43);
        stk.addPoint(73, 53);
        stk.addPoint(76, 59);
        stk.addPoint(78, 62);
        stk.addPoint(79, 61);
        stk.addPoint(80, 58);
        stk.addPoint(82, 54);
        stk.addPoint(83, 46);
        stk.addPoint(88, 17);
        stk.addPoint(89, 5);
        stk.addPoint(90, 0);
        stk.addPoint(92, 3);
        stk.addPoint(93, 8);
        stk.addPoint(96, 16);
        stk.addPoint(98, 26);
        stk.addPoint(103, 36);
        stk.addPoint(107, 45);
        stk.addPoint(113, 53);
        stk.addPoint(115, 54);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -900.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -800.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -700.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -600.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -500.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -400.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -300.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -200.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -100.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 0.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 100.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 200.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 300.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 400.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 500.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 600.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 700.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 800.0, 0.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 900.0, 0.0);
        stk = new TimedStroke();
        stk.addPoint(4, 12);
        stk.addPoint(5, 40);
        stk.addPoint(3, 68);
        stk.addPoint(1, 88);
        stk.addPoint(1, 104);
        stk.addPoint(2, 115);
        stk.addPoint(6, 117);
        stk.addPoint(25, 114);
        stk.addPoint(56, 106);
        stk.addPoint(77, 101);
        stk.addPoint(96, 99);
        stk.addPoint(109, 99);
        stk.addPoint(111, 89);
        stk.addPoint(109, 67);
        stk.addPoint(114, 43);
        stk.addPoint(117, 26);
        stk.addPoint(118, 16);
        stk.addPoint(115, 6);
        stk.addPoint(108, 1);
        stk.addPoint(99, 0);
        stk.addPoint(67, 4);
        stk.addPoint(34, 11);
        stk.addPoint(13, 17);
        stk.addPoint(3, 20);
        stk.addPoint(0, 23);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -900.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -800.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -700.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -600.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -500.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -400.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -300.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -200.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -100.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 0.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 100.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 200.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 300.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 400.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 500.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 600.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 700.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 800.0, 200.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 900.0, 200.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, -900.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, -800.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, -700.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, -600.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, -500.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, -400.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, -300.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, -200.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, -100.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, 0.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, 100.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, 200.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, 300.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, 400.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, 500.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, 600.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, 700.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, 800.0, 600.0);
        this.s.addToFront(new PatchImpl(stk)).moveBy(11, 900.0, 600.0);
        stk = new TimedStroke();
        stk.addPoint(0, 0);
        stk.addPoint(4, 13);
        stk.addPoint(6, 26);
        stk.addPoint(9, 39);
        stk.addPoint(14, 48);
        stk.addPoint(18, 50);
        stk.addPoint(24, 45);
        stk.addPoint(34, 34);
        stk.addPoint(40, 22);
        stk.addPoint(44, 14);
        stk.addPoint(46, 10);
        stk.addPoint(46, 13);
        stk.addPoint(47, 18);
        stk.addPoint(48, 26);
        stk.addPoint(49, 33);
        stk.addPoint(50, 41);
        stk.addPoint(51, 46);
        stk.addPoint(52, 48);
        stk.addPoint(54, 47);
        stk.addPoint(57, 42);
        stk.addPoint(62, 34);
        stk.addPoint(68, 24);
        stk.addPoint(76, 11);
        stk.addPoint(76, 14);
        stk.addPoint(76, 23);
        stk.addPoint(76, 31);
        stk.addPoint(79, 46);
        stk.addPoint(81, 46);
        stk.addPoint(83, 42);
        stk.addPoint(88, 34);
        stk.addPoint(93, 25);
        stk.addPoint(98, 17);
        stk.addPoint(101, 10);
        stk.addPoint(104, 3);
        stk.addPoint(104, 5);
        stk.addPoint(104, 9);
        stk.addPoint(104, 17);
        stk.addPoint(105, 26);
        stk.addPoint(106, 34);
        stk.addPoint(108, 40);
        stk.addPoint(110, 44);
        stk.addPoint(112, 47);
        stk.addPoint(113, 46);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -900.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -800.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -700.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -600.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -500.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -400.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -300.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -200.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, -100.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 0.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 100.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 200.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 300.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 400.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 500.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 600.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 700.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 800.0, 400.0);
        this.s.addToFront((TimedStroke)stk.clone()).moveBy(11, 900.0, 400.0);
        this.suiteZoom();
        this.suiteAnimate();
        System.exit(0);
    }

    public static void main(String[] argv) throws Exception {
        new RegressionTest2().test();
    }

    public class RegressionTransform
    extends ActionItem {
        AffineTransform tx;
        String str;

        public RegressionTransform(AffineTransform tx, String str) {
            this.tx = tx;
            this.str = str;
        }

        public final void doit() {
            RegressionTest2.this.s.applyTransform(this.tx);
        }

        public String getName() {
            return this.str;
        }
    }

    public class AnimationTransform
    extends ActionItem {
        AffineTransform[] txArray;
        String str;
        int i = 0;

        public AnimationTransform(AffineTransform[] txArray, String str) {
            this.txArray = txArray;
            this.str = str;
        }

        public final void init() {
            GraphicalObjectLib.setAnimating(true);
        }

        public final void doit() {
            RegressionTest2.this.s.applyTransform(this.txArray[this.i++]);
        }

        public final void cleanup() {
            GraphicalObjectLib.setAnimating(false);
        }

        public String getName() {
            return this.str;
        }
    }
}

