/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.regression;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.metrics.ActionItem;
import edu.berkeley.guir.lib.metrics.Regression;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.util.SatinRandomLib;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JFrame;

public class RegressionTest
implements SatinConstants {
    Sheet s = new Sheet();
    Rectangle rect;

    public RegressionTest() {
        JFrame f = new JFrame();
        this.s.setVisible(true);
        f.getContentPane().add(this.s);
        f.setSize(800, 800);
        f.show();
    }

    public static AffineTransform scaleAndKeepConstant(double scale, int x, int y) {
        AffineTransform tx = AffineTransform.getTranslateInstance(x, y);
        tx.concatenate(AffineTransform.getScaleInstance(scale, scale));
        tx.concatenate(AffineTransform.getTranslateInstance(-x, -y));
        return tx;
    }

    public void suiteZoom() {
        AffineTransform tx = RegressionTest.scaleAndKeepConstant(1.01, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom In"), 20);
        tx = RegressionTest.scaleAndKeepConstant(0.99, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom Out"), 20);
        tx = RegressionTest.scaleAndKeepConstant(0.99, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom Out"), 20);
        tx = RegressionTest.scaleAndKeepConstant(1.01, this.s.getWidth() / 2, this.s.getHeight() / 2);
        Regression.run(new RegressionTransform(tx, "Zoom In"), 20);
    }

    public void suiteAnimate() {
        AffineTransform[] txArray = AffineTransformLib.animateSlowInSlowOut(RegressionTest.scaleAndKeepConstant(3.0, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom In"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Right"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(-1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Left"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(RegressionTest.scaleAndKeepConstant(0.3333333333333333, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom Out"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Right"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(-1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Left"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(RegressionTest.scaleAndKeepConstant(0.3333333333333333, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom Out"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Right"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getRotateInstance(-1.5707963267948966, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Rotate Left"), 20);
        txArray = AffineTransformLib.animateSlowInSlowOut(RegressionTest.scaleAndKeepConstant(3.0, this.s.getWidth() / 2, this.s.getHeight() / 2), 20);
        Regression.run(new AnimationTransform(txArray, "Animate Zoom In"), 20);
    }

    public void test() {
        int x = (int)(-0.5 * (double)this.s.getWidth());
        int y = (int)(-0.5 * (double)this.s.getHeight());
        int w = 2 * this.s.getWidth();
        int h = 2 * this.s.getHeight();
        this.rect = new Rectangle(x, y, w, h);
        System.out.println("Stroke tests");
        Regression.run(new RegressionAddStroke(), 100);
        Regression.run(new RegressionAddStroke(), 100);
        this.s.clear();
        int i = 0;
        while (i < 100) {
            this.s.addToFront(SatinRandomLib.getRandomStroke(this.rect, 10));
            ++i;
        }
        this.suiteZoom();
        this.suiteAnimate();
        System.out.println("Patch tests");
        this.s.clear();
        this.s.setTransform(new AffineTransform());
        Regression.run(new RegressionAddPatch(), 30);
        Regression.run(new RegressionAddPatch(), 30);
        this.s.clear();
        i = 0;
        while (i < 20) {
            this.s.addToFront(SatinRandomLib.getRandomSemanticZoomPatch(this.rect));
            ++i;
        }
        this.suiteZoom();
        this.suiteAnimate();
        System.out.println("Combined tests");
        i = 0;
        while (i < 100) {
            this.s.addToFront(SatinRandomLib.getRandomStroke(this.rect, 10));
            ++i;
        }
        this.suiteZoom();
        this.suiteAnimate();
        System.exit(0);
    }

    public static void main(String[] argv) throws Exception {
        new RegressionTest().test();
    }

    public class RegressionAddStroke
    extends ActionItem {
        public void init() {
            RegressionTest.this.s.clear();
        }

        public final void doit() {
            RegressionTest.this.s.addToBack(SatinRandomLib.getRandomStroke(RegressionTest.this.rect, 10));
        }

        public String getName() {
            return "Add Stroke";
        }
    }

    public class RegressionAddPatch
    extends ActionItem {
        public void init() {
            RegressionTest.this.s.clear();
        }

        public final void doit() {
            RegressionTest.this.s.addToFront(SatinRandomLib.getRandomPatch(RegressionTest.this.rect));
        }

        public String getName() {
            return "Add Patch";
        }
    }

    public class RegressionTransform
    extends ActionItem {
        AffineTransform tx;
        String str;

        public RegressionTransform(AffineTransform tx, String str) {
            this.tx = tx;
            this.str = str;
        }

        public final void doit() {
            RegressionTest.this.s.applyTransform(this.tx);
        }

        public String getName() {
            return this.str;
        }
    }

    public class AnimationTransform
    extends ActionItem {
        AffineTransform[] txArray;
        String str;
        int i = 0;

        public AnimationTransform(AffineTransform[] txArray, String str) {
            this.txArray = txArray;
            this.str = str;
        }

        public final void init() {
            GraphicalObjectLib.setAnimating(true);
        }

        public final void doit() {
            RegressionTest.this.s.applyTransform(this.txArray[this.i++]);
        }

        public final void cleanup() {
            GraphicalObjectLib.setAnimating(false);
        }

        public String getName() {
            return this.str;
        }
    }
}

