/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.recognizer.rubine;

import edu.berkeley.guir.lib.collection.SortedValueNumMap;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import edu.berkeley.guir.lib.gesture.TrainingException;
import edu.berkeley.guir.lib.satin.recognizer.Classification;
import edu.berkeley.guir.lib.satin.recognizer.SingleStrokeRecognizer;
import edu.berkeley.guir.lib.satin.recognizer.rubine.RubineClassifier;
import edu.berkeley.guir.lib.satin.stroke.TimedPolygon2D;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Set;

public class RubineRecognizer
implements SingleStrokeRecognizer {
    private RubineClassifier classifier;

    public RubineRecognizer() {
    }

    public RubineRecognizer(Reader rdr) throws IOException, ParseException, TrainingException {
        GestureSet gset = new GestureSet();
        gset = GestureSet.read(rdr);
        this.classifier = new RubineClassifier(gset);
        try {
            this.classifier.train();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public RubineClassifier getClassifier() {
        return this.classifier;
    }

    public Classification classify(TimedStroke stk) {
        SortedValueNumMap map;
        Classification c = new Classification();
        if (this.classifier == null) {
            c.put((Object)"tap", 1.0);
            return c;
        }
        TimedPolygon2D polyOld = stk.getPolygon2D(12);
        int[] xpts = new int[polyOld.npoints];
        int[] ypts = new int[polyOld.npoints];
        int i = 0;
        while (i < polyOld.npoints) {
            xpts[i] = (int)polyOld.xpoints[i];
            ypts[i] = (int)polyOld.ypoints[i];
            ++i;
        }
        TimedPolygon polyNew = new TimedPolygon(xpts, ypts, polyOld.times, polyOld.npoints);
        Gesture gesture = new Gesture();
        gesture.setPoints(polyNew);
        try {
            map = this.classifier.classify_satin(gesture);
        }
        catch (Exception e) {
            map = new SortedValueNumMap();
            map.put((Object)"Exception error", 1.0);
        }
        gesture = null;
        if (map.size() <= 0) {
            return c;
        }
        double maxVal = ((Number)map.getLargestValue()).doubleValue();
        Set keys = map.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            double val;
            Object key = it.next();
            if (keys.size() == 1) {
                val = 1.0;
            } else {
                val = ((Number)map.get(key)).doubleValue();
                val = (maxVal - val) / maxVal;
            }
            c.put(key, val);
        }
        return c;
    }
}

