/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.recognizer.rubine;

import edu.berkeley.guir.lib.collection.SortedValueNumMap;
import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.FeatureFactory;
import edu.berkeley.guir.lib.gesture.FeatureVector;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import edu.berkeley.guir.lib.gesture.TrainingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RubineClassifier
extends Classifier {
    public static final String DOT = "dot";
    private boolean flagTrained = false;
    private boolean flagConserveMemory = true;
    private Map idealGesturePoints = new HashMap();
    private String[] gestureCategoryNames;
    private String dotCategoryName = null;

    public RubineClassifier() {
        this(null);
    }

    public RubineClassifier(GestureSet gs) {
        super(gs);
    }

    public synchronized void train() throws TrainingException, InterruptedException {
        super.train();
        FeatureFactory.clearCache();
        this.gestureCategoryNames = new String[this.enabledCategories.size()];
        this.idealGesturePoints.clear();
        int i = 0;
        Iterator iter = this.enabledCategories.iterator();
        while (iter.hasNext()) {
            String gestureName;
            GestureCategory gestureCategory = (GestureCategory)iter.next();
            this.gestureCategoryNames[i] = gestureName = gestureCategory.getName().trim();
            this.idealGesturePoints.put(gestureName, super.getIdealGesturePoints(gestureName));
            if (gestureCategory == this.dotCategory) {
                this.dotCategoryName = gestureName;
            }
            ++i;
        }
        if (this.flagConserveMemory) {
            this.gestureSet = null;
            this.enabledCategories = null;
        }
        this.flagTrained = true;
    }

    public TimedPolygon getIdealGesturePoints(String gestureName) {
        String clearupString = gestureName.trim();
        return (TimedPolygon)this.idealGesturePoints.get(clearupString);
    }

    public boolean getConserveMemory() {
        return this.flagConserveMemory;
    }

    public void setConserveMemory(boolean flag) {
        this.flagConserveMemory = flag;
    }

    protected SortedValueNumMap classify_satin(Gesture gesture) throws Exception {
        if (!this.flagTrained) {
            this.flagTrained = true;
            this.train();
        }
        FeatureFactory.setCaching(false);
        SortedValueNumMap map = new SortedValueNumMap();
        map.setAscending(false);
        if (gesture.size() == 1) {
            if (this.dotCategory == null) {
                map.put((Object)DOT, 1.0);
                return map;
            }
            if (this.dotCategoryName != null) {
                map.put((Object)this.dotCategoryName, 1.0);
                return map;
            }
            map.put((Object)DOT, 1.0);
            return map;
        }
        int numCategories = this.gestureCategoryNames.length;
        double[] disc = new double[numCategories];
        int catIndex = 0;
        while (catIndex < numCategories) {
            double sum = this.weights[catIndex][0];
            int featureNum = 0;
            while (featureNum < this.featureClasses.length) {
                Feature feature = FeatureFactory.getFeature(this.featureClasses[featureNum], gesture);
                sum += this.weights[catIndex][featureNum + 1] * feature.getValue();
                ++featureNum;
            }
            disc[catIndex] = sum;
            ++catIndex;
        }
        FeatureVector fv = new FeatureVector(gesture);
        int i = 0;
        while (i < numCategories) {
            if (!this.gestureCategoryNames[i].equals(this.dotCategoryName)) {
                map.put((Object)this.gestureCategoryNames[i], this.MahalanobisDistance(fv.getValues(), this.meanFeatureValues[i]));
            }
            ++i;
        }
        FeatureFactory.setCaching(true);
        return map;
    }

    protected double calculateAccuracy(double[] disc, int j) {
        double denom = 0.0;
        int i = 0;
        while (i < disc.length) {
            double d = disc[i] - disc[j];
            if (d > -7.0) {
                denom += Math.exp(d);
            }
            ++i;
        }
        return denom;
    }
}

