/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.plaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.plaf.metal.MetalSliderUI;

public class PenSliderUI
extends MetalSliderUI {
    JSlider slider;
    SliderMouseListener mlstnr;
    SliderKeyListener klstnr;

    private void scroll(int direction) {
        int oldValue = this.slider.getValue();
        int delta = 0;
        delta = this.slider.getSnapToTicks() ? this.slider.getMajorTickSpacing() : this.slider.getMinorTickSpacing();
        if (direction < 0) {
            delta *= -1;
        }
        this.slider.setValue(oldValue + delta);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.mlstnr = new SliderMouseListener();
        this.klstnr = new SliderKeyListener();
        this.slider = (JSlider)c;
        this.slider.addMouseListener(this.mlstnr);
        this.slider.addMouseMotionListener(this.mlstnr);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.slider.removeMouseListener(this.mlstnr);
        this.slider.removeMouseMotionListener(this.mlstnr);
    }

    public void paintThumb(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.translate(this.thumbRect.x, this.thumbRect.y);
        graphics.transform(AffineTransform.getScaleInstance(2.0, 2.0));
        if (this.slider.getOrientation() == 0) {
            MetalSliderUI.horizThumbIcon.paintIcon(this.slider, g, 1, 0);
        } else {
            MetalSliderUI.vertThumbIcon.paintIcon(this.slider, g, 0, 1);
        }
        graphics.transform(AffineTransform.getScaleInstance(0.5, 0.5));
        graphics.translate(-this.thumbRect.x, -this.thumbRect.y);
    }

    protected Dimension getThumbSize() {
        Dimension size = super.getThumbSize();
        size.width = 2 * size.width + 2;
        size.height = 2 * size.height + 2;
        return size;
    }

    public static void main(String[] argv) throws Exception {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        JSlider slider = new JSlider();
        p.add(slider);
        slider.setUI(new PenSliderUI());
        slider.setPaintTicks(true);
        slider.setInverted(true);
        slider = new JSlider();
        p.add(slider);
        slider.setUI(new PenSliderUI());
        slider.setOrientation(1);
        slider.setSnapToTicks(true);
        slider.setMajorTickSpacing(25);
        slider.setPaintTicks(true);
        slider.setInverted(true);
        f.getContentPane().add(p);
        f.setSize(300, 300);
        f.setVisible(true);
    }

    class SliderKeyListener
    implements KeyListener {
        SliderKeyListener() {
        }

        public void keyPressed(KeyEvent evt) {
            int val = 1;
            if (PenSliderUI.this.slider.getInverted()) {
                val = -1;
            }
            switch (evt.getKeyCode()) {
                case 33: 
                case 38: 
                case 39: {
                    PenSliderUI.this.scroll(val);
                    break;
                }
                case 34: 
                case 37: 
                case 40: {
                    PenSliderUI.this.scroll(-val);
                }
            }
        }

        public void keyReleased(KeyEvent evt) {
        }

        public void keyTyped(KeyEvent evt) {
        }
    }

    class SliderMouseListener
    implements MouseListener,
    MouseMotionListener {
        SliderMouseListener() {
        }

        private void calculatePercentage(MouseEvent evt) {
            double percent;
            int min = PenSliderUI.this.slider.getMinimum();
            int max = PenSliderUI.this.slider.getMaximum();
            Rectangle bounds = PenSliderUI.this.slider.getBounds();
            PenSliderUI.this.slider.setValueIsAdjusting(true);
            if (PenSliderUI.this.slider.getOrientation() == 1) {
                int y1 = bounds.y;
                int y2 = bounds.y + bounds.height;
                percent = (double)(evt.getY() - y1) / (double)(y2 - y1);
            } else {
                int x1 = bounds.x;
                int x2 = bounds.x + bounds.width;
                percent = 1.0 - (double)(evt.getX() - x1) / (double)(x2 - x1);
            }
            if (!PenSliderUI.this.slider.getInverted()) {
                percent = 1.0 - percent;
            }
            PenSliderUI.this.slider.setValueIsAdjusting(false);
            PenSliderUI.this.slider.setValue((int)(percent * (double)(max - min)));
        }

        public void mouseReleased(MouseEvent evt) {
            this.calculatePercentage(evt);
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseMoved(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseDragged(MouseEvent evt) {
        }
    }
}

