/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectImpl;
import edu.berkeley.guir.lib.satin.objects.Style;
import edu.berkeley.guir.lib.satin.view.View;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class ViewHandler
implements SatinConstants,
Serializable,
Cloneable {
    static final long serialVersionUID = 2848203958293850059L;
    GraphicalObjectImpl attach;
    Style style;
    AffineTransform txNormalize;
    View v;

    private ViewHandler() {
        this.initialize();
    }

    public ViewHandler(GraphicalObjectImpl gob) {
        this.attach = gob;
        this.initialize();
    }

    public ViewHandler(ViewHandler viewHandler) {
        this.attach = viewHandler.attach;
        this.style = (Style)viewHandler.style.clone();
        this.txNormalize = (AffineTransform)viewHandler.txNormalize.clone();
        this.v = (View)viewHandler.v.clone();
    }

    private void initialize() {
        this.style = new Style();
        this.txNormalize = new AffineTransform();
    }

    public GraphicalObject setAttachedGraphicalObject(GraphicalObjectImpl gob) {
        this.attach = gob;
        this.v.setAttachedGraphicalObject(gob);
        return gob;
    }

    public void setView(View v) {
        this.v = v;
        v.setAttachedGraphicalObject(this.attach);
    }

    public View getView() {
        return this.v;
    }

    public void setVisible(boolean flag) {
        this.v.setVisible(flag);
    }

    public boolean isVisible() {
        return this.v.isVisible();
    }

    public Style setStyle(Style newStyle) {
        try {
            this.style = (Style)newStyle.clone();
        }
        catch (Exception e) {
            Debug.println(e);
        }
        return newStyle;
    }

    public Style getStyle() {
        return (Style)this.style.clone();
    }

    public Style getStyleRef() {
        return this.style;
    }

    public boolean isNormalized() {
        return this.v.getBoundingPoints2DRef().isNormalized();
    }

    public Point2D normalizeBoundingPoints() {
        if (this.isNormalized()) {
            return null;
        }
        Point2D pt = this.v.getBoundingPoints2DRef().normalize();
        this.setNormalizingTransform(AffineTransform.getTranslateInstance(-pt.getX(), -pt.getY()));
        return pt;
    }

    public AffineTransform getNormalizingTransform() {
        return this.txNormalize;
    }

    public AffineTransform applyNormalizingTransform(AffineTransform newTx) {
        this.txNormalize.preConcatenate(newTx);
        return newTx;
    }

    public AffineTransform setNormalizingTransform(AffineTransform newTx) {
        AffineTransform txTmp = this.attach.getTransformRef();
        try {
            AffineTransform txInverse = this.txNormalize.createInverse();
            txInverse.preConcatenate(txTmp);
        }
        catch (Exception e) {
            Debug.println(e);
        }
        txTmp.concatenate(newTx);
        this.attach.setTransformInternal(txTmp);
        this.txNormalize = (AffineTransform)newTx.clone();
        return newTx;
    }

    public void clearNormalizingTransform() {
        if (!this.txNormalize.isIdentity()) {
            this.txNormalize.setToIdentity();
        }
    }

    public void setViewBoundingPoints2D(Shape s) {
        this.v.setBoundingPoints2DRef(new Polygon2D(s));
        this.normalizeBoundingPoints();
    }

    public void setViewBoundingPoints2D(Polygon2D newPoly) {
        this.v.setBoundingPoints2DRef(new Polygon2D(newPoly));
        this.normalizeBoundingPoints();
    }

    public void setViewBoundingPoints2DRef(Polygon2D newPoly) {
        this.v.setBoundingPoints2DRef(newPoly);
    }

    public Polygon2D getViewBoundingPoints2D() {
        return new Polygon2D(this.v.getBoundingPoints2DRef());
    }

    public Polygon2D getViewBoundingPoints2DRef() {
        return this.v.getBoundingPoints2DRef();
    }

    public boolean setHasClosedBoundingPoints(boolean flag) {
        this.v.getBoundingPoints2DRef().setClosed(flag);
        return flag;
    }

    public boolean hasClosedBoundingPoints() {
        return this.v.getBoundingPoints2DRef().isClosed();
    }

    public void render(SatinGraphics g) {
        if (this.isVisible()) {
            this.v.render(g);
        }
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append("bounds: " + this.getViewBoundingPoints2DRef());
        strbuf.append("\nstyle:  " + this.getStyleRef());
        strbuf.append("\nview:   " + this.getView());
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public Object clone() {
        return new ViewHandler(this);
    }
}

