/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectImpl;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class SwingPeer
extends GraphicalObjectImpl {
    protected JComponent mRealCom = null;
    private AffineTransform mTrans = null;
    private Rectangle2D mIdealRect = null;
    private String mPeerID = new String();
    private static long peerCount = 0L;
    private Rectangle mLatestBounds = null;

    public SwingPeer(JComponent com) {
        this.mRealCom = com;
        this.setBoundingPoints2D(11, com.getBounds());
        this.mIdealRect = new Rectangle2D.Double(0.0, 0.0, com.getBounds().getWidth(), com.getBounds().getHeight());
        this.mPeerID = String.valueOf(this.mPeerID) + ++peerCount;
        this.mRealCom.setName(this.mPeerID);
    }

    public String getName() {
        return this.mPeerID;
    }

    public JComponent getRealComponent() {
        return this.mRealCom;
    }

    public void defaultRender(SatinGraphics sg) {
        if (sg.getIssuer().equals("sheet") && this.mTrans != sg.getTransform()) {
            this.mTrans = (AffineTransform)sg.getTransform().clone();
            Rectangle2D rect = GeomLib.transformRectangle(this.mTrans, this.mIdealRect);
            this.mLatestBounds = rect.getBounds();
            Rectangle box = new Rectangle((int)rect.getMinX(), (int)rect.getMinY(), (int)rect.getWidth(), (int)rect.getHeight());
            Rectangle parentBounds = this.mRealCom.getParent().getBounds();
            if (box.getMaxX() <= 10.0 || box.getMinX() >= parentBounds.getMaxX() - 10.0 || box.getMinY() >= parentBounds.getMaxY() - 10.0 || box.getMaxY() <= 10.0) {
                this.mRealCom.setVisible(false);
            } else {
                this.mRealCom.setVisible(true);
                this.mRealCom.setBounds((int)box.getMinX(), (int)box.getMinY(), (int)box.getWidth(), (int)box.getHeight());
            }
        }
    }

    public Rectangle getLatestBounds() {
        return this.mLatestBounds;
    }

    public void setSize(double w, double h) {
        this.setBoundingPoints2D(10, new Rectangle2D.Double(this.getBounds2D(10).getMinX(), this.getBounds2D(10).getMinY(), w, h));
        this.mIdealRect = new Rectangle2D.Double(0.0, 0.0, w, h);
    }

    public void delete() {
        super.delete();
        Container co = this.mRealCom.getParent();
        if (co != null) {
            co.remove(this.mRealCom);
        }
    }

    public void setVisible(boolean b) {
        this.mRealCom.setVisible(b);
        super.setVisible(b);
    }
}

