/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.util.ParserLib;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;

public class Style
implements SatinConstants,
Serializable,
Cloneable {
    static final long serialVersionUID = 8995939835246826178L;
    public static final byte TRANSPARENT = 0;
    public static final byte DRAW_CLEAR = 0;
    public static final byte DRAW_SET = 1;
    public static final byte DRAW_COPY = 2;
    public static final byte DRAW_NOOP = 3;
    public static final byte DRAW_COPYINVERTED = 4;
    public static final byte DRAW_INVERT = 5;
    public static final byte DRAW_OR = 6;
    public static final byte DRAW_AND = 7;
    public static final byte DRAW_XOR = 8;
    public static final byte DRAW_EQUIV = 9;
    public static final byte DRAW_NAND = 10;
    public static final byte DRAW_NOR = 11;
    public static final byte DRAW_ANDINVERTED = 12;
    public static final byte DRAW_ANDREVERSE = 13;
    public static final byte DRAW_ORINVERTED = 14;
    public static final byte DRAW_ORREVERSE = 15;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    public static final int JOIN_BEVEL = 2;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    private static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    private static Class baseClass = null;
    private Color fillColor = Color.gray;
    private Color drawColor = Color.black;
    private Color fontColor = Color.black;
    private Font drawFont = DEFAULT_FONT;
    private SatinStroke drawStroke = new SatinStroke();

    static {
        SatinConstants.glprops.setProperty("SATIN_DATA_DIRECTORY_GPROPERTY", "data/");
    }

    public Style() {
    }

    public Style(Style s) {
        this.setDrawStroke(s.getDrawStroke());
        this.setDrawColor(s.getDrawColor());
        this.setFillColor(s.getFillColor());
        this.setFontColor(s.getFontColor());
        this.setDrawFont(s.getDrawFont());
    }

    public Style(String strFileName) {
        this(strFileName, new Style());
    }

    public Style(String strFileName, Style defaults) {
        this(defaults);
        try {
            Debug.println("Loading style properties file " + SatinConstants.glprops.getProperty("SATIN_DATA_DIRECTORY_GPROPERTY") + strFileName);
            InputStream istream = null;
            if (baseClass != null) {
                istream = baseClass.getResourceAsStream(SatinConstants.glprops.getProperty("SATIN_DATA_DIRECTORY_GPROPERTY") + strFileName);
            }
            if (istream == null) {
                istream = new FileInputStream(String.valueOf((String)SatinConstants.glprops.getProperty("SATIN_DATA_DIRECTORY_GPROPERTY")) + strFileName);
            }
            Properties props = this.readProperties(istream);
            this.setProperties(props);
        }
        catch (FileNotFoundException e) {
            Debug.println("Error finding file - using defaults instead");
        }
    }

    public Style(Properties props) {
        this.setProperties(props);
    }

    private Properties readProperties(InputStream istream) {
        Properties props = new Properties();
        try {
            props.load(istream);
        }
        catch (IOException e) {
            Debug.println("Error reading file - using defaults");
            Debug.println(e);
        }
        return props;
    }

    private void setProperties(Properties props) {
        this.handleLineWidth(props.getProperty("LineWidth"));
        this.handleDrawFont(props.getProperty("DrawFont"));
        this.handleDrawColor(props.getProperty("DrawColor"));
        this.handleDrawTransparency(props.getProperty("DrawTransparency"));
        this.handleFillColor(props.getProperty("FillColor"));
        this.handleFillTransparency(props.getProperty("FillTransparency"));
        this.handleEndCap(props.getProperty("EndCap"));
        this.handleLineJoin(props.getProperty("LineJoin"));
        this.handleMiterLimit(props.getProperty("MiterLimit"));
        this.handleDashPhase(props.getProperty("DashPhase"));
        this.handleDashArray(props.getProperty("DashArray"));
    }

    private void handleDrawColor(String str) {
        if (str == null || str.equals("")) {
            return;
        }
        try {
            Color newColor = ParserLib.parseColor(str);
            this.setDrawColor(newColor);
        }
        catch (Exception e) {
            Debug.println("Error parsing draw color - using default value");
        }
    }

    private void handleFillColor(String str) {
        if (str == null || str.equals("")) {
            return;
        }
        try {
            Color newColor = ParserLib.parseColor(str);
            this.setFillColor(newColor);
        }
        catch (Exception e) {
            Debug.println("Error parsing fill color - using default value");
        }
    }

    private void handleDrawFont(String str) {
        if (str == null || str.equals("")) {
            return;
        }
        Font font = Font.decode(str);
        if (font == null) {
            Debug.println("Error parsing draw font - using default value");
        } else {
            this.setDrawFont(font);
        }
    }

    private void handleFillTransparency(String str) {
        this.handleFloat(new HandleFillTransparency(), str);
    }

    private void handleDrawTransparency(String str) {
        this.handleFloat(new HandleDrawTransparency(), str);
    }

    private void handleMiterLimit(String str) {
        this.handleFloat(new HandleMiterLimit(), str);
    }

    private void handleLineWidth(String str) {
        this.handleFloat(new HandleLineWidth(), str);
    }

    private void handleDashPhase(String str) {
        this.handleFloat(new HandleDashPhase(), str);
    }

    private void handleDashArray(String str) {
        if (str == null || str.equals("")) {
            return;
        }
        try {
            float[] fArray = ParserLib.parseFloatArray(str);
            this.setDashArray(fArray);
        }
        catch (Exception e) {
            Debug.println("Error parsing dash array - using default value");
        }
    }

    private void handleEndCap(String str) {
        if (str == null || str.equals("")) {
            return;
        }
        if (str.equalsIgnoreCase("butt")) {
            this.setEndCap(0);
            return;
        }
        if (str.equalsIgnoreCase("round")) {
            this.setEndCap(1);
            return;
        }
        if (str.equalsIgnoreCase("square")) {
            this.setEndCap(2);
            return;
        }
        Debug.println("Error parsing end cap - using default value");
    }

    private void handleLineJoin(String str) {
        if (str == null || str.equals("")) {
            return;
        }
        if (str.equalsIgnoreCase("miter")) {
            this.setLineJoin(0);
            return;
        }
        if (str.equalsIgnoreCase("round")) {
            this.setLineJoin(1);
            return;
        }
        if (str.equalsIgnoreCase("bevel")) {
            this.setLineJoin(2);
            return;
        }
        Debug.println("Error parsing end cap - using default value");
    }

    private void handleFloat(ParseFloat strategy, String str) {
        if (str == null || str.equals("")) {
            return;
        }
        try {
            float f = Float.valueOf(str).floatValue();
            strategy.setStyleValue(f);
        }
        catch (Exception e) {
            Debug.println("Error parsing " + strategy.getName() + " - using default value");
        }
    }

    public static Class getPropertiesBaseLocation() {
        return baseClass;
    }

    public static void setPropertiesBaseLocation(Class newBaseClass) {
        baseClass = newBaseClass;
    }

    public BasicStroke getDrawStroke() {
        return this.drawStroke;
    }

    public float[] getDashArray() {
        float[] fArray = this.drawStroke.getDashArray();
        float[] fArrayReturn = new float[fArray.length];
        int i = 0;
        while (i < fArray.length) {
            fArrayReturn[i] = fArray[i];
            ++i;
        }
        return fArrayReturn;
    }

    private float[] getDashArrayImpl() {
        return this.drawStroke.getDashArray();
    }

    public float getDashPhase() {
        return this.drawStroke.getDashPhase();
    }

    public int getEndCap() {
        return this.drawStroke.getEndCap();
    }

    public int getLineJoin() {
        return this.drawStroke.getLineJoin();
    }

    public float getLineWidth() {
        return this.drawStroke.getLineWidth();
    }

    public float getMiterLimit() {
        return this.drawStroke.getMiterLimit();
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public Font getDrawFont() {
        return this.drawFont;
    }

    public String getDrawFontName() {
        return this.drawFont.getFontName();
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setDrawStroke(BasicStroke s) {
        this.drawStroke = new SatinStroke(s);
    }

    public void setDashArray(float[] fArray) {
        this.drawStroke = new SatinStroke(this.getLineWidth(), this.getEndCap(), this.getLineJoin(), this.getMiterLimit(), fArray, this.getDashPhase());
    }

    public void setDashPhase(float newDashPhase) {
        this.drawStroke = new SatinStroke(this.getLineWidth(), this.getEndCap(), this.getLineJoin(), this.getMiterLimit(), this.getDashArrayImpl(), newDashPhase);
    }

    public void setEndCap(int newEndCap) {
        this.drawStroke = new SatinStroke(this.getLineWidth(), newEndCap, this.getLineJoin(), this.getMiterLimit(), this.getDashArrayImpl(), this.getDashPhase());
    }

    public void setLineJoin(int newLineJoin) {
        this.drawStroke = new SatinStroke(this.getLineWidth(), this.getEndCap(), newLineJoin, this.getMiterLimit(), this.getDashArrayImpl(), this.getDashPhase());
    }

    public void setLineWidth(float newLineWidth) {
        this.drawStroke = new SatinStroke(newLineWidth, this.getEndCap(), this.getLineJoin(), this.getMiterLimit(), this.getDashArrayImpl(), this.getDashPhase());
    }

    public void setMiterLimit(float newMiterLimit) {
        this.drawStroke = new SatinStroke(this.getLineWidth(), this.getEndCap(), this.getLineJoin(), newMiterLimit, this.getDashArrayImpl(), this.getDashPhase());
    }

    public void setDrawFont(Font newFont) {
        this.drawFont = newFont;
    }

    public void setFontColor(Color newColor) {
        this.fontColor = newColor;
    }

    public void setDrawColor(Color newColor) {
        this.drawColor = newColor;
    }

    public void setDrawColorHSV(float h, float s, float v) {
        this.drawColor = new Color(Color.HSBtoRGB(h, s, v));
    }

    public void setDrawColorRGBA(int r, int g, int b, int a) {
        this.drawColor = new Color(r, g, b, a);
    }

    public void setDrawColorRGBA(float r, float g, float b, float a) {
        int rr = (int)(r * 255.0f);
        int gg = (int)(g * 255.0f);
        int bb = (int)(b * 255.0f);
        int aa = (int)(a * 255.0f);
        this.setDrawColorRGBA(rr, gg, bb, aa);
    }

    public void setDrawTransparency(float aa) {
        this.setDrawTransparency((int)(aa * 255.0f));
    }

    public void setDrawTransparency(int aa) {
        int rr = this.drawColor.getRed();
        int gg = this.drawColor.getGreen();
        int bb = this.drawColor.getBlue();
        this.setDrawColorRGBA(rr, gg, bb, aa);
    }

    public void setFillColor(Color newColor) {
        this.fillColor = newColor;
    }

    public void setFillColorHSV(float h, float s, float v) {
        this.fillColor = new Color(Color.HSBtoRGB(h, s, v));
    }

    public void setFillColorRGBA(int r, int g, int b, int a) {
        this.fillColor = new Color(r, g, b, a);
    }

    public void setFillColorRGBA(float r, float g, float b, float a) {
        int rr = (int)(r * 255.0f);
        int gg = (int)(g * 255.0f);
        int bb = (int)(b * 255.0f);
        int aa = (int)(a * 255.0f);
        this.setFillColorRGBA(rr, gg, bb, aa);
    }

    public void setFillTransparency(float aa) {
        this.setFillTransparency((int)(255.0f * aa));
    }

    public void setFillTransparency(int aa) {
        int rr = this.fillColor.getRed();
        int gg = this.fillColor.getGreen();
        int bb = this.fillColor.getBlue();
        this.setFillColorRGBA(rr, gg, bb, aa);
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        new StringBuffer();
        strbuf.append("FillColor:      " + this.fillColor + "\n");
        strbuf.append("DrawColor:      " + this.drawColor + "\n");
        strbuf.append("DrawFont:       " + this.drawFont + "\n");
        strbuf.append("DrawStroke:     " + StringLib.toString(this.drawStroke));
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public Object clone() {
        Style newStyle = new Style(this);
        return newStyle;
    }

    public static void main(String[] argv) {
        System.out.println(new Style());
        System.out.println(new Style("SampleStyle.properties"));
    }

    final class SatinStroke
    extends BasicStroke
    implements Serializable {
        public SatinStroke() {
        }

        public SatinStroke(float width) {
            super(width);
        }

        public SatinStroke(float width, int cap, int join) {
            super(width, cap, join);
        }

        public SatinStroke(float width, int cap, int join, float miterlimit) {
            super(width, cap, join, miterlimit);
        }

        public SatinStroke(float width, int cap, int join, float miterlimit, float[] dash, float dash_phase) {
            super(width, cap, join, miterlimit, dash, dash_phase);
        }

        public SatinStroke(BasicStroke stk) {
            super(stk.getLineWidth(), stk.getEndCap(), stk.getLineJoin(), stk.getMiterLimit(), stk.getDashArray(), stk.getDashPhase());
        }

        public Shape createStrokedShape(Shape s) {
            return super.createStrokedShape(s);
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public float[] getDashArray() {
            return super.getDashArray();
        }

        public float getDashPhase() {
            return super.getDashPhase();
        }

        public int getEndCap() {
            return super.getEndCap();
        }

        public int getLineJoin() {
            return super.getLineJoin();
        }

        public float getLineWidth() {
            return super.getLineWidth();
        }

        public float getMiterLimit() {
            return super.getMiterLimit();
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    abstract class ParseFloat {
        ParseFloat() {
        }

        public abstract void setStyleValue(float var1);

        public abstract String getName();
    }

    class HandleDashPhase
    extends ParseFloat {
        HandleDashPhase() {
        }

        public final void setStyleValue(float val) {
            Style.this.setDashPhase(val);
        }

        public final String getName() {
            return "Miter Limit";
        }
    }

    class HandleMiterLimit
    extends ParseFloat {
        HandleMiterLimit() {
        }

        public final void setStyleValue(float val) {
            Style.this.setMiterLimit(val);
        }

        public final String getName() {
            return "Miter Limit";
        }
    }

    class HandleLineWidth
    extends ParseFloat {
        HandleLineWidth() {
        }

        public final void setStyleValue(float val) {
            Style.this.setLineWidth(val);
        }

        public final String getName() {
            return "Line Width";
        }
    }

    class HandleDrawTransparency
    extends ParseFloat {
        HandleDrawTransparency() {
        }

        public final void setStyleValue(float val) {
            Style.this.setDrawTransparency(val);
        }

        public final String getName() {
            return "Draw Transparency";
        }
    }

    class HandleFillTransparency
    extends ParseFloat {
        HandleFillTransparency() {
        }

        public final void setStyleValue(float val) {
            Style.this.setFillTransparency(val);
        }

        public final String getName() {
            return "Fill Transparency";
        }
    }
}

