/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.satin.objects.StickyGraphicalObjectWrapper;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class StickyXYGraphicalObjectWrapper
extends StickyGraphicalObjectWrapper {
    double stickyX;
    double stickyY;

    public void setStickyLocation(double newX, double newY) {
        this.stickyX = newX;
        this.stickyY = newY;
    }

    protected AffineTransform getStickyTransform(AffineTransform tx) {
        this.getUnstickyTransform(12, tx);
        Point2D pt = AffineTransformLib.getTranslateFactor(tx);
        double dx = this.stickyX - pt.getX();
        double dy = this.stickyY - pt.getY();
        tx.translate(dx, dy);
        return tx;
    }

    public Object clone() {
        StickyXYGraphicalObjectWrapper c = new StickyXYGraphicalObjectWrapper();
        this.clone(c);
        return c;
    }

    public StickyXYGraphicalObjectWrapper clone(StickyXYGraphicalObjectWrapper c) {
        super.clone(c);
        c.stickyX = this.stickyX;
        c.stickyY = this.stickyY;
        return c;
    }

    public Object deepClone() {
        StickyXYGraphicalObjectWrapper c = new StickyXYGraphicalObjectWrapper();
        this.deepClone(c);
        return c;
    }

    public StickyXYGraphicalObjectWrapper deepClone(StickyXYGraphicalObjectWrapper c) {
        super.deepClone(c);
        c.stickyX = this.stickyX;
        c.stickyY = this.stickyY;
        return c;
    }
}

