/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.LineArrow;
import edu.berkeley.guir.lib.satin.objects.Style;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class StickyLineArrow
extends LineArrow {
    Style stickyStyle = new Style();

    public StickyLineArrow() {
    }

    public StickyLineArrow(Point2D ptStart, Point2D ptEnd) {
        super(ptStart, ptEnd);
    }

    public StickyLineArrow(float x1, float y1, float x2, float y2) {
        super(x1, y1, x2, y2);
    }

    public StickyLineArrow(GraphicalObject gobStart, GraphicalObject gobEnd) {
        super(gobStart, gobEnd);
    }

    protected void updateStyle() {
        AffineTransform tx = this.getTransform(12);
        double curScale = AffineTransformLib.getScaleFactor(tx);
        Style s = super.getStyleRef();
        if (this.stickyStyle == null) {
            this.stickyStyle = new Style();
        }
        s.setLineWidth((float)((double)this.stickyStyle.getLineWidth() / curScale));
        s.setFillColor(this.stickyStyle.getFillColor());
        s.setDrawColor(this.stickyStyle.getFillColor());
    }

    public Style getStickyStyleRef() {
        return this.stickyStyle;
    }

    public Style setStyle(Style newStyle) {
        this.stickyStyle = newStyle;
        return newStyle;
    }

    public Style getStyle() {
        this.updateStyle();
        return super.getStyle();
    }

    public Style getStyleRef() {
        this.updateStyle();
        return super.getStyleRef();
    }

    protected void updateArrowHeadAngle() {
        super.updateArrowHeadAngle();
        AffineTransform tx = this.getTransform(12);
        double curScale = AffineTransformLib.getScaleFactor(tx);
        float dstScale = 1.0f + 0.1f * this.getStickyStyleRef().getLineWidth();
        this.txArrowHead.scale((double)dstScale / curScale, (double)dstScale / curScale);
    }

    protected void updateBounds() {
        this.clearPoints();
        this.addPoint(this.ptStart);
        this.addPoint(this.ptEnd);
        this.setArrowHeadVector(this.ptEnd.getX() - this.ptStart.getX(), this.ptEnd.getY() - this.ptStart.getY());
        this.updateArrowHeadAngle();
    }

    protected void defaultRender(SatinGraphics g) {
        this.updateStyle();
        this.updateArrowHeadAngle();
        super.defaultRender(g);
    }

    protected StickyLineArrow clone(StickyLineArrow newArrow) {
        super.clone(newArrow);
        return newArrow;
    }

    protected StickyLineArrow deepClone(StickyLineArrow newArrow) {
        super.clone(newArrow);
        return newArrow;
    }

    public static void main(String[] argv) {
    }
}

