/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectWrapper;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class StickyGraphicalObjectWrapper
extends GraphicalObjectWrapper {
    AffineTransform txSticky = new AffineTransform();
    boolean flagUseSticky = true;

    public StickyGraphicalObjectWrapper() {
        this.id = GraphicalObjectLib.getUniqueID();
    }

    public StickyGraphicalObjectWrapper(GraphicalObject gob) {
        this();
        this.setGraphicalObject(gob);
    }

    public void applyTransform(AffineTransform newTx) {
        AffineTransform txTmp = (AffineTransform)SatinConstants.poolTx.getObject();
        this.updateStickyTransform();
        GeomLib.calcPassthrough(newTx, this.txSticky, txTmp);
        this.gob.applyTransform(txTmp);
        SatinConstants.poolTx.releaseObject(txTmp);
    }

    public void setTransform(AffineTransform newTx) {
        AffineTransform txTmp = (AffineTransform)SatinConstants.poolTx.getObject();
        this.updateStickyTransform();
        GeomLib.calcPassthrough(newTx, this.txSticky, txTmp);
        this.gob.setTransform(txTmp);
        SatinConstants.poolTx.releaseObject(txTmp);
    }

    public AffineTransform getTransformRef() {
        return this.getTransform(11);
    }

    public AffineTransform getTransform(int cdsys) {
        return this.getTransform(cdsys, null);
    }

    public AffineTransform getTransform(int cdsys, AffineTransform outTx) {
        this.updateStickyTransform();
        if (outTx == null) {
            outTx = new AffineTransform();
        }
        switch (cdsys) {
            case 10: {
                outTx.setToIdentity();
                break;
            }
            case 11: {
                outTx.setTransform(this.txSticky);
                outTx.concatenate(this.gob.getTransformRef());
                break;
            }
            case 12: {
                outTx.setTransform(this.txSticky);
                outTx.concatenate(this.gob.getTransformRef());
                GraphicalObject gob = this;
                while ((gob = gob.getParentGroup()) != null) {
                    outTx.preConcatenate(gob.getTransformRef());
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid coordinate system value");
            }
        }
        return outTx;
    }

    public AffineTransform getInverseTransform(int cdsys) {
        return this.getInverseTransform(cdsys, null);
    }

    public AffineTransform getInverseTransform(int cdsys, AffineTransform outTx) {
        if (outTx == null) {
            outTx = new AffineTransform();
        }
        outTx = this.getTransform(cdsys, outTx);
        try {
            outTx.setTransform(outTx.createInverse());
        }
        catch (Exception e) {
            Debug.println("This should never really happen");
        }
        return outTx;
    }

    public Point2D getLocation2D(int cdsys) {
        return this.getLocation2D(cdsys, null, null);
    }

    public Point2D getLocation2D(int cdsys, AffineTransform tx, Point2D pt) {
        Rectangle2D tmpRect = (Rectangle2D)SatinConstants.poolRects.getObject();
        tmpRect = this.getBounds2D(cdsys, tx, tmpRect);
        if (pt == null) {
            pt = new Point2D.Float();
        }
        if (tx != null) {
            tx.transform(pt, pt);
        }
        pt.setLocation(tmpRect.getX(), tmpRect.getY());
        SatinConstants.poolRects.releaseObject(tmpRect);
        return pt;
    }

    public Rectangle2D getBounds2D(int cdsys) {
        return this.getBounds2D(cdsys, null, null);
    }

    public Rectangle2D getBounds2D(int cdsys, AffineTransform tx, Rectangle2D rect) {
        Polygon2D tmpPoly = (Polygon2D)SatinConstants.poolPolys.getObject();
        tmpPoly = this.getBoundingPoints2D(cdsys, tx, tmpPoly);
        if (rect == null) {
            rect = new Rectangle2D.Float();
        }
        if (tx != null) {
            tmpPoly.transform(tx);
        }
        rect.setRect(tmpPoly.getBounds2D());
        SatinConstants.poolPolys.releaseObject(tmpPoly);
        return rect;
    }

    public Polygon2D getBoundingPoints2D(int cdsys) {
        return this.getBoundingPoints2D(cdsys, null, null);
    }

    public Polygon2D getBoundingPoints2D(int cdsys, AffineTransform tx, Polygon2D poly) {
        AffineTransform txTmp = (AffineTransform)SatinConstants.poolTx.getObject();
        if (poly == null) {
            poly = new Polygon2D();
        }
        this.gob.getBoundingPoints2D(cdsys, null, poly);
        switch (cdsys) {
            case 10: {
                txTmp = this.txSticky;
                poly.transform(txTmp);
                break;
            }
            case 11: 
            case 12: {
                this.getTransform(cdsys, txTmp);
                poly.transform(txTmp);
                break;
            }
            default: {
                throw new RuntimeException("Invalid coordinate system value");
            }
        }
        if (tx != null) {
            poly.transform(tx);
        }
        SatinConstants.poolTx.releaseObject(txTmp);
        return poly;
    }

    public float getWidth2D(int cdsys) {
        return (float)this.getBounds2D(cdsys).getWidth();
    }

    public float getHeight2D(int cdsys) {
        return (float)this.getBounds2D(cdsys).getHeight();
    }

    public void moveTo(int cdsys, double x, double y) {
        this.updateStickyTransform();
        this.gob.moveTo(cdsys, x, y);
    }

    public void moveTo(int cdsys, Point2D pt) {
        this.updateStickyTransform();
        this.gob.moveTo(cdsys, pt);
    }

    public void moveBy(int cdsys, double dx, double dy) {
        this.updateStickyTransform();
        this.gob.moveBy(cdsys, dx, dy);
    }

    public void moveBy(int cdsys, Point2D pt) {
        this.updateStickyTransform();
        this.gob.moveBy(cdsys, pt);
    }

    public void setBoundingPoints2D(int cdsys, Shape s) {
        this.updateStickyTransform();
        this.gob.setBoundingPoints2D(cdsys, s);
    }

    public void render(SatinGraphics g) {
        this.gob.render(g);
    }

    private AffineTransform updateStickyTransform() {
        if (this.flagUseSticky) {
            this.getStickyTransform(this.txSticky);
        } else {
            this.txSticky.setToIdentity();
        }
        return this.txSticky;
    }

    protected abstract AffineTransform getStickyTransform(AffineTransform var1);

    protected AffineTransform getUnstickyTransform(int cdsys, AffineTransform tx) {
        this.flagUseSticky = false;
        this.getTransform(cdsys, tx);
        this.flagUseSticky = true;
        return tx;
    }

    protected StickyGraphicalObjectWrapper clone(StickyGraphicalObjectWrapper c) {
        super.clone(c);
        return c;
    }

    protected StickyGraphicalObjectWrapper deepClone(StickyGraphicalObjectWrapper c) {
        super.deepClone(c);
        return c;
    }
}

