/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.objects.LineArrow;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class SnappingLineArrow
extends LineArrow {
    private boolean isDisplaced = false;
    private SnapMap startSnapMap = new SnapMap();
    private SnapMap endSnapMap = new SnapMap();

    public SnappingLineArrow() {
    }

    public SnappingLineArrow(Point2D ptStart, Point2D ptEnd) {
        super(ptStart, ptEnd);
    }

    public SnappingLineArrow(float x1, float y1, float x2, float y2) {
        super(x1, y1, x2, y2);
    }

    public SnappingLineArrow(GraphicalObject gobStart, GraphicalObject gobEnd) {
        super(gobStart, gobEnd);
    }

    protected void calculateGraphicalObjectPoints() {
        if (!this.flagDirty) {
            return;
        }
        Point2D ptAA = this.getStartPoint(12);
        Point2D ptBB = this.getEndPoint(12);
        boolean flagSetAA = false;
        boolean flagSetBB = false;
        if (this.gobStart != null) {
            Rectangle2D bdsStart = this.gobStart.getBounds2D(12);
            this.startSnapMap = new SnapMap(bdsStart);
            if (this.isDisplaced) {
                this.startSnapMap.displace(true);
            }
            ptAA = new Point2D.Float((float)(bdsStart.getX() + bdsStart.getWidth() / 2.0), (float)(bdsStart.getY() + bdsStart.getHeight() / 2.0));
            flagSetAA = true;
        }
        if (this.gobEnd != null) {
            Rectangle2D bdsEnd = this.gobEnd.getBounds2D(12);
            this.endSnapMap = new SnapMap(bdsEnd);
            if (this.isDisplaced) {
                this.endSnapMap.displace(true);
            }
            ptBB = new Point2D.Float((float)(bdsEnd.getX() + bdsEnd.getWidth() / 2.0), (float)(bdsEnd.getY() + bdsEnd.getHeight() / 2.0));
            flagSetBB = true;
        }
        Line2D.Float line = new Line2D.Float(ptAA, ptBB);
        if (flagSetAA) {
            Polygon2D polyAA = this.gobStart.getBoundingPoints2D(12);
            List listAA = GeomLib.calcIntersectPoints(line, polyAA);
            this.ptStart = listAA.size() > 0 ? (Point2D)listAA.get(0) : ptAA;
            this.ptStart = this.startSnapMap.getStartSnapPoint(this.ptStart);
            GraphicalObjectLib.absoluteToLocal(this, this.ptStart, this.ptStart);
        }
        if (flagSetBB) {
            Polygon2D polyBB = this.gobEnd.getBoundingPoints2D(12);
            List listBB = GeomLib.calcIntersectPoints(line, polyBB);
            this.ptEnd = listBB.size() > 0 ? (Point2D)listBB.get(0) : ptBB;
            this.ptEnd = this.endSnapMap.getEndSnapPoint(this.ptEnd);
            GraphicalObjectLib.absoluteToLocal(this, this.ptEnd, this.ptEnd);
        }
        this.updateBounds();
        this.flagDirty = false;
    }

    public void setDisplaced(boolean b) {
        this.isDisplaced = b;
    }

    protected SnappingLineArrow clone(SnappingLineArrow newArrow) {
        super.clone(newArrow);
        newArrow.ptStart = new Point2D.Float((float)this.ptStart.getX(), (float)this.ptStart.getY());
        newArrow.ptEnd = new Point2D.Float((float)this.ptEnd.getX(), (float)this.ptEnd.getY());
        return newArrow;
    }

    protected SnappingLineArrow deepClone(SnappingLineArrow newArrow) {
        super.clone(newArrow);
        return newArrow;
    }

    class SnapMap {
        Point2D.Float A = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float B = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float C = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float D = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float E = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float F = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float G = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float H = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float P = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float Q = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float R = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float S = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float T = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float U = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float V = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float W = new Point2D.Float(0.0f, 0.0f);
        float X = 0.0f;
        float Y = 0.0f;
        float w = 0.0f;
        float h = 0.0f;
        boolean displaced = false;

        public SnapMap() {
            this.buildMap();
        }

        public SnapMap(Rectangle2D bounds) {
            this.X = (float)bounds.getX();
            this.Y = (float)bounds.getY();
            this.w = (float)bounds.getWidth();
            this.h = (float)bounds.getHeight();
            this.buildMap();
        }

        public void buildMap() {
            this.A = new Point2D.Float(this.X, this.Y);
            this.B = new Point2D.Float(this.X + this.w / 2.0f, this.Y);
            this.C = new Point2D.Float(this.X + this.w, this.Y);
            this.D = new Point2D.Float(this.X + this.w, this.Y + this.h / 2.0f);
            this.E = new Point2D.Float(this.X + this.w, this.Y + this.h);
            this.F = new Point2D.Float(this.X + this.w / 2.0f, this.Y + this.h);
            this.G = new Point2D.Float(this.X, this.Y + this.h);
            this.H = new Point2D.Float(this.X, this.Y + this.h / 2.0f);
            this.P = new Point2D.Float(this.X + this.w / 3.0f, this.Y);
            this.Q = new Point2D.Float(this.X + 2.0f * this.w / 3.0f, this.Y);
            this.R = new Point2D.Float(this.X + this.w, this.Y + this.h / 3.0f);
            this.S = new Point2D.Float(this.X + this.w, this.Y + 2.0f * this.h / 3.0f);
            this.T = new Point2D.Float(this.X + 2.0f * this.w / 3.0f, this.Y + this.h);
            this.U = new Point2D.Float(this.X + this.w / 3.0f, this.Y + this.h);
            this.V = new Point2D.Float(this.X, this.Y + 2.0f * this.h / 3.0f);
            this.W = new Point2D.Float(this.X, this.Y + this.h / 3.0f);
        }

        public Point2D getSnapPoint(Point2D pt2snap) {
            int id = this.getGridID((float)pt2snap.getX(), (float)pt2snap.getY());
            switch (id) {
                case 1: {
                    return this.A;
                }
                case 2: {
                    return this.B;
                }
                case 3: {
                    return this.C;
                }
                case 4: {
                    return this.D;
                }
                case 5: {
                    return this.E;
                }
                case 6: {
                    return this.F;
                }
                case 7: {
                    return this.G;
                }
                case 8: {
                    return this.H;
                }
            }
            return new Point2D.Float(0.0f, 0.0f);
        }

        public Point2D getStartSnapPoint(Point2D pt2snap) {
            if (!this.displaced) {
                return this.getSnapPoint(pt2snap);
            }
            int id = this.getGridID((float)pt2snap.getX(), (float)pt2snap.getY());
            switch (id) {
                case 1: {
                    return this.W;
                }
                case 2: {
                    return this.P;
                }
                case 3: {
                    return this.Q;
                }
                case 4: {
                    return this.R;
                }
                case 5: {
                    return this.S;
                }
                case 6: {
                    return this.T;
                }
                case 7: {
                    return this.U;
                }
                case 8: {
                    return this.V;
                }
            }
            return new Point2D.Float(0.0f, 0.0f);
        }

        public Point2D getEndSnapPoint(Point2D pt2snap) {
            if (!this.displaced) {
                return this.getSnapPoint(pt2snap);
            }
            int id = this.getGridID((float)pt2snap.getX(), (float)pt2snap.getY());
            switch (id) {
                case 1: {
                    return this.P;
                }
                case 2: {
                    return this.Q;
                }
                case 3: {
                    return this.R;
                }
                case 4: {
                    return this.S;
                }
                case 5: {
                    return this.T;
                }
                case 6: {
                    return this.U;
                }
                case 7: {
                    return this.V;
                }
                case 8: {
                    return this.W;
                }
            }
            return new Point2D.Float(0.0f, 0.0f);
        }

        public int getGridID(float x, float y) {
            if ((double)x < this.P.getX()) {
                if ((double)y < this.W.getY()) {
                    return 1;
                }
                if ((double)this.Y < this.V.getY()) {
                    return 8;
                }
                return 7;
            }
            if ((double)x < this.Q.getX()) {
                if ((double)y < this.W.getY()) {
                    return 2;
                }
                return 6;
            }
            if ((double)y < this.W.getY()) {
                return 3;
            }
            if ((double)this.Y < this.V.getY()) {
                return 4;
            }
            return 5;
        }

        public void displace(boolean b) {
            this.displaced = b;
        }
    }
}

