/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.command.InsertCommand;
import edu.berkeley.guir.lib.satin.event.BasicStrokeEventFilter;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.StrokeEventFilter;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.image.SatinImageLib;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroupImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.objects.Patch;
import edu.berkeley.guir.lib.satin.objects.Style;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import edu.berkeley.guir.lib.satin.view.StickyZViewWrapper;
import edu.berkeley.guir.lib.satin.watch.Watchable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class PatchImpl
extends GraphicalObjectGroupImpl
implements Patch {
    static final long serialVersionUID = 823824510587863981L;
    public static final String PATCH_STYLE_FILE = "Patch.properties";
    StrokeEventFilter addFilter;
    boolean flagDrawPatch = true;
    boolean flagFillPatch = true;
    boolean flagDrawChildren = true;
    protected BufferedImage externalCacheImage = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.satin.objects.PatchImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SatinConstants.clprops.setClassProperty(clazz, "STYLE", new Style(PATCH_STYLE_FILE));
    }

    public PatchImpl() {
        this.commonInitializations();
    }

    public PatchImpl(TimedStroke stk) {
        this(stk.getBoundingPoints2D(10));
        this.applyTransform(stk.getTransformRef());
        this.commonInitializations();
    }

    public PatchImpl(Shape s) {
        this(GraphicalObjectLib.convert(s));
        this.commonInitializations();
    }

    public PatchImpl(Rectangle2D r) {
        this.setBoundingPoints2D(11, r);
        this.commonInitializations();
    }

    public PatchImpl(Polygon2D newPoly) {
        this.setBoundingPoints2D(11, newPoly);
        this.commonInitializations();
    }

    public PatchImpl(Polygon newPoly) {
        this.setBoundingPoints2D(11, newPoly);
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.addFilter = new BasicStrokeEventFilter();
    }

    public void setAddLeftButtonStrokes(boolean flag) {
        this.addFilter.setAcceptLeftButton(flag);
    }

    public void setAddMiddleButtonStrokes(boolean flag) {
        this.addFilter.setAcceptMiddleButton(flag);
    }

    public void setAddRightButtonStrokes(boolean flag) {
        this.addFilter.setAcceptRightButton(flag);
    }

    public boolean isAddLeftButtonStrokes() {
        return this.addFilter.isLeftButtonAccepted();
    }

    public boolean isAddMiddleButtonStrokes() {
        return this.addFilter.isMiddleButtonAccepted();
    }

    public boolean isAddRightButtonStrokes() {
        return this.addFilter.isRightButtonAccepted();
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        if (!evt.isConsumed() && this.addFilter.isEventAccepted(evt)) {
            TimedStroke stk = evt.getStroke();
            InsertCommand cmd = new InsertCommand(this, stk);
            cmd.setAddPolicy(5);
            SatinConstants.cmdqueue.doCommand(cmd);
            evt.setConsumed();
            evt.setShouldRender(false);
        }
    }

    protected boolean shapeContainsInternal(Point2D pt) {
        return this.getLocalBoundingPoints2DRef().contains(pt);
    }

    protected boolean shapeContainsInternal(Shape s) {
        return GraphicalObjectLib.contains((Shape)this.getLocalBoundingPoints2DRef(), s);
    }

    protected boolean shapeIntersectsInternal(Shape s) {
        return GraphicalObjectLib.intersects((Shape)this.getLocalBoundingPoints2DRef(), s);
    }

    protected void updateGroupBounds(GraphicalObject gob) {
    }

    protected void updateGroupBounds() {
    }

    public void onNotify(Watchable w, Object arg) {
    }

    public void onUpdate(Watchable w, Object arg) {
    }

    public void onUpdate(Watchable w, String strProperty, Object oldVal, Object newVal) {
    }

    public void setDrawPatch(boolean flag) {
        this.flagDrawPatch = flag;
    }

    public void setFillPatch(boolean flag) {
        this.flagFillPatch = flag;
    }

    public void setDrawChildren(boolean flag) {
        this.flagDrawChildren = flag;
    }

    protected void renderChildren(SatinGraphics g) {
        super.defaultRender(g);
    }

    public void cacheImageTo(BufferedImage image) {
        this.externalCacheImage = image;
    }

    protected void defaultRender(SatinGraphics g) {
        if (this.externalCacheImage != null) {
            Graphics2D g2d = this.externalCacheImage.createGraphics();
            SatinGraphics newG = new SatinGraphics(g2d);
            Rectangle2D box = this.getBounds2D(10);
            newG.pushStyle(g.getStyle());
            newG.clearAllTransforms();
            Rectangle2D absBox = this.getBounds2D(12);
            newG.pushTransform(AffineTransform.getTranslateInstance(-absBox.getMinX(), -absBox.getMinY()));
            newG.pushTransform(g.getTransform());
            Shape oldClip = newG.getClip();
            newG.setClip(box);
            if (this.flagFillPatch) {
                newG.fill(this.getLocalBoundingPoints2DRef());
            }
            if (this.flagDrawPatch) {
                newG.draw(this.getLocalBoundingPoints2DRef());
            }
            if (this.flagDrawChildren) {
                this.renderChildren(newG);
            }
            newG.setClip(oldClip);
            newG.dispose();
        } else if (SatinImageLib.imageConvertingRender) {
            AffineTransform trans;
            Rectangle2D bounds = this.getLocalBoundingPoints2DRef().getBounds2D();
            bounds = GeomLib.transformRectangle(g.getGraphics().getTransform(), bounds);
            Color oldColor = g.getGraphics().getColor();
            Stroke oldStroke = g.getGraphics().getStroke();
            if (this.getPrintFill() != null) {
                g.getGraphics().setColor(this.getPrintFill());
                trans = g.getGraphics().getTransform();
                g.getGraphics().setTransform(AffineTransform.getTranslateInstance(0.0, 0.0));
                g.getGraphics().fill(bounds);
                g.getGraphics().setTransform(trans);
            }
            if (this.getPrintDraw() != null) {
                g.getGraphics().setColor(this.getPrintDraw());
                trans = g.getGraphics().getTransform();
                g.getGraphics().setTransform(AffineTransform.getTranslateInstance(0.0, 0.0));
                g.getGraphics().draw(bounds);
                g.getGraphics().setTransform(trans);
            }
            g.getGraphics().setColor(oldColor);
            g.getGraphics().setStroke(oldStroke);
            if (this.flagDrawChildren) {
                this.renderChildren(g);
            }
        } else {
            if (this.flagFillPatch) {
                g.fill(this.getLocalBoundingPoints2DRef());
            }
            if (this.flagDrawPatch) {
                g.draw(this.getLocalBoundingPoints2DRef());
            }
            if (this.flagDrawChildren) {
                this.renderChildren(g);
            }
        }
    }

    public Object clone() {
        return this.clone(new PatchImpl());
    }

    protected PatchImpl clone(PatchImpl p) {
        super.clone(p);
        p.flagDrawPatch = this.flagDrawPatch;
        p.flagFillPatch = this.flagFillPatch;
        p.flagDrawChildren = this.flagDrawChildren;
        return p;
    }

    public Object deepClone() {
        return this.deepClone(new PatchImpl());
    }

    protected PatchImpl deepClone(PatchImpl newPatch) {
        super.deepClone(newPatch);
        newPatch.flagDrawPatch = this.flagDrawPatch;
        newPatch.flagFillPatch = this.flagFillPatch;
        newPatch.flagDrawChildren = this.flagDrawChildren;
        return newPatch;
    }

    public static void main(String[] argv) {
        PatchImpl p1 = new PatchImpl(new Rectangle(200, 200, 50, 50));
        p1.setView(new StickyZViewWrapper(p1.getView()));
        p1.applyTransform(AffineTransform.getTranslateInstance(20.0, 20.0));
        Debug.println("----before----");
        Debug.println(p1);
        PatchImpl p2 = (PatchImpl)p1.deepClone();
        p2.applyTransform(AffineTransform.getScaleInstance(2.0, 2.0));
        Debug.println("----p2----");
        Debug.println(p2);
        Debug.println("----after----");
        Debug.println(p1);
        Debug.println(p1.getTransform(12));
        Debug.println(p2.getTransform(12));
    }

    public void deepClear() {
        super.deepClear();
        this.addFilter = null;
        this.externalCacheImage = null;
    }

    public StrokeEventFilter getStrokeEventFilter() {
        return this.addFilter;
    }

    public Color getPrintFill() {
        return null;
    }

    public Color getPrintDraw() {
        return null;
    }
}

