/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.objects.Style;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import edu.berkeley.guir.lib.satin.watch.Watchable;
import edu.berkeley.guir.lib.satin.watch.Watcher;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class LineArrow
extends TimedStroke
implements Watcher {
    public static final String ARROW_STYLE_FILE = "Arrow.properties";
    static Polygon shapeArrowHead1;
    static Polygon shapeArrowHead2;
    static Polygon shapeArrowHead3;
    protected GraphicalObject gobStart;
    protected GraphicalObject gobEnd;
    protected boolean flagDrawArrowHead = true;
    protected boolean flagDrawArrowLine = true;
    protected Point2D ptStart = new Point2D.Float(0.0f, 0.0f);
    protected Point2D ptEnd = new Point2D.Float(0.0f, 1.0f);
    protected Point2D ptArrowHeadVector = new Point2D.Float();
    protected Shape shapeArrowHead = shapeArrowHead1;
    protected AffineTransform txArrowHead = new AffineTransform();
    protected boolean flagDirty = true;
    static /* synthetic */ Class class$0;

    static {
        Style s = new Style(ARROW_STYLE_FILE);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.satin.objects.LineArrow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SatinConstants.clprops.setClassProperty(clazz, "STYLE", s);
        shapeArrowHead1 = new Polygon();
        shapeArrowHead1.addPoint(0, 5);
        shapeArrowHead1.addPoint(10, 0);
        shapeArrowHead1.addPoint(0, -5);
        shapeArrowHead2 = new Polygon();
        shapeArrowHead2.addPoint(0, 8);
        shapeArrowHead2.addPoint(16, 0);
        shapeArrowHead2.addPoint(0, -8);
        shapeArrowHead3 = new Polygon();
        shapeArrowHead3.addPoint(0, 10);
        shapeArrowHead3.addPoint(20, 0);
        shapeArrowHead3.addPoint(0, -10);
    }

    public LineArrow() {
        this.commonInit();
    }

    public LineArrow(Point2D ptStart, Point2D ptEnd) {
        this.setStartPoint(ptStart);
        this.setEndPoint(ptEnd);
        this.commonInit();
    }

    public LineArrow(float x1, float y1, float x2, float y2) {
        this.setStartPoint(x1, y1);
        this.setEndPoint(x2, y2);
        this.commonInit();
    }

    public LineArrow(GraphicalObject gobStart, GraphicalObject gobEnd) {
        this.setStartGraphicalObject(gobStart);
        this.setEndGraphicalObject(gobEnd);
        this.commonInit();
    }

    private void commonInit() {
        this.updateBounds();
    }

    protected Point2D calcLineDelta(double x1, double y1, double x2, double y2, double len) {
        Point2D.Float pt = new Point2D.Float();
        if (Math.abs(x1 - x2) < 0.001) {
            if (y2 > y1) {
                ((Point2D)pt).setLocation(0.0, -len);
            } else {
                ((Point2D)pt).setLocation(0.0, len);
            }
        } else {
            int sx = 1;
            int sy = 1;
            if (x1 < x2) {
                sx = -1;
            }
            if (y1 < y2) {
                sy = -1;
            }
            double m = (y2 - y1) / (x2 - x1);
            double dx = (float)sx * Math.abs((float)(len / Math.sqrt(m * m + 1.0)));
            double dy = (double)sy * Math.abs(m * dx);
            ((Point2D)pt).setLocation(dx, dy);
        }
        return pt;
    }

    public void setDirty(boolean flag) {
        this.flagDirty = flag;
    }

    protected void calculateGraphicalObjectPoints() {
        if (!this.flagDirty) {
            return;
        }
        Point2D ptAA = this.getStartPoint(12);
        Point2D ptBB = this.getEndPoint(12);
        boolean flagSetAA = false;
        boolean flagSetBB = false;
        if (this.gobStart != null) {
            Rectangle2D bdsStart = this.gobStart.getBounds2D(12);
            ptAA = new Point2D.Float((float)(bdsStart.getX() + bdsStart.getWidth() / 2.0), (float)(bdsStart.getY() + bdsStart.getHeight() / 2.0));
            flagSetAA = true;
        }
        if (this.gobEnd != null) {
            Rectangle2D bdsEnd = this.gobEnd.getBounds2D(12);
            ptBB = new Point2D.Float((float)(bdsEnd.getX() + bdsEnd.getWidth() / 2.0), (float)(bdsEnd.getY() + bdsEnd.getHeight() / 2.0));
            flagSetBB = true;
        }
        Line2D.Float line = new Line2D.Float(ptAA, ptBB);
        if (flagSetAA) {
            Polygon2D polyAA = this.gobStart.getBoundingPoints2D(12);
            List listAA = GeomLib.calcIntersectPoints(line, polyAA);
            this.ptStart = listAA.size() > 0 ? (Point2D)listAA.get(0) : ptAA;
            GraphicalObjectLib.absoluteToLocal(this, this.ptStart, this.ptStart);
        }
        if (flagSetBB) {
            Polygon2D polyBB = this.gobEnd.getBoundingPoints2D(12);
            List listBB = GeomLib.calcIntersectPoints(line, polyBB);
            this.ptEnd = listBB.size() > 0 ? (Point2D)listBB.get(0) : ptBB;
            GraphicalObjectLib.absoluteToLocal(this, this.ptEnd, this.ptEnd);
        }
        this.updateBounds();
        this.flagDirty = false;
    }

    public void setStartPoint(Point2D pt) {
        this.setStartPoint(pt.getX(), pt.getY());
        this.setDirty();
    }

    public void setStartPoint(float x, float y) {
        this.ptStart.setLocation(x, y);
        this.setDirty();
        this.updateBounds();
    }

    public void setStartPoint(double x, double y) {
        this.ptStart.setLocation((float)x, (float)y);
        this.setDirty();
        this.updateBounds();
    }

    public void setStartGraphicalObject(GraphicalObject gob) {
        this.gobStart = gob;
        gob.addWatcher(this);
        this.setDirty();
    }

    public Point2D getStartPoint(int cdsys) {
        AffineTransform tx = this.getTransform(cdsys);
        return tx.transform(this.ptStart, null);
    }

    public GraphicalObject getStartGraphicalObject() {
        return this.gobStart;
    }

    public void setEndPoint(Point2D pt) {
        this.setEndPoint(pt.getX(), pt.getY());
        this.setDirty();
    }

    public void setEndPoint(float x, float y) {
        this.ptEnd.setLocation(x, y);
        this.setDirty();
        this.updateBounds();
    }

    public void setEndPoint(double x, double y) {
        this.ptEnd.setLocation((float)x, (float)y);
        this.setDirty();
        this.updateBounds();
    }

    public void setEndGraphicalObject(GraphicalObject gob) {
        this.gobEnd = gob;
        gob.addWatcher(this);
        this.setDirty();
    }

    public Point2D getEndPoint(int cdsys) {
        AffineTransform tx = this.getTransform(cdsys);
        return tx.transform(this.ptEnd, null);
    }

    public GraphicalObject getEndGraphicalObject() {
        return this.gobEnd;
    }

    public void setArrowHeadVector(Point2D pt) {
        this.setArrowHeadVector((float)pt.getX(), (float)pt.getY());
    }

    public void setArrowHeadVector(float x, float y) {
        double dist = Math.sqrt(x * x + y * y);
        this.ptArrowHeadVector.setLocation((double)x / dist, (double)y / dist);
        this.updateArrowHeadAngle();
    }

    public void setArrowHeadVector(double x, double y) {
        this.setArrowHeadVector((float)x, (float)y);
    }

    protected void updateArrowHeadAngle() {
        double t = Math.atan2(this.ptArrowHeadVector.getY(), this.ptArrowHeadVector.getX());
        this.txArrowHead.setToIdentity();
        this.txArrowHead.translate(this.ptEnd.getX(), this.ptEnd.getY());
        Point2D dpt = this.calcLineDelta(this.ptStart.getX(), this.ptStart.getY(), this.ptEnd.getX(), this.ptEnd.getY(), -this.shapeArrowHead.getBounds2D().getHeight());
        this.txArrowHead.translate(dpt.getX(), dpt.getY());
        this.txArrowHead.rotate(t);
    }

    protected void updateBounds() {
        this.clearPoints();
        this.addPoint(this.ptStart);
        this.addPoint(this.ptEnd);
        this.setArrowHeadVector(this.ptEnd.getX() - this.ptStart.getX(), this.ptEnd.getY() - this.ptStart.getY());
        this.updateArrowHeadAngle();
    }

    protected final boolean shapeContainsInternal(Point2D pt) {
        return super.shapeContainsInternal(pt);
    }

    protected final boolean shapeContainsInternal(Shape s) {
        return super.shapeContainsInternal(s);
    }

    protected final boolean shapeIntersectsInternal(Shape s) {
        return super.shapeIntersectsInternal(s);
    }

    private AffineTransform getArrowHeadTransform(int cdsys) {
        AffineTransform tx = this.getTransform(cdsys);
        this.updateArrowHeadAngle();
        tx.preConcatenate(this.txArrowHead);
        return tx;
    }

    protected boolean lineContains(Point2D pt) {
        return Line2D.ptLineDistSq(this.ptStart.getX(), this.ptStart.getY(), this.ptEnd.getX(), this.ptEnd.getY(), pt.getX(), pt.getY()) <= 0.0;
    }

    public void setDrawArrowHead(boolean flag) {
        this.flagDrawArrowHead = flag;
    }

    public boolean getDrawArrowHead() {
        return this.flagDrawArrowHead;
    }

    public void setDrawArrowLine(boolean flag) {
        this.flagDrawArrowLine = flag;
    }

    public boolean getDrawArrowLine() {
        return this.flagDrawArrowLine;
    }

    protected void defaultRender(SatinGraphics g) {
        this.calculateGraphicalObjectPoints();
        if (this.getDrawArrowLine()) {
            this.drawArrowLine(g);
        }
        if (this.getDrawArrowHead()) {
            this.drawArrowHead(g);
        }
    }

    protected void drawArrowHead(SatinGraphics g) {
        g.pushTransform(this.txArrowHead);
        g.fill(this.shapeArrowHead);
        g.popTransform();
    }

    protected void drawArrowLine(SatinGraphics g) {
        Point2D ptAA = this.getStartPoint(10);
        Point2D ptBB = this.getEndPoint(10);
        g.drawLine((int)ptAA.getX(), (int)ptAA.getY(), (int)ptBB.getX(), (int)ptBB.getY());
    }

    public void onNotify(Watchable w, Object arg) {
        this.setDirty(true);
    }

    public void onUpdate(Watchable w, Object arg) {
        this.setDirty(true);
    }

    public void onUpdate(Watchable w, String strProperty, Object oldVal, Object newVal) {
        this.setDirty(true);
    }

    public void onDelete(Watchable w) {
    }

    protected LineArrow clone(LineArrow newArrow) {
        super.clone(newArrow);
        newArrow.ptStart = new Point2D.Float((float)this.ptStart.getX(), (float)this.ptStart.getY());
        newArrow.ptEnd = new Point2D.Float((float)this.ptEnd.getX(), (float)this.ptEnd.getY());
        return newArrow;
    }

    protected LineArrow deepClone(LineArrow newArrow) {
        super.clone(newArrow);
        return newArrow;
    }
}

