/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.DefaultInterpreterImpl;
import edu.berkeley.guir.lib.satin.interpreter.Interpreter;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectImpl;
import java.io.Serializable;

public class InteractionHandler
implements SatinConstants,
Serializable,
Cloneable {
    static final long serialVersionUID = -6003131899410378232L;
    protected GraphicalObjectImpl attach;
    protected Interpreter cmdintrp;
    protected Interpreter inkintrp;

    private InteractionHandler() {
    }

    public InteractionHandler(InteractionHandler handler) {
        this.attach = handler.attach;
        this.cmdintrp = (Interpreter)handler.cmdintrp.clone();
        this.inkintrp = (Interpreter)handler.inkintrp.clone();
    }

    public InteractionHandler(GraphicalObjectImpl gob) {
        this.attach = gob;
        this.setGestureInterpreter(new DefaultInterpreterImpl());
        this.setInkInterpreter(new DefaultInterpreterImpl());
    }

    public GraphicalObject setAttachedGraphicalObject(GraphicalObjectImpl gob) {
        this.attach = gob;
        this.cmdintrp.setAttachedGraphicalObject(gob);
        this.inkintrp.setAttachedGraphicalObject(gob);
        return gob;
    }

    public Interpreter getGestureInterpreter() {
        return this.cmdintrp;
    }

    public Interpreter setGestureInterpreter(Interpreter intrp) {
        this.cmdintrp = intrp;
        intrp.setAttachedGraphicalObject(this.attach);
        return intrp;
    }

    public Interpreter getInkInterpreter() {
        return this.inkintrp;
    }

    public Interpreter setInkInterpreter(Interpreter intrp) {
        this.inkintrp = intrp;
        intrp.setAttachedGraphicalObject(this.attach);
        return intrp;
    }

    public void onNewStroke(NewStrokeEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        this.attach.preProcessNewStroke(evt);
        if (evt.isConsumed()) {
            return;
        }
        this.attach.redispatchNewStroke(evt);
        if (evt.isConsumed()) {
            return;
        }
        this.attach.postProcessNewStroke(evt);
        if (evt.isConsumed()) {
            return;
        }
        this.attach.handleNewStroke(evt);
    }

    public void preProcessNewStroke(NewStrokeEvent evt) {
        if (this.cmdintrp.isEnabled() && this.cmdintrp.isEventAccepted(evt)) {
            this.cmdintrp.handleNewStroke(evt);
        }
    }

    public void redispatchNewStroke(NewStrokeEvent evt) {
    }

    public void postProcessNewStroke(NewStrokeEvent evt) {
        if (this.inkintrp.isEnabled() && this.inkintrp.isEventAccepted(evt)) {
            this.inkintrp.handleNewStroke(evt);
        }
    }

    public void handleNewStroke(NewStrokeEvent evt) {
    }

    public void onUpdateStroke(UpdateStrokeEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        this.attach.preProcessUpdateStroke(evt);
        if (evt.isConsumed()) {
            return;
        }
        this.attach.redispatchUpdateStroke(evt);
        if (evt.isConsumed()) {
            return;
        }
        this.attach.postProcessUpdateStroke(evt);
        if (evt.isConsumed()) {
            return;
        }
        this.attach.handleUpdateStroke(evt);
    }

    public void preProcessUpdateStroke(UpdateStrokeEvent evt) {
        if (this.cmdintrp.isEnabled() && this.cmdintrp.isEventAccepted(evt)) {
            this.cmdintrp.handleUpdateStroke(evt);
        }
    }

    public void redispatchUpdateStroke(UpdateStrokeEvent evt) {
    }

    public void postProcessUpdateStroke(UpdateStrokeEvent evt) {
        if (this.inkintrp.isEnabled() && this.inkintrp.isEventAccepted(evt)) {
            this.inkintrp.handleUpdateStroke(evt);
        }
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
    }

    public void onSingleStroke(SingleStrokeEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        this.attach.preProcessSingleStroke(evt);
        if (evt.isConsumed()) {
            return;
        }
        this.attach.redispatchSingleStroke(evt);
        if (evt.isConsumed()) {
            return;
        }
        this.attach.postProcessSingleStroke(evt);
        if (evt.isConsumed()) {
            return;
        }
        this.attach.handleSingleStroke(evt);
    }

    public void preProcessSingleStroke(SingleStrokeEvent evt) {
        if (this.cmdintrp.isEnabled() && this.cmdintrp.isEventAccepted(evt)) {
            this.cmdintrp.handleSingleStroke(evt);
        }
    }

    public void redispatchSingleStroke(SingleStrokeEvent evt) {
    }

    public void postProcessSingleStroke(SingleStrokeEvent evt) {
        if (this.inkintrp.isEnabled() && this.inkintrp.isEventAccepted(evt)) {
            this.inkintrp.handleSingleStroke(evt);
        }
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append("Gesture Interpreter: " + this.cmdintrp.toString() + "\n");
        strbuf.append("Ink Interpreter:     " + this.inkintrp.toString());
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public Object clone() {
        return new InteractionHandler(this);
    }
}

