/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.interpreter.Interpreter;
import edu.berkeley.guir.lib.satin.objects.GlobalID;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.objects.Style;
import edu.berkeley.guir.lib.satin.view.View;
import edu.berkeley.guir.lib.satin.watch.Watcher;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;

public class GraphicalObjectWrapper
implements GraphicalObject {
    protected int id = GraphicalObjectLib.getUniqueID();
    protected GraphicalObjectGroup parent;
    protected GraphicalObject gob;
    private GlobalID globalID = null;

    public GraphicalObjectWrapper() {
    }

    public GraphicalObjectWrapper(GraphicalObject gob) {
        this();
        this.setGraphicalObject(gob);
    }

    public void setGraphicalObject(GraphicalObject newGob) {
        this.gob = newGob;
        this.gob.setParentGroup(this.parent);
    }

    public GraphicalObject getGraphicalObject() {
        return this.gob;
    }

    public int getUniqueID() {
        return this.id;
    }

    public void setUniqueID(int newID) {
        this.id = newID;
        if (newID >= GraphicalObjectLib.uniqueID) {
            GraphicalObjectLib.uniqueID = newID + 1;
        }
    }

    public void setGlobalID(String host, int id) {
        this.globalID = new GlobalID(host, id);
    }

    public void setGlobalID(GlobalID guid) {
        this.globalID = guid;
    }

    public GlobalID getGlobalID() {
        return this.globalID;
    }

    public String getGlobalIDXML() {
        return this.globalID.toXML();
    }

    public Iterator getPropertyNames() {
        return this.gob.getPropertyNames();
    }

    public Object getProperty(String strPropertyName) {
        return this.gob.getProperty(strPropertyName);
    }

    public void setProperty(String strPropertyName, Object newVal) {
        this.gob.setProperty(strPropertyName, newVal);
    }

    public Object removeProperty(String strPropertyName) {
        return this.gob.removeProperty(strPropertyName);
    }

    public List getIndexedProperty(String strPropertyName) {
        return this.gob.getIndexedProperty(strPropertyName);
    }

    public Object getIndexedProperty(String strPropertyName, int index) {
        return this.gob.getIndexedProperty(strPropertyName, index);
    }

    public void setIndexedProperty(String strPropertyName, int index, Object newVal) {
        this.gob.setIndexedProperty(strPropertyName, index, newVal);
    }

    public void addIndexedProperty(String strPropertyName, Object newVal) {
        this.gob.addIndexedProperty(strPropertyName, newVal);
    }

    public Object removeIndexedProperty(String strPropertyName, int index) {
        return this.gob.removeIndexedProperty(strPropertyName, index);
    }

    public List removeIndexedProperty(String strPropertyName) {
        return this.gob.removeIndexedProperty(strPropertyName);
    }

    public void clearIndexedProperty(String strPropertyName) {
        this.gob.clearIndexedProperty(strPropertyName);
    }

    public void setView(View v) {
        this.gob.setView(v);
    }

    public View getView() {
        return this.gob.getView();
    }

    public Interpreter setGestureInterpreter(Interpreter intrp) {
        return this.gob.setGestureInterpreter(intrp);
    }

    public Interpreter getGestureInterpreter() {
        return this.gob.getGestureInterpreter();
    }

    public Interpreter setInkInterpreter(Interpreter intrp) {
        return this.gob.setInkInterpreter(intrp);
    }

    public Interpreter getInkInterpreter() {
        return this.gob.getInkInterpreter();
    }

    public Style setStyle(Style newStyle) {
        return this.gob.setStyle(newStyle);
    }

    public Style getStyle() {
        return this.gob.getStyle();
    }

    public Style getStyleRef() {
        return this.gob.getStyleRef();
    }

    public void setResizeMode(int resizeMode) {
        this.gob.setResizeMode(resizeMode);
    }

    public int getResizeMode() {
        return this.gob.getResizeMode();
    }

    public int getRelativeLayer() {
        return this.gob.getRelativeLayer();
    }

    public void setRelativeLayer(int layer) {
        this.gob.setRelativeLayer(layer);
    }

    public List getAbsoluteLayer() {
        return this.gob.getAbsoluteLayer();
    }

    public void bringUpALayer() {
        this.gob.bringUpALayer();
    }

    public void bringUpNLayers(int n) {
        this.gob.bringUpNLayers(n);
    }

    public void bringDownALayer() {
        this.gob.bringDownALayer();
    }

    public void bringDownNLayers(int n) {
        this.gob.bringDownNLayers(n);
    }

    public void bringToTopLayer() {
        this.gob.bringToTopLayer();
    }

    public void bringToBottomLayer() {
        this.gob.bringToBottomLayer();
    }

    public void initAfterAdd() {
        this.gob.initAfterAdd();
    }

    public void initAfterAddToSheet() {
        this.gob.initAfterAddToSheet();
    }

    public void applyTransform(AffineTransform newTx) {
        this.gob.applyTransform(newTx);
    }

    public void setTransform(AffineTransform newTx) {
        this.gob.setTransform(newTx);
    }

    public AffineTransform getTransformRef() {
        return this.gob.getTransformRef();
    }

    public AffineTransform getTransform(int cdsys) {
        return this.gob.getTransform(cdsys);
    }

    public AffineTransform getTransform(int cdsys, AffineTransform outTx) {
        return this.gob.getTransform(cdsys, outTx);
    }

    public AffineTransform getInverseTransform(int cdsys) {
        return this.gob.getInverseTransform(cdsys);
    }

    public AffineTransform getInverseTransform(int cdsys, AffineTransform outTx) {
        return this.gob.getInverseTransform(cdsys, outTx);
    }

    public float minDistance(int cdsys, double x, double y) {
        return this.gob.minDistance(cdsys, x, y);
    }

    public float minDistance(int cdsys, Point2D pt) {
        return this.gob.minDistance(cdsys, pt);
    }

    public Point2D getLocation2D(int cdsys) {
        return this.gob.getLocation2D(cdsys);
    }

    public Point2D getLocation2D(int cdsys, AffineTransform tx, Point2D pt) {
        return this.gob.getLocation2D(cdsys, tx, pt);
    }

    public Rectangle2D getBounds2D(int cdsys) {
        return this.gob.getBounds2D(cdsys);
    }

    public Rectangle2D getBounds2D(int cdsys, AffineTransform tx, Rectangle2D rect) {
        return this.gob.getBounds2D(cdsys, tx, rect);
    }

    public Polygon2D getBoundingPoints2D(int cdsys) {
        return this.gob.getBoundingPoints2D(cdsys);
    }

    public Polygon2D getBoundingPoints2D(int cdsys, AffineTransform tx, Polygon2D poly) {
        return this.gob.getBoundingPoints2D(cdsys, tx, poly);
    }

    public float getWidth2D(int cdsys) {
        return this.gob.getWidth2D(cdsys);
    }

    public float getHeight2D(int cdsys) {
        return this.gob.getHeight2D(cdsys);
    }

    public void setHasClosedBoundingPoints(boolean flag) {
        this.gob.setHasClosedBoundingPoints(flag);
    }

    public boolean hasClosedBoundingPoints() {
        return this.gob.hasClosedBoundingPoints();
    }

    public boolean shapeContains(GraphicalObject gob) {
        return gob.shapeContains(gob);
    }

    public boolean shapeContains(int cdsys, Point2D pt) {
        return this.gob.shapeContains(cdsys, pt);
    }

    public boolean shapeContains(int cdsys, double x, double y) {
        return this.gob.shapeContains(cdsys, x, y);
    }

    public boolean shapeContains(int cdsys, Shape s) {
        return this.gob.shapeContains(cdsys, s);
    }

    public boolean shapeIntersects(GraphicalObject gob) {
        return gob.shapeIntersects(gob);
    }

    public boolean shapeIntersects(int cdsys, Shape s) {
        return this.gob.shapeIntersects(cdsys, s);
    }

    public boolean contains(double x, double y) {
        return this.gob.contains(x, y);
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.gob.contains(x, y, w, h);
    }

    public boolean contains(Point2D p) {
        return this.gob.contains(p);
    }

    public boolean contains(Rectangle2D r) {
        return this.gob.contains(r);
    }

    public Rectangle getBounds() {
        return this.gob.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.gob.getBounds2D();
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.gob.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.gob.getPathIterator(at, flatness);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.gob.intersects(x, y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        return this.gob.intersects(r);
    }

    public Watcher addWatcher(Watcher w) {
        return this.gob.addWatcher(w);
    }

    public int countWatchers() {
        return this.gob.countWatchers();
    }

    public Watcher removeWatcher(Watcher w) {
        return this.gob.removeWatcher(w);
    }

    public void clearWatchers() {
        this.gob.clearWatchers();
    }

    public void enableNotify() {
        this.gob.enableNotify();
    }

    public void disableNotify() {
        this.gob.disableNotify();
    }

    public boolean hasNotifyEnabled() {
        return this.gob.hasNotifyEnabled();
    }

    public void notifyWatchers() {
        this.gob.notifyWatchers();
    }

    public void notifyWatchers(Object arg) {
        this.gob.notifyWatchers(arg);
    }

    public void notifyWatchersUpdate(Object arg) {
        this.gob.notifyWatchersUpdate(arg);
    }

    public void notifyWatchersUpdate(String strProperty, Object oldVal, Object newVal) {
        this.gob.notifyWatchersUpdate(strProperty, oldVal, newVal);
    }

    public void notifyWatchersDelete() {
        this.gob.notifyWatchersDelete();
    }

    public boolean isSelectable() {
        return this.gob.isSelectable();
    }

    public void setSelectable(boolean flag) {
        this.gob.setSelectable(flag);
    }

    public void moveTo(int cdsys, double x, double y) {
        this.gob.moveTo(cdsys, x, y);
    }

    public void moveTo(int cdsys, double x, double y, double theta) {
        this.gob.moveTo(cdsys, x, y, theta);
    }

    public void moveTo(int cdsys, Point2D pt) {
        this.gob.moveTo(cdsys, pt);
    }

    public void moveBy(int cdsys, double dx, double dy) {
        this.gob.moveBy(cdsys, dx, dy);
    }

    public void moveBy(int cdsys, Point2D pt) {
        this.gob.moveBy(cdsys, pt);
    }

    public void setBoundingPoints2D(int cdsys, Shape s) {
        this.gob.setBoundingPoints2D(cdsys, s);
    }

    public void onNewStroke(NewStrokeEvent evt) {
        this.gob.onNewStroke(evt);
    }

    public void preProcessNewStroke(NewStrokeEvent evt) {
        this.gob.preProcessNewStroke(evt);
    }

    public void redispatchNewStroke(NewStrokeEvent evt) {
        this.gob.redispatchNewStroke(evt);
    }

    public void postProcessNewStroke(NewStrokeEvent evt) {
        this.gob.postProcessNewStroke(evt);
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        this.gob.handleNewStroke(evt);
    }

    public void onUpdateStroke(UpdateStrokeEvent evt) {
        this.gob.onUpdateStroke(evt);
    }

    public void preProcessUpdateStroke(UpdateStrokeEvent evt) {
        this.gob.preProcessUpdateStroke(evt);
    }

    public void redispatchUpdateStroke(UpdateStrokeEvent evt) {
        this.gob.redispatchUpdateStroke(evt);
    }

    public void postProcessUpdateStroke(UpdateStrokeEvent evt) {
        this.gob.postProcessUpdateStroke(evt);
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        this.gob.handleUpdateStroke(evt);
    }

    public void onSingleStroke(SingleStrokeEvent evt) {
        this.gob.onSingleStroke(evt);
    }

    public void preProcessSingleStroke(SingleStrokeEvent evt) {
        this.gob.preProcessSingleStroke(evt);
    }

    public void redispatchSingleStroke(SingleStrokeEvent evt) {
        this.gob.redispatchSingleStroke(evt);
    }

    public void postProcessSingleStroke(SingleStrokeEvent evt) {
        this.gob.postProcessSingleStroke(evt);
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        this.gob.handleSingleStroke(evt);
    }

    public void setVisible(boolean flag) {
        this.gob.setVisible(flag);
    }

    public boolean isVisible() {
        return this.gob.isVisible();
    }

    public void disableDamage() {
        this.gob.disableDamage();
    }

    public void enableDamage() {
        this.gob.enableDamage();
    }

    public boolean hasDamageEnabled() {
        return this.gob.hasDamageEnabled();
    }

    public void setClipToBounds(boolean flag) {
        this.gob.setClipToBounds(flag);
    }

    public boolean isClippedToBounds() {
        return this.gob.isClippedToBounds();
    }

    public void damage(int sync) {
        this.parent.damage(sync);
    }

    public void damage(int sync, GraphicalObject gob) {
        this.parent.damage(sync, gob);
    }

    public void damage(int sync, Rectangle2D rect) {
        this.parent.damage(sync, rect);
    }

    public void damage(int sync, Rectangle2D oldRect, Rectangle2D newRect) {
        this.parent.damage(sync, oldRect, newRect);
    }

    public void render(SatinGraphics g) {
        this.gob.render(g);
    }

    public GraphicalObjectGroup getParentGroup() {
        return this.parent;
    }

    public void setParentGroup(GraphicalObjectGroup newParent) {
        if (newParent == null) {
            this.parent = null;
            this.gob.setParentGroup(null);
            return;
        }
        if (newParent == this.parent) {
            return;
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.parent = newParent;
        this.gob.setParentGroup(newParent);
    }

    public Sheet getSheet() {
        if (this.parent != null) {
            return this.parent.getSheet();
        }
        return null;
    }

    public void delete() {
        this.notifyWatchersDelete();
    }

    public Object clone() {
        GraphicalObjectWrapper gobw = new GraphicalObjectWrapper();
        this.clone(gobw);
        return gobw;
    }

    protected GraphicalObjectWrapper clone(GraphicalObjectWrapper gobw) {
        gobw.parent = this.parent;
        gobw.gob = this.gob;
        return gobw;
    }

    public Object deepClone() {
        GraphicalObjectWrapper gobw = new GraphicalObjectWrapper();
        this.deepClone(gobw);
        return gobw;
    }

    protected GraphicalObjectWrapper deepClone(GraphicalObjectWrapper gobw) {
        gobw.parent = this.parent;
        gobw.gob = (GraphicalObject)this.gob.deepClone();
        return gobw;
    }
}

