/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollectionImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.Style;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;

public final class GraphicalObjectLib
implements SatinConstants {
    static int uniqueID;
    static boolean flagAnimating;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        uniqueID = 0;
        flagAnimating = false;
    }

    public static final synchronized int getUniqueID() {
        return uniqueID++;
    }

    public static final boolean isAnimating() {
        return flagAnimating;
    }

    public static final void setAnimating(boolean flag) {
        flagAnimating = flag;
    }

    public static void animate(GraphicalObject gob, AffineTransform[] txArray) {
        gob.disableNotify();
        GraphicalObjectLib.setAnimating(true);
        System.gc();
        int i = 0;
        while (i < txArray.length) {
            gob.applyTransform(txArray[i]);
            ++i;
        }
        gob.enableNotify();
        GraphicalObjectLib.setAnimating(false);
        gob.damage(20);
    }

    public static Rectangle getRenderBounds(GraphicalObject gob) {
        Rectangle rect = new Rectangle();
        Style style = gob.getStyleRef();
        int width = (int)style.getLineWidth() + 1;
        gob.getBounds2D(12, null, rect);
        rect.x -= width;
        rect.y -= width;
        rect.width += 2 * width;
        rect.height += 2 * width;
        return rect;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void toLocalCoordinates(GraphicalObject gobMove, GraphicalObject gobCoord) {
        AffineTransform txOld = (AffineTransform)SatinConstants.poolTx.getObject();
        AffineTransform txApply = (AffineTransform)SatinConstants.poolTx.getObject();
        try {
            try {
                gobMove.getTransform(12, txOld);
                gobCoord.getInverseTransform(12, txApply);
                txApply.concatenate(txOld);
                gobMove.disableNotify();
                gobMove.disableDamage();
                gobMove.setTransform(txApply);
                gobMove.enableNotify();
                gobMove.enableDamage();
            }
            catch (Exception e) {
                Debug.println(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            SatinConstants.poolTx.releaseObject(txOld);
            SatinConstants.poolTx.releaseObject(txApply);
            throw throwable;
        }
        {
            Object var5_7 = null;
            SatinConstants.poolTx.releaseObject(txOld);
            SatinConstants.poolTx.releaseObject(txApply);
            return;
        }
    }

    public static Point2D toLocalCoordinates(GraphicalObject gobSrc, Point2D pt, GraphicalObject gobDst) {
        return GraphicalObjectLib.toLocalCoordinates(gobSrc, pt, gobDst, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Point2D toLocalCoordinates(GraphicalObject gobSrc, Point2D ptSrc, GraphicalObject gobDst, Point2D ptDst) {
        AffineTransform txSrc = (AffineTransform)SatinConstants.poolTx.getObject();
        AffineTransform txDst = (AffineTransform)SatinConstants.poolTx.getObject();
        if (ptDst == null) {
            ptDst = new Point2D.Float();
        }
        try {
            try {
                if (gobSrc != null) {
                    gobSrc.getTransform(12, txSrc);
                } else {
                    SatinConstants.poolTx.releaseObject(txSrc);
                    txSrc = new AffineTransform();
                }
                if (gobDst != null) {
                    gobDst.getInverseTransform(12, txDst);
                } else {
                    SatinConstants.poolTx.releaseObject(txDst);
                    txDst = new AffineTransform();
                }
                txDst.concatenate(txSrc);
                txDst.transform(ptSrc, ptDst);
            }
            catch (Exception e) {
                Debug.println(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            SatinConstants.poolTx.releaseObject(txSrc);
            SatinConstants.poolTx.releaseObject(txDst);
            throw throwable;
        }
        {
            Object var7_9 = null;
            SatinConstants.poolTx.releaseObject(txSrc);
            SatinConstants.poolTx.releaseObject(txDst);
            return ptDst;
        }
    }

    public static Rectangle2D toLocalCoordinates(GraphicalObject gobSrc, Rectangle2D rectSrc, GraphicalObject gobDst) {
        return GraphicalObjectLib.toLocalCoordinates(gobSrc, rectSrc, gobDst, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Rectangle2D toLocalCoordinates(GraphicalObject gobSrc, Rectangle2D rectSrc, GraphicalObject gobDst, Rectangle2D rectDst) {
        AffineTransform txSrc = (AffineTransform)SatinConstants.poolTx.getObject();
        AffineTransform txDst = (AffineTransform)SatinConstants.poolTx.getObject();
        if (rectDst == null) {
            rectDst = new Rectangle2D.Float();
        }
        try {
            try {
                if (gobSrc != null) {
                    txSrc = gobSrc.getTransform(12, txSrc);
                } else {
                    SatinConstants.poolTx.releaseObject(txSrc);
                    txSrc = new AffineTransform();
                }
                if (gobDst != null) {
                    txDst = gobDst.getInverseTransform(12, txDst);
                } else {
                    SatinConstants.poolTx.releaseObject(txDst);
                    txDst = new AffineTransform();
                }
                txDst.concatenate(txSrc);
                GeomLib.transformRectangle(txDst, rectSrc, rectDst);
            }
            catch (Exception e) {
                Debug.println(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            SatinConstants.poolTx.releaseObject(txSrc);
            SatinConstants.poolTx.releaseObject(txDst);
            throw throwable;
        }
        {
            Object var7_9 = null;
            SatinConstants.poolTx.releaseObject(txSrc);
            SatinConstants.poolTx.releaseObject(txDst);
            return rectDst;
        }
    }

    public static Point2D localToAbsolute(GraphicalObject gob, Point2D ptIn) {
        return GraphicalObjectLib.localToAbsolute(gob, ptIn, null);
    }

    public static Point2D localToAbsolute(GraphicalObject gob, Point2D ptIn, Point2D ptReturn) {
        AffineTransform txAbs = (AffineTransform)SatinConstants.poolTx.getObject();
        if (ptReturn == null) {
            ptReturn = new Point2D.Float();
        }
        gob.getTransform(12, txAbs);
        txAbs.transform(ptIn, ptReturn);
        SatinConstants.poolTx.releaseObject(txAbs);
        return ptReturn;
    }

    public static Rectangle2D localToAbsolute(GraphicalObject gob, Rectangle2D rectIn) {
        Point2D p1 = GraphicalObjectLib.localToAbsolute(gob, new Point2D.Double(rectIn.getX(), rectIn.getY()));
        Point2D p2 = GraphicalObjectLib.localToAbsolute(gob, new Point2D.Double(rectIn.getX() + rectIn.getWidth(), rectIn.getY() + rectIn.getHeight()));
        return new Rectangle2D.Double(p1.getX(), p1.getY(), p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    public static Point2D absoluteToLocal(GraphicalObject gob, Point2D ptIn) {
        return GraphicalObjectLib.absoluteToLocal(gob, ptIn, null);
    }

    public static Point2D absoluteToLocal(GraphicalObject gob, Point2D ptIn, Point2D ptReturn) {
        AffineTransform txAbs = (AffineTransform)SatinConstants.poolTx.getObject();
        if (ptReturn == null) {
            ptReturn = new Point2D.Float();
        }
        gob.getInverseTransform(12, txAbs);
        txAbs.transform(ptIn, ptReturn);
        SatinConstants.poolTx.releaseObject(txAbs);
        return ptReturn;
    }

    public static Rectangle2D absoluteToLocal(GraphicalObject gob, Rectangle2D rectIn) {
        Point2D p1 = GraphicalObjectLib.absoluteToLocal(gob, new Point2D.Double(rectIn.getX(), rectIn.getY()));
        Point2D p2 = GraphicalObjectLib.absoluteToLocal(gob, new Point2D.Double(rectIn.getX() + rectIn.getWidth(), rectIn.getY() + rectIn.getHeight()));
        return new Rectangle2D.Double(p1.getX(), p1.getY(), p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    public static double getScaleFactor(int cdsys, GraphicalObject gob) {
        double scale;
        switch (cdsys) {
            case 12: {
                AffineTransform txTmp = gob.getTransform(cdsys);
                scale = AffineTransformLib.getScaleFactor(txTmp);
                break;
            }
            case 11: {
                scale = AffineTransformLib.getScaleFactor(gob.getTransformRef());
                break;
            }
            case 10: {
                scale = 1.0;
                break;
            }
            default: {
                throw new RuntimeException("Unknown coordinate system value");
            }
        }
        return scale;
    }

    public static AffineTransform getScaleTransformAt(GraphicalObject gob, double absScale, GraphicalObjectGroup parent) {
        AffineTransform xform = parent.getInverseTransform(12);
        xform.concatenate(AffineTransform.getScaleInstance(absScale, absScale));
        return xform;
    }

    public static double getAbsScaleFactorAt(GraphicalObject gob, double sheetScale) {
        return GraphicalObjectLib.getAbsTransformAt(gob, sheetScale).getScaleX();
    }

    public static AffineTransform getTransformAt(GraphicalObject gob, double sheetScale) {
        AffineTransform tx = GraphicalObjectLib.getAbsTransformAt(gob, sheetScale);
        tx.preConcatenate(gob.getParentGroup().getInverseTransform(12));
        return tx;
    }

    private static AffineTransform getAbsTransformAt(GraphicalObject gob, double sheetScale) {
        AffineTransform absTx = gob.getTransform(12);
        absTx.preConcatenate(gob.getSheet().getInverseTransform(12));
        absTx.preConcatenate(AffineTransform.getScaleInstance(sheetScale, sheetScale));
        return absTx;
    }

    public static final int compareLayers(GraphicalObject gobA, GraphicalObject gobB) {
        int returnVal = 0;
        try {
            returnVal = GraphicalObjectLib.compareLayers(gobA.getAbsoluteLayer(), gobB.getAbsoluteLayer());
        }
        catch (Exception e) {
            Debug.println("This error should never happen.");
            Debug.println(e);
        }
        return returnVal;
    }

    public static final int compareLayers(List gobA, List gobB) {
        Iterator itA = gobA.iterator();
        Iterator itB = gobB.iterator();
        while (itA.hasNext() && itB.hasNext()) {
            int layerB;
            int layerA = (Integer)itA.next();
            if (layerA < (layerB = ((Integer)itB.next()).intValue())) {
                return -1;
            }
            if (layerA <= layerB) continue;
            return 1;
        }
        if (!itA.hasNext() && !itB.hasNext()) {
            return 0;
        }
        if (itA.hasNext()) {
            return -1;
        }
        return 1;
    }

    public static final GraphicalObject getTopmostLeaf(GraphicalObjectCollection gobcol) {
        return GraphicalObjectLib.getLeaf(gobcol, true);
    }

    public static final GraphicalObject getBottommostLeaf(GraphicalObjectCollection gobcol) {
        return GraphicalObjectLib.getLeaf(gobcol, false);
    }

    public static final GraphicalObject getTopmostBranch(GraphicalObjectCollection gobcol) {
        return GraphicalObjectLib.getBranch(gobcol, true);
    }

    public static final GraphicalObject getBottommostBranch(GraphicalObjectCollection gobcol) {
        return GraphicalObjectLib.getBranch(gobcol, false);
    }

    private static final GraphicalObject getLeaf(GraphicalObjectCollection gobcol, boolean flagTopmost) {
        GraphicalObjectCollectionImpl gobcoltmp = new GraphicalObjectCollectionImpl();
        Iterator it = gobcol.getForwardIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof GraphicalObject) || obj instanceof GraphicalObjectGroup) continue;
            gobcoltmp.add((GraphicalObject)obj);
        }
        if (flagTopmost) {
            return GraphicalObjectLib.getTopmostGraphicalObject(gobcoltmp);
        }
        return GraphicalObjectLib.getBottommostGraphicalObject(gobcoltmp);
    }

    private static final GraphicalObject getBranch(GraphicalObjectCollection gobcol, boolean flagTopmost) {
        GraphicalObjectCollectionImpl gobcoltmp = new GraphicalObjectCollectionImpl();
        Iterator it = gobcol.getForwardIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof GraphicalObjectGroup)) continue;
            gobcoltmp.add((GraphicalObjectGroup)obj);
        }
        if (flagTopmost) {
            return GraphicalObjectLib.getTopmostGraphicalObject(gobcoltmp);
        }
        return GraphicalObjectLib.getBottommostGraphicalObject(gobcoltmp);
    }

    public static final GraphicalObject getTopmostGraphicalObject(GraphicalObjectCollection gobcol) {
        Iterator it = gobcol.getForwardIterator();
        GraphicalObject gobTop = null;
        List absLayerTop = null;
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            if (gobTop == null) {
                gobTop = gob;
                absLayerTop = gobTop.getAbsoluteLayer();
                continue;
            }
            List absLayer = gob.getAbsoluteLayer();
            if (GraphicalObjectLib.compareLayers(absLayer, absLayerTop) >= 0) continue;
            absLayerTop = absLayer;
            gobTop = gob;
        }
        return gobTop;
    }

    public static final GraphicalObject getBottommostGraphicalObject(GraphicalObjectCollection gobcol) {
        Iterator it = gobcol.getForwardIterator();
        GraphicalObject gobBottom = null;
        List absLayerBottom = null;
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            if (gobBottom == null) {
                gobBottom = gob;
                absLayerBottom = gobBottom.getAbsoluteLayer();
                continue;
            }
            List absLayer = gob.getAbsoluteLayer();
            if (GraphicalObjectLib.compareLayers(absLayer, absLayerBottom) <= 0) continue;
            absLayerBottom = absLayer;
            gobBottom = gob;
        }
        return gobBottom;
    }

    public static final GraphicalObjectCollection flatten(GraphicalObjectCollection gobcol) {
        GraphicalObjectCollectionImpl gobcolList = new GraphicalObjectCollectionImpl();
        GraphicalObjectLib.flattenHelper(gobcol, gobcolList);
        return gobcolList;
    }

    private static final void flattenHelper(GraphicalObjectCollection tree, GraphicalObjectCollection list) {
        Iterator it = tree.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            list.addToBack(gob);
            if (!(gob instanceof GraphicalObjectGroup)) continue;
            GraphicalObjectLib.flattenHelper((GraphicalObjectCollection)((Object)gob), list);
        }
    }

    public static final GraphicalObjectCollection removeGraphicalObjectGroups(GraphicalObjectCollection gobcol) {
        GraphicalObjectCollectionImpl gobcolTmp = new GraphicalObjectCollectionImpl();
        int i = 0;
        while (i < gobcol.numElements()) {
            GraphicalObject gob = gobcol.get(i);
            if (!(gob instanceof GraphicalObjectGroup)) {
                gobcolTmp.addToBack(gob);
            }
            ++i;
        }
        return gobcolTmp;
    }

    public static final Point2D getCenterOfMass(GraphicalObject gob) {
        return GraphicalObjectLib.getCenterOfMass(gob, null);
    }

    public static final Point2D getCenterOfMass(GraphicalObject gob, Point2D pt) {
        if (pt == null) {
            pt = new Point2D.Float();
        }
        Polygon2D p = gob.getBoundingPoints2D(12);
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        while (i < p.npoints) {
            x += (double)p.xpoints[i];
            y += (double)p.ypoints[i];
            ++i;
        }
        pt.setLocation(x /= (double)p.npoints, y /= (double)p.npoints);
        return pt;
    }

    public static final double weightAtTop(GraphicalObject gobAA, GraphicalObject gobBB) {
        Point2D ptAA = GraphicalObjectLib.getCenterOfMass(gobAA);
        Point2D ptBB = GraphicalObjectLib.getCenterOfMass(gobBB);
        return ptBB.getY() - ptAA.getY();
    }

    public static final double weightAtBottom(GraphicalObject gobAA, GraphicalObject gobBB) {
        return GraphicalObjectLib.weightAtTop(gobBB, gobAA);
    }

    public static final double weightAtRight(GraphicalObject gobAA, GraphicalObject gobBB) {
        Point2D ptAA = GraphicalObjectLib.getCenterOfMass(gobAA);
        Point2D ptBB = GraphicalObjectLib.getCenterOfMass(gobBB);
        return ptAA.getX() - ptBB.getX();
    }

    public static final double weightAtLeft(GraphicalObject gobAA, GraphicalObject gobBB) {
        return GraphicalObjectLib.weightAtRight(gobBB, gobAA);
    }

    public static final boolean atTop(GraphicalObject gobAA, GraphicalObject gobBB) {
        return GraphicalObjectLib.atTop(gobAA, gobBB, 5.0);
    }

    public static final boolean atTop(GraphicalObject gobAA, GraphicalObject gobBB, double thresh) {
        Rectangle2D rectAA = (Rectangle2D)SatinConstants.poolRects.getObject();
        Rectangle2D rectBB = (Rectangle2D)SatinConstants.poolRects.getObject();
        Rectangle2D rectCheck = (Rectangle2D)SatinConstants.poolRects.getObject();
        gobAA.getBounds2D(12, null, rectAA);
        gobBB.getBounds2D(12, null, rectBB);
        double x1 = rectBB.getX() - thresh;
        double y1 = rectBB.getY() - thresh;
        double x2 = rectBB.getX() + rectBB.getWidth() + thresh;
        double y2 = rectBB.getY() + thresh;
        rectCheck.setRect(x1, y1, x2 - x1, y2 - y1);
        boolean flagReturn = rectCheck.intersects(rectAA);
        SatinConstants.poolRects.releaseObject(rectAA);
        SatinConstants.poolRects.releaseObject(rectBB);
        SatinConstants.poolRects.releaseObject(rectCheck);
        return flagReturn;
    }

    public static final boolean atBottom(GraphicalObject gobAA, GraphicalObject gobBB) {
        return GraphicalObjectLib.atBottom(gobAA, gobBB, 5.0);
    }

    public static final boolean atBottom(GraphicalObject gobAA, GraphicalObject gobBB, double thresh) {
        return GraphicalObjectLib.atTop(gobBB, gobAA, thresh);
    }

    public static final boolean atRight(GraphicalObject gobAA, GraphicalObject gobBB) {
        return GraphicalObjectLib.atRight(gobAA, gobBB, 5.0);
    }

    public static final boolean atRight(GraphicalObject gobAA, GraphicalObject gobBB, double thresh) {
        Rectangle2D rectAA = (Rectangle2D)SatinConstants.poolRects.getObject();
        Rectangle2D rectBB = (Rectangle2D)SatinConstants.poolRects.getObject();
        Rectangle2D rectCheck = (Rectangle2D)SatinConstants.poolRects.getObject();
        gobAA.getBounds2D(12, null, rectAA);
        gobBB.getBounds2D(12, null, rectBB);
        double x1 = rectBB.getX() + rectBB.getWidth() - thresh;
        double y1 = rectBB.getY() - thresh;
        double x2 = rectBB.getX() + rectBB.getWidth() + thresh;
        double y2 = rectBB.getY() + rectBB.getHeight() + thresh;
        rectCheck.setRect(x1, y1, x2 - x1, y2 - y1);
        boolean flagReturn = rectCheck.intersects(rectAA);
        SatinConstants.poolRects.releaseObject(rectAA);
        SatinConstants.poolRects.releaseObject(rectBB);
        SatinConstants.poolRects.releaseObject(rectCheck);
        return flagReturn;
    }

    public static final boolean atLeft(GraphicalObject gobAA, GraphicalObject gobBB) {
        return GraphicalObjectLib.atLeft(gobAA, gobBB, 5.0);
    }

    public static final boolean atLeft(GraphicalObject gobAA, GraphicalObject gobBB, double thresh) {
        return GraphicalObjectLib.atRight(gobBB, gobAA, thresh);
    }

    public static final Polygon2D convert(Shape s) {
        float[] curr = new float[6];
        Polygon2D p = new Polygon2D();
        PathIterator it = s.getPathIterator(null);
        FlatteningPathIterator fpi = new FlatteningPathIterator(it, 1.0, 10);
        while (!fpi.isDone()) {
            int linetype = fpi.currentSegment(curr);
            switch (linetype) {
                case 0: {
                    p.addPoint(curr[0], curr[1]);
                    break;
                }
                case 1: {
                    p.addPoint(curr[0], curr[1]);
                    break;
                }
                case 2: 
                case 3: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            fpi.next();
        }
        return p;
    }

    public static final boolean contains(Shape sAA, Shape sBB) {
        Rectangle2D rAA = sAA.getBounds2D();
        Rectangle2D rBB = sBB.getBounds2D();
        if (rBB.getHeight() == 0.0 && rBB.getWidth() == 0.0 ? !rAA.contains(rBB.getX(), rBB.getY()) : (rBB.getHeight() == 0.0 || rBB.getWidth() == 0.0 ? !rAA.contains(rBB.getX(), rBB.getY()) || !rAA.contains(rBB.getX() + rBB.getWidth(), rBB.getY() + rBB.getHeight()) : !rAA.contains(rBB))) {
            return false;
        }
        Polygon2D polyBB = (Polygon2D)SatinConstants.poolPolys.getObject();
        boolean flagReturn = true;
        polyBB.setToShape(sBB);
        int i = 0;
        while (i < polyBB.npoints) {
            if (!sAA.contains(polyBB.xpoints[i], polyBB.ypoints[i])) {
                flagReturn = false;
                break;
            }
            ++i;
        }
        SatinConstants.poolPolys.releaseObject(polyBB);
        return flagReturn;
    }

    public static final boolean contains(GraphicalObject gob, Shape s) {
        Polygon2D poly = (Polygon2D)SatinConstants.poolPolys.getObject();
        gob.getBoundingPoints2D(12, null, poly);
        boolean flagReturn = GraphicalObjectLib.contains((Shape)poly, s);
        SatinConstants.poolPolys.releaseObject(poly);
        return flagReturn;
    }

    public static final boolean contains(Shape s, GraphicalObject gob) {
        Polygon2D poly = (Polygon2D)SatinConstants.poolPolys.getObject();
        gob.getBoundingPoints2D(12, null, poly);
        boolean flagReturn = GraphicalObjectLib.contains(s, (Shape)poly);
        SatinConstants.poolPolys.releaseObject(poly);
        return flagReturn;
    }

    public static final boolean intersects(Shape sAA, Shape sBB) {
        Rectangle2D rBB;
        Rectangle2D rAA = sAA.getBounds2D();
        if (!rAA.intersects(rBB = sBB.getBounds2D())) {
            return false;
        }
        Polygon2D polyBB = (Polygon2D)SatinConstants.poolPolys.getObject();
        boolean flagReturn = false;
        polyBB.setToShape(sBB);
        int i = 0;
        while (i < polyBB.npoints) {
            if (!sAA.contains(polyBB.xpoints[i], polyBB.ypoints[i])) {
                flagReturn = true;
                break;
            }
            ++i;
        }
        SatinConstants.poolPolys.releaseObject(polyBB);
        return flagReturn;
    }

    public static final boolean intersects(GraphicalObject gob, Shape s) {
        Polygon2D poly = (Polygon2D)SatinConstants.poolPolys.getObject();
        gob.getBoundingPoints2D(12, null, poly);
        boolean flagReturn = GraphicalObjectLib.intersects((Shape)poly, s);
        SatinConstants.poolPolys.releaseObject(poly);
        return flagReturn;
    }

    public static final boolean intersects(Shape s, GraphicalObject gob) {
        Polygon2D poly = (Polygon2D)SatinConstants.poolPolys.getObject();
        gob.getBoundingPoints2D(12, null, poly);
        boolean flagReturn = GraphicalObjectLib.intersects(s, (Shape)poly);
        SatinConstants.poolPolys.releaseObject(poly);
        return flagReturn;
    }

    public static String toShortClassName(Object obj) {
        String packageName;
        if (obj == null) {
            return null;
        }
        String className = obj.getClass().getName();
        String shortClassName = className.substring((packageName = obj.getClass().getPackage().getName()).length());
        if (shortClassName.charAt(0) == '.') {
            shortClassName = shortClassName.substring(1);
        }
        return shortClassName;
    }

    public static String toShortString(GraphicalObject gob) {
        if (gob == null) {
            return null;
        }
        String s = String.valueOf(GraphicalObjectLib.toShortClassName(gob)) + ":" + gob.getUniqueID();
        return s;
    }
}

