/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.properties.FlexProperties;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.StrokeListener;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.graphics.GraphicsLib;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.interpreter.DefaultInterpreterImpl;
import edu.berkeley.guir.lib.satin.interpreter.Interpreter;
import edu.berkeley.guir.lib.satin.objects.GlobalID;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.objects.InteractionHandler;
import edu.berkeley.guir.lib.satin.objects.Style;
import edu.berkeley.guir.lib.satin.objects.ViewHandler;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import edu.berkeley.guir.lib.satin.view.DefaultViewImpl;
import edu.berkeley.guir.lib.satin.view.View;
import edu.berkeley.guir.lib.satin.watch.Watchable;
import edu.berkeley.guir.lib.satin.watch.WatchableImpl;
import edu.berkeley.guir.lib.satin.watch.Watcher;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class GraphicalObjectImpl
implements GraphicalObject,
Watchable,
Shape,
StrokeListener {
    static final long serialVersionUID = -6330140664442146288L;
    private static boolean defaultFlagDebug;
    private static Style debugStyle;
    private static Style selectedStyle;
    FlexProperties properties = new FlexProperties(this);
    int id = -1;
    GraphicalObjectGroup parent;
    private GlobalID globalID = null;
    InteractionHandler interaction;
    ViewHandler view;
    WatchableImpl watchable;
    AffineTransform tx;
    Polygon2D xBoundingPts;
    boolean flagDirty;
    boolean flagSelectable = true;
    HashMap mapProperties;
    transient int damageCount = 0;
    boolean flagClipToBounds = false;
    private int resizeMode;
    private boolean isRenderFinished = true;
    private long latestRenderTime = 0L;
    private GraphicalObjectRenderingCache renderCache = null;
    Rectangle rectClipBoundsAA = new Rectangle();
    Rectangle2D rectClipBoundsBB = new Rectangle2D.Float();

    static {
        SatinConstants.clprops.setDefaultProperty("STYLE", new Style());
        SatinConstants.clprops.setDefaultProperty("VIEW", new DefaultView());
        SatinConstants.clprops.setDefaultProperty("INKINTRP", new DefaultInterpreterImpl());
        SatinConstants.clprops.setDefaultProperty("GESTUREINTRP", new DefaultInterpreterImpl());
        debugStyle = new Style("Debug.properties");
        selectedStyle = new Style();
    }

    public static void setClassDebugProperty(boolean flag) {
        defaultFlagDebug = flag;
    }

    public static boolean getClassDebugProperty() {
        return defaultFlagDebug;
    }

    public final void setClassProperty(String strPropertyName, Object obj) {
        SatinConstants.clprops.setClassProperty(this.getClass(), strPropertyName, obj);
    }

    public final Object getClassProperty(String strPropertyName) {
        return SatinConstants.clprops.getClassProperty(this.getClass(), strPropertyName);
    }

    public final void setClassPropertyView(View v) {
        this.setClassProperty("VIEW", v);
    }

    public final View getClassPropertyView() {
        View v = (View)this.getClassProperty("VIEW");
        return (View)v.clone();
    }

    public boolean isRenderFinished() {
        return this.isRenderFinished;
    }

    public GraphicalObjectRenderingCache getRenderCache() {
        return this.renderCache;
    }

    protected void updateCacheInternal(GraphicalObjectRenderingCache grc, AffineTransform refTransform, Style refStyle) {
    }

    public final void setClassPropertyStyle(Style s) {
        this.setClassProperty("STYLE", s);
    }

    public final Style getClassPropertyStyle() {
        Style s = (Style)this.getClassProperty("STYLE");
        return (Style)s.clone();
    }

    public final void setClassPropertyGestureInterpreter(Interpreter intrp) {
        this.setClassProperty("GESTUREINTRP", intrp);
    }

    public final Interpreter getClassPropertyGestureInterpreter() {
        Interpreter i = (Interpreter)this.getClassProperty("GESTUREINTRP");
        return (Interpreter)i.clone();
    }

    public final void setClassPropertyInkInterpreter(Interpreter intrp) {
        this.setClassProperty("INKINTRP", intrp);
    }

    public final Interpreter getClassPropertyInkInterpreter() {
        Interpreter i = (Interpreter)this.getClassProperty("INKINTRP");
        return (Interpreter)i.clone();
    }

    public GraphicalObjectImpl() {
        this.watchable = new WatchableImpl();
        this.disableNotify();
        this.id = GraphicalObjectLib.getUniqueID();
        this.globalID = new GlobalID(this.id);
        this.initialize();
        this.view.setStyle(this.getClassPropertyStyle());
        this.tx = new AffineTransform();
        this.setDirty();
        this.enableNotify();
        this.resizeMode = 0;
        this.renderCache = new GraphicalObjectRenderingCache(this);
    }

    public GraphicalObjectImpl(GraphicalObjectImpl gob) {
        gob.clone(this);
    }

    private void initialize() {
        InteractionHandler ihandler = this.createNewInteractionHandler();
        ihandler.setGestureInterpreter(this.getClassPropertyGestureInterpreter());
        ihandler.setInkInterpreter(this.getClassPropertyInkInterpreter());
        this.setInteractionHandler(ihandler);
        ViewHandler vhandler = this.createNewViewHandler();
        vhandler.setView(new DefaultView());
        this.setViewHandler(vhandler);
    }

    protected InteractionHandler createNewInteractionHandler() {
        return new InternalInteractionHandler();
    }

    protected InteractionHandler getInteractionHandler() {
        return this.interaction;
    }

    protected InteractionHandler setInteractionHandler(InteractionHandler newHandler) {
        this.interaction = newHandler;
        newHandler.setAttachedGraphicalObject(this);
        return newHandler;
    }

    protected ViewHandler createNewViewHandler() {
        return new InternalViewHandler();
    }

    protected ViewHandler getViewHandler() {
        return this.view;
    }

    protected ViewHandler setViewHandler(ViewHandler newHandler) {
        this.view = newHandler;
        newHandler.setAttachedGraphicalObject(this);
        return newHandler;
    }

    public int getUniqueID() {
        return this.id;
    }

    public void setUniqueID(int newID) {
        this.id = newID;
        if (newID >= GraphicalObjectLib.uniqueID) {
            GraphicalObjectLib.uniqueID = newID + 1;
        }
    }

    public void setGlobalID(String host, int id) {
        this.globalID = new GlobalID(host, id);
    }

    public void setGlobalID(GlobalID guid) {
        this.globalID = guid;
    }

    public GlobalID getGlobalID() {
        return this.globalID;
    }

    public String getGlobalIDXML() {
        return this.globalID.toXML();
    }

    public Iterator getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public Object getProperty(String strPropertyName) {
        return this.properties.getProperty(strPropertyName);
    }

    public void setProperty(String strPropertyName, Object newVal) {
        this.properties.setProperty(strPropertyName, newVal);
    }

    public Object removeProperty(String strPropertyName) {
        return this.properties.removeProperty(strPropertyName);
    }

    public List getIndexedProperty(String strPropertyName) {
        return this.properties.getIndexedProperty(strPropertyName);
    }

    public Object getIndexedProperty(String strPropertyName, int index) {
        return this.properties.getIndexedProperty(strPropertyName, index);
    }

    public void setIndexedProperty(String strPropertyName, int index, Object newVal) {
        this.properties.setIndexedProperty(strPropertyName, index, newVal);
    }

    public void addIndexedProperty(String strPropertyName, Object newVal) {
        this.properties.addIndexedProperty(strPropertyName, newVal);
    }

    public Object removeIndexedProperty(String strPropertyName, int index) {
        return this.properties.removeIndexedProperty(strPropertyName, index);
    }

    public List removeIndexedProperty(String strPropertyName) {
        return this.properties.removeIndexedProperty(strPropertyName);
    }

    public void clearIndexedProperty(String strPropertyName) {
        this.properties.clearIndexedProperty(strPropertyName);
    }

    public void setView(View v) {
        this.view.setView(v);
    }

    public View getView() {
        return this.view.getView();
    }

    public Interpreter getGestureInterpreter() {
        return this.interaction.getGestureInterpreter();
    }

    public Interpreter setGestureInterpreter(Interpreter intrp) {
        return this.interaction.setGestureInterpreter(intrp);
    }

    public Interpreter getInkInterpreter() {
        return this.interaction.getInkInterpreter();
    }

    public Interpreter setInkInterpreter(Interpreter intrp) {
        return this.interaction.setInkInterpreter(intrp);
    }

    public Style setStyle(Style newStyle) {
        Style oldStyle = this.view.getStyle();
        this.view.setStyle(newStyle);
        this.setDirty();
        this.notifyWatchersUpdate("style", oldStyle, newStyle);
        this.damage(21, this);
        return newStyle;
    }

    public Style getStyle() {
        return this.view.getStyle();
    }

    public Style getStyleRef() {
        return this.view.getStyleRef();
    }

    public void setResizeMode(int resizeMode) {
        this.resizeMode = resizeMode;
    }

    public int getResizeMode() {
        return this.resizeMode;
    }

    public int getRelativeLayer() {
        if (this.parent != null) {
            return this.parent.getRelativeLayer(this);
        }
        return -1;
    }

    public void setRelativeLayer(int layer) {
        List oldLayer = null;
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            oldLayer = this.getAbsoluteLayer();
        }
        if (this.parent != null) {
            this.parent.setRelativeLayer(this, layer);
        }
        this.setDirty();
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            this.notifyWatchersUpdate("layer", oldLayer, this.getAbsoluteLayer());
            this.damage(21, this);
        }
    }

    public List getAbsoluteLayer() {
        if (this.parent != null) {
            ArrayList<Integer> layersList = this.parent.getAbsoluteLayer();
            int layerSelf = this.parent.getRelativeLayer(this);
            if (layersList == null) {
                layersList = new ArrayList<Integer>();
            }
            layersList.add(new Integer(layerSelf));
            return layersList;
        }
        return null;
    }

    public void bringUpALayer() {
        GraphicalObjectGroup gobs;
        List oldLayer = null;
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            oldLayer = this.getAbsoluteLayer();
        }
        if ((gobs = this.getParentGroup()) != null) {
            this.parent.bringUpALayer(this);
        }
        this.setDirty();
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            this.notifyWatchersUpdate("layer", oldLayer, this.getAbsoluteLayer());
            this.damage(21, this);
        }
    }

    public void bringUpNLayers(int n) {
        GraphicalObjectGroup gobs;
        List oldLayer = null;
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            oldLayer = this.getAbsoluteLayer();
        }
        if ((gobs = this.getParentGroup()) != null) {
            this.parent.bringUpNLayers(this, n);
        }
        this.setDirty();
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            this.notifyWatchersUpdate("layer", oldLayer, this.getAbsoluteLayer());
            this.damage(21, this);
        }
    }

    public void bringDownALayer() {
        GraphicalObjectGroup gobs;
        List oldLayer = null;
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            oldLayer = this.getAbsoluteLayer();
        }
        if ((gobs = this.getParentGroup()) != null) {
            this.parent.bringDownALayer(this);
        }
        this.setDirty();
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            this.notifyWatchersUpdate("layer", oldLayer, this.getAbsoluteLayer());
            this.damage(21, this);
        }
    }

    public void bringDownNLayers(int n) {
        GraphicalObjectGroup gobs;
        List oldLayer = null;
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            oldLayer = this.getAbsoluteLayer();
        }
        if ((gobs = this.getParentGroup()) != null) {
            this.parent.bringDownNLayers(this, n);
        }
        this.setDirty();
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            this.notifyWatchersUpdate("layer", oldLayer, this.getAbsoluteLayer());
            this.damage(21, this);
        }
    }

    public void bringToTopLayer() {
        GraphicalObjectGroup gobs;
        List oldLayer = null;
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            oldLayer = this.getAbsoluteLayer();
        }
        if ((gobs = this.getParentGroup()) != null) {
            this.parent.bringToTopLayer(this);
        }
        this.setDirty();
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            this.notifyWatchersUpdate("layer", oldLayer, this.getAbsoluteLayer());
            this.damage(21, this);
        }
    }

    public void bringToBottomLayer() {
        GraphicalObjectGroup gobs;
        List oldLayer = null;
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            oldLayer = this.getAbsoluteLayer();
        }
        if ((gobs = this.getParentGroup()) != null) {
            this.parent.bringToBottomLayer(this);
        }
        this.setDirty();
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            this.notifyWatchersUpdate("layer", oldLayer, this.getAbsoluteLayer());
            this.damage(21, this);
        }
    }

    protected void setDirty() {
        this.flagDirty = true;
        this.xBoundingPts = null;
    }

    protected boolean isDirty() {
        return true;
    }

    protected void updateBoundingPoints() {
        if (this.isDirty()) {
            this.xBoundingPts = this.getLocalBoundingPoints2DRef().transformCopy(this.getTransformRef());
            this.flagDirty = false;
        }
    }

    protected void setTransformInternal(AffineTransform newTx) {
        this.tx = newTx;
        this.setDirty();
    }

    protected void setLocalBoundingPoints2DRef(Polygon2D poly) {
        this.view.setViewBoundingPoints2DRef(poly);
    }

    protected Polygon2D getLocalBoundingPoints2DRef() {
        return this.view.getViewBoundingPoints2DRef();
    }

    protected Polygon2D getBoundingPoints2DRef() {
        this.updateBoundingPoints();
        if (this.hasClosedBoundingPoints()) {
            this.xBoundingPts.setClosed(true);
        } else {
            this.xBoundingPts.setClosed(false);
        }
        return this.xBoundingPts;
    }

    public void applyTransform(AffineTransform newTx) {
        Rectangle2D oldBounds = null;
        Rectangle2D newBounds = null;
        Point2D ptOld = null;
        Point2D ptNew = null;
        AffineTransform txOld = null;
        AffineTransform txNew = null;
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            oldBounds = (Rectangle2D)SatinConstants.poolRects.getObject();
            oldBounds = this.getBounds2D(12, null, oldBounds);
        }
        if (this.hasNotifyEnabled()) {
            txOld = (AffineTransform)SatinConstants.poolTx.getObject();
            txOld.setTransform(this.tx);
        }
        this.tx.preConcatenate(newTx);
        this.setDirty();
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            newBounds = (Rectangle2D)SatinConstants.poolRects.getObject();
            newBounds = this.getBounds2D(12, null, newBounds);
        }
        if (this.hasNotifyEnabled()) {
            ptOld = (Point2D)SatinConstants.poolPoints.getObject();
            ptNew = (Point2D)SatinConstants.poolPoints.getObject();
            ptOld.setLocation(oldBounds.getX(), oldBounds.getY());
            ptNew.setLocation(newBounds.getX(), newBounds.getY());
            txNew = (AffineTransform)SatinConstants.poolTx.getObject();
            txNew.setTransform(this.tx);
            this.notifyWatchersUpdate("xform", txOld, txNew);
            this.notifyWatchersUpdate("location", ptOld, ptNew);
        }
        if (this.hasDamageEnabled()) {
            this.damage(20, oldBounds, newBounds);
        }
        SatinConstants.poolRects.releaseObject(oldBounds);
        SatinConstants.poolRects.releaseObject(newBounds);
        SatinConstants.poolTx.releaseObject(txOld);
        SatinConstants.poolTx.releaseObject(txNew);
        SatinConstants.poolPoints.releaseObject(ptOld);
        SatinConstants.poolPoints.releaseObject(ptNew);
    }

    public void setTransform(AffineTransform newTx) {
        Rectangle2D oldBounds = null;
        Rectangle2D newBounds = null;
        Point2D ptOld = null;
        Point2D ptNew = null;
        AffineTransform txOld = null;
        AffineTransform txNew = null;
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            oldBounds = (Rectangle2D)SatinConstants.poolRects.getObject();
            this.getBounds2D(12, null, oldBounds);
        }
        if (this.hasNotifyEnabled()) {
            txOld = (AffineTransform)SatinConstants.poolTx.getObject();
            txOld.setTransform(this.tx);
        }
        this.view.clearNormalizingTransform();
        this.tx.setTransform(newTx);
        this.setDirty();
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            newBounds = (Rectangle2D)SatinConstants.poolRects.getObject();
            newBounds = this.getBounds2D(12, null, newBounds);
        }
        if (this.hasNotifyEnabled()) {
            ptOld = (Point2D)SatinConstants.poolPoints.getObject();
            ptNew = (Point2D)SatinConstants.poolPoints.getObject();
            ptOld.setLocation(oldBounds.getX(), oldBounds.getY());
            ptNew.setLocation(newBounds.getX(), newBounds.getY());
            txNew = (AffineTransform)SatinConstants.poolTx.getObject();
            txNew.setTransform(this.tx);
            this.notifyWatchersUpdate("xform", txOld, txNew);
            this.notifyWatchersUpdate("location", ptOld, ptNew);
        }
        if (this.hasDamageEnabled()) {
            if (Sheet.isIdleRenderingMode()) {
                this.damage(22, oldBounds, newBounds);
            } else {
                this.damage(21, oldBounds, newBounds);
            }
        }
        SatinConstants.poolRects.releaseObject(oldBounds);
        SatinConstants.poolRects.releaseObject(newBounds);
        SatinConstants.poolTx.releaseObject(txOld);
        SatinConstants.poolTx.releaseObject(txNew);
        SatinConstants.poolPoints.releaseObject(ptOld);
        SatinConstants.poolPoints.releaseObject(ptNew);
    }

    public AffineTransform getTransform(int cdsys) {
        return this.getTransform(cdsys, null);
    }

    public AffineTransform getTransform(int cdsys, AffineTransform outTx) {
        if (outTx == null) {
            outTx = new AffineTransform();
        }
        switch (cdsys) {
            case 10: {
                outTx.setToIdentity();
                break;
            }
            case 11: {
                outTx.setTransform(this.tx);
                break;
            }
            case 12: {
                outTx.setTransform(this.tx);
                GraphicalObject gob = this;
                while ((gob = gob.getParentGroup()) != null) {
                    outTx.preConcatenate(gob.getTransformRef());
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid coordinate system value");
            }
        }
        return outTx;
    }

    public AffineTransform getInverseTransform(int cdsys) {
        return this.getInverseTransform(cdsys, null);
    }

    public AffineTransform getInverseTransform(int cdsys, AffineTransform outTx) {
        if (outTx == null) {
            outTx = new AffineTransform();
        }
        outTx = this.getTransform(cdsys, outTx);
        try {
            outTx.setTransform(outTx.createInverse());
        }
        catch (Exception e) {
            Debug.println("This should never really happen");
        }
        return outTx;
    }

    public AffineTransform getTransformRef() {
        return this.tx;
    }

    public void setParentGroup(GraphicalObjectGroup newParent) {
        if (newParent == null) {
            this.parent = null;
            return;
        }
        if (newParent == this.parent) {
            return;
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.parent = newParent;
    }

    public GraphicalObjectGroup getParentGroup() {
        return this.parent;
    }

    public Sheet getSheet() {
        if (this.parent != null) {
            return this.parent.getSheet();
        }
        return null;
    }

    public void delete() {
        this.notifyWatchersDelete();
    }

    public void initAfterAdd() {
    }

    public void initAfterAddToSheet() {
    }

    public float minDistance(int cdsys, double x, double y) {
        return this.minDistance(cdsys, new Point2D.Float((float)x, (float)y));
    }

    public float minDistance(int cdsys, Point2D pt) {
        Point2D ptTmp = (Point2D)SatinConstants.poolPoints.getObject();
        switch (cdsys) {
            case 12: {
                GraphicalObjectLib.absoluteToLocal(this, pt, ptTmp);
                break;
            }
            case 11: {
                AffineTransform tx = this.getTransformRef();
                tx.transform(pt, ptTmp);
                break;
            }
            case 10: {
                ptTmp.setLocation(pt);
                break;
            }
            default: {
                throw new RuntimeException("Invalid coordinate system value");
            }
        }
        float dist = this.minLocalDistance(ptTmp.getX(), ptTmp.getY());
        SatinConstants.poolPoints.releaseObject(ptTmp);
        return dist;
    }

    protected float minLocalDistance(double x, double y) {
        return this.getLocalBoundingPoints2DRef().minDistance(x, y);
    }

    public Point2D getLocation2D(int cdsys) {
        return this.getLocation2D(cdsys, null, null);
    }

    public Point2D getLocation2D(int cdsys, AffineTransform tx, Point2D pt) {
        Rectangle2D tmpRect = (Rectangle2D)SatinConstants.poolRects.getObject();
        tmpRect = this.getBounds2D(cdsys, tx, tmpRect);
        if (pt == null) {
            pt = new Point2D.Float();
        }
        if (tx != null) {
            tx.transform(pt, pt);
        }
        pt.setLocation(tmpRect.getX(), tmpRect.getY());
        SatinConstants.poolRects.releaseObject(tmpRect);
        return pt;
    }

    public Rectangle2D getBounds2D(int cdsys) {
        return this.getBounds2D(cdsys, null, null);
    }

    public Rectangle2D getBounds2D(int cdsys, AffineTransform tx, Rectangle2D rect) {
        Polygon2D tmpPoly = (Polygon2D)SatinConstants.poolPolys.getObject();
        tmpPoly = this.getBoundingPoints2D(cdsys, tx, tmpPoly);
        if (rect == null) {
            rect = new Rectangle2D.Float();
        }
        if (tx != null) {
            tmpPoly.transform(tx);
        }
        rect.setRect(tmpPoly.getBounds2D());
        SatinConstants.poolPolys.releaseObject(tmpPoly);
        return rect;
    }

    public Polygon2D getBoundingPoints2D(int cdsys) {
        return this.getBoundingPoints2D(cdsys, null, null);
    }

    public Polygon2D getBoundingPoints2D(int cdsys, AffineTransform tx, Polygon2D poly) {
        if (poly == null) {
            poly = new Polygon2D();
        }
        switch (cdsys) {
            case 10: {
                poly.setPoly(this.getLocalBoundingPoints2DRef());
                break;
            }
            case 11: {
                this.updateBoundingPoints();
                poly.setPoly(this.xBoundingPts);
                break;
            }
            case 12: {
                AffineTransform txTmp = (AffineTransform)SatinConstants.poolTx.getObject();
                this.getTransform(12, txTmp);
                poly.setPoly(this.getLocalBoundingPoints2DRef());
                poly.transform(txTmp);
                SatinConstants.poolTx.releaseObject(txTmp);
                break;
            }
            default: {
                throw new RuntimeException("Invalid coordinate system value");
            }
        }
        if (tx != null) {
            poly.transform(tx);
        }
        if (this.hasClosedBoundingPoints()) {
            poly.setClosed(true);
        } else {
            poly.setClosed(false);
        }
        return poly;
    }

    public float getWidth2D(int cdsys) {
        Rectangle2D tmpRect = (Rectangle2D)SatinConstants.poolRects.getObject();
        tmpRect = this.getBounds2D(cdsys, this.tx, tmpRect);
        SatinConstants.poolRects.releaseObject(tmpRect);
        return (float)tmpRect.getWidth();
    }

    public float getHeight2D(int cdsys) {
        Rectangle2D tmpRect = (Rectangle2D)SatinConstants.poolRects.getObject();
        tmpRect = this.getBounds2D(cdsys, this.tx, tmpRect);
        SatinConstants.poolRects.releaseObject(tmpRect);
        return (float)tmpRect.getHeight();
    }

    public void setHasClosedBoundingPoints(boolean flag) {
        this.view.setHasClosedBoundingPoints(flag);
    }

    public boolean hasClosedBoundingPoints() {
        return this.view.hasClosedBoundingPoints();
    }

    public boolean isSelectable() {
        return this.flagSelectable;
    }

    public void setSelectable(boolean flag) {
        this.flagSelectable = flag;
    }

    public void moveTo(int cdsys, double x, double y) {
        AffineTransform tx = (AffineTransform)SatinConstants.poolTx.getObject();
        switch (cdsys) {
            case 10: {
                Point2D pt = (Point2D)SatinConstants.poolPoints.getObject();
                this.getLocation2D(cdsys, null, pt);
                tx.setToTranslation(x - pt.getX(), y - pt.getY());
                this.applyTransform(tx);
                SatinConstants.poolPoints.releaseObject(pt);
                break;
            }
            case 11: 
            case 12: {
                this.getTransform(cdsys, tx);
                double[] matrix = new double[6];
                tx.getMatrix(matrix);
                tx.setTransform(matrix[0], matrix[1], matrix[2], matrix[3], x, y);
                if (cdsys == 12) {
                    AffineTransform txiParent = (AffineTransform)SatinConstants.poolTx.getObject();
                    this.getParentGroup().getInverseTransform(12, txiParent);
                    tx.preConcatenate(txiParent);
                    SatinConstants.poolTx.releaseObject(txiParent);
                }
                Rectangle2D rect = this.getLocalBoundingPoints2DRef().getBounds2D();
                tx.translate(-rect.getX(), -rect.getY());
                this.setTransform(tx);
                break;
            }
            default: {
                throw new RuntimeException("Invalid coordinate system value");
            }
        }
        SatinConstants.poolTx.releaseObject(tx);
    }

    public void moveTo(int cdsys, double x, double y, double theta) {
        this.moveTo(cdsys, -this.getBounds2D(cdsys).getWidth() / 2.0, -this.getBounds2D(cdsys).getHeight() / 2.0);
        this.applyTransform(AffineTransform.getRotateInstance(theta));
        this.moveTo(cdsys, x, y);
    }

    public void moveTo(int cdsys, Point2D pt) {
        this.moveTo(cdsys, pt.getX(), pt.getY());
    }

    public void moveBy(int cdsys, double dx, double dy) {
        switch (cdsys) {
            case 10: {
                this.applyTransform(AffineTransform.getTranslateInstance(dx, dy));
                break;
            }
            case 11: 
            case 12: {
                Point2D ptPos = (Point2D)SatinConstants.poolPoints.getObject();
                this.getLocation2D(cdsys, null, ptPos);
                ptPos.setLocation(ptPos.getX() + dx, ptPos.getY() + dy);
                this.moveTo(cdsys, ptPos.getX(), ptPos.getY());
                SatinConstants.poolPoints.releaseObject(ptPos);
                break;
            }
            default: {
                throw new RuntimeException("Invalid coordinate system value");
            }
        }
    }

    public void moveBy(int cdsys, Point2D pt) {
        this.moveBy(cdsys, pt.getX(), pt.getY());
    }

    public void setBoundingPoints2D(int cdsys, Shape s) {
        Rectangle2D oldBounds = null;
        Rectangle2D newBounds = null;
        Point2D ptOld = null;
        Point2D ptNew = null;
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            oldBounds = (Rectangle2D)SatinConstants.poolRects.getObject();
            oldBounds = this.getBounds2D(12, null, oldBounds);
        }
        if (this.hasNotifyEnabled()) {
            ptOld = (Point2D)SatinConstants.poolPoints.getObject();
            ptOld.setLocation(oldBounds.getX(), oldBounds.getY());
        }
        Polygon2D p = new Polygon2D(s);
        switch (cdsys) {
            case 12: {
                p.transform(this.getInverseTransform(12));
                break;
            }
            case 11: {
                this.setTransform(new AffineTransform());
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid coordinate system value");
            }
        }
        this.disableNotify();
        this.disableDamage();
        this.view.setViewBoundingPoints2D(p);
        this.xBoundingPts = null;
        this.enableDamage();
        this.enableNotify();
        this.getRenderCache().setCacheInvalide();
        this.setDirty();
        if (this.hasDamageEnabled() || this.hasNotifyEnabled()) {
            newBounds = (Rectangle2D)SatinConstants.poolRects.getObject();
            newBounds = this.getBounds2D(12, null, newBounds);
            ptNew = (Point2D)SatinConstants.poolPoints.getObject();
            ptNew.setLocation(newBounds.getX(), newBounds.getY());
            this.notifyWatchersUpdate("bounds", oldBounds, newBounds);
            this.notifyWatchersUpdate("location", ptOld, ptNew);
        }
        if (this.hasDamageEnabled()) {
            this.damage(21, oldBounds, newBounds);
        }
        SatinConstants.poolRects.releaseObject(oldBounds);
        SatinConstants.poolRects.releaseObject(newBounds);
        SatinConstants.poolPoints.releaseObject(ptOld);
        SatinConstants.poolPoints.releaseObject(ptNew);
    }

    public void onNewStroke(NewStrokeEvent evt) {
        this.interaction.onNewStroke(evt);
    }

    public void preProcessNewStroke(NewStrokeEvent evt) {
        this.interaction.preProcessNewStroke(evt);
    }

    public void redispatchNewStroke(NewStrokeEvent evt) {
        this.interaction.redispatchNewStroke(evt);
    }

    public void postProcessNewStroke(NewStrokeEvent evt) {
        this.interaction.postProcessNewStroke(evt);
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        this.interaction.handleNewStroke(evt);
    }

    public void onUpdateStroke(UpdateStrokeEvent evt) {
        this.interaction.onUpdateStroke(evt);
    }

    public void preProcessUpdateStroke(UpdateStrokeEvent evt) {
        this.interaction.preProcessUpdateStroke(evt);
    }

    public void redispatchUpdateStroke(UpdateStrokeEvent evt) {
        this.interaction.redispatchUpdateStroke(evt);
    }

    public void postProcessUpdateStroke(UpdateStrokeEvent evt) {
        this.interaction.postProcessUpdateStroke(evt);
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        this.interaction.handleUpdateStroke(evt);
    }

    public void onSingleStroke(SingleStrokeEvent evt) {
        this.interaction.onSingleStroke(evt);
    }

    public void preProcessSingleStroke(SingleStrokeEvent evt) {
        this.interaction.preProcessSingleStroke(evt);
    }

    public void redispatchSingleStroke(SingleStrokeEvent evt) {
        this.interaction.redispatchSingleStroke(evt);
    }

    public void postProcessSingleStroke(SingleStrokeEvent evt) {
        this.interaction.postProcessSingleStroke(evt);
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        this.interaction.handleSingleStroke(evt);
    }

    protected boolean shapeContainsInternal(Point2D pt) {
        return this.getLocalBoundingPoints2DRef().contains(pt);
    }

    protected boolean shapeContainsInternal(Shape s) {
        return GraphicalObjectLib.contains(this, s);
    }

    protected boolean shapeIntersectsInternal(Shape s) {
        return GraphicalObjectLib.intersects(this, s);
    }

    public boolean shapeContains(GraphicalObject gob) {
        return this.shapeContains(12, gob.getBoundingPoints2D(12));
    }

    public boolean shapeContains(int cdsys, Point2D pt) {
        AffineTransform tx = (AffineTransform)SatinConstants.poolTx.getObject();
        Point2D ptTmp = (Point2D)SatinConstants.poolPoints.getObject();
        switch (cdsys) {
            case 10: 
            case 11: 
            case 12: {
                this.getInverseTransform(cdsys, tx);
                break;
            }
            default: {
                throw new RuntimeException("Unknown coordinate system parameter");
            }
        }
        ptTmp.setLocation(pt.getX(), pt.getY());
        tx.transform(ptTmp, ptTmp);
        boolean flagReturn = this.shapeContainsInternal(ptTmp);
        SatinConstants.poolTx.releaseObject(tx);
        SatinConstants.poolPoints.releaseObject(ptTmp);
        return flagReturn;
    }

    public boolean shapeContains(int cdsys, double x, double y) {
        Point2D pt = (Point2D)SatinConstants.poolPoints.getObject();
        pt.setLocation(x, y);
        boolean flagReturn = this.shapeContains(cdsys, pt);
        SatinConstants.poolPoints.releaseObject(pt);
        return flagReturn;
    }

    public boolean shapeContains(int cdsys, Shape s) {
        AffineTransform tx = (AffineTransform)SatinConstants.poolTx.getObject();
        Polygon2D poly = (Polygon2D)SatinConstants.poolPolys.getObject();
        switch (cdsys) {
            case 10: 
            case 11: 
            case 12: {
                this.getInverseTransform(cdsys, tx);
                break;
            }
            default: {
                throw new RuntimeException("Unknown coordinate system parameter");
            }
        }
        poly.setToPathIterator(s.getPathIterator(tx));
        boolean flagReturn = this.shapeContainsInternal(poly);
        SatinConstants.poolTx.releaseObject(tx);
        SatinConstants.poolPolys.releaseObject(poly);
        return flagReturn;
    }

    public boolean shapeIntersects(GraphicalObject gob) {
        return this.shapeIntersects(12, gob.getBoundingPoints2D(12));
    }

    public boolean shapeIntersects(int cdsys, Shape s) {
        Rectangle2D r1 = (Rectangle2D)SatinConstants.poolRects.getObject();
        AffineTransform tx = (AffineTransform)SatinConstants.poolTx.getObject();
        Polygon2D poly = (Polygon2D)SatinConstants.poolPolys.getObject();
        switch (cdsys) {
            case 10: 
            case 11: 
            case 12: {
                this.getInverseTransform(cdsys, tx);
                break;
            }
            default: {
                throw new RuntimeException("Unknown coordinate system parameter");
            }
        }
        poly.setToPathIterator(s.getPathIterator(tx));
        boolean flagReturn = this.shapeIntersectsInternal(poly);
        SatinConstants.poolRects.releaseObject(r1);
        SatinConstants.poolTx.releaseObject(tx);
        SatinConstants.poolPolys.releaseObject(poly);
        return flagReturn;
    }

    public boolean contains(double x, double y) {
        return this.shapeContains(11, x, y);
    }

    public boolean contains(double x, double y, double w, double h) {
        Rectangle2D rect = (Rectangle2D)SatinConstants.poolRects.getObject();
        rect.setRect(x, y, w, h);
        boolean flagReturn = this.shapeContains(11, rect);
        SatinConstants.poolRects.releaseObject(rect);
        return flagReturn;
    }

    public boolean contains(Point2D p) {
        return this.shapeContains(11, p);
    }

    public boolean contains(Rectangle2D r) {
        return this.shapeContains(11, r);
    }

    public Rectangle getBounds() {
        return this.getBoundingPoints2DRef().getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.getBoundingPoints2DRef().getBounds2D();
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.getBoundingPoints2DRef().getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getBoundingPoints2DRef().getPathIterator(at, flatness);
    }

    public boolean intersects(double x, double y, double w, double h) {
        Rectangle2D rect = (Rectangle2D)SatinConstants.poolRects.getObject();
        rect.setRect(x, y, w, h);
        boolean flagReturn = this.shapeIntersects(11, rect);
        SatinConstants.poolRects.releaseObject(rect);
        return flagReturn;
    }

    public boolean intersects(Rectangle2D r) {
        return this.shapeIntersects(11, r);
    }

    public Watcher addWatcher(Watcher w) {
        return this.watchable.addWatcher(w);
    }

    public int countWatchers() {
        return this.watchable.countWatchers();
    }

    public Watcher removeWatcher(Watcher w) {
        return this.watchable.removeWatcher(w);
    }

    public void clearWatchers() {
        this.watchable.clearWatchers();
    }

    public void enableNotify() {
        this.watchable.enableNotify();
    }

    public void disableNotify() {
        this.watchable.disableNotify();
    }

    public boolean hasNotifyEnabled() {
        return this.watchable.hasNotifyEnabled();
    }

    public void notifyWatchers() {
        this.watchable.notifyWatchers(this);
    }

    public void notifyWatchers(Object arg) {
        this.watchable.notifyWatchers(this, arg);
    }

    public void notifyWatchersUpdate(Object arg) {
        this.watchable.notifyWatchersUpdate(this, arg);
    }

    public void notifyWatchersUpdate(String strProperty, Object oldVal, Object newVal) {
        this.watchable.notifyWatchersUpdate(this, strProperty, oldVal, newVal);
    }

    public void notifyWatchersDelete() {
        this.watchable.notifyWatchersDelete(this);
    }

    public void setVisible(boolean flag) {
        this.view.setVisible(flag);
    }

    public boolean isVisible() {
        return this.view.isVisible();
    }

    public void disableDamage() {
        ++this.damageCount;
    }

    public void enableDamage() {
        --this.damageCount;
        if (this.damageCount < 0) {
            throw new RuntimeException("Error - unbalanced number of disable/enable damage calls made");
        }
    }

    public boolean hasDamageEnabled() {
        return this.damageCount == 0;
    }

    public void setClipToBounds(boolean flag) {
        this.flagClipToBounds = flag;
    }

    public boolean isClippedToBounds() {
        return this.flagClipToBounds;
    }

    public void damage(int sync) {
        this.damage(sync, this);
    }

    public void damage(int sync, GraphicalObject gob) {
        if (!this.hasDamageEnabled()) {
            return;
        }
        GraphicalObjectGroup p = this.getParentGroup();
        if (p != null) {
            p.damage(sync, gob);
        }
    }

    public void damage(int sync, Rectangle2D rect) {
        if (!this.hasDamageEnabled()) {
            return;
        }
        GraphicalObjectGroup p = this.getParentGroup();
        if (p != null) {
            p.damage(sync, rect);
        }
    }

    public void damage(int sync, Rectangle2D oldBounds, Rectangle2D newBounds) {
        if (!this.hasDamageEnabled()) {
            return;
        }
        Rectangle.union(oldBounds, newBounds, oldBounds);
        this.damage(sync, oldBounds);
    }

    public long getLatestRenderTime() {
        return this.latestRenderTime;
    }

    public final void render(SatinGraphics g) {
        if (!this.isVisible()) {
            if (SatinConstants.cmdsubsys.isSelected(this)) {
                SatinConstants.cmdsubsys.removeSelected(this);
            }
            return;
        }
        if (this.rectClipBoundsAA == null) {
            this.rectClipBoundsAA = new Rectangle();
        }
        if (this.rectClipBoundsBB == null) {
            this.rectClipBoundsBB = new Rectangle2D.Float();
        }
        this.rectClipBoundsAA = g.getClipBounds(this.rectClipBoundsAA);
        this.rectClipBoundsBB = this.getBounds2D(10, null, this.rectClipBoundsBB);
        if (this.rectClipBoundsBB.getWidth() == 0.0 || this.rectClipBoundsBB.getHeight() == 0.0) {
            this.rectClipBoundsBB.setRect(this.rectClipBoundsBB.getX(), this.rectClipBoundsBB.getY(), this.rectClipBoundsBB.getWidth() + 1.0, this.rectClipBoundsBB.getHeight() + 1.0);
        }
        if (!this.rectClipBoundsAA.intersects(this.rectClipBoundsBB)) {
            return;
        }
        if (this.isClippedToBounds()) {
            g.clipRect((int)this.rectClipBoundsBB.getX(), (int)this.rectClipBoundsBB.getY(), (int)this.rectClipBoundsBB.getWidth(), (int)this.rectClipBoundsBB.getHeight());
        }
        if (this.getSheet() != null) {
            this.latestRenderTime = this.getSheet().getRenderServer().getLatestRenderTimeStamp();
        }
        this.isRenderFinished = false;
        this.view.render(g);
        this.isRenderFinished = true;
        if (this.isClippedToBounds()) {
            g.setClip(this.rectClipBoundsAA.x, this.rectClipBoundsAA.y, this.rectClipBoundsAA.width, this.rectClipBoundsAA.height);
        }
        if (defaultFlagDebug || SatinConstants.cmdsubsys.isSelected(this)) {
            Rectangle2D rect = this.getBounds2D(12);
            g.ignoreTransforms();
            if ((!(this instanceof TimedStroke) || this.view.isNormalized()) && defaultFlagDebug) {
                g.pushStyle(debugStyle);
                this.renderDebug(g, rect);
                g.popStyle();
            }
            if (SatinConstants.cmdsubsys.isSelected(this) && this.isVisible()) {
                g.pushStyle(selectedStyle);
                this.renderSelected(g, rect);
                g.popStyle();
            }
            g.dontIgnoreTransforms();
        }
    }

    protected abstract void defaultRender(SatinGraphics var1);

    protected void renderDebug(SatinGraphics g, Rectangle2D rect) {
        this.renderAllCoordBounds(g, rect);
        this.renderBoundingBox(g, rect);
    }

    protected void renderSelected(SatinGraphics g, Rectangle2D rect) {
        int size = 6;
        int x = (int)rect.getX();
        int y = (int)rect.getY();
        int w = (int)rect.getWidth();
        int h = (int)rect.getHeight();
        int x1 = x;
        int y1 = y;
        int x2 = x + w / 2;
        int y2 = y;
        int x3 = x + w;
        int y3 = y;
        int x4 = x + w;
        int y4 = y + h / 2;
        int x5 = x + w;
        int y5 = y + h;
        int x6 = x + w / 2;
        int y6 = y + h;
        int x7 = x;
        int y7 = y + h;
        int x8 = x;
        int y8 = y + h / 2;
        g.fillRect(x1 - size / 2, y1 - size / 2, size, size);
        g.fillRect(x2 - size / 2, y2 - size / 2, size, size);
        g.fillRect(x3 - size / 2, y3 - size / 2, size, size);
        g.fillRect(x4 - size / 2, y4 - size / 2, size, size);
        g.fillRect(x5 - size / 2, y5 - size / 2, size, size);
        g.fillRect(x6 - size / 2, y6 - size / 2, size, size);
        g.fillRect(x7 - size / 2, y7 - size / 2, size, size);
        g.fillRect(x8 - size / 2, y8 - size / 2, size, size);
    }

    protected void renderSelectionHandle(SatinGraphics g, int x, int y) {
        int size = 6;
        g.fillRect(x - size / 2, y - size / 2, size, size);
    }

    private void renderBoxedNum(SatinGraphics g, Font font, int val, int x, int y, int pos) {
        String str = "" + val;
        Rectangle rect = GraphicsLib.calculateBoundingBox(str, font, x, y, pos);
        rect.x = x;
        rect.y = y;
        g.fillRect(rect, pos);
        g.drawString(str, x, y, pos);
    }

    protected void renderAllCoordBounds(SatinGraphics g, Rectangle2D bounds) {
        int x1 = (int)bounds.getX();
        int y1 = (int)bounds.getY();
        int x2 = (int)(bounds.getX() + bounds.getWidth());
        int y2 = (int)(bounds.getY() + bounds.getHeight());
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        this.renderBoxedNum(g, g.getFont(), x1, x1, y1 + (int)(0.25 * (double)h), 83);
        this.renderBoxedNum(g, g.getFont(), y1, x1 + (int)(0.25 * (double)w), y1, 81);
        this.renderBoxedNum(g, g.getFont(), x2, x2, y1 + (int)(0.75 * (double)h), 85);
        this.renderBoxedNum(g, g.getFont(), y2, x1 + (int)(0.75 * (double)w), y2, 87);
    }

    protected void renderBoundingBox(SatinGraphics g, Rectangle2D bounds) {
        g.drawRect((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
    }

    protected void renderDimensions(SatinGraphics g, Rectangle2D bounds) {
        if (bounds.getWidth() < 60.0 || bounds.getHeight() < 60.0) {
            return;
        }
        int x1 = (int)bounds.getX();
        int y1 = (int)bounds.getY();
        int x2 = (int)(bounds.getX() + bounds.getWidth());
        int y2 = (int)(bounds.getY() + bounds.getHeight());
        g.drawLine(x2 - 30, y2 - 60, x2 - 30, y1 + 60);
        this.renderBoxedNum(g, g.getFont(), (int)bounds.getHeight(), x2 - 30, y1 + (int)(0.3 * bounds.getHeight()), 84);
        g.drawLine(x2 - 60, y2 - 30, x1 + 60, y2 - 30);
        this.renderBoxedNum(g, g.getFont(), (int)bounds.getWidth(), x1 + (int)(0.3 * bounds.getWidth()), y2 - 30, 84);
    }

    public boolean equals(Object obj) {
        GraphicalObject gob;
        return obj instanceof GraphicalObject && (gob = (GraphicalObject)obj).getUniqueID() == this.getUniqueID();
    }

    public Object clone() {
        throw new RuntimeException("The method clone() in class " + this.getClass() + " has not been correctly overridden yet...");
    }

    protected GraphicalObjectImpl clone(GraphicalObjectImpl gobClone) {
        gobClone.parent = null;
        gobClone.tx = (AffineTransform)this.tx.clone();
        gobClone.flagDirty = true;
        gobClone.setViewHandler((ViewHandler)this.view.clone());
        return gobClone;
    }

    public Object deepClone() {
        return this.clone();
    }

    protected GraphicalObjectImpl deepClone(GraphicalObjectImpl gobClone) {
        return this.clone(gobClone);
    }

    public String getPresentationName() {
        StringBuffer strbuf = new StringBuffer("################################################\n");
        String strClass = this.getClass().toString();
        int index = strClass.lastIndexOf(46);
        if (index >= 0) {
            strClass = strClass.substring(index + 1);
        }
        String strPres = "   " + strClass + " ID: " + this.getUniqueID() + "   ";
        strbuf.replace(3, strPres.length() + 3, strPres);
        return strbuf.toString();
    }

    public final String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append("################################################\n" + this.getPresentationName());
        strbuf.append(this.toDebugString());
        strbuf.append("\n" + this.getPresentationName() + "################################################\n");
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public String toDebugString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append("ParentID:       ");
        GraphicalObjectGroup parent = this.getParentGroup();
        if (parent == null) {
            strbuf.append("No parent");
        } else {
            strbuf.append(parent.getUniqueID());
        }
        strbuf.append("\nRel Layer:      " + this.getRelativeLayer());
        strbuf.append("\nAbs Layer:      " + this.getAbsoluteLayer());
        strbuf.append("\nLocation:       " + StringLib.toString(this.getLocation2D(11)));
        strbuf.append("\nTransform:      " + this.getTransformRef());
        strbuf.append("\nClosedBdingPts: " + this.hasClosedBoundingPoints());
        strbuf.append("\nLocalBounds:    " + StringLib.toString(this.getBounds2D(10)));
        strbuf.append("\nLocalBdingPts:  " + StringLib.toString(this.getBoundingPoints2D(10)));
        strbuf.append("\nBounds:         " + StringLib.toString(this.getBounds2D(11)));
        strbuf.append("\nBdingPts:       " + StringLib.toString(this.getBoundingPoints2D(11)));
        strbuf.append("\nAbsBounds:      " + StringLib.toString(this.getBounds2D(12)));
        strbuf.append("\nAbsBdingPts:    " + StringLib.toString(this.getBoundingPoints2D(12)));
        strbuf.append("\nWatched by:     " + this.watchable.toString());
        strbuf.append("\nStyle:\n" + StringLib.indent(this.getStyleRef().toString(), 3));
        strbuf.append("\nInkInterpreter:\n" + StringLib.indent(this.getInkInterpreter().toString(), 3));
        strbuf.append("\nGestureInterpreter:\n" + StringLib.indent(this.getGestureInterpreter().toString(), 3));
        strbuf.append("\nView:\n" + StringLib.indent(this.getView().toString(), 3));
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public void deepClear() {
        this.tx = null;
        this.xBoundingPts = null;
        this.renderCache = null;
        this.rectClipBoundsAA = null;
        this.rectClipBoundsBB = null;
    }

    final class InternalInteractionHandler
    extends InteractionHandler {
        public InternalInteractionHandler() {
            super(GraphicalObjectImpl.this);
        }
    }

    final class InternalViewHandler
    extends ViewHandler {
        public InternalViewHandler() {
            super(GraphicalObjectImpl.this);
        }
    }

    public class GraphicalObjectRenderingCache {
        private BufferedImage cacheImage = null;
        private AffineTransform cacheTransform = null;
        private boolean isCacheValid = false;
        private GraphicalObject attachedGob = null;

        public GraphicalObjectRenderingCache(GraphicalObject obj) {
            this.attachedGob = obj;
        }

        public BufferedImage getCacheImage() {
            if (this.isCacheValid) {
                return this.cacheImage;
            }
            return null;
        }

        public BufferedImage getCacheHistory() {
            return this.cacheImage;
        }

        public AffineTransform getCacheTransform() {
            if (this.isCacheValid) {
                return this.cacheTransform;
            }
            return null;
        }

        public void setCacheTransform(AffineTransform tr) {
            this.cacheTransform = tr;
        }

        public void setCacheImage(BufferedImage ci) {
            this.cacheImage = ci;
        }

        public void updateCache(AffineTransform refTransform, Style refStyle) {
            ((GraphicalObjectImpl)this.attachedGob).updateCacheInternal(this, refTransform, refStyle);
            if (this.cacheImage != null) {
                this.isCacheValid = true;
            }
        }

        public boolean getCacheValidity() {
            return this.isCacheValid;
        }

        public void setCacheInvalide() {
            this.isCacheValid = false;
            GraphicalObjectImpl gob = (GraphicalObjectImpl)((Object)this.attachedGob.getParentGroup());
            if (gob != null) {
                gob.getRenderCache().setCacheInvalide();
            }
        }
    }

    static final class DefaultView
    extends DefaultViewImpl {
        public DefaultView() {
            this.setName("DefaultView");
        }

        public void render(SatinGraphics g) {
            ((GraphicalObjectImpl)this.gob).defaultRender(g);
        }

        public Object clone() {
            return this.clone(new DefaultView());
        }

        protected DefaultView clone(DefaultView v) {
            super.clone(v);
            return v;
        }
    }
}

