/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.collection.OrderedList;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SatinEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.StrokeEvent;
import edu.berkeley.guir.lib.satin.event.StrokeListener;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollectionImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.objects.InteractionHandler;
import edu.berkeley.guir.lib.satin.objects.SwingPeer;
import edu.berkeley.guir.lib.satin.objects.SwingPeerContainer;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import edu.berkeley.guir.lib.satin.util.GetType;
import edu.berkeley.guir.lib.satin.util.GetTypeContainedBy;
import edu.berkeley.guir.lib.satin.util.GetTypeContains;
import edu.berkeley.guir.lib.satin.util.GetTypeIntersects;
import edu.berkeley.guir.lib.satin.watch.Watchable;
import edu.berkeley.guir.lib.satin.watch.Watcher;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class GraphicalObjectGroupImpl
extends GraphicalObjectImpl
implements GraphicalObjectGroup,
GraphicalObjectCollection,
GraphicalObject,
Watchable,
Watcher,
Shape,
StrokeListener,
SwingPeerContainer {
    static final long serialVersionUID = -2021211329861762769L;
    static DispatchNewStrategy dispatchNew;
    static DispatchUpdateStrategy dispatchUpdate;
    static DispatchSingleStrategy dispatchSingle;
    static GetType getTypeContainedBy;
    static GetType getTypeContains;
    static GetType getTypeIntersects;
    GraphicalObjectCollectionImpl gobcol = new GraphicalObjectCollectionImpl();
    private boolean ignoreChildDelete = false;
    private boolean allowDeepGet = true;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroupImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        dispatchNew = new DispatchNewStrategy();
        dispatchUpdate = new DispatchUpdateStrategy();
        dispatchSingle = new DispatchSingleStrategy();
        getTypeContainedBy = new GetTypeContainedBy();
        getTypeContains = new GetTypeContains();
        getTypeIntersects = new GetTypeIntersects();
    }

    protected InteractionHandler createNewInteractionHandler() {
        return new InternalInteractionHandler();
    }

    public GraphicalObject add(GraphicalObject gob) {
        return this.addToFront(gob);
    }

    public GraphicalObject addToBack(GraphicalObject gob) {
        return this.add(this.gobcol.numElements(), gob);
    }

    public GraphicalObject addToFront(GraphicalObject gob) {
        return this.add(0, gob);
    }

    public GraphicalObject add(int index, GraphicalObject gob) {
        return this.add(index, gob, 6);
    }

    public GraphicalObject add(GraphicalObject gob, int pos) {
        return this.addToFront(gob, pos);
    }

    public GraphicalObject addToBack(GraphicalObject gob, int pos) {
        return this.add(this.gobcol.numElements(), gob, pos);
    }

    public GraphicalObject addToFront(GraphicalObject gob, int pos) {
        return this.add(0, gob, pos);
    }

    private void callInitAfterAddToSheet(GraphicalObject gob) {
        gob.initAfterAddToSheet();
        if (gob instanceof GraphicalObjectGroup) {
            GraphicalObjectGroup grp = (GraphicalObjectGroup)gob;
            Iterator it = grp.getForwardIterator();
            while (it.hasNext()) {
                GraphicalObject child = (GraphicalObject)it.next();
                this.callInitAfterAddToSheet(child);
            }
        }
    }

    public GraphicalObject add(int index, GraphicalObject gob, int pos) {
        gob.disableNotify();
        gob.disableDamage();
        if (pos == 5) {
            GraphicalObjectLib.toLocalCoordinates(gob, this);
        }
        gob.setParentGroup(this);
        gob.addWatcher(this);
        this.gobcol.add(index, gob);
        gob.enableNotify();
        gob.enableDamage();
        this.updateGroupBounds(gob);
        gob.initAfterAdd();
        if (this.getSheet() != null) {
            this.callInitAfterAddToSheet(gob);
        }
        this.damage(21, gob);
        return gob;
    }

    public void clear() {
        Rectangle2D bounds = this.getBounds2D(12);
        this.gobcol.clear();
        this.updateGroupBounds();
        this.damage(21, bounds);
    }

    public boolean contains(GraphicalObject gob) {
        return this.gobcol.contains(gob);
    }

    public GraphicalObject get(int index) {
        return this.gobcol.get(index);
    }

    public GraphicalObject getFirst() {
        return this.gobcol.getFirst();
    }

    public GraphicalObject getLast() {
        return this.gobcol.getLast();
    }

    public GraphicalObject getID(int id) {
        return this.gobcol.getID(id);
    }

    public Rectangle2D getCollectionBounds2D(int cdsys) {
        return this.gobcol.getCollectionBounds2D(cdsys);
    }

    public Rectangle2D getCollectionBounds2D(int cdsys, Rectangle2D rect) {
        return this.gobcol.getCollectionBounds2D(cdsys, rect);
    }

    public int indexOf(GraphicalObject gob) {
        return this.gobcol.indexOf(gob);
    }

    public boolean isEmpty() {
        return this.gobcol.isEmpty();
    }

    public void sort(Comparator c) {
    }

    public int numElements() {
        return this.gobcol.numElements();
    }

    public GraphicalObject removeSilently(GraphicalObject gob) {
        if (!this.contains(gob)) {
            return gob;
        }
        this.gobcol.remove(gob);
        gob.setParentGroup(null);
        gob.removeWatcher(this);
        return gob;
    }

    public GraphicalObject remove(GraphicalObject gob) {
        if (!this.contains(gob)) {
            return gob;
        }
        Rectangle2D bounds = this.getBounds2D(12);
        this.gobcol.remove(gob);
        this.updateGroupBounds();
        gob.setParentGroup(null);
        gob.removeWatcher(this);
        this.damage(21, bounds);
        return gob;
    }

    public Iterator getForwardIterator() {
        return this.gobcol.getForwardIterator();
    }

    public Iterator getReverseIterator() {
        return this.gobcol.getReverseIterator();
    }

    protected void updateGroupBounds(GraphicalObject gob) {
        Rectangle2D oldBounds = (Rectangle2D)SatinConstants.poolRects.getObject();
        Rectangle2D newBounds = (Rectangle2D)SatinConstants.poolRects.getObject();
        this.getBounds2D(12, null, oldBounds);
        gob.getBounds2D(12, null, newBounds);
        if (this.numElements() > 1) {
            Rectangle2D.union(oldBounds, newBounds, newBounds);
        }
        double dw = Math.abs(newBounds.getWidth() - oldBounds.getWidth());
        double dh = Math.abs(newBounds.getHeight() - oldBounds.getHeight());
        if (dw > 0.001 || dh > 0.001) {
            AffineTransform oldTx = this.getTransform(11);
            this.disableDamage();
            this.disableNotify();
            this.setBoundingPoints2D(12, newBounds);
            this.setTransform(oldTx);
            this.enableDamage();
            this.enableNotify();
        }
        SatinConstants.poolRects.releaseObject(oldBounds);
        SatinConstants.poolRects.releaseObject(newBounds);
    }

    protected void updateGroupBounds() {
        GraphicalObject gob;
        Rectangle2D oldBounds = (Rectangle2D)SatinConstants.poolRects.getObject();
        Rectangle2D newBounds = (Rectangle2D)SatinConstants.poolRects.getObject();
        newBounds.setRect(0.0, 0.0, 0.0, 0.0);
        Iterator it = this.gobcol.getForwardIterator();
        if (it.hasNext()) {
            gob = (GraphicalObject)it.next();
            oldBounds = gob.getBounds2D(12, null, oldBounds);
        }
        while (it.hasNext()) {
            gob = (GraphicalObject)it.next();
            newBounds = gob.getBounds2D(12, null, newBounds);
            Rectangle2D.union(oldBounds, newBounds, oldBounds);
        }
        AffineTransform oldTx = this.getTransform(11);
        this.disableDamage();
        this.disableNotify();
        this.setBoundingPoints2D(12, newBounds);
        this.setTransform(oldTx);
        this.enableDamage();
        this.enableNotify();
        SatinConstants.poolRects.releaseObject(oldBounds);
        SatinConstants.poolRects.releaseObject(newBounds);
    }

    public int getRelativeLayer(GraphicalObject gob) {
        return this.gobcol.indexOf(gob);
    }

    public void setRelativeLayer(GraphicalObject gob, int layer) {
        if (layer < 0) {
            return;
        }
        OrderedList list = this.gobcol.getOrderedList();
        int index = list.indexOf(gob);
        if (layer >= list.size()) {
            list.moveToBack(index);
        } else {
            list.moveTo(index, layer);
        }
        this.damage(21, gob);
    }

    public List getAbsoluteLayer(GraphicalObject gob) {
        return gob.getAbsoluteLayer();
    }

    public void bringUpALayer(GraphicalObject gob) {
        OrderedList list = this.gobcol.getOrderedList();
        int pos = this.gobcol.indexOf(gob);
        list.swap(pos, pos - 1);
        this.damage(21, gob);
    }

    public void bringUpNLayers(GraphicalObject gob, int n) {
        OrderedList list = this.gobcol.getOrderedList();
        int pos = this.gobcol.indexOf(gob);
        list.moveTo(pos, Math.min(0, pos - n));
        this.damage(21, gob);
    }

    public void bringDownALayer(GraphicalObject gob) {
        OrderedList list = this.gobcol.getOrderedList();
        int pos = this.gobcol.indexOf(gob);
        list.swap(pos, pos + 1);
        this.damage(21, gob);
    }

    public void bringDownNLayers(GraphicalObject gob, int n) {
        OrderedList list = this.gobcol.getOrderedList();
        int pos = this.gobcol.indexOf(gob);
        list.moveTo(pos, Math.min(list.size() - 1, pos + n));
        this.damage(21, gob);
    }

    public void bringToTopLayer(GraphicalObject gob) {
        OrderedList list = this.gobcol.getOrderedList();
        int pos = this.gobcol.indexOf(gob);
        list.moveToFront(pos);
        this.damage(21, gob);
    }

    public void bringToBottomLayer(GraphicalObject gob) {
        OrderedList list = this.gobcol.getOrderedList();
        int pos = this.gobcol.indexOf(gob);
        list.moveToBack(pos);
        this.damage(21, gob);
    }

    public void removeAllSilently(GraphicalObjectCollection gobcol) {
        Iterator it = gobcol.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            this.removeSilently(gob);
        }
    }

    public void removeAll(GraphicalObjectCollection gobcol) {
        Rectangle2D rect = gobcol.getCollectionBounds2D(12);
        Iterator it = gobcol.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            this.remove(gob);
        }
        this.damage(21, rect);
    }

    public boolean getAllowDeepGet() {
        return this.allowDeepGet;
    }

    public void setAllowDeepGet(boolean flag) {
        this.allowDeepGet = flag;
    }

    private GraphicalObjectCollection handleDepth(int depth) {
        GraphicalObjectCollection search;
        switch (depth) {
            case 41: {
                search = GraphicalObjectLib.flatten(this.gobcol);
                break;
            }
            case 40: {
                search = this.gobcol;
                break;
            }
            default: {
                throw new RuntimeException("Invalid depth parameter");
            }
        }
        return search;
    }

    private GetType handleGetTypeAlgorithm(int gettype) {
        GetType getalg = null;
        switch (gettype) {
            case 50: {
                getalg = getTypeIntersects;
                break;
            }
            case 51: {
                getalg = getTypeContainedBy;
                break;
            }
            case 52: {
                getalg = getTypeContains;
                break;
            }
            case 54: {
                throw new RuntimeException("Not implemented yet");
            }
            case 55: {
                throw new RuntimeException("Not implemented yet");
            }
            default: {
                throw new RuntimeException("Invalid get-type parameter");
            }
        }
        return getalg;
    }

    private GraphicalObjectCollection handleNumber(GraphicalObjectCollection out, int num) {
        if (out.numElements() > 0) {
            switch (num) {
                case 30: {
                    break;
                }
                case 31: {
                    GraphicalObject gob = GraphicalObjectLib.getTopmostLeaf(out);
                    if (gob == null) {
                        gob = GraphicalObjectLib.getTopmostBranch(out);
                    }
                    out.clear();
                    out.add(gob);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid number-of-items parameter");
                }
            }
        }
        return out;
    }

    private void getDeepGraphicalObjects(Object ptOrShape, GraphicalObject in, double thresh, GetType getalg, GraphicalObjectCollection out) {
        GraphicalObjectCollectionImpl inCol = new GraphicalObjectCollectionImpl();
        GraphicalObjectCollectionImpl outCol = new GraphicalObjectCollectionImpl();
        GraphicalObjectCollectionImpl recursiveSearch = new GraphicalObjectCollectionImpl();
        inCol.add(in);
        if (ptOrShape instanceof Point2D) {
            getalg.get((Point2D)ptOrShape, (GraphicalObjectCollection)inCol, thresh, (GraphicalObjectCollection)outCol);
        } else if (ptOrShape instanceof Shape) {
            getalg.get((Shape)ptOrShape, (GraphicalObjectCollection)inCol, thresh, (GraphicalObjectCollection)outCol);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        if (getalg instanceof GetTypeContainedBy && in instanceof GraphicalObjectGroup) {
            if (ptOrShape instanceof Point2D) {
                getTypeIntersects.get((Point2D)ptOrShape, (GraphicalObjectCollection)inCol, thresh, (GraphicalObjectCollection)recursiveSearch);
            } else {
                getTypeIntersects.get((Shape)ptOrShape, (GraphicalObjectCollection)inCol, thresh, (GraphicalObjectCollection)recursiveSearch);
            }
        }
        if (outCol.isEmpty() && recursiveSearch.isEmpty()) {
            return;
        }
        if (!$assertionsDisabled && (outCol.isEmpty() || outCol.get(0) != in)) {
            throw new AssertionError();
        }
        if (in instanceof GraphicalObjectGroup) {
            GraphicalObjectGroup inGrp = (GraphicalObjectGroup)in;
            int numOut = out.numElements();
            if (inGrp.getAllowDeepGet()) {
                Iterator it = inGrp.getForwardIterator();
                while (it.hasNext()) {
                    GraphicalObject gob = (GraphicalObject)it.next();
                    this.getDeepGraphicalObjects(ptOrShape, gob, thresh, getalg, out);
                }
            }
            if (out.numElements() == numOut && !outCol.isEmpty()) {
                out.add(in);
            }
        } else if (!outCol.isEmpty()) {
            out.add(in);
        }
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, Point2D pt, int num, int depth, int gettype, double thresh, GraphicalObjectCollection out) {
        Point2D ptTmp = (Point2D)SatinConstants.poolPoints.getObject();
        if (out == null) {
            out = new GraphicalObjectCollectionImpl();
        }
        switch (cdsys) {
            case 12: {
                ptTmp.setLocation(pt.getX(), pt.getY());
                break;
            }
            case 11: {
                AffineTransform tx = (AffineTransform)SatinConstants.poolTx.getObject();
                if (this.getParentGroup() != null) {
                    this.getParentGroup().getTransform(12, tx);
                }
                tx.transform(pt, ptTmp);
                SatinConstants.poolTx.releaseObject(tx);
                break;
            }
            case 10: {
                GraphicalObjectLib.localToAbsolute(this, pt, ptTmp);
                break;
            }
            default: {
                throw new RuntimeException("Invalid coordinate-system parameter");
            }
        }
        GraphicalObjectCollection search = this.handleDepth(40);
        GetType getalg = this.handleGetTypeAlgorithm(gettype);
        getalg.get(ptTmp, search, thresh, out);
        if (depth == 41 && this.getAllowDeepGet()) {
            GraphicalObjectCollectionImpl shallowOut = new GraphicalObjectCollectionImpl(out);
            out.clear();
            Iterator it = shallowOut.getForwardIterator();
            while (it.hasNext()) {
                GraphicalObject gob = (GraphicalObject)it.next();
                this.getDeepGraphicalObjects(ptTmp, gob, thresh, getalg, out);
            }
        } else if (!$assertionsDisabled && depth != 40) {
            throw new AssertionError();
        }
        out = this.handleNumber(out, num);
        SatinConstants.poolPoints.releaseObject(ptTmp);
        return out;
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, double x, double y, int num, int depth, int gettype, double thresh, GraphicalObjectCollection out) {
        Point2D pt = (Point2D)SatinConstants.poolPoints.getObject();
        pt.setLocation(x, y);
        GraphicalObjectCollection gobcol = this.getGraphicalObjects(cdsys, pt, num, depth, gettype, thresh, out);
        SatinConstants.poolPoints.releaseObject(pt);
        return gobcol;
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, Shape s, int num, int depth, int gettype, double thresh, GraphicalObjectCollection out) {
        Polygon2D poly = (Polygon2D)SatinConstants.poolPolys.getObject();
        AffineTransform tx = (AffineTransform)SatinConstants.poolTx.getObject();
        if (out == null) {
            out = new GraphicalObjectCollectionImpl();
        }
        switch (cdsys) {
            case 12: {
                break;
            }
            case 11: {
                if (this.getParentGroup() == null) break;
                this.getParentGroup().getTransform(12, tx);
                break;
            }
            case 10: {
                this.getTransform(12, tx);
                break;
            }
            default: {
                throw new RuntimeException("Invalid coordinate-system parameter");
            }
        }
        poly.setToPathIterator(s.getPathIterator(tx));
        GraphicalObjectCollection search = this.handleDepth(40);
        GetType getalg = this.handleGetTypeAlgorithm(gettype);
        getalg.get(poly, search, thresh, out);
        if (depth == 41 && this.getAllowDeepGet()) {
            GraphicalObjectCollectionImpl shallowOut = new GraphicalObjectCollectionImpl(out);
            out.clear();
            if (getalg instanceof GetTypeContainedBy) {
                getTypeIntersects.get(poly, search, thresh, (GraphicalObjectCollection)shallowOut);
            }
            Iterator it = shallowOut.getForwardIterator();
            while (it.hasNext()) {
                GraphicalObject gob = (GraphicalObject)it.next();
                this.getDeepGraphicalObjects(poly, gob, thresh, getalg, out);
            }
        } else if (!$assertionsDisabled && depth != 40) {
            throw new AssertionError();
        }
        out = this.handleNumber(out, num);
        SatinConstants.poolPolys.releaseObject(poly);
        SatinConstants.poolTx.releaseObject(tx);
        return out;
    }

    public GraphicalObjectCollection getGraphicalObjects(GraphicalObject gob, int num, int depth, int gettype, double thresh, GraphicalObjectCollection out) {
        Polygon2D poly = (Polygon2D)SatinConstants.poolPolys.getObject();
        gob.getBoundingPoints2D(12, null, poly);
        GraphicalObjectCollection gobcol = this.getGraphicalObjects(12, poly, num, depth, gettype, thresh, out);
        SatinConstants.poolPolys.releaseObject(poly);
        return gobcol;
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, Point2D pt, int num, int depth, int gettype) {
        return this.getGraphicalObjects(cdsys, pt, num, depth, gettype, 5.0, null);
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, double x, double y, int num, int depth, int gettype) {
        return this.getGraphicalObjects(cdsys, x, y, num, depth, gettype, 5.0, null);
    }

    public GraphicalObjectCollection getGraphicalObjects(int cdsys, Shape s, int num, int depth, int gettype) {
        return this.getGraphicalObjects(cdsys, s, num, depth, gettype, 5.0, null);
    }

    public GraphicalObjectCollection getGraphicalObjects(GraphicalObject gob, int num, int depth, int gettype) {
        return this.getGraphicalObjects(gob, num, depth, gettype, 5.0, null);
    }

    public GraphicalObjectCollection getGraphicalObjects() {
        return this.gobcol;
    }

    public void onNotify(Watchable w, Object arg) {
    }

    public void onUpdate(Watchable w, Object arg) {
        this.setBoundingPoints2D(10, this.getCollectionBounds2D(12));
    }

    public void onUpdate(Watchable w, String strProperty, Object oldVal, Object newVal) {
        this.setBoundingPoints2D(10, this.getCollectionBounds2D(12));
    }

    public void onDelete(Watchable w) {
        if (!this.ignoreChildDelete && w instanceof GraphicalObject) {
            this.remove((GraphicalObject)w);
        }
    }

    public void notifyWatchersDelete() {
        super.notifyWatchersDelete();
        this.ignoreChildDelete = true;
        this.gobcol.setIgnoreChildDelete(true);
        Iterator iter = this.gobcol.getForwardIterator();
        while (iter.hasNext()) {
            ((GraphicalObject)iter.next()).notifyWatchersDelete();
        }
        this.ignoreChildDelete = false;
        this.gobcol.setIgnoreChildDelete(false);
    }

    protected GraphicalObject getDispatchee(TimedStroke stk) {
        Iterator it = this.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            if (!gob.shapeContains(stk)) continue;
            return gob;
        }
        return null;
    }

    protected GraphicalObject getCachedDispatchee(StrokeEvent evt) {
        return evt.getNextDispatchee(this);
    }

    protected boolean shapeContainsInternal(Point2D pt) {
        boolean flagReturn = false;
        Iterator it = this.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            if (!gob.shapeContains(11, pt)) continue;
            flagReturn = true;
            break;
        }
        return flagReturn;
    }

    protected boolean shapeContainsInternal(Shape s) {
        boolean flagReturn = false;
        Iterator it = this.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            if (!gob.shapeContains(11, s)) continue;
            flagReturn = true;
            break;
        }
        return flagReturn;
    }

    protected boolean shapeIntersectsInternal(Shape s) {
        boolean flagReturn = false;
        Iterator it = this.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            if (!gob.shapeIntersects(11, s)) continue;
            flagReturn = true;
            break;
        }
        return flagReturn;
    }

    protected void defaultRender(SatinGraphics g) {
        Iterator it = this.gobcol.getReverseIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            try {
                g.pushStyle(gob.getStyleRef());
                g.pushTransform(gob.getTransformRef());
                gob.render(g);
                g.popTransform();
                g.popStyle();
            }
            catch (Exception e) {
                gob.render(g);
            }
        }
    }

    public String toDebugString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append(super.toDebugString());
        strbuf.append("\nWatcher IDs:    " + this.hashCode() + ", " + this.gobcol.hashCode());
        strbuf.append("\nContained GObs: " + this.gobcol.toString());
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public Object clone() {
        return this.clone(new GraphicalObjectGroupImpl());
    }

    protected GraphicalObjectGroupImpl clone(GraphicalObjectGroupImpl gobgrpClone) {
        super.clone(gobgrpClone);
        Iterator it = this.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            gobgrpClone.addToBack(gob);
        }
        return gobgrpClone;
    }

    public Object deepClone() {
        return this.deepClone(new GraphicalObjectGroupImpl());
    }

    protected GraphicalObjectGroupImpl deepClone(GraphicalObjectGroupImpl newGobGrp) {
        super.clone(newGobGrp);
        newGobGrp.clear();
        Iterator it = this.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            GraphicalObject gobClone = (GraphicalObject)gob.deepClone();
            gobClone.clearWatchers();
            newGobGrp.addToBack(gobClone);
        }
        return newGobGrp;
    }

    public void addSwingPeer(SwingPeer peer, Sheet sheet) {
        this.addToFront(peer, 6);
        if (this.getSheet() == null) {
            sheet.add(peer.getRealComponent());
        } else {
            this.getSheet().add(peer.getRealComponent());
        }
    }

    public void removeSwingPeer(SwingPeer peer) {
        this.remove(peer);
        this.getSheet().remove(peer.getRealComponent());
    }

    final class InternalInteractionHandler
    extends InteractionHandler {
        public InternalInteractionHandler() {
            super(GraphicalObjectGroupImpl.this);
        }

        public InternalInteractionHandler(InternalInteractionHandler handler) {
            super(handler);
        }

        public void redispatchNewStroke(NewStrokeEvent evt) {
            this.onStroke(evt, dispatchNew);
        }

        public void redispatchUpdateStroke(UpdateStrokeEvent evt) {
            this.onStroke(evt, dispatchUpdate);
        }

        public void redispatchSingleStroke(SingleStrokeEvent evt) {
            this.onStroke(evt, dispatchSingle);
        }

        private void onStroke(StrokeEvent evt, DispatchStrategy strategy) {
            TimedStroke stk = evt.getStroke();
            GraphicalObject gob = null;
            if (evt instanceof NewStrokeEvent) {
                gob = GraphicalObjectGroupImpl.this.getDispatchee(stk);
                evt.appendDispatchee(gob);
            } else {
                gob = GraphicalObjectGroupImpl.this.getCachedDispatchee(evt);
                if (gob != null && !gob.shapeContains(stk)) {
                    evt.removeDispatchee(gob);
                    gob = null;
                }
            }
            if (gob != null) {
                strategy.redispatch(gob, evt);
            }
        }

        public Object clone() {
            return new InternalInteractionHandler(this);
        }
    }

    static abstract class DispatchStrategy {
        DispatchStrategy() {
        }

        public abstract void redispatch(GraphicalObject var1, SatinEvent var2);
    }

    static final class DispatchNewStrategy
    extends DispatchStrategy {
        DispatchNewStrategy() {
        }

        public void redispatch(GraphicalObject gob, SatinEvent evt) {
            gob.onNewStroke((NewStrokeEvent)evt);
        }
    }

    static final class DispatchUpdateStrategy
    extends DispatchStrategy {
        DispatchUpdateStrategy() {
        }

        public void redispatch(GraphicalObject gob, SatinEvent evt) {
            gob.onUpdateStroke((UpdateStrokeEvent)evt);
        }
    }

    static final class DispatchSingleStrategy
    extends DispatchStrategy {
        DispatchSingleStrategy() {
        }

        public void redispatch(GraphicalObject gob, SatinEvent evt) {
            gob.onSingleStroke((SingleStrokeEvent)evt);
        }
    }
}

