/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.collection.OrderedList;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.PatchImpl;
import edu.berkeley.guir.lib.satin.watch.Watchable;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class GraphicalObjectCollectionImpl
implements GraphicalObjectCollection {
    static final long serialVersionUID = 864134089977095294L;
    OrderedList list = new OrderedList();
    boolean flagDirty = false;
    Rectangle2D relBounds = new Rectangle2D.Float();
    Rectangle2D absBounds = new Rectangle2D.Float();
    boolean flagIgnoreDelete = false;

    public GraphicalObjectCollectionImpl() {
        this.clearObjectBounds();
    }

    public GraphicalObjectCollectionImpl(GraphicalObjectCollection gobcol) {
        Iterator it = gobcol.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            this.addToBack(gob);
        }
    }

    public GraphicalObjectCollectionImpl(GraphicalObjectCollectionImpl gobcol) {
        gobcol.clone(this);
    }

    protected OrderedList getOrderedList() {
        return this.list;
    }

    void setIgnoreChildDelete(boolean flag) {
        this.flagIgnoreDelete = flag;
    }

    private void clearObjectBounds() {
        this.relBounds.setRect(3.4028234663852886E38, 3.4028234663852886E38, 0.0, 0.0);
        this.absBounds.setRect(3.4028234663852886E38, 3.4028234663852886E38, 0.0, 0.0);
    }

    private void calculateObjectBounds() {
        Iterator it = this.getForwardIterator();
        boolean flagFirst = true;
        this.clearObjectBounds();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            if (flagFirst) {
                flagFirst = false;
                this.relBounds = gob.getBounds2D(11, null, this.relBounds);
                this.absBounds = gob.getBounds2D(12, null, this.absBounds);
                continue;
            }
            this.updateBounds(gob);
        }
        this.flagDirty = false;
    }

    private void updateBounds(GraphicalObject gob) {
        Rectangle2D rect = (Rectangle2D)SatinConstants.poolRects.getObject();
        gob.getBounds2D(11, null, rect);
        Rectangle2D.union(this.relBounds, rect, this.relBounds);
        gob.getBounds2D(12, null, rect);
        Rectangle2D.union(this.absBounds, rect, this.absBounds);
        SatinConstants.poolRects.releaseObject(rect);
    }

    public Rectangle2D getCollectionBounds2D(int cdsys) {
        return this.getCollectionBounds2D(cdsys, new Rectangle2D.Float());
    }

    public Rectangle2D getCollectionBounds2D(int cdsys, Rectangle2D rect) {
        if (!this.flagDirty) {
            // empty if block
        }
        this.calculateObjectBounds();
        if (rect == null) {
            rect = new Rectangle2D.Float();
        }
        switch (cdsys) {
            case 12: {
                rect.setRect(this.absBounds);
                break;
            }
            case 11: {
                rect.setRect(this.relBounds);
                break;
            }
            default: {
                throw new RuntimeException("What the heck did you pass in?");
            }
        }
        return rect;
    }

    public GraphicalObject add(GraphicalObject gob) {
        return this.addToFront(gob);
    }

    public GraphicalObject addToBack(GraphicalObject gob) {
        return this.add(this.numElements(), gob);
    }

    public GraphicalObject addToFront(GraphicalObject gob) {
        return this.add(0, gob);
    }

    public GraphicalObject add(int index, GraphicalObject gob) {
        if (!this.list.contains(gob)) {
            this.list.add(index, gob);
            gob.addWatcher(this);
            this.updateBounds(gob);
        }
        return gob;
    }

    public void clear() {
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            gob.removeWatcher(this);
        }
        this.list.clear();
        this.clearObjectBounds();
    }

    public boolean contains(GraphicalObject gob) {
        return this.list.contains(gob);
    }

    public GraphicalObject get(int index) {
        return (GraphicalObject)this.list.get(index);
    }

    public GraphicalObject getFirst() {
        if (this.numElements() > 0) {
            return (GraphicalObject)this.list.get(0);
        }
        return null;
    }

    public GraphicalObject getLast() {
        if (this.numElements() > 0) {
            return (GraphicalObject)this.list.get(this.numElements() - 1);
        }
        return null;
    }

    public GraphicalObject getID(int id) {
        Iterator it = this.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObjectGroup gobgrp;
            GraphicalObject gob = (GraphicalObject)it.next();
            if (gob.getUniqueID() == id) {
                return gob;
            }
            if (!(gob instanceof GraphicalObjectGroup) || (gob = (gobgrp = (GraphicalObjectGroup)gob).getID(id)) == null) continue;
            return gob;
        }
        return null;
    }

    public int indexOf(GraphicalObject gob) {
        return this.list.indexOf(gob);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int numElements() {
        return this.list.size();
    }

    public GraphicalObject remove(GraphicalObject gob) {
        boolean hadGob = this.list.remove(gob);
        if (hadGob) {
            gob.removeWatcher(this);
            this.flagDirty = true;
        }
        return gob;
    }

    public Iterator getForwardIterator() {
        return this.list.getForwardIterator();
    }

    public Iterator getReverseIterator() {
        return this.list.getReverseIterator();
    }

    public void sort(Comparator c) {
        Collections.sort(this.list, c);
    }

    public void onNotify(Watchable w, Object arg) {
    }

    public void onUpdate(Watchable w, Object arg) {
        this.flagDirty = true;
    }

    public void onUpdate(Watchable w, String strProperty, Object oldVal, Object newVal) {
        this.flagDirty = true;
    }

    public void onRepaint(GraphicalObject gob) {
    }

    public void onRepaint(Rectangle rect) {
    }

    public void onDelete(Watchable w) {
        if (w instanceof GraphicalObject && !this.flagIgnoreDelete) {
            this.remove((GraphicalObject)w);
            this.flagDirty = true;
        }
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        Iterator it = this.getForwardIterator();
        strbuf.append("[\n");
        while (it.hasNext()) {
            String strTmp = it.next().toString();
            strbuf.append(String.valueOf(StringLib.indent(strTmp, 3)) + "\n; \n");
        }
        strbuf.append("]");
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public Object clone() {
        return this.clone(new GraphicalObjectCollectionImpl());
    }

    protected GraphicalObjectCollectionImpl clone(GraphicalObjectCollectionImpl gobcolClone) {
        gobcolClone.list = (OrderedList)this.list.clone();
        gobcolClone.flagDirty = true;
        Iterator it = gobcolClone.list.iterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            gob.addWatcher(gobcolClone);
        }
        return gobcolClone;
    }

    public Object deepClone() {
        return this.deepClone(new GraphicalObjectCollectionImpl());
    }

    protected GraphicalObjectCollectionImpl deepClone(GraphicalObjectCollectionImpl newGobcol) {
        this.clone(newGobcol);
        newGobcol.clear();
        Iterator it = this.getForwardIterator();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            newGobcol.addToBack((GraphicalObject)gob.deepClone());
        }
        return newGobcol;
    }

    public static void main(String[] argv) {
        GraphicalObjectCollectionImpl gobcol = new GraphicalObjectCollectionImpl();
        PatchImpl gob = new PatchImpl(new Rectangle(0, 0, 20, 20));
        gobcol.add(gob);
        gob = new PatchImpl(new Rectangle(30, 60, 20, 20));
        gobcol.add(gob);
        Debug.println(gobcol);
    }
}

