/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.graphics.GraphicsLib;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectImpl;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;

public class GObText
extends GraphicalObjectImpl {
    static final long serialVersionUID = -3108921581005924972L;
    StringBuffer strbuf;
    int numRows = 1;
    int numCols = 1;
    int heightChars;

    public GObText() {
        this.strbuf = new StringBuffer();
    }

    public GObText(String newStr) {
        this.set(newStr);
    }

    public void set(String newStr) {
        this.strbuf = new StringBuffer(newStr);
        this.calculateBounds();
        this.damage(21, this);
    }

    public void append(String newStr) {
        this.strbuf.append(newStr);
        this.calculateBounds();
        this.damage(21, this);
    }

    public void insert(String newStr, int pos) {
        this.strbuf.insert(pos, newStr);
        this.calculateBounds();
        this.damage(21, this);
    }

    public void replace(String newStr, int start, int end) {
        String strFull = this.strbuf.toString();
        String strLeading = strFull.substring(0, start);
        String strTrailing = strFull.substring(end);
        this.strbuf = new StringBuffer(String.valueOf(strLeading) + newStr + strTrailing);
        this.calculateBounds();
        this.damage(21, this);
    }

    public void clear() {
        this.strbuf = new StringBuffer();
        this.calculateBounds();
        this.damage(21, this);
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumRows(int newNumRows) {
        this.numRows = newNumRows;
        this.calculateBounds();
        this.damage(21, this);
    }

    public int getNumCols() {
        return this.numCols;
    }

    public void setNumCols(int newNumCols) {
        this.numCols = newNumCols;
        this.calculateBounds();
        this.damage(21, this);
    }

    private FontMetrics getFontMetrics() {
        Font f = this.getStyle().getDrawFont();
        Toolkit tk = Toolkit.getDefaultToolkit();
        FontMetrics fmetric = tk.getFontMetrics(f);
        return fmetric;
    }

    private void calculateBounds() {
        FontMetrics fmetric = this.getFontMetrics();
        int width = 0;
        int height = 0;
        String str = StringLib.fold(this.strbuf.toString(), "\n", this.getNumCols());
        width = GraphicsLib.calculateTotalWidth(str, fmetric);
        height = GraphicsLib.calculateTotalHeight(str, fmetric);
        this.heightChars = fmetric.getHeight();
        Rectangle bounds = this.getBounds();
        bounds.width = width;
        bounds.height = height;
        this.setBoundingPoints2D(11, bounds);
    }

    protected void defaultRender(SatinGraphics g) {
        Point2D pt = this.getLocation2D(11);
        g.drawString(this.strbuf.toString(), (int)pt.getX(), (int)pt.getY() + this.heightChars);
    }

    public Object clone() {
        GObText gob = new GObText();
        this.clone(gob);
        return gob;
    }

    protected void clone(GObText gob) {
        super.clone(gob);
        gob.strbuf = new StringBuffer(this.strbuf.toString());
        gob.numRows = this.numRows;
        gob.numCols = this.numCols;
        gob.heightChars = this.heightChars;
    }

    public String toDebugString() {
        StringBuffer strbufTmp = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbufTmp.append(String.valueOf(super.toDebugString()) + "\n");
        strbufTmp.append("Text: " + this.strbuf.toString());
        String str = strbufTmp.toString();
        SatinConstants.poolStrbuf.releaseObject(strbufTmp);
        return str;
    }
}

