/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectImpl;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class GObJComponentWrapperOutput
extends GraphicalObjectImpl
implements SatinConstants {
    static final long serialVersionUID = -308123049230984017L;
    JComponent component;
    ComponentListener lstnr;

    public GObJComponentWrapperOutput(JComponent newComponent) {
        this.setComponent(newComponent);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(JComponent comp) {
        if (comp == null) {
            return;
        }
        if (this.component != null) {
            this.component.removeComponentListener(this.lstnr);
        }
        this.component = comp;
        Dimension dim = comp.getSize();
        int compWidth = dim.width;
        int compHeight = dim.height;
        if (comp instanceof JTextArea) {
            String title = ((JTextArea)comp).getText();
            JLabel label = new JLabel(title);
            label.setFont(comp.getFont());
            compWidth = (int)((double)label.getPreferredSize().width * 1.1);
            compHeight = (int)((double)label.getPreferredSize().height * 1.1);
        }
        this.component.setBounds(0, 0, compWidth, compHeight);
        this.setBoundingPoints2D(11, this.component.getBounds());
        this.lstnr = new ConsistencyListener();
        this.component.addComponentListener(this.lstnr);
    }

    public void initAfterAddToSheet() {
        super.initAfterAddToSheet();
        this.getSheet().addToSwingWrapper(this);
    }

    public void delete() {
        super.delete();
        this.getSheet().deleteFromSwingWrapper(this);
    }

    private void handleMouseEvent(MouseEvent oldEvt) {
        MouseEvent mouseEvt = new MouseEvent(this.component, oldEvt.getID(), oldEvt.getWhen(), oldEvt.getModifiers(), oldEvt.getX(), oldEvt.getY(), oldEvt.getClickCount(), oldEvt.isPopupTrigger());
        FocusEvent focusEvt = new FocusEvent(this.component, 1004);
        SatinConstants.cmdsubsys.postEvent(mouseEvt);
        SatinConstants.cmdsubsys.postEvent(focusEvt);
        this.damage(21);
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        this.handleMouseEvent(evt.getMouseEvent());
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        this.handleMouseEvent(evt.getMouseEvent());
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        this.handleMouseEvent(evt.getMouseEvent());
        evt.setConsumed();
    }

    public void keyEventDispatcher(KeyEvent evt) {
        this.component.dispatchEvent(evt);
    }

    protected void defaultRender(SatinGraphics g) {
        this.component.paint(g);
    }

    public String toDebugString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append(String.valueOf(super.toDebugString()) + "\n");
        strbuf.append("Component:      " + this.component.toString());
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public Object clone() {
        return this.deepClone(new GObJComponentWrapperOutput(null));
    }

    protected Object deepClone(GObJComponentWrapperOutput cloneTarget) {
        super.deepClone(cloneTarget);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(this.component);
            os.flush();
            out.close();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            ObjectInputStream is = new ObjectInputStream(in);
            cloneTarget.component = (JComponent)is.readObject();
            in.close();
        }
        catch (Exception exp) {
            System.out.println("Serialization hack for GObJComponentWrapperOutput::deepClone failed -- " + exp.toString());
        }
        return cloneTarget;
    }

    class ConsistencyListener
    extends ComponentAdapter {
        ConsistencyListener() {
        }

        public void componentMoved(ComponentEvent evt) {
            Rectangle rect = GObJComponentWrapperOutput.this.component.getBounds();
            GObJComponentWrapperOutput.this.setBoundingPoints2D(11, rect);
        }

        public void componentResized(ComponentEvent evt) {
            Rectangle rect = GObJComponentWrapperOutput.this.component.getBounds();
            GObJComponentWrapperOutput.this.setBoundingPoints2D(11, rect);
        }
    }
}

