/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GObJComponentWrapper
extends GraphicalObjectImpl
implements SatinConstants {
    static final long serialVersionUID = 7308133840977774017L;
    JComponent component;
    ComponentListener lstnr;

    public GObJComponentWrapper(JComponent newComponent) {
        this.setComponent(newComponent);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(JComponent comp) {
        if (comp == null) {
            return;
        }
        if (this.component != null) {
            this.component.removeComponentListener(this.lstnr);
        }
        this.component = comp;
        Dimension dim = comp.getSize();
        int compWidth = dim.width;
        int compHeight = dim.height;
        if (comp instanceof JTextArea) {
            String text = ((JTextArea)comp).getText();
            int width = 0;
            int height = 0;
            JLabel label = new JLabel();
            label.setFont(comp.getFont());
            if (text.indexOf(10) != -1) {
                StringTokenizer tok = new StringTokenizer(text, "\n\r\f");
                while (tok.hasMoreTokens()) {
                    label.setText(tok.nextToken());
                    Dimension size = label.getPreferredSize();
                    if (size.width > width) {
                        width = size.width;
                    }
                    height += size.height;
                }
            } else {
                label.setText(text);
                width = label.getPreferredSize().width;
                height = label.getPreferredSize().height;
            }
            compWidth = (int)((double)width * 1.1);
            compHeight = (int)((double)height * 1.1);
        } else if (comp instanceof JLabel) {
            compWidth = (int)((double)comp.getPreferredSize().width * 1.1);
            compHeight = (int)((double)comp.getPreferredSize().height * 1.1);
        }
        this.component.setBounds(0, 0, compWidth, compHeight);
        this.setBoundingPoints2D(11, this.component.getBounds());
        this.lstnr = new ConsistencyListener();
        this.component.addComponentListener(this.lstnr);
    }

    public void initAfterAddToSheet() {
        super.initAfterAddToSheet();
        this.getSheet().addToSwingWrapper(this);
    }

    public void delete() {
        this.getSheet().deleteFromSwingWrapper(this);
        super.delete();
    }

    public void handleMouseEvent(MouseEvent oldEvt) {
        Debug.println("mouse event for " + this.component.toString() + " " + this.component.getX() + " " + this.component.getY());
        Debug.println("mouse event for " + oldEvt.paramString());
        int newX = oldEvt.getX() - this.component.getX();
        int newY = oldEvt.getY() - this.component.getY();
        Component deepComponent = this.component.findComponentAt(newX, newY);
        Point p1 = this.component.getLocationOnScreen();
        Point p2 = deepComponent.getLocationOnScreen();
        Debug.println("mouse event for " + deepComponent.toString());
        MouseEvent mouseEvt = new MouseEvent(deepComponent, 501, oldEvt.getWhen(), oldEvt.getModifiers(), newX -= p2.x - p1.x, newY -= p2.y - p1.y, oldEvt.getClickCount(), oldEvt.isPopupTrigger());
        Debug.println("mouse event for " + mouseEvt.paramString());
        deepComponent.dispatchEvent(mouseEvt);
        mouseEvt = new MouseEvent(deepComponent, 502, oldEvt.getWhen(), oldEvt.getModifiers(), newX, newY, oldEvt.getClickCount(), oldEvt.isPopupTrigger());
        Debug.println("mouse event for " + mouseEvt.paramString());
        deepComponent.dispatchEvent(mouseEvt);
        mouseEvt = new MouseEvent(deepComponent, 500, oldEvt.getWhen(), oldEvt.getModifiers(), newX, newY, oldEvt.getClickCount(), oldEvt.isPopupTrigger());
        Debug.println("mouse event for " + mouseEvt.paramString());
        deepComponent.dispatchEvent(mouseEvt);
        this.damage(21);
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        this.handleMouseEvent(evt.getMouseEvent());
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        this.handleMouseEvent(evt.getMouseEvent());
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        this.handleMouseEvent(evt.getMouseEvent());
        evt.setConsumed();
    }

    public void keyEventDispatcher(KeyEvent evt) {
        Debug.println("key event for " + this.component.toString());
        this.component.dispatchEvent(evt);
    }

    protected void defaultRender(SatinGraphics g) {
        this.component.paint(g);
        this.component.update(g);
    }

    public String toDebugString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append(String.valueOf(super.toDebugString()) + "\n");
        strbuf.append("Component:      " + this.component.toString());
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public Object clone() {
        return this.deepClone(new GObJComponentWrapper(null));
    }

    protected Object deepClone(GObJComponentWrapper cloneTarget) {
        block3: {
            super.deepClone(cloneTarget);
            if (this.component instanceof JTextArea) {
                return cloneTarget;
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream os = new ObjectOutputStream(out);
                os.writeObject(this.component);
                os.flush();
                out.close();
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                ObjectInputStream is = new ObjectInputStream(in);
                cloneTarget.component = (JComponent)is.readObject();
                in.close();
            }
            catch (Exception exp) {
                System.out.println("Serialization hack for GobJComponentWrapper::deepClone failed -- " + exp.toString());
                if (!(this.component instanceof JTextField)) break block3;
                System.out.println("create a new JTextField instead");
                JTextField newtext = new JTextField();
                newtext.setBounds(0, 0, 100, 30);
                newtext.setBorder(BorderFactory.createTitledBorder(""));
                newtext.setVisible(true);
                cloneTarget.component = newtext;
            }
        }
        return cloneTarget;
    }

    class ConsistencyListener
    extends ComponentAdapter {
        ConsistencyListener() {
        }

        public void componentMoved(ComponentEvent evt) {
            Rectangle rect = GObJComponentWrapper.this.component.getBounds();
            GObJComponentWrapper.this.setBoundingPoints2D(11, rect);
        }

        public void componentResized(ComponentEvent evt) {
            Rectangle rect = GObJComponentWrapper.this.component.getBounds();
            GObJComponentWrapper.this.setBoundingPoints2D(11, rect);
        }
    }
}

