/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectImpl;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;

public class GObImage
extends GraphicalObjectImpl
implements ImageObserver {
    static final long serialVersionUID = -3561711969729745457L;
    transient Image img;
    transient BufferedImage bimg;
    boolean flagUpdated = false;
    boolean flagDrawBorder = true;

    protected GObImage() {
    }

    public GObImage(Image img) {
        this.img = img;
        this.flagUpdated = true;
        this.updateImageBoundingPoints();
    }

    public GObImage(String strFileName) throws FileNotFoundException {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (!new File(strFileName).canRead()) {
            throw new FileNotFoundException();
        }
        this.img = tk.createImage(strFileName);
        this.updateImageBoundingPoints();
    }

    public GObImage(URL url) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.img = tk.createImage(url);
        this.updateImageBoundingPoints();
    }

    public synchronized boolean imageUpdate(Image img, int infoFlags, int x, int y, int width, int height) {
        if (img == null) {
            return true;
        }
        this.disableNotify();
        this.flagUpdated = false;
        int status = Toolkit.getDefaultToolkit().checkImage(img, -1, -1, null);
        if ((status & 0x20) > 0) {
            Polygon p = GeomLib.makePolygon(new Rectangle(0, 0, img.getWidth(null), img.getHeight(null)));
            super.setBoundingPoints2D(10, p);
            this.flagUpdated = true;
            this.damage(20);
            return false;
        }
        this.enableNotify();
        this.damage(21);
        return true;
    }

    public Image getImage() {
        return this.img;
    }

    public boolean isFullyLoaded() {
        return this.flagUpdated;
    }

    public void setDrawBorder(boolean flag) {
        this.flagDrawBorder = flag;
    }

    public boolean getDrawBorder() {
        return this.flagDrawBorder;
    }

    private void updateImageBoundingPoints() {
        Polygon p = GeomLib.makePolygon(new Rectangle(0, 0, this.img.getWidth(this), this.img.getHeight(this)));
        super.setBoundingPoints2D(10, p);
    }

    protected void defaultRender(SatinGraphics g) {
        if (this.flagDrawBorder) {
            g.draw(this.getLocalBoundingPoints2DRef());
        }
        if (!this.flagUpdated) {
            Toolkit.getDefaultToolkit().prepareImage(this.img, -1, -1, this);
            return;
        }
        if (this.bimg == null) {
            if (this.img instanceof BufferedImage) {
                this.bimg = (BufferedImage)this.img;
            } else {
                this.bimg = new BufferedImage(this.img.getWidth(null), this.img.getHeight(null), 2);
                this.bimg.createGraphics().drawImage(this.img, 0, 0, this);
            }
        }
        g.drawImage((Image)this.bimg, 0, 0, this);
    }

    public Object clone() {
        return this.clone(new GObImage());
    }

    public GObImage clone(GObImage gobClone) {
        super.clone(gobClone);
        int width = this.bimg.getWidth();
        int height = this.bimg.getHeight();
        int[] values = new int[width * height];
        this.bimg.getRGB(0, 0, width, height, values, 0, width);
        gobClone.bimg = new BufferedImage(width, height, 2);
        gobClone.bimg.setRGB(0, 0, width, height, values, 0, width);
        return gobClone;
    }

    public Object deepClone() {
        return this.clone();
    }

    public GObImage deepClone(GObImage gobClone) {
        return this.clone(gobClone);
    }

    private void readObject(ObjectInputStream oistream) throws IOException {
        try {
            oistream.defaultReadObject();
            int width = oistream.readInt();
            int height = oistream.readInt();
            int[] values = (int[])oistream.readObject();
            this.bimg = new BufferedImage(width, height, 2);
            this.bimg.setRGB(0, 0, width, height, values, 0, width);
        }
        catch (Exception e) {
            Debug.println(e);
        }
    }

    private void writeObject(ObjectOutputStream oostream) throws IOException {
        oostream.defaultWriteObject();
        int width = this.bimg.getWidth();
        int height = this.bimg.getHeight();
        int[] values = new int[width * height];
        this.bimg.getRGB(0, 0, width, height, values, 0, width);
        oostream.writeInt(width);
        oostream.writeInt(height);
        oostream.writeObject(values);
    }
}

