/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.objects;

import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.objects.Patch;
import edu.berkeley.guir.lib.satin.objects.PatchImpl;
import edu.berkeley.guir.lib.satin.objects.Style;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import edu.berkeley.guir.lib.satin.view.SemanticZoomMultiViewImpl;
import edu.berkeley.guir.lib.satin.view.SemanticZoomViewImpl;
import edu.berkeley.guir.lib.satin.view.View;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FramedPatch
extends PatchImpl {
    private static final int BORDER_THICKNESS = 5;
    private static final int BORDER_INSET = 2;
    private static final int TITLEBAR_HEIGHT = 20;
    private static final int TITLEBAR_CLOSEICON_OFFSET = 5;
    private static final int TITLEBAR_TEXTOFFSET_X = 5;
    private static final int TITLEBAR_TEXTOFFSET_Y = 15;
    private static final BasicStroke thinStroke = new BasicStroke(1.0f, 2, 0);
    private static final BasicStroke thickStroke = new BasicStroke(5.0f, 1, 1);
    private String title;
    private boolean showTitleBar = true;
    private boolean showCloseButton = true;
    private boolean titleIsEditable = false;
    private FontRenderContext fontRenderContext;
    private double lastX;
    private double lastY;
    protected boolean closePressed = false;
    protected boolean editableTitlePressed = false;

    public FramedPatch() {
        this.title = "";
        this.commonInit();
    }

    public FramedPatch(Rectangle2D rect) {
        super(rect);
        this.title = "";
        this.commonInit();
    }

    public FramedPatch(Patch patch, String title) {
        super(new Rectangle2D.Double(patch.getBounds2D(10).getX() - 2.0, patch.getBounds2D(10).getY() - 2.0, patch.getBounds2D(10).getWidth() + 5.0, patch.getBounds2D(10).getHeight() + 5.0));
        this.commonInit();
        patch.moveTo(11, 2.0, 2.0);
        this.addToFront(patch, 6);
        this.title = title;
    }

    private void commonInit() {
        this.getStyleRef().setFillColor(new Color(255, 255, 255, 64));
        this.getStyleRef().setDrawColor(new Color(102, 102, 153));
        this.getStyleRef().setDrawStroke(thickStroke);
    }

    protected Font getTitleFont() {
        double scale = GraphicalObjectLib.getScaleFactor(12, this.getSheet());
        Font defaultTitleFont = UIManager.getFont("InternalFrame.titleFont");
        if (defaultTitleFont != null) {
            Font titleFont = defaultTitleFont.deriveFont(defaultTitleFont.getSize2D() / (float)scale);
            return titleFont;
        }
        return null;
    }

    protected void superRender(SatinGraphics g) {
        super.defaultRender(g);
    }

    protected void defaultRender(SatinGraphics g) {
        super.defaultRender(g);
        if (this.showTitleBar) {
            double scale = GraphicalObjectLib.getScaleFactor(12, this.getSheet());
            int patchWidth = (int)this.getWidth2D(10);
            Style s = new Style();
            s.setDrawColor(new Color(102, 102, 153));
            s.setFillColor(new Color(204, 204, 255));
            s.setDrawStroke(thickStroke);
            g.pushStyle(s);
            g.fillRect(0, 0, patchWidth, (int)(20.0 / scale));
            g.popStyle();
            if (this.showCloseButton) {
                s = new Style();
                s.setFillColor(new Color(180, 180, 180));
                s.setDrawStroke(thickStroke);
                g.pushStyle(s);
                int sideSize = (int)(10.0 / scale);
                int startX = (int)((double)(patchWidth - sideSize) - 5.0 / scale);
                int startY = (int)(5.0 / scale);
                g.popStyle();
                s.setDrawColor(new Color(0, 0, 0));
                s.setDrawStroke(thinStroke);
                g.pushStyle(s);
                g.draw(new Line2D.Double(startX, startY, startX + sideSize, startY + sideSize));
                g.draw(new Line2D.Double(startX, startY + sideSize, startX + sideSize, startY));
                g.popStyle();
            }
            Font origFont = g.getFont();
            Font titleFont = this.getTitleFont();
            if (titleFont != null) {
                g.setFont(titleFont);
            }
            this.fontRenderContext = g.getFontRenderContext();
            g.drawString(this.title, (int)(5.0 / scale), (int)(15.0 / scale));
            g.setFont(origFont);
        }
    }

    public boolean getShowTitleBar() {
        return this.showTitleBar;
    }

    public void setShowTitleBar(boolean flag) {
        this.showTitleBar = flag;
    }

    public boolean getShowCloseButton() {
        return this.showCloseButton;
    }

    public void setShowCloseButton(boolean flag) {
        this.showCloseButton = flag;
    }

    public boolean isTitleEditable() {
        return this.titleIsEditable;
    }

    public void setTitleEditable(boolean flag) {
        this.titleIsEditable = flag;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isInsideTitleBar(Point2D point) {
        if (this.showTitleBar) {
            double scale = GraphicalObjectLib.getScaleFactor(12, this.getSheet());
            int y = (int)point.getY();
            return (double)y < 20.0 / scale;
        }
        return false;
    }

    public boolean isInsideTitleBarCloseButton(Point2D point) {
        if (this.showTitleBar && this.showCloseButton) {
            double scale = GraphicalObjectLib.getScaleFactor(12, this.getSheet());
            int x = (int)point.getX();
            int y = (int)point.getY();
            int patchWidth = (int)this.getWidth2D(10);
            int sideSize = (int)(10.0 / scale);
            int startX = (int)((double)(patchWidth - sideSize) - 5.0 / scale);
            int startY = (int)(5.0 / scale);
            return startX <= x && x <= startX + sideSize && startY <= y && y <= startY + sideSize;
        }
        return false;
    }

    public boolean isInsideEditableTitle(Point2D point) {
        if (this.isInsideTitleBar(point) && this.isTitleEditable()) {
            int x;
            double scale = GraphicalObjectLib.getScaleFactor(12, this.getSheet());
            return (int)(5.0 / scale) <= (x = (int)point.getX()) && (double)x <= (double)((int)(5.0 / scale)) + this.getTitleFont().getStringBounds(this.title, this.fontRenderContext).getWidth();
        }
        return false;
    }

    public void handleTitleBarNewStroke(NewStrokeEvent evt) {
        Component root;
        String newTitle;
        TimedStroke stk = evt.getStroke();
        Point2D ptPress = stk.getStartPoint2D(12);
        this.bringToTopLayer();
        this.lastX = ptPress.getX();
        this.lastY = ptPress.getY();
        Point2D localPt = GraphicalObjectLib.absoluteToLocal((GraphicalObject)this, ptPress);
        this.closePressed = this.isInsideTitleBarCloseButton(localPt);
        this.editableTitlePressed = this.isInsideEditableTitle(localPt);
        if (this.editableTitlePressed && (newTitle = JOptionPane.showInputDialog(root = SwingUtilities.getRoot(this.getSheet()), "Enter the new title:", "Rename", 3)) != null) {
            this.setTitle(newTitle);
            this.damage(20);
        }
        evt.setConsumed();
    }

    public void handleTitleBarUpdateStroke(UpdateStrokeEvent evt) {
        if (!this.closePressed && !this.editableTitlePressed) {
            TimedStroke stk = evt.getStroke();
            Point2D pt = stk.getEndPoint2D(12);
            this.moveBy(12, pt.getX() - this.lastX, pt.getY() - this.lastY);
            this.lastX = pt.getX();
            this.lastY = pt.getY();
        }
        evt.setConsumed();
        evt.setShouldRender(false);
    }

    public void handleTitleBarSingleStroke(SingleStrokeEvent evt) {
        TimedStroke stk;
        Point2D pt;
        evt.setConsumed();
        evt.setShouldRender(false);
        if (this.closePressed && this.isInsideTitleBarCloseButton(GraphicalObjectLib.absoluteToLocal((GraphicalObject)this, pt = (stk = evt.getStroke()).getEndPoint2D(12)))) {
            this.getSheet().remove(this);
        }
    }

    class FramedPatchIconView
    extends SemanticZoomViewImpl {
        public FramedPatchIconView(GraphicalObject gob) {
            this.setDisplayRange(0.0, 100.0);
        }

        public void render(SatinGraphics g) {
            double scale = GraphicalObjectLib.getScaleFactor(12, FramedPatch.this.getSheet());
            int patchWidth = (int)FramedPatch.this.getWidth2D(10);
            Style s = new Style();
            s.setDrawColor(new Color(102, 102, 153));
            s.setFillColor(new Color(204, 204, 255));
            s.setDrawStroke(thickStroke);
            g.pushStyle(s);
            g.fillRect(0, 0, patchWidth, (int)(20.0 / scale));
            g.popStyle();
            Font origFont = g.getFont();
            Font defaultTitleFont = UIManager.getFont("InternalFrame.font");
            Font titleFont = defaultTitleFont.deriveFont(defaultTitleFont.getSize2D() / (float)scale);
            g.setFont(titleFont);
            g.drawString(FramedPatch.this.title, (int)(15.0 / scale), (int)(15.0 / scale));
            g.setFont(origFont);
        }

        public Object clone() {
            return this;
        }
    }

    class FramedPatchMultiView
    extends SemanticZoomMultiViewImpl {
        public FramedPatchMultiView(View v1, View v2) {
            this.add(v1);
            this.add(v2);
        }
    }
}

