/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.stroke;

import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import edu.berkeley.guir.lib.satin.interpreter.stroke.MergeStrokeInterpreter;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.stroke.StrokeLib;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SplitStrokeInterpreter
extends InterpreterImpl {
    GraphicalObjectGroup grp;

    public void handleSingleStroke(SingleStrokeEvent evt) {
        GraphicalObject gob;
        GraphicalObjectCollection gobcol;
        TimedStroke stk = evt.getStroke();
        if (this.grp == null && this.getAttachedGraphicalObject() instanceof GraphicalObjectGroup) {
            this.grp = (GraphicalObjectGroup)this.getAttachedGraphicalObject();
        }
        if ((gobcol = this.grp.getGraphicalObjects(stk, 30, 40, 50)).numElements() <= 0) {
            return;
        }
        Rectangle r = GraphicalObjectLib.getRenderBounds(stk);
        Iterator it = gobcol.getForwardIterator();
        LinkedList<TimedStroke> listDel = new LinkedList<TimedStroke>();
        LinkedList listAdd = new LinkedList();
        while (it.hasNext()) {
            TimedStroke stkTemp;
            List listSplit;
            gob = (GraphicalObject)it.next();
            if (!(gob instanceof TimedStroke) || (listSplit = StrokeLib.splitStroke(stkTemp = (TimedStroke)gob, r)).size() <= 0) continue;
            listDel.add(stkTemp);
            listAdd.addAll(listSplit);
        }
        it = listDel.iterator();
        while (it.hasNext()) {
            gob = (GraphicalObject)it.next();
            gob.delete();
        }
        it = listAdd.iterator();
        while (it.hasNext()) {
            gob = (GraphicalObject)it.next();
            this.grp.addToFront(gob);
        }
    }

    public Object clone() {
        return new MergeStrokeInterpreter();
    }
}

