/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.stroke;

import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.stroke.StrokeLib;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.util.Iterator;
import java.util.LinkedList;

public class MergeStrokeInterpreter
extends InterpreterImpl {
    GraphicalObjectGroup grp;

    public void handleSingleStroke(SingleStrokeEvent evt) {
        GraphicalObjectCollection gobcol;
        TimedStroke stk = evt.getStroke();
        if (this.grp == null && this.getAttachedGraphicalObject() instanceof GraphicalObjectGroup) {
            this.grp = (GraphicalObjectGroup)this.getAttachedGraphicalObject();
        }
        if ((gobcol = this.grp.getGraphicalObjects(stk, 30, 40, 50)).numElements() <= 0) {
            return;
        }
        Iterator it = gobcol.getForwardIterator();
        LinkedList<GraphicalObject> list = new LinkedList<GraphicalObject>();
        TimedStroke stkMerge = stk;
        while (it.hasNext()) {
            TimedStroke stkTemp;
            GraphicalObject gob = (GraphicalObject)it.next();
            if (!(gob instanceof TimedStroke) || (stkTemp = StrokeLib.mergeStrokes((TimedStroke)gob, stkMerge)) == null) continue;
            stkMerge = stkTemp;
            list.add(gob);
        }
        if (stkMerge != stk) {
            it = list.iterator();
            while (it.hasNext()) {
                ((GraphicalObject)it.next()).delete();
            }
            stk.delete();
            stk.getParentGroup().addToFront(stkMerge, 5);
            evt.setConsumed();
        }
    }

    public Object clone() {
        return new MergeStrokeInterpreter();
    }
}

