/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.stroke;

import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class ImmediateInkFeedbackInterpreter
extends InterpreterImpl {
    Point2D prePosition = new Point2D.Double();
    Color inkColor = Color.black;
    double inkWidth = 1.0;

    public void setInkWidth(double w) {
        this.inkWidth = w;
    }

    public double getInkWidth() {
        return this.inkWidth;
    }

    public void setInkColor(Color inkC) {
        this.inkColor = inkC;
    }

    public Color getInkColor() {
        return this.inkColor;
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        this.prePosition = (Point2D)evt.getStroke().getStartPoint2D(12).clone();
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        Point2D currentPoint = evt.getStroke().getEndPoint2D(12);
        Graphics2D g = (Graphics2D)this.getAttachedGraphicalObject().getSheet().getGraphics();
        Color oldColor = g.getColor();
        Stroke w = g.getStroke();
        if (evt.isRightButton()) {
            g.setColor(Color.lightGray);
            g.setStroke(new BasicStroke(6.0f));
        } else {
            g.setStroke(new BasicStroke((int)this.inkWidth));
            g.setColor(this.inkColor);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawLine((int)this.prePosition.getX(), (int)this.prePosition.getY(), (int)currentPoint.getX(), (int)currentPoint.getY());
        g.setColor(oldColor);
        g.setStroke(w);
        this.prePosition = (Point2D)currentPoint.clone();
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        Point2D currentPoint = evt.getStroke().getEndPoint2D(12);
        Graphics2D g = (Graphics2D)this.getAttachedGraphicalObject().getSheet().getGraphics();
        Color oldColor = g.getColor();
        Stroke w = g.getStroke();
        if (evt.isRightButton()) {
            g.setColor(Color.lightGray);
            g.setStroke(new BasicStroke(6.0f));
        } else {
            g.setStroke(new BasicStroke((int)this.inkWidth));
            g.setColor(this.inkColor);
        }
        g.drawLine((int)this.prePosition.getX(), (int)this.prePosition.getY(), (int)currentPoint.getX(), (int)currentPoint.getY());
        g.setColor(oldColor);
        g.setStroke(w);
        this.prePosition = (Point2D)currentPoint.clone();
    }

    public Object clone() {
        return new ImmediateInkFeedbackInterpreter();
    }
}

