/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.rubine;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.gesture.TrainingException;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import edu.berkeley.guir.lib.satin.recognizer.Classification;
import edu.berkeley.guir.lib.satin.recognizer.Recognizer;
import edu.berkeley.guir.lib.satin.recognizer.rubine.RubineRecognizer;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.WeakHashMap;

public abstract class RubineInterpreter
extends InterpreterImpl {
    static final long serialVersionUID = -8744819975929174646L;
    public static final String RUBINE_DATA_DIRECTORY_PROPERTY = "RUBINE_DATA_DIRECTORY_PROPERTY";
    public static final String RUBINE_DATA_DIRECTORY_DEFAULT = "data/interpreters/";
    public static final String RUBINE_DATA_URL_PROPERTY = "RubineData";
    public static final String RUBINE_DATA_URL_DEFAULT = "";
    private static final WeakHashMap cache;
    protected boolean flagSimplify = false;
    protected String strFileName;
    protected Class baseClass;
    protected double confidence;
    protected transient RubineRecognizer recognizer;

    static {
        SatinConstants.glprops.setProperty(RUBINE_DATA_DIRECTORY_PROPERTY, RUBINE_DATA_DIRECTORY_DEFAULT);
        SatinConstants.glprops.setProperty(RUBINE_DATA_URL_PROPERTY, RUBINE_DATA_URL_DEFAULT);
        cache = new WeakHashMap();
    }

    private RubineInterpreter() {
    }

    public RubineInterpreter(String strFileName) {
        this(strFileName, null, false);
    }

    public RubineInterpreter(String strFileName, Class baseClass) {
        this(strFileName, baseClass, false);
    }

    public RubineInterpreter(String strFileName, boolean flagSimplify) {
        this(strFileName, null, flagSimplify);
    }

    public RubineInterpreter(String strFileName, Class baseClass, boolean flagSimplify) {
        this.strFileName = strFileName;
        this.recognizer = this.initializeRecognizer(strFileName, baseClass);
        this.setSimplify(flagSimplify);
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Rubine Interpreter");
        this.confidence = 0.8;
    }

    private RubineRecognizer initializeRecognizer(String str, Class baseClass) {
        RubineRecognizer recognizer = null;
        recognizer = (RubineRecognizer)cache.get(str);
        if (recognizer != null) {
            return recognizer;
        }
        if (str.equals(RUBINE_DATA_URL_DEFAULT)) {
            recognizer = new RubineRecognizer();
            cache.put(str, recognizer);
            return recognizer;
        }
        try {
            String strFileName = String.valueOf((String)SatinConstants.glprops.getProperty(RUBINE_DATA_DIRECTORY_PROPERTY)) + str;
            InputStream istream = null;
            if (baseClass != null) {
                istream = baseClass.getResourceAsStream(SatinConstants.glprops.getProperty(RUBINE_DATA_DIRECTORY_PROPERTY) + str);
            }
            if (istream == null) {
                istream = new FileInputStream(strFileName);
            }
            InputStreamReader rdr = new InputStreamReader(istream);
            BufferedReader brdr = new BufferedReader(rdr);
            recognizer = new RubineRecognizer(brdr);
            cache.put(str, recognizer);
            return recognizer;
        }
        catch (Exception e) {
            Debug.println(e);
            try {
                String strURL = String.valueOf((String)SatinConstants.glprops.getProperty(RUBINE_DATA_URL_PROPERTY)) + str;
                URL url = new URL(strURL);
                InputStream istream = url.openStream();
                InputStreamReader rdr = new InputStreamReader(istream);
                recognizer = new RubineRecognizer(rdr);
                cache.put(str, recognizer);
                return recognizer;
            }
            catch (FileNotFoundException e2) {
                Debug.println(e2);
                Debug.println("Initialization Error - using empty Rubine Recognizer");
                recognizer = new RubineRecognizer();
            }
            catch (ParseException e3) {
                Debug.println(e3);
                Debug.println("Bad Rubine data file.");
                Debug.println("Initialization Error - using empty Rubine Recognizer");
                recognizer = new RubineRecognizer();
            }
            catch (TrainingException e4) {
                Debug.println(e4);
                Debug.println("Error in Rubine Recognizer processing data file.");
                Debug.println("Initialization Error - using empty Rubine Recognizer");
                recognizer = new RubineRecognizer();
            }
            catch (IOException e5) {
                Debug.println(e5);
                Debug.println("Initialization Error - using empty Rubine Recognizer");
                recognizer = new RubineRecognizer();
            }
            return recognizer;
        }
    }

    public Recognizer getRecognizer() {
        return this.recognizer;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public String getFileName() {
        return this.strFileName;
    }

    public void setConfidence(double val) {
        this.confidence = val;
    }

    public void setSimplify(boolean flag) {
        this.flagSimplify = flag;
    }

    public void handleNewStroke(NewStrokeEvent evt) {
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        if (this.recognizer == null) {
            return;
        }
        TimedStroke stk = evt.getStroke();
        Classification c = this.recognizer.classify(stk = this.preprocessStroke(stk));
        Double d = (Double)c.getFirstValue();
        if (d < this.confidence) {
            return;
        }
        this.handleSingleStroke(evt, c);
    }

    protected TimedStroke preprocessStroke(TimedStroke stk) {
        if (this.flagSimplify) {
            Polygon2D poly = stk.getPolygon2D(12);
            poly = poly.simplify();
            return new TimedStroke(poly);
        }
        return stk;
    }

    protected abstract void handleSingleStroke(SingleStrokeEvent var1, Classification var2);

    public RubineInterpreter clone(RubineInterpreter intrp) {
        intrp.strFileName = this.strFileName;
        intrp.baseClass = this.baseClass;
        intrp.recognizer = intrp.initializeRecognizer(this.strFileName, this.baseClass);
        intrp.commonInitializations();
        return intrp;
    }

    private void readObject(ObjectInputStream oistream) throws IOException {
        try {
            oistream.defaultReadObject();
        }
        catch (Exception e) {
            Debug.println(e);
        }
        this.initializeRecognizer(this.strFileName, this.baseClass);
    }

    private void writeObject(ObjectOutputStream oostream) throws IOException {
        oostream.defaultWriteObject();
    }
}

