/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.commands;

import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.commands.AbstractSelectInterpreter;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.stroke.StrokeLib;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;

public class TapSelectInterpreter
extends AbstractSelectInterpreter {
    static final long serialVersionUID = 6720938029363799658L;

    public TapSelectInterpreter() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Tap Select Interpreter");
        this.setAcceptMiddleButton(false);
        this.setAcceptRightButton(false);
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        TimedStroke stk = evt.getStroke();
        if (!StrokeLib.isTap(stk)) {
            return;
        }
        GraphicalObjectCollection gobcol = this.getCandidates(evt);
        GraphicalObject selgob = null;
        selgob = this.getSelectCandidate(gobcol);
        this.toggleSelectGraphicalObject(selgob);
        if (selgob != null) {
            evt.setConsumed();
            evt.setShouldRender(false);
        }
    }

    public Object clone() {
        return new TapSelectInterpreter();
    }
}

