/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.commands;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.command.CopyCommand;
import edu.berkeley.guir.lib.satin.command.CutCommand;
import edu.berkeley.guir.lib.satin.command.DeleteCommand;
import edu.berkeley.guir.lib.satin.command.PasteCommand;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.GestureCommandInterpreterImpl;
import edu.berkeley.guir.lib.satin.interpreter.rubine.RubineInterpreter;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollectionImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.recognizer.Classification;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class StandardGestureInterpreter
extends GestureCommandInterpreterImpl {
    static final long serialVersionUID = 1118908262546911989L;
    protected boolean flagShallow = true;
    protected RubineInterpreter intrp;

    public StandardGestureInterpreter() {
        this("standard.gsa", null);
    }

    public StandardGestureInterpreter(Class baseClass) {
        this("standard.gsa", baseClass);
    }

    public StandardGestureInterpreter(String filename) {
        this(filename, null);
    }

    public StandardGestureInterpreter(String filename, Class baseClass) {
        this.intrp = new StandardRubineInterpreter(filename, baseClass);
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Standard Gesture Interpreter");
    }

    public void setShallow() {
        this.flagShallow = true;
    }

    public void setDeep() {
        this.flagShallow = false;
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        this.intrp.handleSingleStroke(evt);
    }

    protected void handleUndo(TimedStroke stk) {
        try {
            SatinConstants.cmdqueue.undo();
            this.getAttachedGraphicalObject().damage(21);
        }
        catch (Exception e) {
            Debug.println(e);
        }
    }

    protected void handleRedo(TimedStroke stk) {
        try {
            SatinConstants.cmdqueue.redo();
            this.getAttachedGraphicalObject().damage(21);
        }
        catch (Exception e) {
            Debug.println(e);
        }
    }

    protected void handleCut(TimedStroke stk) {
        CutCommand cmd = new CutCommand();
        GraphicalObjectCollection gobcol = this.getGraphicalObjectsTouching(stk, 2.0);
        Iterator it = gobcol.getForwardIterator();
        GraphicalObject attach = this.getAttachedGraphicalObject();
        while (it.hasNext()) {
            GraphicalObject gob = (GraphicalObject)it.next();
            if (gob == attach) continue;
            cmd.addGraphicalObject(gob);
        }
        SatinConstants.cmdqueue.doCommand(cmd);
    }

    protected void handleCopy(TimedStroke stk) {
        GraphicalObject gob = this.getGraphicalObjectCenteredAt(stk);
        if (gob != null && gob != this.getAttachedGraphicalObject()) {
            SatinConstants.cmdqueue.doCommand(new CopyCommand(gob));
        }
    }

    protected void handlePaste(TimedStroke stk) {
        GraphicalObject gob = this.getAttachedGraphicalObject();
        Rectangle2D rect = stk.getBounds2D(12);
        Point2D.Float pt = new Point2D.Float((float)(rect.getX() + rect.getWidth() / 2.0), (float)(rect.getY() + rect.getHeight()));
        GraphicalObjectLib.absoluteToLocal(gob, pt, pt);
        if (gob instanceof GraphicalObjectGroup) {
            SatinConstants.cmdqueue.doCommand(new PasteCommand((GraphicalObjectGroup)gob, ((Point2D)pt).getX(), ((Point2D)pt).getY()));
        }
    }

    protected void handleDelete(TimedStroke stk) {
        GraphicalObject gob = this.getGraphicalObjectCenteredAt(stk);
        if (gob != null && gob != this.getAttachedGraphicalObject()) {
            SatinConstants.cmdqueue.doCommand(new DeleteCommand(gob));
        }
    }

    protected void handleCenter(TimedStroke stk) {
        GraphicalObject gob = this.getAttachedGraphicalObject();
        Rectangle2D gobbds = gob.getBounds2D();
        Rectangle2D stkbds = stk.getBounds2D();
        double x1 = gobbds.getX() + gobbds.getWidth() / 2.0;
        double y1 = gobbds.getY() + gobbds.getHeight() / 2.0;
        double x2 = stkbds.getX() + stkbds.getWidth() / 2.0;
        double y2 = stkbds.getY() + stkbds.getHeight() / 2.0;
        AffineTransform[] txArray = AffineTransformLib.animateSlowInSlowOut(AffineTransform.getTranslateInstance(x1 - x2, y1 - y2), 10);
        GraphicalObjectLib.animate(gob, txArray);
    }

    protected int getViewPortDirection(String str) {
        String strLower = str.toLowerCase();
        int direction = -1;
        if (strLower.startsWith("viewportleft")) {
            direction = 107;
        } else if (strLower.startsWith("viewportright")) {
            direction = 103;
        } else if (strLower.startsWith("viewportup")) {
            direction = 101;
        } else if (strLower.startsWith("viewportdown")) {
            direction = 105;
        } else if (strLower.startsWith("viewportdiagupright")) {
            direction = 102;
        } else if (strLower.startsWith("viewportdiagupleft")) {
            direction = 100;
        } else if (strLower.startsWith("viewportdiagdownright")) {
            direction = 104;
        } else if (strLower.startsWith("viewportdiagdownleft")) {
            direction = 106;
        }
        return direction;
    }

    protected void handleViewPort(String str, TimedStroke stk) {
        AffineTransform tx = new AffineTransform();
        GraphicalObject gob = this.getAttachedGraphicalObject();
        double len = stk.getLength2D(12);
        int direction = this.getViewPortDirection(str);
        switch (direction) {
            case 107: {
                tx.translate(len, 0.0);
                break;
            }
            case 103: {
                tx.translate(-len, 0.0);
                break;
            }
            case 101: {
                tx.translate(0.0, len);
                break;
            }
            case 105: {
                tx.translate(0.0, -len);
                break;
            }
            case 102: {
                tx.translate(-len / 2.0, len / 2.0);
                break;
            }
            case 100: {
                tx.translate(len / 2.0, len / 2.0);
                break;
            }
            case 104: {
                tx.translate(-len / 2.0, -len / 2.0);
                break;
            }
            case 106: {
                tx.translate(len / 2.0, -len / 2.0);
            }
        }
        AffineTransform[] txArray = AffineTransformLib.animateSlowInSlowOut(tx, 8);
        this.getAttachedGraphicalObject().getSheet().setSheetPanning(true);
        GraphicalObjectLib.animate(gob, txArray);
        this.getAttachedGraphicalObject().getSheet().setSheetPanning(false);
    }

    protected GraphicalObjectCollection getGraphicalObjectsTouching(TimedStroke stk, double thresh) {
        if (!(this.getAttachedGraphicalObject() instanceof GraphicalObjectGroup)) {
            return null;
        }
        GraphicalObject gob = this.getAttachedGraphicalObject();
        Object gobtmp = null;
        Polygon2D s = stk.getBoundingPoints2D(12);
        GraphicalObjectGroup gobgrp = (GraphicalObjectGroup)gob;
        GraphicalObjectCollection gobcol = new GraphicalObjectCollectionImpl();
        int depth = this.flagShallow ? 40 : 41;
        gobcol = gobgrp.getGraphicalObjects(12, s, 30, depth, 50, thresh, gobcol);
        return gobcol;
    }

    protected GraphicalObject getGraphicalObjectCenteredAt(TimedStroke stk) {
        return this.getGraphicalObjectCenteredAt(stk, 5.0);
    }

    protected GraphicalObject getGraphicalObjectCenteredAt(TimedStroke stk, double thresh) {
        GraphicalObject gobtmp = null;
        GraphicalObjectCollection gobcol = this.getGraphicalObjectsTouching(stk, thresh);
        if (gobcol.numElements() > 0) {
            gobtmp = GraphicalObjectLib.getTopmostGraphicalObject(gobcol);
        }
        return gobtmp;
    }

    public Object clone() {
        return new StandardGestureInterpreter();
    }

    class StandardRubineInterpreter
    extends RubineInterpreter {
        public StandardRubineInterpreter(String str, Class baseClass) {
            super(str, baseClass, false);
        }

        protected void handleSingleStroke(SingleStrokeEvent evt, Classification c) {
            String str = (String)c.getFirstKey();
            TimedStroke stk = evt.getStroke();
            str = str.trim();
            if (stk.getLength2D(12) < 20.0) {
                return;
            }
            if (str.startsWith("ViewPort")) {
                StandardGestureInterpreter.this.handleViewPort(str, stk);
                evt.setConsumed("Viewport");
            } else if (str.startsWith("Center")) {
                StandardGestureInterpreter.this.handleCenter(stk);
                evt.setConsumed("Center");
            } else if (str.startsWith("Copy")) {
                StandardGestureInterpreter.this.handleCopy(stk);
                evt.setConsumed("Copy");
            } else if (str.startsWith("Cut")) {
                StandardGestureInterpreter.this.handleCut(stk);
                evt.setConsumed("Cut");
            } else if (str.startsWith("Paste")) {
                StandardGestureInterpreter.this.handlePaste(stk);
                evt.setConsumed("Paste");
            } else if (str.startsWith("Delete")) {
                StandardGestureInterpreter.this.handleDelete(stk);
                evt.setConsumed("Delete");
            } else if (str.startsWith("Undo")) {
                StandardGestureInterpreter.this.handleUndo(stk);
                evt.setConsumed("Undo");
            } else if (str.startsWith("Redo")) {
                StandardGestureInterpreter.this.handleRedo(stk);
                evt.setConsumed("Redo");
            }
        }

        public Object clone() {
            return new StandardRubineInterpreter(this.getFileName(), this.baseClass);
        }
    }
}

