/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.commands;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ResizeSelectedInterpreter
extends InterpreterImpl {
    static final long serialVersionUID = -184293472626407622L;
    private static final int BOUNDS_THRESHOLD = 10;
    private static final int TOPLEFT = 8;
    private static final int TOP = 9;
    private static final int TOPRIGHT = 10;
    private static final int RIGHT = 11;
    private static final int BOTTOMRIGHT = 12;
    private static final int BOTTOM = 13;
    private static final int BOTTOMLEFT = 14;
    private static final int LEFT = 15;
    protected GraphicalObject selgob;
    protected int position;

    public ResizeSelectedInterpreter() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Move Selected Item Interpreter");
    }

    private boolean isNearBounds(GraphicalObject gob, Point2D pt) {
        Rectangle2D bds = gob.getBounds2D(12);
        Line2D.Float line = new Line2D.Float();
        Point2D.Float ptCorner = new Point2D.Float();
        double x1 = bds.getX();
        double y1 = bds.getY();
        double x2 = bds.getX() + bds.getWidth();
        double y2 = bds.getY() + bds.getHeight();
        ((Point2D)ptCorner).setLocation(x1, y1);
        if (ptCorner.distance(pt) < 10.0) {
            this.position = 8;
            return true;
        }
        ((Point2D)ptCorner).setLocation(x2, y1);
        if (ptCorner.distance(pt) < 10.0) {
            this.position = 10;
            return true;
        }
        ((Point2D)ptCorner).setLocation(x2, y2);
        if (ptCorner.distance(pt) < 10.0) {
            this.position = 12;
            return true;
        }
        ((Point2D)ptCorner).setLocation(x1, y2);
        if (ptCorner.distance(pt) < 10.0) {
            this.position = 14;
            return true;
        }
        ((Line2D)line).setLine(x1, y1, x2, y1);
        if (line.ptSegDist(pt) < 10.0) {
            this.position = 9;
            return true;
        }
        ((Line2D)line).setLine(x2, y1, x2, y2);
        if (line.ptSegDist(pt) < 10.0) {
            this.position = 11;
            return true;
        }
        ((Line2D)line).setLine(x1, y2, x2, y2);
        if (line.ptSegDist(pt) < 10.0) {
            this.position = 13;
            return true;
        }
        ((Line2D)line).setLine(x1, y1, x1, y2);
        if (line.ptSegDist(pt) < 10.0) {
            this.position = 15;
            return true;
        }
        return false;
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        TimedStroke stk = evt.getStroke();
        GraphicalObject gob = this.getAttachedGraphicalObject();
        GraphicalObject gobTmp = null;
        this.selgob = null;
        if (gob instanceof GraphicalObjectGroup) {
            GraphicalObjectGroup gobgrp = (GraphicalObjectGroup)gob;
            Point2D ptPress = stk.getStartPoint2D(12);
            GraphicalObjectCollection gobcol = gobgrp.getGraphicalObjects(12, ptPress, 31, 40, 52);
            if (gobcol.numElements() > 0) {
                gobTmp = gobcol.get(0);
            }
            if (SatinConstants.cmdsubsys.isSelected(gobTmp) && this.isNearBounds(gobTmp, ptPress)) {
                this.selgob = gobTmp;
                evt.setConsumed();
                evt.setShouldRender(false);
            }
        }
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        if (this.selgob != null) {
            TimedStroke stk = evt.getStroke();
            Point2D pt = stk.getEndPoint2D(12);
            Rectangle2D oldBounds = this.selgob.getBounds2D(12);
            Rectangle2D newBounds = this.getNewBounds(this.selgob, pt);
            AffineTransform tx = AffineTransformLib.resize(oldBounds, newBounds);
            this.selgob.applyTransform(tx);
            evt.setConsumed();
            evt.setShouldRender(false);
        }
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        if (this.selgob != null) {
            evt.setConsumed();
            evt.setShouldRender(false);
        }
        this.selgob = null;
    }

    protected Rectangle2D getNewBounds(GraphicalObject gob, Point2D pt) {
        Rectangle2D bounds = gob.getBounds2D(12);
        double x1 = bounds.getX();
        double y1 = bounds.getY();
        double x2 = bounds.getX() + bounds.getWidth();
        double y2 = bounds.getY() + bounds.getHeight();
        switch (this.position) {
            case 8: {
                x1 = pt.getX();
                y1 = pt.getY();
                break;
            }
            case 9: {
                y1 = pt.getY();
                break;
            }
            case 10: {
                x2 = pt.getX();
                y1 = pt.getY();
                break;
            }
            case 11: {
                x2 = pt.getX();
                break;
            }
            case 12: {
                x2 = pt.getX();
                y2 = pt.getY();
                break;
            }
            case 13: {
                y2 = pt.getY();
                break;
            }
            case 14: {
                x1 = pt.getX();
                y2 = pt.getY();
                break;
            }
            case 15: {
                x1 = pt.getX();
            }
        }
        bounds.setRect(x1, y1, x2 - x1, y2 - y1);
        return bounds;
    }

    public Object clone() {
        return new ResizeSelectedInterpreter();
    }
}

