/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.commands;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.command.Command;
import edu.berkeley.guir.lib.satin.command.PhantomMoveCommand;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.geom.Point2D;
import java.util.Iterator;

public class MoveSelectedInterpreter
extends InterpreterImpl {
    static final long serialVersionUID = 1104683975462911745L;
    boolean isOverSelected;
    double lastX;
    double lastY;
    Point2D[] oldRelLocs;
    Point2D[] newRelLocs;
    boolean flagShallow = true;

    public MoveSelectedInterpreter() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Move Selected Item Interpreter");
        this.setAcceptMiddleButton(false);
        this.setAcceptRightButton(false);
    }

    public void setDeep() {
        this.flagShallow = false;
    }

    public void setShallow() {
        this.flagShallow = true;
    }

    public Point2D[] getOldPosition() {
        return this.oldRelLocs;
    }

    public void setOldPosition(Point2D[] oldPos) {
        this.oldRelLocs = oldPos;
    }

    public boolean isOverSelected() {
        return this.isOverSelected;
    }

    public void setOverSelected(boolean b) {
        this.isOverSelected = b;
    }

    public double getLastX() {
        return this.lastX;
    }

    public double getLastY() {
        return this.lastY;
    }

    public void setLastX(double x) {
        this.lastX = x;
    }

    public void setLastY(double y) {
        this.lastY = y;
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        TimedStroke stk = evt.getStroke();
        GraphicalObject attached = this.getAttachedGraphicalObject();
        GraphicalObject gobTmp = null;
        this.isOverSelected = false;
        if (attached instanceof GraphicalObjectGroup) {
            GraphicalObjectCollection gobcol;
            Point2D ptPress = stk.getStartPoint2D(12);
            GraphicalObjectGroup gobgrp = (GraphicalObjectGroup)attached;
            if (this.flagShallow) {
                gobcol = gobgrp.getGraphicalObjects(12, ptPress, 30, 40, 52);
                gobTmp = GraphicalObjectLib.getTopmostGraphicalObject(gobcol);
            } else {
                gobcol = gobgrp.getGraphicalObjects(12, ptPress, 30, 41, 52);
                gobTmp = GraphicalObjectLib.getTopmostGraphicalObject(gobcol);
                if (gobTmp != null) {
                    GraphicalObjectGroup parent = gobTmp.getParentGroup();
                    while (parent != null) {
                        if (SatinConstants.cmdsubsys.isSelected(parent)) {
                            gobTmp = parent;
                        }
                        parent = parent.getParentGroup();
                    }
                }
            }
            if (SatinConstants.cmdsubsys.isSelected(gobTmp)) {
                this.isOverSelected = true;
                evt.setConsumed();
                evt.setShouldRender(false);
                this.lastX = ptPress.getX();
                this.lastY = ptPress.getY();
                GraphicalObjectCollection selObjs = SatinConstants.cmdsubsys.getSelectedCollection();
                this.oldRelLocs = new Point2D[selObjs.numElements()];
                int i = 0;
                Iterator it = selObjs.getForwardIterator();
                while (it.hasNext()) {
                    GraphicalObject gob = (GraphicalObject)it.next();
                    this.oldRelLocs[i] = gob.getLocation2D(11);
                    ++i;
                }
            }
        }
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        if (this.isOverSelected) {
            TimedStroke stk = evt.getStroke();
            Point2D pt = stk.getEndPoint2D(12);
            Iterator i = SatinConstants.cmdsubsys.getSelected();
            while (i.hasNext()) {
                GraphicalObject gob = (GraphicalObject)i.next();
                gob.moveBy(12, pt.getX() - this.lastX, pt.getY() - this.lastY);
            }
            this.lastX = pt.getX();
            this.lastY = pt.getY();
            evt.setConsumed();
            evt.setShouldRender(false);
        }
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        if (this.isOverSelected) {
            evt.setConsumed();
            evt.setShouldRender(false);
            GraphicalObjectCollection selObjs = SatinConstants.cmdsubsys.getSelectedCollection();
            this.newRelLocs = new Point2D[selObjs.numElements()];
            int i = 0;
            Iterator it = selObjs.getForwardIterator();
            while (it.hasNext()) {
                GraphicalObject gob = (GraphicalObject)it.next();
                this.newRelLocs[i] = gob.getLocation2D(11);
                ++i;
            }
            if (!this.oldRelLocs[0].equals(this.newRelLocs[0])) {
                SatinConstants.cmdqueue.doCommand(this.createMoveCommand());
            }
        }
        this.getAttachedGraphicalObject().damage(21);
    }

    protected Command createMoveCommand() {
        return new PhantomMoveCommand(SatinConstants.cmdsubsys.getSelected(), this.oldRelLocs, this.newRelLocs);
    }

    public Object clone() {
        return new MoveSelectedInterpreter();
    }
}

