/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.commands;

import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.StrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.commands.AbstractSelectInterpreter;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.stroke.StrokeLib;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Timer;

public class HoldSelectInterpreter
extends AbstractSelectInterpreter {
    static final long serialVersionUID = 1209384023928599658L;
    public static final int holdTimeForSelect = 1000;
    protected Timer timer;
    protected boolean isHold;
    protected boolean isConsumingEvents;
    protected boolean didToggle;
    protected StrokeEvent lastEvt;
    protected int curStrokeNum = 0;
    protected HoldSelectAction holdAction;

    public HoldSelectInterpreter() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Hold Select Interpreter");
        this.timer = new Timer(1000, new HoldSelectAction(0));
        this.timer.setRepeats(false);
    }

    protected boolean selectClosestGob(StrokeEvent lastEvent) {
        TimedStroke stk = lastEvent.getStroke();
        if (!StrokeLib.isTap(stk)) {
            return false;
        }
        GraphicalObjectCollection gobcol = this.getCandidates(stk);
        GraphicalObject selgob = this.getSelectCandidate(gobcol);
        boolean flagSelected = false;
        if (selgob != null) {
            flagSelected = this.toggleSelectGraphicalObject(selgob);
            this.didToggle = true;
            this.isConsumingEvents = true;
        }
        return flagSelected;
    }

    public boolean isEventAccepted(StrokeEvent evt) {
        boolean flag = super.isEventAccepted(evt);
        if (!flag) {
            ++this.curStrokeNum;
        }
        return flag;
    }

    public boolean isEventAccepted(EventObject evt) {
        boolean flag = super.isEventAccepted(evt);
        if (!flag) {
            ++this.curStrokeNum;
        }
        return flag;
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        ++this.curStrokeNum;
        this.lastEvt = evt;
        this.isHold = false;
        this.isConsumingEvents = false;
        this.didToggle = false;
        this.timer.removeActionListener(this.holdAction);
        this.holdAction = new HoldSelectAction(this.curStrokeNum);
        this.timer.addActionListener(this.holdAction);
        this.timer.start();
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        this.lastEvt = evt;
        if (this.isConsumingEvents) {
            evt.setConsumed(true);
        }
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        this.lastEvt = evt;
        this.timer.stop();
        if (this.isHold && this.didToggle) {
            evt.setShouldRender(false);
        }
        if (this.isConsumingEvents) {
            evt.setConsumed(true);
            this.getAttachedGraphicalObject().damage(20);
        }
    }

    public Object clone() {
        return new HoldSelectInterpreter();
    }

    class HoldSelectAction
    extends AbstractAction {
        int holdStrokeNum;

        public HoldSelectAction(int num) {
            this.setHoldStrokeNum(num);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.holdStrokeNum == HoldSelectInterpreter.this.curStrokeNum) {
                HoldSelectInterpreter.this.isHold = true;
                HoldSelectInterpreter.this.selectClosestGob(HoldSelectInterpreter.this.lastEvt);
            }
        }

        public void setHoldStrokeNum(int num) {
            this.holdStrokeNum = num;
        }
    }
}

