/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.commands;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import edu.berkeley.guir.lib.satin.objects.FramedPatch;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import java.awt.geom.Point2D;

public class FramedPatchTitleBarInterpreter
extends InterpreterImpl
implements SatinConstants {
    private FramedPatch currentPatch = null;

    public void handleNewStroke(NewStrokeEvent evt) {
        FramedPatch thePatch;
        Point2D endPt = evt.getStroke().getEndPoint2D(12);
        this.currentPatch = null;
        GraphicalObject gob = null;
        GraphicalObjectGroup gobgrp = (GraphicalObjectGroup)this.getAttachedGraphicalObject();
        GraphicalObjectCollection gobcol = gobgrp.getGraphicalObjects(12, endPt, 31, 40, 52);
        if (!gobcol.isEmpty()) {
            gob = gobcol.get(0);
        }
        if (gob instanceof FramedPatch && (thePatch = (FramedPatch)gob).isInsideTitleBar(GraphicalObjectLib.absoluteToLocal(gob, endPt))) {
            this.currentPatch = thePatch;
            this.currentPatch.handleTitleBarNewStroke(evt);
        }
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        if (this.currentPatch != null) {
            this.currentPatch.handleTitleBarUpdateStroke(evt);
        }
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        if (this.currentPatch != null) {
            this.currentPatch.handleTitleBarSingleStroke(evt);
        }
    }

    public Object clone() {
        return new FramedPatchTitleBarInterpreter();
    }
}

