/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.commands;

import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;

public class CircleSelectInterpreter
extends InterpreterImpl {
    static final long serialVersionUID = -893939878094060567L;
    boolean flagShallow = true;

    public CircleSelectInterpreter() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Circle Select Interpreter");
    }

    public void setDeep() {
        this.flagShallow = false;
    }

    public void setShallow() {
        this.flagShallow = true;
    }

    public boolean isShallow() {
        return this.flagShallow;
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        GraphicalObject gob = this.getAttachedGraphicalObject();
        if (gob == null || !(gob instanceof GraphicalObjectGroup)) {
            return;
        }
        TimedStroke stk = evt.getStroke();
        if (stk.getLength2D(12) < 80.0) {
            return;
        }
        TimedStroke stkA = stk.getSubstroke(0.0, 0.2);
        TimedStroke stkB = stk.getSubstroke(0.8, 1.0);
        if (GeomLib.minDistance(stkA.getPolygon2D(12), stkB.getPolygon2D(12)) > 150.0) {
            return;
        }
        GraphicalObjectGroup gobgrp = (GraphicalObjectGroup)gob;
        int depth = this.flagShallow ? 40 : 41;
        GraphicalObjectCollection gobcol = gobgrp.getGraphicalObjects(12, stk.getPolygon2D(12), 30, depth, 51);
        if (gobcol.numElements() > 0) {
            SatinConstants.cmdsubsys.clearSelected();
            SatinConstants.cmdsubsys.addSelected(gobcol.getForwardIterator());
            evt.setConsumed();
        }
    }

    public Object clone() {
        return this.clone(new CircleSelectInterpreter());
    }

    protected CircleSelectInterpreter clone(CircleSelectInterpreter intrp) {
        super.clone(intrp);
        intrp.flagShallow = this.flagShallow;
        return intrp;
    }
}

