/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter.commands;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollectionImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.util.Iterator;

public abstract class AbstractSelectInterpreter
extends InterpreterImpl {
    protected boolean flagShallow = true;
    protected boolean flagMultiSelect = false;

    public AbstractSelectInterpreter() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setAcceptMiddleButton(false);
        this.setAcceptRightButton(false);
    }

    public void setDeep() {
        this.flagShallow = false;
    }

    public void setShallow() {
        this.flagShallow = true;
    }

    public void setMultiSelect(boolean flag) {
        this.flagMultiSelect = flag;
    }

    public boolean isMultiSelect() {
        return this.flagMultiSelect;
    }

    protected GraphicalObjectCollection getCandidates(SingleStrokeEvent evt) {
        return this.getCandidates(evt.getStroke());
    }

    protected GraphicalObjectCollection getCandidates(TimedStroke stk) {
        GraphicalObject gob = this.getAttachedGraphicalObject();
        GraphicalObjectCollection out = new GraphicalObjectCollectionImpl();
        if (gob instanceof GraphicalObjectGroup) {
            GraphicalObjectGroup gobgrp = (GraphicalObjectGroup)gob;
            out = this.flagShallow ? gobgrp.getGraphicalObjects(12, stk.getStartPoint2D(12), 30, 40, 52, 5.0, null) : gobgrp.getGraphicalObjects(12, stk.getStartPoint2D(12), 30, 41, 52, 5.0, null);
        }
        GraphicalObjectCollection gobcol = (GraphicalObjectCollection)out.clone();
        Iterator it = gobcol.getForwardIterator();
        while (it.hasNext()) {
            gob = (GraphicalObject)it.next();
            if (gob.isSelectable()) continue;
            out.remove(gob);
        }
        return out;
    }

    protected GraphicalObject getSelectCandidate(GraphicalObjectCollection gobcol) {
        if (gobcol.numElements() > 0) {
            return GraphicalObjectLib.getTopmostGraphicalObject(gobcol);
        }
        return null;
    }

    protected boolean toggleSelectGraphicalObject(GraphicalObject selgob) {
        boolean flagReturn = false;
        if (selgob != null) {
            if (SatinConstants.cmdsubsys.isSelected(selgob)) {
                SatinConstants.cmdsubsys.removeSelected(selgob);
            } else {
                if (!this.flagMultiSelect) {
                    SatinConstants.cmdsubsys.clearSelected();
                }
                SatinConstants.cmdsubsys.addSelected(selgob);
                flagReturn = true;
            }
            selgob.damage(21);
        }
        return flagReturn;
    }
}

