/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.Interpreter;
import edu.berkeley.guir.lib.satin.interpreter.InterpreterWrapper;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.util.StringLib;

public class SemanticZoomInterpreterWrapper
extends InterpreterWrapper {
    static final long serialVersionUID = -4734902309482390174L;
    private double startScale = 0.0;
    private double endScale = Double.MAX_VALUE;

    public SemanticZoomInterpreterWrapper() {
        this.commonInitializations();
    }

    public SemanticZoomInterpreterWrapper(Interpreter newintrp, double startSc, double endSc) {
        this.setRange(startSc, endSc);
        this.setInterpreter(newintrp);
        this.commonInitializations();
    }

    public SemanticZoomInterpreterWrapper(Interpreter newintrp) {
        this.setInterpreter(newintrp);
        this.commonInitializations();
    }

    public SemanticZoomInterpreterWrapper(SemanticZoomInterpreterWrapper w) {
        this.setInterpreter((Interpreter)w.getInterpreter().clone());
        this.setRange(w.getStartScale(), w.getEndScale());
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Semantic Zoom Interpreter");
    }

    public void setRange(double start, double end) {
        this.startScale = start;
        this.endScale = end;
    }

    public double getStartScale() {
        return this.startScale;
    }

    public double getEndScale() {
        return this.endScale;
    }

    public boolean isEnabled() {
        double curscale = this.getAbsoluteScaleFactor();
        return super.isEnabled() && this.getStartScale() <= curscale && curscale <= this.getEndScale();
    }

    protected double getAbsoluteScaleFactor() {
        return GraphicalObjectLib.getScaleFactor(12, this.getAttachedGraphicalObject());
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        double curscale = this.getAbsoluteScaleFactor();
        if (this.getStartScale() <= curscale && curscale <= this.getEndScale()) {
            this.getInterpreter().handleNewStroke(evt);
        }
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        double curscale = this.getAbsoluteScaleFactor();
        if (this.getStartScale() <= curscale && curscale <= this.getEndScale()) {
            this.getInterpreter().handleUpdateStroke(evt);
        }
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        double curscale = this.getAbsoluteScaleFactor();
        if (this.getStartScale() <= curscale && curscale <= this.getEndScale()) {
            this.getInterpreter().handleSingleStroke(evt);
        }
    }

    public Object clone() {
        return this.clone(new SemanticZoomInterpreterWrapper());
    }

    protected SemanticZoomInterpreterWrapper clone(SemanticZoomInterpreterWrapper iw) {
        super.clone(iw);
        iw.startScale = this.startScale;
        iw.endScale = this.endScale;
        return iw;
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append(super.toString());
        strbuf.append("\nContained Interpreter\n:");
        strbuf.append(StringLib.indent(this.getInterpreter().toString(), 3));
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }
}

