/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.command.Command;
import edu.berkeley.guir.lib.satin.command.UndoableCommand;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.DefaultInterpreterImpl;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.objects.Patch;
import edu.berkeley.guir.lib.satin.objects.PatchImpl;
import edu.berkeley.guir.lib.satin.stroke.StrokeLib;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import edu.berkeley.guir.lib.satin.watch.Watchable;
import edu.berkeley.guir.lib.satin.watch.Watcher;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ScribbledTextInterpreter
extends DefaultInterpreterImpl
implements Watcher,
SatinConstants {
    static final long serialVersionUID = 5319980068459537343L;
    public static final double DEFAULT_DISTANCE_THRESHOLD = 200.0;
    public static final double DEFAULT_VERTICAL_HEIGHT_THRESHOLD = 80.0;
    public static final double DEFAULT_HORIZONTAL_OFFSET_THRESHOLD = 40.0;
    public static final double DEFAULT_VERTICAL_OFFSET_THRESHOLD = 5.0;
    public static final double DEFAULT_STRAIGHTNESS_THRESHOLD = 0.2;
    public static final int DEFAULT_LETTER_HEIGHT = 80;
    public static final int DEFAULT_INTERWORD_SPACE = 45;
    public static final int DEFAULT_INTERLINE_SPACE = 5;
    private double distanceThreshold;
    private double verticalHeightThreshold;
    private double horizontalOffsetThreshold;
    private double verticalOffsetThreshold;
    private double straightnessThreshold;
    private int interWordSpace;
    private int interLineSpace;
    private int letterHeight;
    private int letterHeightSq;
    protected TimedStroke lastStk;
    private Patch currentScribble;
    private boolean newScribbleWasCreated;
    private boolean strokeWasAddedToScribble;
    protected GraphicalObjectGroup parent;

    public ScribbledTextInterpreter() {
        this.setName("Scribble Interpreter");
        this.distanceThreshold = 200.0;
        this.verticalHeightThreshold = 80.0;
        this.horizontalOffsetThreshold = 40.0;
        this.verticalOffsetThreshold = 5.0;
        this.straightnessThreshold = 0.2;
        this.interWordSpace = 45;
        this.interLineSpace = 5;
        this.letterHeight = 80;
        this.letterHeightSq = this.letterHeight * this.letterHeight;
        this.lastStk = null;
        this.currentScribble = null;
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        TimedStroke thisStk = evt.getStroke();
        if (thisStk.getLength2D(12) < 4.0) {
            return;
        }
        this.parent = (GraphicalObjectGroup)this.getAttachedGraphicalObject();
        this.parent.disableDamage();
        if (this.isRightSize(thisStk) && this.belongsWithScribble(thisStk, this.currentScribble)) {
            SatinConstants.cmdqueue.doCommand(new AddStrokeToScribbleCommand(this.currentScribble, thisStk));
            evt.setConsumed(true);
        } else if (this.isRightSize(thisStk)) {
            this.doCreateNewScribbleCommand(this.parent, thisStk);
            evt.setConsumed(true);
        }
        this.parent.enableDamage();
    }

    public Command getAddStrokeToScribbleCommand(Patch scribble, TimedStroke stk) {
        return new AddStrokeToScribbleCommand(scribble, stk);
    }

    public void onNotify(Watchable w, Object arg) {
    }

    public void onUpdate(Watchable w, Object arg) {
    }

    public void onUpdate(Watchable w, String strProperty, Object oldVal, Object newVal) {
    }

    public void onDelete(Watchable w) {
        if (w == this.currentScribble) {
            this.currentScribble = null;
        }
    }

    protected void doCreateNewScribbleCommand(GraphicalObjectGroup parent, TimedStroke stk) {
        PatchImpl newScribble = new PatchImpl();
        SatinConstants.cmdqueue.doCommand(new CreateNewScribbleCommand(parent, newScribble, stk));
    }

    public Patch getCurrentScribble() {
        return this.currentScribble;
    }

    public boolean getStrokeWasAddedToScribble() {
        return this.strokeWasAddedToScribble;
    }

    public boolean getNewScribbleWasCreated() {
        return this.newScribbleWasCreated;
    }

    public int getInterWordSpace() {
        return this.interWordSpace;
    }

    public void setInterWordSpace(int iws) {
        this.interWordSpace = iws;
    }

    public int getInterLineSpace() {
        return this.interLineSpace;
    }

    public void setInterLineSpace(int ils) {
        this.interLineSpace = ils;
    }

    public int getLetterHeight() {
        return this.letterHeight;
    }

    public void setLetterHeight(int lh) {
        this.letterHeight = lh;
        this.letterHeightSq = lh * lh;
    }

    protected Point2D getLocalToAbs(GraphicalObject gob, Point2D pt) {
        return GraphicalObjectLib.localToAbsolute(gob, pt);
    }

    protected Point2D getAbsToLocal(GraphicalObject gob, Point2D pt) {
        return GraphicalObjectLib.absoluteToLocal(gob, pt);
    }

    protected Rectangle2D getLocalToAbs(GraphicalObject gob, Rectangle2D rect) {
        return GraphicalObjectLib.localToAbsolute(gob, rect);
    }

    protected Rectangle2D getAbsToLocal(GraphicalObject gob, Rectangle2D rect) {
        return GraphicalObjectLib.absoluteToLocal(gob, rect);
    }

    protected AffineTransform getAbsTransform(GraphicalObject gob) {
        return gob.getTransform(12);
    }

    protected AffineTransform getInverseAbsTransform(GraphicalObject gob) {
        return gob.getInverseTransform(12);
    }

    public boolean looksLikeText(TimedStroke stk, double scaleFactor) {
        boolean isRightHeight = false;
        boolean isCurvy = false;
        Rectangle2D bounds = stk.getBounds2D(12);
        isRightHeight = bounds.getHeight() <= this.verticalHeightThreshold;
        if (bounds.getWidth() > (double)this.interWordSpace) {
            int wSq = (int)(bounds.getWidth() * bounds.getWidth());
            isCurvy = !(stk.getLength2D(12) < Math.sqrt(wSq + this.letterHeightSq));
        } else {
            isCurvy = true;
        }
        return isRightHeight && isCurvy;
    }

    public boolean isRightSize(TimedStroke stk) {
        return this.looksLikeText(stk, GraphicalObjectLib.getScaleFactor(11, this.parent));
    }

    public boolean belongsWithScribble(TimedStroke stk, Patch phrase) {
        boolean retVal = false;
        if (phrase == null || this.lastStk == null) {
            retVal = false;
        } else if (StrokeLib.computeHandwritingDistance(stk, this.lastStk) < this.distanceThreshold) {
            retVal = true;
        } else {
            Rectangle2D bdsStk = stk.getBounds2D(12);
            Rectangle2D bdsPhrase = phrase.getBounds2D(12);
            Sheet sheet = this.getAttachedGraphicalObject().getSheet();
            double sheetAbsScale = GraphicalObjectLib.getScaleFactor(12, sheet);
            retVal = bdsStk.getX() > bdsPhrase.getX() - this.horizontalOffsetThreshold && bdsStk.getX() < bdsPhrase.getX() + this.horizontalOffsetThreshold && bdsStk.getY() > bdsPhrase.getY() + bdsPhrase.getHeight() - this.verticalOffsetThreshold * sheetAbsScale && bdsStk.getY() < bdsPhrase.getY() + bdsPhrase.getHeight() + this.verticalOffsetThreshold * sheetAbsScale;
        }
        return retVal;
    }

    public Object clone() {
        ScribbledTextInterpreter pInterp = new ScribbledTextInterpreter();
        pInterp.distanceThreshold = this.distanceThreshold;
        pInterp.verticalHeightThreshold = this.verticalHeightThreshold;
        pInterp.horizontalOffsetThreshold = this.horizontalOffsetThreshold;
        pInterp.verticalOffsetThreshold = this.verticalOffsetThreshold;
        return pInterp;
    }

    public class AddStrokeToScribbleCommand
    extends UndoableCommand {
        private Patch scribble;
        private TimedStroke newStk;
        private Rectangle2D oldRelBds;
        private Rectangle2D newRelBds;
        private Map stkOldRelLocs;
        private Map stkNewRelLocs;
        private TimedStroke oldLastStk;
        private boolean oldNewScribbleWasCreated;
        private boolean oldStrokeWasAddedToScribble;

        public AddStrokeToScribbleCommand(Patch scribble, TimedStroke newStk) {
            this.scribble = scribble;
            this.newStk = newStk;
            this.oldLastStk = ScribbledTextInterpreter.this.lastStk;
            this.oldNewScribbleWasCreated = ScribbledTextInterpreter.this.newScribbleWasCreated;
            this.oldStrokeWasAddedToScribble = ScribbledTextInterpreter.this.strokeWasAddedToScribble;
        }

        public String getPresentationName() {
            return "add stroke to scribble";
        }

        private void setRelLocations(Map relLocs) {
            Iterator it = relLocs.keySet().iterator();
            while (it.hasNext()) {
                GraphicalObject gob = (GraphicalObject)it.next();
                gob.moveTo(11, (Point2D)relLocs.get(gob));
            }
        }

        public boolean canRedo() {
            return true;
        }

        public void run() {
            HashMap<GraphicalObject, Point2D> stkOldAbsLocs = new HashMap<GraphicalObject, Point2D>();
            this.stkOldRelLocs = new HashMap();
            this.stkNewRelLocs = new HashMap();
            this.oldRelBds = this.scribble.getBounds2D(11);
            Iterator it = this.scribble.getForwardIterator();
            while (it.hasNext()) {
                GraphicalObject gob = (GraphicalObject)it.next();
                this.stkOldRelLocs.put(gob, gob.getLocation2D(11));
                stkOldAbsLocs.put(gob, ScribbledTextInterpreter.this.getLocalToAbs(gob, gob.getLocation2D(10)));
            }
            Rectangle2D oldAbsBds = ScribbledTextInterpreter.this.getLocalToAbs((GraphicalObject)this.scribble, this.scribble.getBounds2D(10));
            Rectangle2D newAbsBds = oldAbsBds.createUnion(this.newStk.getBounds2D(12));
            this.newRelBds = ScribbledTextInterpreter.this.getAbsToLocal((GraphicalObject)this.scribble.getParentGroup(), newAbsBds);
            PatchImpl dummy = new PatchImpl(this.newRelBds);
            dummy.setVisible(false);
            this.scribble.getParentGroup().add(dummy, 6);
            it = this.scribble.getForwardIterator();
            while (it.hasNext()) {
                GraphicalObject gob = (GraphicalObject)it.next();
                this.stkNewRelLocs.put(gob, ScribbledTextInterpreter.this.getAbsToLocal((GraphicalObject)dummy, (Point2D)stkOldAbsLocs.get(gob)));
            }
            GraphicalObjectLib.toLocalCoordinates(this.newStk, dummy);
            dummy.delete();
            this.redo();
        }

        public void redo() {
            this.scribble.disableDamage();
            this.scribble.disableNotify();
            this.scribble.setBoundingPoints2D(11, this.newRelBds);
            this.scribble.enableNotify();
            this.scribble.enableDamage();
            this.setRelLocations(this.stkNewRelLocs);
            this.scribble.add(this.newStk, 6);
            ScribbledTextInterpreter.this.lastStk = this.newStk;
            ScribbledTextInterpreter.this.newScribbleWasCreated = false;
            ScribbledTextInterpreter.this.strokeWasAddedToScribble = true;
        }

        public void undo() {
            this.scribble.remove(this.newStk);
            this.setRelLocations(this.stkOldRelLocs);
            this.scribble.disableDamage();
            this.scribble.disableNotify();
            this.scribble.setBoundingPoints2D(11, this.oldRelBds);
            this.scribble.enableNotify();
            this.scribble.enableDamage();
            ScribbledTextInterpreter.this.lastStk = this.oldLastStk;
            ScribbledTextInterpreter.this.newScribbleWasCreated = this.oldNewScribbleWasCreated;
            ScribbledTextInterpreter.this.strokeWasAddedToScribble = this.oldStrokeWasAddedToScribble;
        }
    }

    public class CreateNewScribbleCommand
    extends UndoableCommand {
        private GraphicalObjectGroup parent;
        private Patch scribble;
        private Rectangle2D scribbleRelBds;
        private TimedStroke stk;
        private Point2D stkRelLoc;
        private TimedStroke oldLastStk;
        private boolean oldNewScribbleWasCreated;
        private boolean oldStrokeWasAddedToScribble;
        private Patch oldCurrentScribble;

        public CreateNewScribbleCommand(GraphicalObjectGroup parent, Patch scribble, TimedStroke stk) {
            this.parent = parent;
            this.scribble = scribble;
            this.stk = stk;
            this.oldLastStk = ScribbledTextInterpreter.this.lastStk;
            this.oldNewScribbleWasCreated = ScribbledTextInterpreter.this.newScribbleWasCreated;
            this.oldStrokeWasAddedToScribble = ScribbledTextInterpreter.this.strokeWasAddedToScribble;
            this.oldCurrentScribble = ScribbledTextInterpreter.this.currentScribble;
        }

        public String getPresentationName() {
            return "create new scribble";
        }

        public boolean canRedo() {
            return true;
        }

        public void run() {
            Rectangle2D stkAbsBds = this.stk.getBounds2D(12);
            PatchImpl dummy = new PatchImpl(stkAbsBds);
            dummy.setVisible(false);
            this.parent.add(dummy, 5);
            this.scribbleRelBds = dummy.getBounds2D(11);
            Rectangle2D stkRelBds = ScribbledTextInterpreter.this.getAbsToLocal((GraphicalObject)dummy, stkAbsBds);
            this.stkRelLoc = new Point2D.Double(stkRelBds.getX(), stkRelBds.getY());
            dummy.delete();
            this.scribble.setBoundingPoints2D(11, this.scribbleRelBds);
            this.parent.add(this.scribble, 6);
            this.scribble.add(this.stk, 5);
            this.stk.moveTo(11, this.stkRelLoc);
            this.afterDo();
        }

        public void redo() {
            this.parent.add(this.scribble, 6);
            this.afterDo();
        }

        private void afterDo() {
            if (this.oldCurrentScribble != null) {
                this.oldCurrentScribble.removeWatcher(ScribbledTextInterpreter.this);
            }
            this.scribble.addWatcher(ScribbledTextInterpreter.this);
            ScribbledTextInterpreter.this.lastStk = this.stk;
            ScribbledTextInterpreter.this.newScribbleWasCreated = true;
            ScribbledTextInterpreter.this.strokeWasAddedToScribble = false;
            ScribbledTextInterpreter.this.currentScribble = this.scribble;
        }

        public void undo() {
            this.parent.remove(this.scribble);
            if (this.oldCurrentScribble != null) {
                this.oldCurrentScribble.addWatcher(ScribbledTextInterpreter.this);
            }
            this.scribble.removeWatcher(ScribbledTextInterpreter.this);
            ScribbledTextInterpreter.this.lastStk = this.oldLastStk;
            ScribbledTextInterpreter.this.newScribbleWasCreated = this.oldNewScribbleWasCreated;
            ScribbledTextInterpreter.this.strokeWasAddedToScribble = this.oldStrokeWasAddedToScribble;
            ScribbledTextInterpreter.this.currentScribble = this.oldCurrentScribble;
        }
    }
}

