/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.interpreter;

import edu.berkeley.guir.lib.satin.event.NewStrokeEvent;
import edu.berkeley.guir.lib.satin.event.SingleStrokeEvent;
import edu.berkeley.guir.lib.satin.event.UpdateStrokeEvent;
import edu.berkeley.guir.lib.satin.interpreter.DefaultMultiInterpreterImpl;
import edu.berkeley.guir.lib.satin.interpreter.Interpreter;

public class MultiplexedMultiInterpreterImpl
extends DefaultMultiInterpreterImpl {
    static final long serialVersionUID = -1203958120958098514L;
    Interpreter currentIntrp = null;
    int currentIndex = 0;

    public MultiplexedMultiInterpreterImpl() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("MultiplexedMultiInterpreterImpl");
    }

    public Interpreter add(Interpreter intrp) {
        super.add(intrp);
        if (this.currentIntrp == null) {
            this.currentIntrp = intrp;
        }
        return intrp;
    }

    public void setCurrent(int index) {
        this.currentIndex = index;
        this.currentIntrp = this.get(index);
    }

    public void setCurrent(Interpreter intrp) {
        if (!this.contains(intrp)) {
            throw new RuntimeException("Does not contain this Interpreter");
        }
        this.currentIntrp = intrp;
    }

    public void handleNewStroke(NewStrokeEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.currentIntrp != null) {
            this.currentIntrp.handleNewStroke(evt);
        }
    }

    public void handleUpdateStroke(UpdateStrokeEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.currentIntrp != null) {
            this.currentIntrp.handleUpdateStroke(evt);
        }
    }

    public void handleSingleStroke(SingleStrokeEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.currentIntrp != null) {
            this.currentIntrp.handleSingleStroke(evt);
        }
    }

    public Object clone() {
        return this.clone(new MultiplexedMultiInterpreterImpl());
    }

    protected DefaultMultiInterpreterImpl clone(MultiplexedMultiInterpreterImpl im) {
        super.clone(im);
        im.setCurrent(this.currentIndex);
        return im;
    }
}

